/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.AuditDSGenerator;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.CustomDSLoader;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DynamicDSGenerator;
import com.isomorphic.datasource.FrameworkDynamicDSGenerator;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MultiTenantDSGenerator
extends Base
implements FrameworkDynamicDSGenerator {
    private static Logger log = new Logger(MultiTenantDSGenerator.class.getName());
    private static Logger tidLog = new Logger("com.isomorphic.datasource.TenantIDTracer");
    private static final String TENANT_CACHE_TYPENAME = "tenant.datasources";
    private static final String TENANT_FS_CACHE_TYPENAME = "tenant.fileSource.datasources";
    private static final String USE_PROJECT_FS_NAMES = "tenant.useProjectFileSourceNames";
    private static final String USE_PROJECT_FS_PATHS = "tenant.useProjectFileSourcePaths";
    private static String tenantNamingPattern;
    private static String tenantNameTemplate;
    private static String servletReqAttribute;
    private static String dbNameTemplate;
    private static boolean poolDataSources;
    private static boolean allowClientParam;
    private static List<String> allowedTenants;
    private static List<String> testDataSources;
    private static Config config;

    private static void setupTenantDSPaths() {
        String projectDSPaths = (String)config.getUninterpolated("project.datasources");
        String tenantDSPaths = (String)config.getUninterpolated(TENANT_CACHE_TYPENAME);
        config.remove("project.tenant.datasources");
        config.remove("project.tenant.fileSource.datasources");
        if (tenantDSPaths == null) {
            if (projectDSPaths == null) {
                return;
            }
            ArrayList<String> tenantDSPathList = new ArrayList<String>();
            for (String projectPath : DataTools.commaSeparatedStringToList(projectDSPaths)) {
                if (projectPath.startsWith("ds://")) {
                    tenantDSPathList.add(projectPath);
                    continue;
                }
                if (projectPath.endsWith("/mock")) continue;
                tenantDSPathList.add(projectPath + "/tenants");
            }
            MultiTenantDSGenerator.setStructCacheTypePathList(TENANT_CACHE_TYPENAME, tenantDSPathList);
            return;
        }
        boolean hasFileSourceTenantPaths = false;
        ArrayList<String> tenantDSPathList = new ArrayList<String>();
        for (String tenantPath : DataTools.commaSeparatedStringToList(tenantDSPaths)) {
            if (tenantPath.startsWith("ds://")) {
                hasFileSourceTenantPaths = true;
            }
            tenantDSPathList.add(tenantPath);
        }
        if (projectDSPaths != null && config.getBoolean((Object)USE_PROJECT_FS_NAMES, true)) {
            for (String projectPath : DataTools.commaSeparatedStringToList(projectDSPaths)) {
                if (!projectPath.startsWith("ds://")) continue;
                tenantDSPathList.add(projectPath);
            }
        }
        MultiTenantDSGenerator.setStructCacheTypePathList(TENANT_CACHE_TYPENAME, tenantDSPathList);
        if (hasFileSourceTenantPaths) {
            tenantDSPathList = new ArrayList();
            for (String tenantPath : DataTools.commaSeparatedStringToList(tenantDSPaths)) {
                if (tenantPath.startsWith("ds://")) continue;
                tenantDSPathList.add(tenantPath);
            }
            if (projectDSPaths != null && config.getBoolean((Object)USE_PROJECT_FS_PATHS, true)) {
                for (String projectPath : DataTools.commaSeparatedStringToList(projectDSPaths)) {
                    if (projectPath.startsWith("ds://")) continue;
                    tenantDSPathList.add(projectPath);
                }
            }
            MultiTenantDSGenerator.setStructCacheTypePathList(TENANT_FS_CACHE_TYPENAME, tenantDSPathList);
        }
    }

    private static void setStructCacheTypePathList(String cacheTypeName, List<String> pathList) {
        if (pathList != null && pathList.size() > 0) {
            config.put("project." + cacheTypeName, String.join((CharSequence)", ", pathList));
        }
    }

    private static void setupConfig() {
        dbNameTemplate = config.getString("tenant.dbNameTemplate", "mt_$tenantId");
        tenantNameTemplate = config.getString("tenant.datasources.nameTemplate", "mt_${tenantId}_$baseId");
        tenantNamingPattern = config.getString("tenant.datasources.namingPattern", "mt_([A-Za-z0-9]+)_([A-Za-z0-9_$]+)");
        servletReqAttribute = config.getString("tenant.servletReqAttribute", "isc_tenantId");
        MultiTenantDSGenerator.setupTenantDSPaths();
        poolDataSources = config.getBoolean((Object)"datasources.poolTenantDataSources", true);
        allowClientParam = config.getBoolean((Object)"tenant.testOnlyURLParam", false);
        testDataSources = config.getList("tenant.testDataSources");
        allowedTenants = config.getList("mt.tenants");
    }

    public static boolean shouldAllowClientTenantIdParam() {
        return allowClientParam;
    }

    public static String getTenantDatabaseName(String tenantId, Map context) {
        try {
            context.put("tenantId", tenantId);
            context.put("properties", context.get("config"));
            return (String)Velocity.evaluate(dbNameTemplate, context);
        }
        catch (Exception e) {
            log.warning((Object)("failed to build a multi-tenant Database ID for tenant " + tenantId), e);
            return null;
        }
    }

    public static String getTenantDataSourceId(String tenantId, String baseId, DSRequest request) {
        Matcher matcher = Pattern.compile(tenantNamingPattern).matcher(baseId);
        if (matcher.matches()) {
            return baseId;
        }
        try {
            Map<Object, Object> context = Velocity.getStandardContextMap(request);
            context.put("tenantId", tenantId);
            context.put("baseId", baseId);
            return (String)Velocity.evaluate(tenantNameTemplate, context);
        }
        catch (Exception e) {
            log.warning((Object)("failed to build a multi-tenant DataSource ID for tenant " + tenantId + " from base DataSource ID " + baseId), e);
            return null;
        }
    }

    public static String getRequestTenantId(DSRequest request) {
        if (request == null) {
            return null;
        }
        String tenantId = request.getTenantId();
        HttpServletRequest servletRequest = request.getHttpServletRequest();
        if (tenantId == null && servletRequest != null) {
            tenantId = (String)servletRequest.getAttribute(servletReqAttribute);
        }
        return tenantId;
    }

    public static String getRPCManagerTenantId(RPCManager rpc) {
        if (rpc == null) {
            return null;
        }
        String tenantId = rpc.getTenantId();
        RequestContext context = rpc.getContext();
        if (tenantId == null && context != null && context.request != null) {
            tenantId = (String)context.request.getAttribute(servletReqAttribute);
        }
        return tenantId;
    }

    private String getAuthorizedBaseDSId(String id, String tenantId) {
        if (allowedTenants != null && !allowedTenants.contains(tenantId)) {
            log.debug("ignoring tenant " + tenantId + " as it's not in the explicit list");
            return null;
        }
        Matcher matcher = Pattern.compile(tenantNamingPattern).matcher(id);
        matcher.matches();
        if (!tenantId.equals(matcher.group(1))) {
            return null;
        }
        return matcher.group(2);
    }

    private boolean addCustomFSLookupPaths(String cacheType) {
        if (TENANT_CACHE_TYPENAME.equals(cacheType) && config.containsKey("project.tenant.fileSource.datasources")) {
            DataSource.addLoadFlag("storeCacheType", TENANT_FS_CACHE_TYPENAME);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource getDataSource(String id, DSRequest request) {
        String tenantId = MultiTenantDSGenerator.getRequestTenantId(request);
        if (tenantId == null) {
            return null;
        }
        String baseDSId = this.getAuthorizedBaseDSId(id, tenantId);
        if (baseDSId == null) {
            return null;
        }
        String cacheType = TENANT_CACHE_TYPENAME;
        if (testDataSources != null && testDataSources.contains(baseDSId)) {
            log.debug("loading test DS " + baseDSId + " for tenant " + tenantId + " from normal DS search path");
            cacheType = "datasources";
        }
        DataSource tenantDS = null;
        try {
            Map<Object, Object> context = Velocity.getStandardContextMap(request);
            String dbName = MultiTenantDSGenerator.getTenantDatabaseName(tenantId, context);
            TenantDSLoader loader = new TenantDSLoader(id, baseDSId, tenantId, dbName, cacheType);
            String dbPath = "sql." + dbName;
            Config dbConfig = config.getSubtree(dbPath);
            if (dbConfig != null && dbConfig.size() > 0) {
                log.info("found definition for database " + dbName + " in global config");
            } else {
                dbConfig = config.addSubtreeFromTemplate(dbPath, "tenant.dbTemplate", context);
                if (log.isDebugEnabled()) {
                    log.debug("adding definition for database " + dbName + " to global config from template:\n" + String.valueOf((Object)dbConfig));
                } else {
                    log.info("adding definition for database " + dbName + " to global config config from template");
                }
            }
            AuditDSGenerator generator = BasicDataSource.auditGenerator;
            if (generator != null && generator.hasMappingFor(id)) {
                tenantDS = generator.getDataSource(baseDSId, request, loader);
            } else {
                boolean addedLoadFlag = this.addCustomFSLookupPaths(cacheType);
                try {
                    tenantDS = DataSource.loadDS(baseDSId, request, loader);
                }
                finally {
                    if (addedLoadFlag) {
                        DataSource.popLoadFlags();
                    }
                }
            }
            if (tenantDS == null) {
                log.warning("unable to load definition of " + baseDSId + " for " + id);
                return null;
            }
        }
        catch (Exception e) {
            log.warning((Object)("failed to load definition of " + baseDSId + " for " + id), e);
            return null;
        }
        return tenantDS;
    }

    @Override
    public Boolean isPoolable(String id) {
        return poolDataSources;
    }

    @Override
    public boolean isAuthorized(String id, DSRequest request) {
        String assertedTenantId;
        String tenantId = MultiTenantDSGenerator.getRequestTenantId(request);
        if (tenantId == null) {
            return false;
        }
        if (tidLog.isDebugEnabled()) {
            tidLog.debug("Tenant ID " + tenantId + " requested connection to DS " + id);
        }
        if ((assertedTenantId = (String)Logger.getMDC("ASSERT_TENANT_ID")) != null && !assertedTenantId.equals(tenantId)) {
            throw new IllegalArgumentException("Tenant ID " + tenantId + " requested connection to DataSource " + id + " but logger context asserts that only " + assertedTenantId + " is allowed");
        }
        String baseDSId = this.getAuthorizedBaseDSId(id, tenantId);
        return baseDSId != null;
    }

    static {
        config = Config.getGlobal();
        if (config.getBoolean((Object)"tenant.enabled", true)) {
            MultiTenantDSGenerator.setupConfig();
            DataSource.addDynamicDSGenerator((DynamicDSGenerator)new MultiTenantDSGenerator(), Pattern.compile("^" + tenantNamingPattern + "$"));
            log.info("Tenant dynamic DS generation has been initialized");
        } else {
            log.info("Tenant dynamic DS generation has been disabled");
        }
    }

    static class TenantDSLoader
    implements CustomDSLoader {
        private String id;
        private String baseId;
        private String dbName;
        private String tenantId;
        private String cacheType;

        public TenantDSLoader(String id, String baseId, String tenantId, String dbName, String cacheType) {
            this.id = id;
            this.dbName = dbName;
            this.baseId = baseId;
            this.tenantId = tenantId;
            this.cacheType = cacheType;
        }

        @Override
        public String getCacheTypeName() {
            return this.cacheType;
        }

        @Override
        public Map getDynamicConfigOverrides(Map config) {
            Map newConfig = DataTools.mapMerge(config, new DataTypeMap());
            newConfig.put("ID", this.id);
            newConfig.put("baseId", this.baseId);
            newConfig.put("dbName", this.dbName);
            newConfig.put("tenantId", this.tenantId);
            newConfig.put("cacheType", this.cacheType);
            if (!newConfig.containsKey("tableName")) {
                newConfig.put("tableName", this.baseId);
            }
            return newConfig;
        }
    }
}

