package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * The type of join to make between two SQL tables when resolving  {@link
 * com.smartgwt.client.docs.serverds.DataSourceField#includeFrom includeFrom} fields.
 */
public enum JoinType implements ValueEnum {
    /**
     * A regular inner join, whereby rows are only included in the resultset where the join can be satisified, so a missing row
     * in the table being joined to results in the entire row being omitted.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "inner".
     */
    INNER("inner"),
    /**
     * An outer join. All outer joins generated by Smart GWT's SQL subsystem are left outer joins, meaning that every row in
     * the join-from (or "left") table that matches the criteria is included, and missing rows in the  join-to (or "right")
     * table cause columns to be set to null.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "outer".
     */
    OUTER("outer");
    private String value;

    JoinType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
