/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Represents a data question and either the steps taken in attempting to answer it or the result.
 * @see com.smartgwt.client.docs.AnswerEngine Answer Engine
 */
@BeanFactory.FrameworkClass
public class DataQuestion extends DataClass {

    public static DataQuestion getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new DataQuestion(jsObj);
    }
        


    public DataQuestion(){
        
    }

    public DataQuestion(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * An arbitrary non-empty string that uniquely identifies the data question. This is a required property.
     *
     * @param ID New ID value. Default value is null
     * @return {@link com.smartgwt.client.ai.DataQuestion DataQuestion} instance, for chaining setter calls
     */
    public DataQuestion setID(String ID) {
        return (DataQuestion)setAttribute("ID", ID);
    }

    /**
     * An arbitrary non-empty string that uniquely identifies the data question. This is a required property.
     *
     * @return Current ID value. Default value is null
     */
    public String getID()  {
        return getAttributeAsString("ID");
    }
    

    /**
     * The result of the operation.
     *
     * @param result New result value. Default value is null
     * @return {@link com.smartgwt.client.ai.DataQuestion DataQuestion} instance, for chaining setter calls
     */
    public DataQuestion setResult(DataQuestionResult result) {
        return (DataQuestion)setAttribute("result", result == null ? null : result.getJsObj());
    }

    /**
     * The result of the operation.
     *
     * @return Current result value. Default value is null
     */
    public DataQuestionResult getResult()  {
        return DataQuestionResult.getOrCreateRef(getAttributeAsJavaScriptObject("result"));
    }
    

    /**
     * The settings for the data question.
     *
     * @param settings New settings value. Default value is null
     * @return {@link com.smartgwt.client.ai.DataQuestion DataQuestion} instance, for chaining setter calls
     */
    public DataQuestion setSettings(DataQuestionSettings settings) {
        return (DataQuestion)setAttribute("settings", settings == null ? null : settings.getJsObj());
    }

    /**
     * The settings for the data question.
     *
     * @return Current settings value. Default value is null
     */
    public DataQuestionSettings getSettings()  {
        return new DataQuestionSettings(getAttributeAsJavaScriptObject("settings"));
    }
    

    /**
     * The end-user's AI request.
     *
     * @param userAIRequest New userAIRequest value. Default value is null
     * @return {@link com.smartgwt.client.ai.DataQuestion DataQuestion} instance, for chaining setter calls
     */
    public DataQuestion setUserAIRequest(UserAIRequest userAIRequest) {
        return (DataQuestion)setAttribute("userAIRequest", userAIRequest == null ? null : userAIRequest.getJsObj());
    }

    /**
     * The end-user's AI request.
     *
     * @return Current userAIRequest value. Default value is null
     */
    public UserAIRequest getUserAIRequest()  {
        return UserAIRequest.getOrCreateRef(getAttributeAsJavaScriptObject("userAIRequest"));
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
