/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.data;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Settings for generation of AdvancedCriteria descriptions.
 */
@BeanFactory.FrameworkClass
public class CriteriaOutputSettings extends DataClass {

    public static CriteriaOutputSettings getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new CriteriaOutputSettings(jsObj);
    }
        


    public CriteriaOutputSettings(){
        
    }

    public CriteriaOutputSettings(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * By default HTML characters such as <code>"&lt;br&gt;"</code> will be written into the output description to format the
     * result. Setting <code>escapeHTML</code> true will instead force HTML values in the output to be displayed to the user
     * instead.
     *
     * @param escapeHTML New escapeHTML value. Default value is null
     * @return {@link com.smartgwt.client.data.CriteriaOutputSettings CriteriaOutputSettings} instance, for chaining setter calls
     */
    public CriteriaOutputSettings setEscapeHTML(Boolean escapeHTML) {
        return (CriteriaOutputSettings)setAttribute("escapeHTML", escapeHTML);
    }

    /**
     * By default HTML characters such as <code>"&lt;br&gt;"</code> will be written into the output description to format the
     * result. Setting <code>escapeHTML</code> true will instead force HTML values in the output to be displayed to the user
     * instead.
     *
     * @return Current escapeHTML value. Default value is null
     */
    public Boolean getEscapeHTML()  {
        return getAttributeAsBoolean("escapeHTML", true);
    }
    

    /**
     * Prefix to be prepended to each criterion description.
     *
     * @param prefix New prefix value. Default value is null
     * @return {@link com.smartgwt.client.data.CriteriaOutputSettings CriteriaOutputSettings} instance, for chaining setter calls
     */
    public CriteriaOutputSettings setPrefix(String prefix) {
        return (CriteriaOutputSettings)setAttribute("prefix", prefix);
    }

    /**
     * Prefix to be prepended to each criterion description.
     *
     * @return Current prefix value. Default value is null
     */
    public String getPrefix()  {
        return getAttributeAsString("prefix");
    }
    

    /**
     * Suffix to be appended to each criterion description.
     *
     * @param suffix New suffix value. Default value is null
     * @return {@link com.smartgwt.client.data.CriteriaOutputSettings CriteriaOutputSettings} instance, for chaining setter calls
     */
    public CriteriaOutputSettings setSuffix(String suffix) {
        return (CriteriaOutputSettings)setAttribute("suffix", suffix);
    }

    /**
     * Suffix to be appended to each criterion description.
     *
     * @return Current suffix value. Default value is null
     */
    public String getSuffix()  {
        return getAttributeAsString("suffix");
    }
    

    /**
     * {@link com.smartgwt.client.types.TextMatchStyle} to use if converting from a simple criteria. This property, if
     * specified, is passed to {@link com.smartgwt.client.data.DataSource#convertCriteria convertCriteria} to override the
     * default.
     *
     * @param textMatchStyle New textMatchStyle value. Default value is null
     * @return {@link com.smartgwt.client.data.CriteriaOutputSettings CriteriaOutputSettings} instance, for chaining setter calls
     */
    public CriteriaOutputSettings setTextMatchStyle(String textMatchStyle) {
        return (CriteriaOutputSettings)setAttribute("textMatchStyle", textMatchStyle);
    }

    /**
     * {@link com.smartgwt.client.types.TextMatchStyle} to use if converting from a simple criteria. This property, if
     * specified, is passed to {@link com.smartgwt.client.data.DataSource#convertCriteria convertCriteria} to override the
     * default.
     *
     * @return Current textMatchStyle value. Default value is null
     */
    public String getTextMatchStyle()  {
        return getAttributeAsString("textMatchStyle");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
