package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * What type of content is being displayed within the {@link com.smartgwt.client.widgets.HTMLFlow}? This content may come
 * from the {@link com.smartgwt.client.widgets.HTMLFlow#getContentsURL contentsURL} or be directly specified as {@link
 * com.smartgwt.client.widgets.HTMLFlow#getContents HTMLFlow.contents}.
 */
public enum ContentsType implements ValueEnum {
    /**
     * The HTML content is treated as a standalone document and displayed in an isolated context using an IFRAME.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "page".
     */
    PAGE("page"),
    /**
     * The HTML content is treated as a snippet designed to integrate into the main page and is directly inserted into the DOM.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "fragment".
     */
    FRAGMENT("fragment");
    private String value;

    ContentsType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
