package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Indicates the request format to be used for a REST operation.  Is only applicable to  {@link
 * com.smartgwt.client.docs.ServerRestConnector RestConnector DataSources}.  Note for all of these 
 * <code>RESTRequestFormat</code> options, only simple key-value criteria are supported; to  handle {@link
 * com.smartgwt.client.data.AdvancedCriteria}, you can use a  {@link
 * com.smartgwt.client.docs.serverds.DataSource#requestTemplate requestTemplate}, or subclass 
 * <code>com.isomorphic.dataSource.RestConnector</code> and override the <code>applyValuesOrCriteriaToRequest()</code>
 * method.
 */
public enum RESTRequestFormat implements ValueEnum {
    /**
     * Indicates that context is provided to the target REST service by setting parameter values 
     *  in the URL. With this request format, the {@link com.smartgwt.client.data.DSRequest}'s values or criteria will
     * be added to the {@link com.smartgwt.client.data.DataSource#getDataURL target dataURL} as standard HTTP parameters values
     * as 
     *  follows:<ul>
     *  <li>For "add" and "update" requests the "values" will be added to the target URL (see
     *  the server-side Javadoc for <code>DSRequest.getValues()</code>)</li>
     *  <li>For "fetch" and "remove" requests, where the concept of "values" doesn't make sense, 
     *  the "criteria" will be added to the target URL (see the server-side Javadoc for 
     *  <code>DSRequest.getCriteria()</code>)</li>
     *  </ul>
     *  So if we had a fetch request that specified criteria like this:<pre>
     *  {countryCode: "US", stateCode: "CA"}
     *  </pre>
     *  and a {@link com.smartgwt.client.data.OperationBinding#getDataURL dataURL} like this:<pre>
     *  <dataURL>https://somerestservice.com/customer/fetch</dataURL>
     *  </pre>
     *  we would end up with a target URL like this:<pre>
     *  https://somerestservice.com/customer/fetch?countryCode=US&stateCode=CA
     *  </pre>
     * Also, note that any explicitly declared {@link com.smartgwt.client.docs.serverds.DataSource#params params} will also be
     * added 
     *  to the target URL as standard HTTP parameters, as well as the request values/criteria (if 
     *  there are any name collisions, the request values/criteria take precedence).
     *  <p>
     *  This format is often used to supply criteria to "fetch" operations, and primary-key values 
     *  to "remove" operations. However, this is by no means a universal approach; different REST 
     *  services adopt different approaches, there is no generally-accepted "right way" to handle
     *  things
     *  <p>
     * It is possible to suppress this automatic mapping - see {@link
     * com.smartgwt.client.docs.serverds.DataSource#suppressAutoMappings DataSource.suppressAutoMappings}
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "params".
     */
    PARAMS("params"),
    /**
     * Indicates that context is provided to the target REST service by providing a block of 
     *  JSON-encoded text in the body of the HTTP request sent to the REST server. With this 
     *  request format, <code>RestConnector</code> will render an incoming 
     *  {@link com.smartgwt.client.data.DSRequest}'s values or criteria as a JSON object; for "add" and "update" requests,
     *  the "values" will be used, and for "fetch" and "remove" operations, the criteria will be 
     *  used (see the server-side Javadoc for <code>DSRequest.getCriteria()</code>). 
     *  <p>
     *  So if we had an add request with the following record:<pre>
     *  {
     *  customerId: 7023,
     *  customerName: "Bay Financials inc",
     *  city: "San Francisco",
     *  countryCode: "US", 
     *  stateCode: "CA"
     *  }
     *  </pre>
     *  those values would be included, in strict JSON form, in the body of the HTTP request that
     *  <code>RestConnector</code> sends to the REST webservice:<pre>
     *  {"customerId": 7023,"customerName": "Bay Financials inc",
     *  "city: "San Francisco","countryCode": "US", "stateCode": "CA"}
     *  </pre>
     *  <p>
     *  This format is most often used when you need to supply more extensive amounts of data, like
     *  entire records to "add" and "update" operations. However, as mentioned above, this is by no
     *  means a universal approach, and some REST services use URL parameters even when specifying
     *  entire records of data. Also, some REST services use XML rather than JSON
     *  <p>
     * Note, if there is a {@link com.smartgwt.client.docs.serverds.DataSource#requestTemplate requestTemplate} in force, we
     * use that
     *  to drive the content and format of the generated JSON block
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "json".
     */
    JSON("json"),
    /**
     * Indicates that context is provided to the target REST service by providing a block of 
     *  XML text in the body of the HTTP request sent to the REST server. With this 
     *  request format, <code>RestConnector</code> will render an incoming 
     *  {@link com.smartgwt.client.data.DSRequest}'s values or criteria as a snippet of XML text; for "add" and "update" 
     *  requests, the "values" will be used, and for "fetch" and "remove" operations, the criteria 
     *  will be used (see the server-side Javadoc for <code>DSRequest.getCriteria()</code>). The 
     * name of the enclosing tag is specified in {@link com.smartgwt.client.docs.serverds.DataSource#xmlTag DataSource.xmlTag}.
     * 
     *  <p>
     *  So if we had an add request with the following record:<pre>
     *  {
     *  customerId: 7023,
     *  customerName: "Bay Financials inc",
     *  city: "San Francisco",
     *  countryCode: "US", 
     *  stateCode: "CA"
     *  }
     *  </pre>
     *  those values would be included in the body of the HTTP request that <code>RestConnector</code> 
     *  sends to the REST webservice (assuming the <code>xmlTag</code> is "customer"):<pre>
     *  &lt;customer&gt;
     *  &lt;customerId&gt;7023&lt;/customerId&gt;
     *  &lt;customerName&gt;Bay Financials inc"&lt;/customerName&gt;
     *  &lt;city&gt;San Francisco&lt;/city&gt;
     *  &lt;countryCode&gt;US&lt;/countryCode&gt;
     *  &lt;stateCode&gt;CA"&lt;/stateCode&gt;
     *  &lt;/customer&gt;
     *  </pre>
     *  <p>
     * Note, if there is a {@link com.smartgwt.client.docs.serverds.DataSource#requestTemplate requestTemplate} in force, we
     * use that
     *  to drive the content and format of the generated XML
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "xml".
     */
    XML("xml");
    private String value;

    RESTRequestFormat(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
