/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.util.tour;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * The Tour class allows you to build tours and tutorials for end users, highlighting specific  components on the page and
 * prompting for specific user-interactions. <P> Tours are a specific type of {@link
 * com.smartgwt.client.util.workflow.Process Workflow Process} and  consist of a series of {@link
 * com.smartgwt.client.util.tour.TourStep TourSteps}. Typically each step refers to an element  on the page, which is
 * either being highlighted for the user, or, for a tutorial, is an element  that the user is being prompted to interact
 * with (see TourStep.clickTarget, for example). <P>  Most steps have a TourWindow, which shows explanatory or
 * instructional text. For tutorial steps  that request a user action, the target can be highlighted and a large arrow is
 * shown pointing at  the target. <P> The placement of the TourWindow and arrow is automatic, and intelligently takes into
 * account the  type of interaction requested. For example, if a tutorial requires a user to change a value in a 
 * SelectItem, the TourWindow and arrow will avoid appearing underneath the select, where they could  be occluded by the
 * drop-down picklist.  Similarly, for a drag and drop interaction, the TourWindow  avoids overlapping both the drag source
 * and the drop area. <P> Because of all this automatic behavior, a tutorial step typically consists of just: <P> 1.
 * explanatory text (tourStep.title and tourStep.description)<br> 2. the target<br> 3. the expected interaction (eg click
 * the target, or type something in, or drag something to  another widget)<br> 4. validation of input (what was typed or
 * chosen), if applicable <P> Developers may use {@link com.smartgwt.client.util.AutoTest#getLocator AutoTest locators} to
 * specify specific components  or elements as action targets. Using locators means that tours and tutorials will typically
 * still  work even if your application changes (for example, new controls are added). Note that we recommend  making use
 * of the {@link com.smartgwt.client.util.AutoTest#installLocatorShortcut locator shortcut} to rapidly generate  locators.
 * <P> A tour is typically written as a <code>.proc.xml</code> document stored in the folder configured  via the
 * <code>project.processes</code> setting in {@link com.smartgwt.client.docs.Server_properties server.properties}
 * (webroot/processes by default). They may be loaded via the {@link com.smartgwt.client.util.tour.Tour#loadTour
 * loadTour()} method. <P> <b>The Tour feature is available with Power or better licenses only</b>  See  <a
 * href="http://smartclient.com/product">smartclient.com/product</a> for details.<br> It requires the standard DataBinding
 * and {@link com.smartgwt.client.docs.LoadingOptionalModules optional} <code>Tour</code> module.
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("Tour")
public class Tour extends Process {

    public static Tour getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        BaseClass obj = BaseClass.getRef(jsObj);
        if(obj != null) {
            return (Tour) obj;
        } else {
            return new Tour(jsObj);
        }
    }
        


    public Tour(){
        if("LGPL".equals(SC.getLicenseType()) || "Pro".equals(SC.getLicenseType())) {
                
						throw new java.lang.IllegalStateException("Tour is a part the Tour Module which comes with Power Edition or better. Please see smartclient.com/product for details on licensing.");
						
					} else if(SC.hasTour()==false || SC.hasWorkflow()==false || SC.hasDrawing()==false) {
					
						throw new java.lang.IllegalStateException("The standard DataBinding / Drawing and optional Tour modules are required to use the Tour class.  See the LoadingOptionalModules overview in the \"docs\" package of JavaDoc for instructions.");
			        }
        		scClassName = "Tour";
    }

    public Tour(JavaScriptObject jsObj){
        scClassName = "Tour";
        setJavaScriptObject(jsObj);
    }

    public native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.core.BaseClass::getConfig()();
        var scClassName = this.@com.smartgwt.client.core.BaseClass::scClassName;
        return $wnd.isc[scClassName].create(config);
    }-*/;


    // ********************* Properties / Attributes ***********************

    /**
     * Default value for {@link com.smartgwt.client.util.tour.TourStep#getAllowDropOnDescendants
     * TourStep.allowDropOnDescendants} within this tour.
     *
     * @param allowDropOnDescendants New allowDropOnDescendants value. Default value is false
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     */
    public Tour setAllowDropOnDescendants(boolean allowDropOnDescendants) {
        return (Tour)setAttribute("allowDropOnDescendants", allowDropOnDescendants, true);
    }

    /**
     * Default value for {@link com.smartgwt.client.util.tour.TourStep#getAllowDropOnDescendants
     * TourStep.allowDropOnDescendants} within this tour.
     *
     * @return Current allowDropOnDescendants value. Default value is false
     */
    public boolean getAllowDropOnDescendants()  {
        Boolean result = getAttributeAsBoolean("allowDropOnDescendants");
        return result == null ? false : result;
    }
    

    /**
     * Should tour be auto-reset once it finishes in any manner so it can restarted?
     *
     * @param autoReset New autoReset value. Default value is true
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Tour setAutoReset(Boolean autoReset)  throws IllegalStateException {
        return (Tour)setAttribute("autoReset", autoReset, false);
    }

    /**
     * Should tour be auto-reset once it finishes in any manner so it can restarted?
     *
     * @return Current autoReset value. Default value is true
     */
    public Boolean getAutoReset()  {
        Boolean result = getAttributeAsBoolean("autoReset");
        return result == null ? true : result;
    }
    

    /**
     * Set to <code>false</code> to prevent tour steps from allowing the user to cancel the tour. By default the cancel button
     * will still be shown but is disabled.  Set {@link com.smartgwt.client.util.tour.Tour#getShowCancelButton
     * showCancelButton} to false to suppress the cancel button entirely. <p> Any time the cancel button is visible, its hover
     * can be customized via {@link com.smartgwt.client.util.tour.Tour#getStepCancelButtonPrompt stepCancelButtonPrompt}. For
     * <code>canCancel:false</code> tours where the cancel button is not hidden, a custom prompt may be useful to provide an
     * explanation to the user as the tour can't be canceled.
     *
     * @param canCancel New canCancel value. Default value is null
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Tour setCanCancel(Boolean canCancel)  throws IllegalStateException {
        return (Tour)setAttribute("canCancel", canCancel, false);
    }

    /**
     * Set to <code>false</code> to prevent tour steps from allowing the user to cancel the tour. By default the cancel button
     * will still be shown but is disabled.  Set {@link com.smartgwt.client.util.tour.Tour#getShowCancelButton
     * showCancelButton} to false to suppress the cancel button entirely. <p> Any time the cancel button is visible, its hover
     * can be customized via {@link com.smartgwt.client.util.tour.Tour#getStepCancelButtonPrompt stepCancelButtonPrompt}. For
     * <code>canCancel:false</code> tours where the cancel button is not hidden, a custom prompt may be useful to provide an
     * explanation to the user as the tour can't be canceled.
     *
     * @return Current canCancel value. Default value is null
     */
    public Boolean getCanCancel()  {
        return getAttributeAsBoolean("canCancel");
    }
    

    /**
     * The {@link com.smartgwt.client.util.workflow.ProcessElement}s representing steps that should be performed if the user
     * cancels the tour. These steps are typically {@link com.smartgwt.client.util.tour.TourStep}s. <P> Alternately, or in
     * addition to these cancelation steps, the {@link com.smartgwt.client.util.workflow.Process#addFinishedHandler finished}
     * method will be called once there are no more steps to process in the tour.
     *
     * @param cancelSteps New cancelSteps value. Default value is null
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Tour setCancelSteps(ProcessElement... cancelSteps)  throws IllegalStateException {
        return (Tour)setAttribute("cancelSteps", cancelSteps, false);
    }

    /**
     * The {@link com.smartgwt.client.util.workflow.ProcessElement}s representing steps that should be performed if the user
     * cancels the tour. These steps are typically {@link com.smartgwt.client.util.tour.TourStep}s. <P> Alternately, or in
     * addition to these cancelation steps, the {@link com.smartgwt.client.util.workflow.Process#addFinishedHandler finished}
     * method will be called once there are no more steps to process in the tour.
     *
     * @return Current cancelSteps value. Default value is null
     */
    public ProcessElement[] getCancelSteps()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfProcessElement(getAttributeAsJavaScriptObject("cancelSteps"));
    }
    

    /**
     * Set the CSS border of the outline for drop targets as a CSS string including border-width, border-style, and/or color
     * (eg "1px dashed blue"). See {@link com.smartgwt.client.util.tour.Tour#getOutlineBorder outlineBorder} for properties
     * applied to non-drop targets. <P> This property applies the same border to all four sides of the outlined component(s).
     *
     * @param dropOutlineBorder New dropOutlineBorder value. Default value is "1px solid #44ff44"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @see com.smartgwt.client.util.tour.Tour#setOutlineBorder
     */
    public Tour setDropOutlineBorder(String dropOutlineBorder) {
        return (Tour)setAttribute("dropOutlineBorder", dropOutlineBorder, true);
    }

    /**
     * Set the CSS border of the outline for drop targets as a CSS string including border-width, border-style, and/or color
     * (eg "1px dashed blue"). See {@link com.smartgwt.client.util.tour.Tour#getOutlineBorder outlineBorder} for properties
     * applied to non-drop targets. <P> This property applies the same border to all four sides of the outlined component(s).
     *
     * @return Current dropOutlineBorder value. Default value is "1px solid #44ff44"
     * @see com.smartgwt.client.util.tour.Tour#getOutlineBorder
     */
    public String getDropOutlineBorder()  {
        return getAttributeAsString("dropOutlineBorder");
    }
    

    /**
     * Default value of {@link com.smartgwt.client.util.tour.TourStep#getActionButtonTitle TourStep.actionButtonTitle} for the
     * first step in the tour. <P> Default titles for the middle and last steps are configured by {@link
     * com.smartgwt.client.util.tour.Tour#getStepActionButtonTitle stepActionButtonTitle} and {@link
     * com.smartgwt.client.util.tour.Tour#getLastStepActionButtonTitle lastStepActionButtonTitle} respectively.
     *
     * @param firstStepActionButtonTitle New firstStepActionButtonTitle value. Default value is "Let's go!"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setFirstStepActionButtonTitle(String firstStepActionButtonTitle)  throws IllegalStateException {
        return (Tour)setAttribute("firstStepActionButtonTitle", firstStepActionButtonTitle, false);
    }

    /**
     * Default value of {@link com.smartgwt.client.util.tour.TourStep#getActionButtonTitle TourStep.actionButtonTitle} for the
     * first step in the tour. <P> Default titles for the middle and last steps are configured by {@link
     * com.smartgwt.client.util.tour.Tour#getStepActionButtonTitle stepActionButtonTitle} and {@link
     * com.smartgwt.client.util.tour.Tour#getLastStepActionButtonTitle lastStepActionButtonTitle} respectively.
     *
     * @return Current firstStepActionButtonTitle value. Default value is "Let's go!"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getFirstStepActionButtonTitle()  {
        return getAttributeAsString("firstStepActionButtonTitle");
    }
    

    /**
     * Default value of {@link com.smartgwt.client.util.tour.TourStep#getCancelButtonTitle TourStep.cancelButtonTitle} for the
     * first step in the tour. <P> Default title for the middle steps is configured by {@link
     * com.smartgwt.client.util.tour.Tour#getStepCancelButtonTitle stepCancelButtonTitle}. No cancel button is shown for the
     * last step.
     *
     * @param firstStepCancelButtonTitle New firstStepCancelButtonTitle value. Default value is "Skip this tour"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setFirstStepCancelButtonTitle(String firstStepCancelButtonTitle)  throws IllegalStateException {
        return (Tour)setAttribute("firstStepCancelButtonTitle", firstStepCancelButtonTitle, false);
    }

    /**
     * Default value of {@link com.smartgwt.client.util.tour.TourStep#getCancelButtonTitle TourStep.cancelButtonTitle} for the
     * first step in the tour. <P> Default title for the middle steps is configured by {@link
     * com.smartgwt.client.util.tour.Tour#getStepCancelButtonTitle stepCancelButtonTitle}. No cancel button is shown for the
     * last step.
     *
     * @return Current firstStepCancelButtonTitle value. Default value is "Skip this tour"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getFirstStepCancelButtonTitle()  {
        return getAttributeAsString("firstStepCancelButtonTitle");
    }
    

    /**
     * Default value of {@link com.smartgwt.client.util.tour.TourStep#getActionButtonTitle TourStep.actionButtonTitle} for the
     * last step in the tour. <P> Default titles for the first and middle steps are configured by {@link
     * com.smartgwt.client.util.tour.Tour#getFirstStepActionButtonTitle firstStepActionButtonTitle} and {@link
     * com.smartgwt.client.util.tour.Tour#getStepActionButtonTitle stepActionButtonTitle} respectively.
     *
     * @param lastStepActionButtonTitle New lastStepActionButtonTitle value. Default value is "Done"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setLastStepActionButtonTitle(String lastStepActionButtonTitle)  throws IllegalStateException {
        return (Tour)setAttribute("lastStepActionButtonTitle", lastStepActionButtonTitle, false);
    }

    /**
     * Default value of {@link com.smartgwt.client.util.tour.TourStep#getActionButtonTitle TourStep.actionButtonTitle} for the
     * last step in the tour. <P> Default titles for the first and middle steps are configured by {@link
     * com.smartgwt.client.util.tour.Tour#getFirstStepActionButtonTitle firstStepActionButtonTitle} and {@link
     * com.smartgwt.client.util.tour.Tour#getStepActionButtonTitle stepActionButtonTitle} respectively.
     *
     * @return Current lastStepActionButtonTitle value. Default value is "Done"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getLastStepActionButtonTitle()  {
        return getAttributeAsString("lastStepActionButtonTitle");
    }
    

    /**
     * The tour mode allows step configuration to be simplified by using the context to apply appropriate defaults.
     *
     * @param mode New mode value. Default value is "tour"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     */
    public Tour setMode(TourMode mode) {
        return (Tour)setAttribute("mode", mode == null ? null : mode.getValue(), true);
    }

    /**
     * The tour mode allows step configuration to be simplified by using the context to apply appropriate defaults.
     *
     * @return Current mode value. Default value is "tour"
     */
    public TourMode getMode()  {
        return EnumUtil.getEnum(TourMode.values(), getAttribute("mode"));
    }
    

    /**
     * Defaults settings for {@link com.smartgwt.client.docs.NotifyType notifyType} message displayed by {@link
     * com.smartgwt.client.util.tour.Tour#notifyValidationMessage notifyValidationMessage}.
     *
     * @param notifyMessageSettings New notifyMessageSettings value. Default value is null
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Tour setNotifyMessageSettings(NotifySettings notifyMessageSettings)  throws IllegalStateException {
        return (Tour)setAttribute("notifyMessageSettings", notifyMessageSettings == null ? null : notifyMessageSettings.getJsObj(), false);
    }

    /**
     * Defaults settings for {@link com.smartgwt.client.docs.NotifyType notifyType} message displayed by {@link
     * com.smartgwt.client.util.tour.Tour#notifyValidationMessage notifyValidationMessage}.
     *
     * @return Current notifyMessageSettings value. Default value is null
     */
    public NotifySettings getNotifyMessageSettings()  {
        return new NotifySettings(getAttributeAsJavaScriptObject("notifyMessageSettings"));
    }
    

    /**
     * Category of message to use in +{notifyValidationMessage,notifyValidationMessage} by default. <P> If this category has
     * not been configured in {@link com.smartgwt.client.widgets.notify.Notify} it will be automatically configured using
     * +{notifyMessageSettings,notifyMessageSettings}.
     *
     * @param notifyType New notifyType value. Default value is "tourExpectedValue"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.NotifyType NotifyType 
     */
    public Tour setNotifyType(String notifyType)  throws IllegalStateException {
        return (Tour)setAttribute("notifyType", notifyType, false);
    }

    /**
     * Category of message to use in +{notifyValidationMessage,notifyValidationMessage} by default. <P> If this category has
     * not been configured in {@link com.smartgwt.client.widgets.notify.Notify} it will be automatically configured using
     * +{notifyMessageSettings,notifyMessageSettings}.
     *
     * @return Current notifyType value. Default value is "tourExpectedValue"
     * @see com.smartgwt.client.docs.NotifyType NotifyType 
     */
    public String getNotifyType()  {
        return getAttributeAsString("notifyType");
    }
    

    /**
     * Set the CSS border of the outline of non-drop targets as a CSS string including border-width, border-style, and/or color
     * (eg "1px dashed blue"). See {@link com.smartgwt.client.util.tour.Tour#getDropOutlineBorder dropOutlineBorder} for
     * properties applied to drop targets. <P> This property applies the same border to all four sides of the outlined
     * component(s).
     *
     * @param outlineBorder New outlineBorder value. Default value is "1px solid red"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @see com.smartgwt.client.util.tour.Tour#setDropOutlineBorder
     */
    public Tour setOutlineBorder(String outlineBorder) {
        return (Tour)setAttribute("outlineBorder", outlineBorder, true);
    }

    /**
     * Set the CSS border of the outline of non-drop targets as a CSS string including border-width, border-style, and/or color
     * (eg "1px dashed blue"). See {@link com.smartgwt.client.util.tour.Tour#getDropOutlineBorder dropOutlineBorder} for
     * properties applied to drop targets. <P> This property applies the same border to all four sides of the outlined
     * component(s).
     *
     * @return Current outlineBorder value. Default value is "1px solid red"
     * @see com.smartgwt.client.util.tour.Tour#getDropOutlineBorder
     */
    public String getOutlineBorder()  {
        return getAttributeAsString("outlineBorder");
    }
    

    /**
     * This property allows you to override the {@link com.smartgwt.client.widgets.tour.TourWindow#getShowCancelButton
     * TourWindow.showCancelButton} to hide the cancel button for all steps of the tour. <P> See also {@link
     * com.smartgwt.client.util.tour.Tour#getCanCancel canCancel}
     *
     * @param showCancelButton New showCancelButton value. Default value is null
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Tour setShowCancelButton(Boolean showCancelButton)  throws IllegalStateException {
        return (Tour)setAttribute("showCancelButton", showCancelButton, false);
    }

    /**
     * This property allows you to override the {@link com.smartgwt.client.widgets.tour.TourWindow#getShowCancelButton
     * TourWindow.showCancelButton} to hide the cancel button for all steps of the tour. <P> See also {@link
     * com.smartgwt.client.util.tour.Tour#getCanCancel canCancel}
     *
     * @return Current showCancelButton value. Default value is null
     */
    public Boolean getShowCancelButton()  {
        return getAttributeAsBoolean("showCancelButton");
    }
    

    /**
     * Should {@link com.smartgwt.client.util.tour.TourStep#getInputValidationNotifyMessage
     * TourStep.inputValidationNotifyMessage} be shown as detailed in {@link com.smartgwt.client.types.TourInputValidationMode}
     * for the entire tour? Set to <code>false</code> to suppress reporting messages to the user. {@link
     * com.smartgwt.client.util.tour.Tour#notifyValidationMessage notifyValidationMessage} will not be called. <P> This setting
     * can be overridden for individual {@link com.smartgwt.client.util.tour.TourStep tourSteps}.
     *
     * @param showInputValidationMessage New showInputValidationMessage value. Default value is null
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Tour setShowInputValidationMessage(Boolean showInputValidationMessage)  throws IllegalStateException {
        return (Tour)setAttribute("showInputValidationMessage", showInputValidationMessage, false);
    }

    /**
     * Should {@link com.smartgwt.client.util.tour.TourStep#getInputValidationNotifyMessage
     * TourStep.inputValidationNotifyMessage} be shown as detailed in {@link com.smartgwt.client.types.TourInputValidationMode}
     * for the entire tour? Set to <code>false</code> to suppress reporting messages to the user. {@link
     * com.smartgwt.client.util.tour.Tour#notifyValidationMessage notifyValidationMessage} will not be called. <P> This setting
     * can be overridden for individual {@link com.smartgwt.client.util.tour.TourStep tourSteps}.
     *
     * @return Current showInputValidationMessage value. Default value is null
     */
    public Boolean getShowInputValidationMessage()  {
        return getAttributeAsBoolean("showInputValidationMessage");
    }
    

    /**
     * Should a progress bar be shown in each step to indicate progress through the tour?
     *
     * @param showProgress New showProgress value. Default value is null
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Tour setShowProgress(Boolean showProgress)  throws IllegalStateException {
        return (Tour)setAttribute("showProgress", showProgress, false);
    }

    /**
     * Should a progress bar be shown in each step to indicate progress through the tour?
     *
     * @return Current showProgress value. Default value is null
     */
    public Boolean getShowProgress()  {
        return getAttributeAsBoolean("showProgress");
    }
    

    /**
     * Show progress percent next to progress bar when {@link com.smartgwt.client.util.tour.Tour#getShowProgress showProgress}
     * is enabled?
     *
     * @param showProgressPercent New showProgressPercent value. Default value is null
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Tour setShowProgressPercent(Boolean showProgressPercent)  throws IllegalStateException {
        return (Tour)setAttribute("showProgressPercent", showProgressPercent, false);
    }

    /**
     * Show progress percent next to progress bar when {@link com.smartgwt.client.util.tour.Tour#getShowProgress showProgress}
     * is enabled?
     *
     * @return Current showProgressPercent value. Default value is null
     */
    public Boolean getShowProgressPercent()  {
        return getAttributeAsBoolean("showProgressPercent");
    }
    

    /**
     * Default value for {@link com.smartgwt.client.util.tour.TourStep#getActionButtonTitle TourStep.actionButtonTitle} for
     * steps other than the first and last ones. <P> Default titles for the first and last steps are configured by {@link
     * com.smartgwt.client.util.tour.Tour#getFirstStepActionButtonTitle firstStepActionButtonTitle} and {@link
     * com.smartgwt.client.util.tour.Tour#getLastStepActionButtonTitle lastStepActionButtonTitle} respectively.
     *
     * @param stepActionButtonTitle New stepActionButtonTitle value. Default value is "Next"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.util.tour.Tour#setStepCancelButtonTitle
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setStepActionButtonTitle(String stepActionButtonTitle)  throws IllegalStateException {
        return (Tour)setAttribute("stepActionButtonTitle", stepActionButtonTitle, false);
    }

    /**
     * Default value for {@link com.smartgwt.client.util.tour.TourStep#getActionButtonTitle TourStep.actionButtonTitle} for
     * steps other than the first and last ones. <P> Default titles for the first and last steps are configured by {@link
     * com.smartgwt.client.util.tour.Tour#getFirstStepActionButtonTitle firstStepActionButtonTitle} and {@link
     * com.smartgwt.client.util.tour.Tour#getLastStepActionButtonTitle lastStepActionButtonTitle} respectively.
     *
     * @return Current stepActionButtonTitle value. Default value is "Next"
     * @see com.smartgwt.client.util.tour.Tour#getStepCancelButtonTitle
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getStepActionButtonTitle()  {
        return getAttributeAsString("stepActionButtonTitle");
    }
    

    /**
     * Prompt displayed in hover for cancel button.
     *
     * @param stepCancelButtonPrompt New stepCancelButtonPrompt value. Default value is null
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setStepCancelButtonPrompt(String stepCancelButtonPrompt)  throws IllegalStateException {
        return (Tour)setAttribute("stepCancelButtonPrompt", stepCancelButtonPrompt, false);
    }

    /**
     * Prompt displayed in hover for cancel button.
     *
     * @return Current stepCancelButtonPrompt value. Default value is null
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getStepCancelButtonPrompt()  {
        return getAttributeAsString("stepCancelButtonPrompt");
    }
    

    /**
     * Default value for {@link com.smartgwt.client.util.tour.TourStep#getCancelButtonTitle TourStep.cancelButtonTitle} for all
     * steps where the cancel button is shown. <P> Default title for the first step is configured by {@link
     * com.smartgwt.client.util.tour.Tour#getFirstStepCancelButtonTitle firstStepCancelButtonTitle}.
     *
     * @param stepCancelButtonTitle New stepCancelButtonTitle value. Default value is "Skip this tour"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.util.tour.Tour#setStepActionButtonTitle
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setStepCancelButtonTitle(String stepCancelButtonTitle)  throws IllegalStateException {
        return (Tour)setAttribute("stepCancelButtonTitle", stepCancelButtonTitle, false);
    }

    /**
     * Default value for {@link com.smartgwt.client.util.tour.TourStep#getCancelButtonTitle TourStep.cancelButtonTitle} for all
     * steps where the cancel button is shown. <P> Default title for the first step is configured by {@link
     * com.smartgwt.client.util.tour.Tour#getFirstStepCancelButtonTitle firstStepCancelButtonTitle}.
     *
     * @return Current stepCancelButtonTitle value. Default value is "Skip this tour"
     * @see com.smartgwt.client.util.tour.Tour#getStepActionButtonTitle
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getStepCancelButtonTitle()  {
        return getAttributeAsString("stepCancelButtonTitle");
    }
    

    /**
     * The {@link com.smartgwt.client.util.workflow.ProcessElement}s representing steps in this tour. These steps are typically
     * {@link com.smartgwt.client.util.tour.TourStep}s.
     *
     * @param steps New steps value. Default value is null
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public Tour setSteps(ProcessElement... steps)  throws IllegalStateException {
        return (Tour)setAttribute("steps", steps, false);
    }

    /**
     * The {@link com.smartgwt.client.util.workflow.ProcessElement}s representing steps in this tour. These steps are typically
     * {@link com.smartgwt.client.util.tour.TourStep}s.
     *
     * @return Current steps value. Default value is null
     */
    public ProcessElement[] getSteps()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfProcessElement(getAttributeAsJavaScriptObject("steps"));
    }
    

    /**
     * Title for the <i>Make Changes...</i> button in the TourComplete dialog.
     *
     * @param tourCompleteMakeChangesButtonTitle New tourCompleteMakeChangesButtonTitle value. Default value is "Make Changes..."
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourCompleteMakeChangesButtonTitle(String tourCompleteMakeChangesButtonTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourCompleteMakeChangesButtonTitle", tourCompleteMakeChangesButtonTitle, false);
    }

    /**
     * Title for the <i>Make Changes...</i> button in the TourComplete dialog.
     *
     * @return Current tourCompleteMakeChangesButtonTitle value. Default value is "Make Changes..."
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourCompleteMakeChangesButtonTitle()  {
        return getAttributeAsString("tourCompleteMakeChangesButtonTitle");
    }
    

    /**
     * Title for the <i>View XML</i> button in the TourComplete dialog.
     *
     * @param tourCompleteRunTourButtonTitle New tourCompleteRunTourButtonTitle value. Default value is "Run Tour"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourCompleteRunTourButtonTitle(String tourCompleteRunTourButtonTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourCompleteRunTourButtonTitle", tourCompleteRunTourButtonTitle, false);
    }

    /**
     * Title for the <i>View XML</i> button in the TourComplete dialog.
     *
     * @return Current tourCompleteRunTourButtonTitle value. Default value is "Run Tour"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourCompleteRunTourButtonTitle()  {
        return getAttributeAsString("tourCompleteRunTourButtonTitle");
    }
    

    /**
     * Title for the <i>Tour Complete</i> dialog displayed after recording a Tour.
     *
     * @param tourCompleteTitle New tourCompleteTitle value. Default value is "New Tour Recording Complete"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourCompleteTitle(String tourCompleteTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourCompleteTitle", tourCompleteTitle, false);
    }

    /**
     * Title for the <i>Tour Complete</i> dialog displayed after recording a Tour.
     *
     * @return Current tourCompleteTitle value. Default value is "New Tour Recording Complete"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourCompleteTitle()  {
        return getAttributeAsString("tourCompleteTitle");
    }
    

    /**
     * Title for the <i>Tour ID</i> field in the TourComplete dialog.
     *
     * @param tourCompleteTourIdTitle New tourCompleteTourIdTitle value. Default value is "Tour ID"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourCompleteTourIdTitle(String tourCompleteTourIdTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourCompleteTourIdTitle", tourCompleteTourIdTitle, false);
    }

    /**
     * Title for the <i>Tour ID</i> field in the TourComplete dialog.
     *
     * @return Current tourCompleteTourIdTitle value. Default value is "Tour ID"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourCompleteTourIdTitle()  {
        return getAttributeAsString("tourCompleteTourIdTitle");
    }
    

    /**
     * Title for the <i>View XML</i> button in the TourComplete dialog.
     *
     * @param tourCompleteViewXMLButtonTitle New tourCompleteViewXMLButtonTitle value. Default value is "View XML"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourCompleteViewXMLButtonTitle(String tourCompleteViewXMLButtonTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourCompleteViewXMLButtonTitle", tourCompleteViewXMLButtonTitle, false);
    }

    /**
     * Title for the <i>View XML</i> button in the TourComplete dialog.
     *
     * @return Current tourCompleteViewXMLButtonTitle value. Default value is "View XML"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourCompleteViewXMLButtonTitle()  {
        return getAttributeAsString("tourCompleteViewXMLButtonTitle");
    }
    

    /**
     * Title for the <i>Action Type</i> field in the TourStep Wizard.
     *
     * @param tourStepWizardActionTypeTitle New tourStepWizardActionTypeTitle value. Default value is "Action Type"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardActionTypeTitle(String tourStepWizardActionTypeTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardActionTypeTitle", tourStepWizardActionTypeTitle, false);
    }

    /**
     * Title for the <i>Action Type</i> field in the TourStep Wizard.
     *
     * @return Current tourStepWizardActionTypeTitle value. Default value is "Action Type"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardActionTypeTitle()  {
        return getAttributeAsString("tourStepWizardActionTypeTitle");
    }
    

    /**
     * Prompt for the <i>Auto Complete</i> field in the TourStep Wizard.
     *
     * @param tourStepWizardAutoCompletePrompt New tourStepWizardAutoCompletePrompt value. Default value is "Should the tour move forward when the user completes the chosen action?"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardAutoCompletePrompt(String tourStepWizardAutoCompletePrompt)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardAutoCompletePrompt", tourStepWizardAutoCompletePrompt, false);
    }

    /**
     * Prompt for the <i>Auto Complete</i> field in the TourStep Wizard.
     *
     * @return Current tourStepWizardAutoCompletePrompt value. Default value is "Should the tour move forward when the user completes the chosen action?"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardAutoCompletePrompt()  {
        return getAttributeAsString("tourStepWizardAutoCompletePrompt");
    }
    

    /**
     * Title for the <i>Auto Complete</i> field in the TourStep Wizard.
     *
     * @param tourStepWizardAutoCompleteTitle New tourStepWizardAutoCompleteTitle value. Default value is "Auto Complete"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardAutoCompleteTitle(String tourStepWizardAutoCompleteTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardAutoCompleteTitle", tourStepWizardAutoCompleteTitle, false);
    }

    /**
     * Title for the <i>Auto Complete</i> field in the TourStep Wizard.
     *
     * @return Current tourStepWizardAutoCompleteTitle value. Default value is "Auto Complete"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardAutoCompleteTitle()  {
        return getAttributeAsString("tourStepWizardAutoCompleteTitle");
    }
    

    /**
     * Hint for the <i>Bind Output</i> field in the TourStep Wizard.
     *
     * @param tourStepWizardBindOutputHint New tourStepWizardBindOutputHint value. Default value is "Bind to variable for later use"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardBindOutputHint(String tourStepWizardBindOutputHint)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardBindOutputHint", tourStepWizardBindOutputHint, false);
    }

    /**
     * Hint for the <i>Bind Output</i> field in the TourStep Wizard.
     *
     * @return Current tourStepWizardBindOutputHint value. Default value is "Bind to variable for later use"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardBindOutputHint()  {
        return getAttributeAsString("tourStepWizardBindOutputHint");
    }
    

    /**
     * Title for the <i>Bind Output</i> field in the TourStep Wizard.
     *
     * @param tourStepWizardBindOutputTitle New tourStepWizardBindOutputTitle value. Default value is "Bind Output"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardBindOutputTitle(String tourStepWizardBindOutputTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardBindOutputTitle", tourStepWizardBindOutputTitle, false);
    }

    /**
     * Title for the <i>Bind Output</i> field in the TourStep Wizard.
     *
     * @return Current tourStepWizardBindOutputTitle value. Default value is "Bind Output"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardBindOutputTitle()  {
        return getAttributeAsString("tourStepWizardBindOutputTitle");
    }
    

    /**
     * Title for the <i>Case Sensitive</i> field in the TourStep Wizard.
     *
     * @param tourStepWizardCaseSensitiveTitle New tourStepWizardCaseSensitiveTitle value. Default value is "Case Sensitive"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardCaseSensitiveTitle(String tourStepWizardCaseSensitiveTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardCaseSensitiveTitle", tourStepWizardCaseSensitiveTitle, false);
    }

    /**
     * Title for the <i>Case Sensitive</i> field in the TourStep Wizard.
     *
     * @return Current tourStepWizardCaseSensitiveTitle value. Default value is "Case Sensitive"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardCaseSensitiveTitle()  {
        return getAttributeAsString("tourStepWizardCaseSensitiveTitle");
    }
    

    /**
     * Title for the <i>Done</i> button in the TourStep Wizard.
     *
     * @param tourStepWizardDoneButtonTitle New tourStepWizardDoneButtonTitle value. Default value is "Done"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardDoneButtonTitle(String tourStepWizardDoneButtonTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardDoneButtonTitle", tourStepWizardDoneButtonTitle, false);
    }

    /**
     * Title for the <i>Done</i> button in the TourStep Wizard.
     *
     * @return Current tourStepWizardDoneButtonTitle value. Default value is "Done"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardDoneButtonTitle()  {
        return getAttributeAsString("tourStepWizardDoneButtonTitle");
    }
    

    /**
     * Hint for the <i>Drop Target</i> field in the TourStep Wizard.
     *
     * @param tourStepWizardDropTargetHint New tourStepWizardDropTargetHint value. Default value is "No drop target"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardDropTargetHint(String tourStepWizardDropTargetHint)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardDropTargetHint", tourStepWizardDropTargetHint, false);
    }

    /**
     * Hint for the <i>Drop Target</i> field in the TourStep Wizard.
     *
     * @return Current tourStepWizardDropTargetHint value. Default value is "No drop target"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardDropTargetHint()  {
        return getAttributeAsString("tourStepWizardDropTargetHint");
    }
    

    /**
     * Descriptive text displayed in a popup {@link com.smartgwt.client.widgets.notify.Notify notification window} when a 
     * <i>Drop Target</i> is selected for this TourStep.
     *
     * @param tourStepWizardDropTargetNotifyText New tourStepWizardDropTargetNotifyText value. Default value is "Shift+Click on the app to record a drop target locator"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardDropTargetNotifyText(String tourStepWizardDropTargetNotifyText)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardDropTargetNotifyText", tourStepWizardDropTargetNotifyText, false);
    }

    /**
     * Descriptive text displayed in a popup {@link com.smartgwt.client.widgets.notify.Notify notification window} when a 
     * <i>Drop Target</i> is selected for this TourStep.
     *
     * @return Current tourStepWizardDropTargetNotifyText value. Default value is "Shift+Click on the app to record a drop target locator"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardDropTargetNotifyText()  {
        return getAttributeAsString("tourStepWizardDropTargetNotifyText");
    }
    

    /**
     * Prompt for the <i>Drop Target</i> field in the TourStep Wizard.
     *
     * @param tourStepWizardDropTargetPrompt New tourStepWizardDropTargetPrompt value. Default value is "Click icon, then Shift+Click within the application to add a drop target"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardDropTargetPrompt(String tourStepWizardDropTargetPrompt)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardDropTargetPrompt", tourStepWizardDropTargetPrompt, false);
    }

    /**
     * Prompt for the <i>Drop Target</i> field in the TourStep Wizard.
     *
     * @return Current tourStepWizardDropTargetPrompt value. Default value is "Click icon, then Shift+Click within the application to add a drop target"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardDropTargetPrompt()  {
        return getAttributeAsString("tourStepWizardDropTargetPrompt");
    }
    

    /**
     * Title for the <i>Drop Target</i> field in the TourStep Wizard.
     *
     * @param tourStepWizardDropTargetTitle New tourStepWizardDropTargetTitle value. Default value is "Drop Target"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardDropTargetTitle(String tourStepWizardDropTargetTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardDropTargetTitle", tourStepWizardDropTargetTitle, false);
    }

    /**
     * Title for the <i>Drop Target</i> field in the TourStep Wizard.
     *
     * @return Current tourStepWizardDropTargetTitle value. Default value is "Drop Target"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardDropTargetTitle()  {
        return getAttributeAsString("tourStepWizardDropTargetTitle");
    }
    

    /**
     * Hint for the <i>Expected Value</i> field in the TourStep Wizard.
     *
     * @param tourStepWizardExpectedValueHint New tourStepWizardExpectedValueHint value. Default value is "Value for the user to enter"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardExpectedValueHint(String tourStepWizardExpectedValueHint)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardExpectedValueHint", tourStepWizardExpectedValueHint, false);
    }

    /**
     * Hint for the <i>Expected Value</i> field in the TourStep Wizard.
     *
     * @return Current tourStepWizardExpectedValueHint value. Default value is "Value for the user to enter"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardExpectedValueHint()  {
        return getAttributeAsString("tourStepWizardExpectedValueHint");
    }
    

    /**
     * Title for the <i>Expected Value</i> field in the TourStep Wizard.
     *
     * @param tourStepWizardExpectedValueTitle New tourStepWizardExpectedValueTitle value. Default value is "Expected Value"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardExpectedValueTitle(String tourStepWizardExpectedValueTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardExpectedValueTitle", tourStepWizardExpectedValueTitle, false);
    }

    /**
     * Title for the <i>Expected Value</i> field in the TourStep Wizard.
     *
     * @return Current tourStepWizardExpectedValueTitle value. Default value is "Expected Value"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardExpectedValueTitle()  {
        return getAttributeAsString("tourStepWizardExpectedValueTitle");
    }
    

    /**
     * Title for the <i>Instructions</i> field in the TourStep Wizard.
     *
     * @param tourStepWizardInstructionsTitle New tourStepWizardInstructionsTitle value. Default value is "Instructions"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardInstructionsTitle(String tourStepWizardInstructionsTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardInstructionsTitle", tourStepWizardInstructionsTitle, false);
    }

    /**
     * Title for the <i>Instructions</i> field in the TourStep Wizard.
     *
     * @return Current tourStepWizardInstructionsTitle value. Default value is "Instructions"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardInstructionsTitle()  {
        return getAttributeAsString("tourStepWizardInstructionsTitle");
    }
    

    /**
     * Title for the <i>Next Step</i> button in the TourStep Wizard.
     *
     * @param tourStepWizardNextStepButtonTitle New tourStepWizardNextStepButtonTitle value. Default value is "Next Step"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardNextStepButtonTitle(String tourStepWizardNextStepButtonTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardNextStepButtonTitle", tourStepWizardNextStepButtonTitle, false);
    }

    /**
     * Title for the <i>Next Step</i> button in the TourStep Wizard.
     *
     * @return Current tourStepWizardNextStepButtonTitle value. Default value is "Next Step"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardNextStepButtonTitle()  {
        return getAttributeAsString("tourStepWizardNextStepButtonTitle");
    }
    

    /**
     * Empty message for the grid in the <i>Tour Wizard</i> when no steps are present.
     *
     * @param tourStepWizardNoStepsMessage New tourStepWizardNoStepsMessage value. Default value is "No Tour Steps Recorded"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardNoStepsMessage(String tourStepWizardNoStepsMessage)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardNoStepsMessage", tourStepWizardNoStepsMessage, false);
    }

    /**
     * Empty message for the grid in the <i>Tour Wizard</i> when no steps are present.
     *
     * @return Current tourStepWizardNoStepsMessage value. Default value is "No Tour Steps Recorded"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardNoStepsMessage()  {
        return getAttributeAsString("tourStepWizardNoStepsMessage");
    }
    

    /**
     * Prompt for the <i>Record Step</i> window header in the TourStep Wizard.
     *
     * @param tourStepWizardRecordStepHeaderPrompt New tourStepWizardRecordStepHeaderPrompt value. Default value is "Drag this window out of the way to get at UI within the application"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardRecordStepHeaderPrompt(String tourStepWizardRecordStepHeaderPrompt)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardRecordStepHeaderPrompt", tourStepWizardRecordStepHeaderPrompt, false);
    }

    /**
     * Prompt for the <i>Record Step</i> window header in the TourStep Wizard.
     *
     * @return Current tourStepWizardRecordStepHeaderPrompt value. Default value is "Drag this window out of the way to get at UI within the application"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardRecordStepHeaderPrompt()  {
        return getAttributeAsString("tourStepWizardRecordStepHeaderPrompt");
    }
    

    /**
     * Title for the <i>Record Tour Step</i> window in the TourStep Wizard.
     *
     * @param tourStepWizardRecordStepTitle New tourStepWizardRecordStepTitle value. Default value is "Record Tour Step"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardRecordStepTitle(String tourStepWizardRecordStepTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardRecordStepTitle", tourStepWizardRecordStepTitle, false);
    }

    /**
     * Title for the <i>Record Tour Step</i> window in the TourStep Wizard.
     *
     * @return Current tourStepWizardRecordStepTitle value. Default value is "Record Tour Step"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardRecordStepTitle()  {
        return getAttributeAsString("tourStepWizardRecordStepTitle");
    }
    

    /**
     * Descriptive text displayed in a popup {@link com.smartgwt.client.widgets.notify.Notify notification window} when a 
     * Target is selected for this TourStep.
     *
     * @param tourStepWizardTargeNotifyText New tourStepWizardTargeNotifyText value. Default value is "Shift+Click on the app to record a target locator"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardTargeNotifyText(String tourStepWizardTargeNotifyText)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardTargeNotifyText", tourStepWizardTargeNotifyText, false);
    }

    /**
     * Descriptive text displayed in a popup {@link com.smartgwt.client.widgets.notify.Notify notification window} when a 
     * Target is selected for this TourStep.
     *
     * @return Current tourStepWizardTargeNotifyText value. Default value is "Shift+Click on the app to record a target locator"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardTargeNotifyText()  {
        return getAttributeAsString("tourStepWizardTargeNotifyText");
    }
    

    /**
     * Prompt for the <i>Target</i> field in the TourStep Wizard.
     *
     * @param tourStepWizardTargePrompt New tourStepWizardTargePrompt value. Default value is "Click icon, then Shift+Click within the application to add a target"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardTargePrompt(String tourStepWizardTargePrompt)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardTargePrompt", tourStepWizardTargePrompt, false);
    }

    /**
     * Prompt for the <i>Target</i> field in the TourStep Wizard.
     *
     * @return Current tourStepWizardTargePrompt value. Default value is "Click icon, then Shift+Click within the application to add a target"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardTargePrompt()  {
        return getAttributeAsString("tourStepWizardTargePrompt");
    }
    

    /**
     * Title for the <i>Target</i> field in the TourStep Wizard.
     *
     * @param tourStepWizardTargetTitle New tourStepWizardTargetTitle value. Default value is "Target"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardTargetTitle(String tourStepWizardTargetTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardTargetTitle", tourStepWizardTargetTitle, false);
    }

    /**
     * Title for the <i>Target</i> field in the TourStep Wizard.
     *
     * @return Current tourStepWizardTargetTitle value. Default value is "Target"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardTargetTitle()  {
        return getAttributeAsString("tourStepWizardTargetTitle");
    }
    

    /**
     * Title for the <i>TourStep Title</i> field in the TourStep Wizard.
     *
     * @param tourStepWizardTitle New tourStepWizardTitle value. Default value is "Title"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourStepWizardTitle(String tourStepWizardTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourStepWizardTitle", tourStepWizardTitle, false);
    }

    /**
     * Title for the <i>TourStep Title</i> field in the TourStep Wizard.
     *
     * @return Current tourStepWizardTitle value. Default value is "Title"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourStepWizardTitle()  {
        return getAttributeAsString("tourStepWizardTitle");
    }
    

    /**
     * Title for the <i>interactive Tutorial</i> option in the Tour Type picker in the Tour  Wizard.
     *
     * @param tourWizardInteractiveTourTitle New tourWizardInteractiveTourTitle value. Default value is "Interactive Tutorial"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourWizardInteractiveTourTitle(String tourWizardInteractiveTourTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourWizardInteractiveTourTitle", tourWizardInteractiveTourTitle, false);
    }

    /**
     * Title for the <i>interactive Tutorial</i> option in the Tour Type picker in the Tour  Wizard.
     *
     * @return Current tourWizardInteractiveTourTitle value. Default value is "Interactive Tutorial"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourWizardInteractiveTourTitle()  {
        return getAttributeAsString("tourWizardInteractiveTourTitle");
    }
    

    /**
     * Title for the <i>Start with New Screen</i> picker in the Tour Wizard.
     *
     * @param tourWizardNewScreenPickerTitle New tourWizardNewScreenPickerTitle value. Default value is "Start With New Screen"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourWizardNewScreenPickerTitle(String tourWizardNewScreenPickerTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourWizardNewScreenPickerTitle", tourWizardNewScreenPickerTitle, false);
    }

    /**
     * Title for the <i>Start with New Screen</i> picker in the Tour Wizard.
     *
     * @return Current tourWizardNewScreenPickerTitle value. Default value is "Start With New Screen"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourWizardNewScreenPickerTitle()  {
        return getAttributeAsString("tourWizardNewScreenPickerTitle");
    }
    

    /**
     * Title for the <i>Record Tour</i> button in the Tour Wizard.
     *
     * @param tourWizardRecordButtonTitle New tourWizardRecordButtonTitle value. Default value is "Record Tour"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourWizardRecordButtonTitle(String tourWizardRecordButtonTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourWizardRecordButtonTitle", tourWizardRecordButtonTitle, false);
    }

    /**
     * Title for the <i>Record Tour</i> button in the Tour Wizard.
     *
     * @return Current tourWizardRecordButtonTitle value. Default value is "Record Tour"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourWizardRecordButtonTitle()  {
        return getAttributeAsString("tourWizardRecordButtonTitle");
    }
    

    /**
     * Title for the <i>Reify Tutorial</i> option in the Tour Type picker in the Tour Wizard.
     *
     * @param tourWizardReifyTourTitle New tourWizardReifyTourTitle value. Default value is "Reify Tutorial"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourWizardReifyTourTitle(String tourWizardReifyTourTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourWizardReifyTourTitle", tourWizardReifyTourTitle, false);
    }

    /**
     * Title for the <i>Reify Tutorial</i> option in the Tour Type picker in the Tour Wizard.
     *
     * @return Current tourWizardReifyTourTitle value. Default value is "Reify Tutorial"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourWizardReifyTourTitle()  {
        return getAttributeAsString("tourWizardReifyTourTitle");
    }
    

    /**
     * Hint text for the <i>Required DataSources</i> item in the Tour Wizard.
     *
     * @param tourWizardRequiredDataSourcesHint New tourWizardRequiredDataSourcesHint value. Default value is "Comma separated list of required DS's"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourWizardRequiredDataSourcesHint(String tourWizardRequiredDataSourcesHint)  throws IllegalStateException {
        return (Tour)setAttribute("tourWizardRequiredDataSourcesHint", tourWizardRequiredDataSourcesHint, false);
    }

    /**
     * Hint text for the <i>Required DataSources</i> item in the Tour Wizard.
     *
     * @return Current tourWizardRequiredDataSourcesHint value. Default value is "Comma separated list of required DS's"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourWizardRequiredDataSourcesHint()  {
        return getAttributeAsString("tourWizardRequiredDataSourcesHint");
    }
    

    /**
     * Title for the <i>Required DataSources</i> item in the Tour Wizard.
     *
     * @param tourWizardRequiredDataSourcesTitle New tourWizardRequiredDataSourcesTitle value. Default value is "Required DataSources"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourWizardRequiredDataSourcesTitle(String tourWizardRequiredDataSourcesTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourWizardRequiredDataSourcesTitle", tourWizardRequiredDataSourcesTitle, false);
    }

    /**
     * Title for the <i>Required DataSources</i> item in the Tour Wizard.
     *
     * @return Current tourWizardRequiredDataSourcesTitle value. Default value is "Required DataSources"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourWizardRequiredDataSourcesTitle()  {
        return getAttributeAsString("tourWizardRequiredDataSourcesTitle");
    }
    

    /**
     * Title for the <i>Show Progress</i> picker in the Tour Wizard.
     *
     * @param tourWizardShowProgressTitle New tourWizardShowProgressTitle value. Default value is "Show Progress"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourWizardShowProgressTitle(String tourWizardShowProgressTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourWizardShowProgressTitle", tourWizardShowProgressTitle, false);
    }

    /**
     * Title for the <i>Show Progress</i> picker in the Tour Wizard.
     *
     * @return Current tourWizardShowProgressTitle value. Default value is "Show Progress"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourWizardShowProgressTitle()  {
        return getAttributeAsString("tourWizardShowProgressTitle");
    }
    

    /**
     * Title for the Tour Wizard.
     *
     * @param tourWizardTitle New tourWizardTitle value. Default value is "New Tour Configuration"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourWizardTitle(String tourWizardTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourWizardTitle", tourWizardTitle, false);
    }

    /**
     * Title for the Tour Wizard.
     *
     * @return Current tourWizardTitle value. Default value is "New Tour Configuration"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourWizardTitle()  {
        return getAttributeAsString("tourWizardTitle");
    }
    

    /**
     * Title for the Tour Type picker in the Tour Wizard.
     *
     * @param tourWizardTourTypeTitle New tourWizardTourTypeTitle value. Default value is "Tour Type"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourWizardTourTypeTitle(String tourWizardTourTypeTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourWizardTourTypeTitle", tourWizardTourTypeTitle, false);
    }

    /**
     * Title for the Tour Type picker in the Tour Wizard.
     *
     * @return Current tourWizardTourTypeTitle value. Default value is "Tour Type"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourWizardTourTypeTitle()  {
        return getAttributeAsString("tourWizardTourTypeTitle");
    }
    

    /**
     * Title for the <i>non-interactive UI Tour</i> option in the Tour Type picker in the Tour  Wizard.
     *
     * @param tourWizardUITourTitle New tourWizardUITourTitle value. Default value is "UI Tour (Non Interactive)"
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Tour setTourWizardUITourTitle(String tourWizardUITourTitle)  throws IllegalStateException {
        return (Tour)setAttribute("tourWizardUITourTitle", tourWizardUITourTitle, false);
    }

    /**
     * Title for the <i>non-interactive UI Tour</i> option in the Tour Type picker in the Tour  Wizard.
     *
     * @return Current tourWizardUITourTitle value. Default value is "UI Tour (Non Interactive)"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTourWizardUITourTitle()  {
        return getAttributeAsString("tourWizardUITourTitle");
    }
    

    /**
     * Defaults for each {@link com.smartgwt.client.util.tour.TourStep#getTargetView TourStep.targetView} autoChild in the
     * tour. These defaults are applied before {@link com.smartgwt.client.util.tour.TourStep#getWindowDefaults
     * TourStep.windowDefaults} if any.
     *
     * @param windowDefaults New windowDefaults value. Default value is {...}
     * @return {@link com.smartgwt.client.util.tour.Tour Tour} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public Tour setWindowDefaults(Canvas windowDefaults)  throws IllegalStateException {
        if (windowDefaults != null) {
            if (windowDefaults.isCreated()) {
                ConfigUtil.warnOfPreConfigInstantiation(Tour.class, "setWindowDefaults", "Canvas");
            }
            windowDefaults.setConfigOnly(true);
        }
        JavaScriptObject config = windowDefaults == null ? null : windowDefaults.getConfig();
        return (Tour)setAttribute("windowDefaults", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * Defaults for each {@link com.smartgwt.client.util.tour.TourStep#getTargetView TourStep.targetView} autoChild in the
     * tour. These defaults are applied before {@link com.smartgwt.client.util.tour.TourStep#getWindowDefaults
     * TourStep.windowDefaults} if any.
     *
     * @return Current windowDefaults value. Default value is {...}
     */
    public Canvas getWindowDefaults()  {
        Canvas properties = new Canvas();
        properties.setConfigOnly(true);
        properties.setConfig(getAttributeAsJavaScriptObject("windowDefaults"));
        return properties;
    }
    

    // ********************* Methods ***********************
	/**
     * Notify user of expected value entry validation message. Default implementation uses the  {@link
     * com.smartgwt.client.widgets.notify.Notify Notify system} to show the message in it's default position. See {@link
     * com.smartgwt.client.docs.NotifyType notifyType} for notification configuration details. <P>
     * @param message message provided by {@link com.smartgwt.client.util.tour.TourStep#getInputValidationNotifyMessage
     * TourStep.inputValidationNotifyMessage}
     */
    public native void notifyValidationMessage(String message) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "notifyValidationMessage", "String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.notifyValidationMessage(message);
    }-*/;


    // ********************* Static Methods ***********************

	/**
     * Get a Tour instance by it's ID.
     * @param tourId tour ID to retrieve.
     * See {@link com.smartgwt.client.docs.Identifier Identifier}
     *
     * @return the tour, or null if not defined
     * @see com.smartgwt.client.docs.Identifier Identifier
     */
    public static native Tour getTour(String tourId) /*-{
        var ret = $wnd.isc.Tour.getTour(tourId);
        if(ret == null) return null;
        return @com.smartgwt.client.util.tour.Tour::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;



    // ***********************************************************


    
	/**
     * Loads an XML tour definition stored in XML from the server. <p> Tour files are stored as .proc.xml files in {@link
     * com.smartgwt.client.docs.ComponentXML Component XML} format, in the directory indicated by the
     * <code>project.processes</code> setting in {@link com.smartgwt.client.docs.Server_properties server.properties}
     * (<code><i>webroot</i>/processes</code> by default).  To load a tour saved in a file <i>tourId</i>.proc.xml, pass just
     * <i>tourId</i> to this method.
     * @param tourId tour ID or IDs to load.
     * See {@link com.smartgwt.client.docs.Identifier Identifier}
     * @param callback called when the tour is loaded with argument                            "process", the first tour.  Other tours can be
     * looked                            up via {@link com.smartgwt.client.util.tour.Tour#getTour getTour()}.
     */
    public static native void loadTour(String tourId, ProcessCallback callback) /*-{
	    $wnd.isc.Tour.loadTour(tourId, 
			$entry( function(process) { 
			    // create an instance of Tour rather than Process in Java
			    var tourJ = $wnd.isc.isA.Tour(process) 
			    			? @com.smartgwt.client.util.tour.Tour::new(Lcom/google/gwt/core/client/JavaScriptObject;)(process) 
			    			: @com.smartgwt.client.util.workflow.Process::new(Lcom/google/gwt/core/client/JavaScriptObject;)(process);
				if(callback!=null) callback.@com.smartgwt.client.callbacks.ProcessCallback::execute(Lcom/smartgwt/client/util/workflow/Process;)(
				    tourJ
				);
			}));
	}-*/;

    

}
