/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.grid;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;

import com.smartgwt.logicalstructure.core.*;
import com.smartgwt.logicalstructure.widgets.*;
import com.smartgwt.logicalstructure.widgets.drawing.*;
import com.smartgwt.logicalstructure.widgets.plugins.*;
import com.smartgwt.logicalstructure.widgets.form.*;
import com.smartgwt.logicalstructure.widgets.tile.*;
import com.smartgwt.logicalstructure.widgets.grid.*;
import com.smartgwt.logicalstructure.widgets.chart.*;
import com.smartgwt.logicalstructure.widgets.layout.*;
import com.smartgwt.logicalstructure.widgets.menu.*;
import com.smartgwt.logicalstructure.widgets.rte.*;
import com.smartgwt.logicalstructure.widgets.ace.*;
import com.smartgwt.logicalstructure.widgets.tab.*;
import com.smartgwt.logicalstructure.widgets.tableview.*;
import com.smartgwt.logicalstructure.widgets.toolbar.*;
import com.smartgwt.logicalstructure.widgets.tree.*;
import com.smartgwt.logicalstructure.widgets.viewer.*;
import com.smartgwt.logicalstructure.widgets.calendar.*;
import com.smartgwt.logicalstructure.widgets.cube.*;
import com.smartgwt.logicalstructure.widgets.tools.*;
import com.smartgwt.logicalstructure.widgets.tour.*;
import com.smartgwt.logicalstructure.widgets.ai.*;

/**
 * Shuttle-style selection component allowing uses to select records by moving them from a set of source records to a set
 * of target records
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("Shuttle")
public class Shuttle extends Layout {

    public static Shuttle getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;
        final BaseWidget refInstance = BaseWidget.getRef(jsObj);
        if (refInstance == null) {
            return new Shuttle(jsObj);
        } else {
            assert refInstance instanceof Shuttle;
            return (Shuttle)refInstance;
        }
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(Shuttle.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.Shuttle.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(Shuttle.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.Shuttle.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public Shuttle(){
        scClassName = "Shuttle";
    }

    public Shuttle(JavaScriptObject jsObj){
        scClassName = "Shuttle";
        setJavaScriptObject(jsObj);
    }

    protected native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
        var widget = $wnd.isc[scClassName].create(config);
        if ($wnd.isc.keepGlobals) this.@com.smartgwt.client.widgets.BaseWidget::internalSetID(Lcom/google/gwt/core/client/JavaScriptObject;)(widget);
        this.@com.smartgwt.client.widgets.BaseWidget::doInit()();
        return widget;
    }-*/;


    // ********************* Properties / Attributes ***********************

    /**
     * VLayout autoChild holding the {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectAllButton selectAllButton},
     * {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectButton selectButton}, {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getDeselectButton deselectButton} and {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getDeselectAllButton deselectAllButton}
     * <p>
     * This component is an AutoChild named "controlBar".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current controlBar value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public VLayout getControlBar() throws IllegalStateException {
        errorIfNotCreated("controlBar");
        return (VLayout)VLayout.getByJSObject(getAttributeAsJavaScriptObject("controlBar"));
    }
    

    /**
     * List of options for this shuttle. <P> Note that a shuttle must have either a data object or a dataSource specified
     *
     * @param data New data value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setData(Record... data)  throws IllegalStateException {
        return (Shuttle)setAttribute("data", data, false);
    }
    

    /**
     * DataSource for this shuttle's data set. The list of options will be fetched from this dataSource unless an explicit
     * {@link com.smartgwt.client.widgets.grid.Shuttle#getData data} object was also provided. <P> Note that a shuttle must
     * have either a dataSource or data object.
     *
     * @param dataSource New dataSource value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setDataSource(DataSource dataSource)  throws IllegalStateException {
        return (Shuttle)setAttribute("dataSource", dataSource == null ? null : dataSource.getOrCreateJsObj(), false);
    }

    /**
     * DataSource for this shuttle's data set. The list of options will be fetched from this dataSource unless an explicit
     * {@link com.smartgwt.client.widgets.grid.Shuttle#getData data} object was also provided. <P> Note that a shuttle must
     * have either a dataSource or data object.
     *
     * @return Current dataSource value. Default value is null
     */
    public DataSource getDataSource()  {
        return DataSource.getOrCreateRef(getAttributeAsJavaScriptObject("dataSource"));
    }
    

    /**
     * ImgButton for deselecting the full set of selected data in the shuttle.
     * <p>
     * This component is an AutoChild named "deselectAllButton".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current deselectAllButton value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ImgButton getDeselectAllButton() throws IllegalStateException {
        errorIfNotCreated("deselectAllButton");
        return (ImgButton)ImgButton.getByJSObject(getAttributeAsJavaScriptObject("deselectAllButton"));
    }
    

    /**
     * Height for the {@link com.smartgwt.client.widgets.grid.Shuttle#getDeselectAllButton deselectAllButton}
     *
     * @param deselectAllButtonHeight New deselectAllButtonHeight value. Default value is 22
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setDeselectAllButtonHeight(Integer deselectAllButtonHeight)  throws IllegalStateException {
        return (Shuttle)setAttribute("deselectAllButtonHeight", deselectAllButtonHeight, false);
    }

    /**
     * Height for the {@link com.smartgwt.client.widgets.grid.Shuttle#getDeselectAllButton deselectAllButton}
     *
     * @return Current deselectAllButtonHeight value. Default value is 22
     */
    public Integer getDeselectAllButtonHeight()  {
        return getAttributeAsInt("deselectAllButtonHeight");
    }
    

    /**
     * Icon for the {@link com.smartgwt.client.widgets.grid.Shuttle#getDeselectAllButton deselectAllButton}
     *
     * @param deselectAllButtonIcon New deselectAllButtonIcon value. Default value is "[SKINIMG]TransferIcons/left_all.png"
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public Shuttle setDeselectAllButtonIcon(String deselectAllButtonIcon)  throws IllegalStateException {
        return (Shuttle)setAttribute("deselectAllButtonIcon", deselectAllButtonIcon, false);
    }

    /**
     * Icon for the {@link com.smartgwt.client.widgets.grid.Shuttle#getDeselectAllButton deselectAllButton}
     *
     * @return Current deselectAllButtonIcon value. Default value is "[SKINIMG]TransferIcons/left_all.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getDeselectAllButtonIcon()  {
        return getAttributeAsString("deselectAllButtonIcon");
    }
    

    /**
     * Width for the {@link com.smartgwt.client.widgets.grid.Shuttle#getDeselectAllButton deselectAllButton}
     *
     * @param deselectAllButtonWidth New deselectAllButtonWidth value. Default value is 24
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setDeselectAllButtonWidth(Integer deselectAllButtonWidth)  throws IllegalStateException {
        return (Shuttle)setAttribute("deselectAllButtonWidth", deselectAllButtonWidth, false);
    }

    /**
     * Width for the {@link com.smartgwt.client.widgets.grid.Shuttle#getDeselectAllButton deselectAllButton}
     *
     * @return Current deselectAllButtonWidth value. Default value is 24
     */
    public Integer getDeselectAllButtonWidth()  {
        return getAttributeAsInt("deselectAllButtonWidth");
    }
    

    /**
     * ImgButton for deselecting a single record
     * <p>
     * This component is an AutoChild named "deselectButton".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current deselectButton value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ImgButton getDeselectButton() throws IllegalStateException {
        errorIfNotCreated("deselectButton");
        return (ImgButton)ImgButton.getByJSObject(getAttributeAsJavaScriptObject("deselectButton"));
    }
    

    /**
     * Height for the {@link com.smartgwt.client.widgets.grid.Shuttle#getDeselectButton deselectButton}
     *
     * @param deselectButtonHeight New deselectButtonHeight value. Default value is 22
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setDeselectButtonHeight(Integer deselectButtonHeight)  throws IllegalStateException {
        return (Shuttle)setAttribute("deselectButtonHeight", deselectButtonHeight, false);
    }

    /**
     * Height for the {@link com.smartgwt.client.widgets.grid.Shuttle#getDeselectButton deselectButton}
     *
     * @return Current deselectButtonHeight value. Default value is 22
     */
    public Integer getDeselectButtonHeight()  {
        return getAttributeAsInt("deselectButtonHeight");
    }
    

    /**
     * Icon for the {@link com.smartgwt.client.widgets.grid.Shuttle#getDeselectButton deselectButton}
     *
     * @param deselectButtonIcon New deselectButtonIcon value. Default value is "[SKINIMG]TransferIcons/left.png"
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public Shuttle setDeselectButtonIcon(String deselectButtonIcon)  throws IllegalStateException {
        return (Shuttle)setAttribute("deselectButtonIcon", deselectButtonIcon, false);
    }

    /**
     * Icon for the {@link com.smartgwt.client.widgets.grid.Shuttle#getDeselectButton deselectButton}
     *
     * @return Current deselectButtonIcon value. Default value is "[SKINIMG]TransferIcons/left.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getDeselectButtonIcon()  {
        return getAttributeAsString("deselectButtonIcon");
    }
    

    /**
     * Width for the {@link com.smartgwt.client.widgets.grid.Shuttle#getDeselectButton deselectButton}
     *
     * @param deselectButtonWidth New deselectButtonWidth value. Default value is 24
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setDeselectButtonWidth(Integer deselectButtonWidth)  throws IllegalStateException {
        return (Shuttle)setAttribute("deselectButtonWidth", deselectButtonWidth, false);
    }

    /**
     * Width for the {@link com.smartgwt.client.widgets.grid.Shuttle#getDeselectButton deselectButton}
     *
     * @return Current deselectButtonWidth value. Default value is 24
     */
    public Integer getDeselectButtonWidth()  {
        return getAttributeAsInt("deselectButtonWidth");
    }
    

    /**
     * {@link com.smartgwt.client.data.DSRequest#getOperationId OperationId} for fetching records from the shuttle's {@link
     * com.smartgwt.client.data.DataSource}.
     *
     * @param fetchOperation New fetchOperation value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setFetchOperation(String fetchOperation)  throws IllegalStateException {
        return (Shuttle)setAttribute("fetchOperation", fetchOperation, false);
    }

    /**
     * {@link com.smartgwt.client.data.DSRequest#getOperationId OperationId} for fetching records from the shuttle's {@link
     * com.smartgwt.client.data.DataSource}.
     *
     * @return Current fetchOperation value. Default value is null
     */
    public String getFetchOperation()  {
        return getAttributeAsString("fetchOperation");
    }
    

    /**
     * Fields for the {@link com.smartgwt.client.widgets.grid.Shuttle#getSourceGrid sourceGrid} and {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getTargetGrid targetGrid}. <P> As with other databound components, if fields
     * are not explicitly  specified, they will be derived from the {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getDataSource dataSource} as described {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getFields here}
     *
     * @param fields New fields value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setFields(ListGridField... fields)  throws IllegalStateException {
        return (Shuttle)setAttribute("fields", fields, false);
    }

    /**
     * Fields for the {@link com.smartgwt.client.widgets.grid.Shuttle#getSourceGrid sourceGrid} and {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getTargetGrid targetGrid}. <P> As with other databound components, if fields
     * are not explicitly  specified, they will be derived from the {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getDataSource dataSource} as described {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getFields here}
     *
     * @return Current fields value. Default value is null
     */
    public ListGridField[] getFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfListGridField(getAttributeAsJavaScriptObject("fields"));
    }
    

    /**
     * DSRequest configuration for retrieving records from this shuttle's dataSource.
     *
     * @param filterContext New filterContext value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setFilterContext(DSRequest filterContext)  throws IllegalStateException {
        return (Shuttle)setAttribute("filterContext", filterContext == null ? null : filterContext.getJsObj(), false);
    }

    /**
     * DSRequest configuration for retrieving records from this shuttle's dataSource.
     *
     * @return Current filterContext value. Default value is null
     */
    public DSRequest getFilterContext()  {
        return DSRequest.getOrCreateRef(getAttributeAsJavaScriptObject("filterContext"));
    }
    

    /**
     * Implicit criteria for retrieving records from this shuttle's dataSource. <P> These criteria may be combined with
     * <code>"inSet"</code> or <code>"notInSet"</code> sub criteria for the {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getValueField valueField} in order to populate the set of unselected records in
     * the {@link com.smartgwt.client.widgets.grid.Shuttle#getSourceGrid sourceGrid}. They are {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getImplicitCriteria ListGrid.implicitCriteria} meaning that any user-entered
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter criteria} will be overlayed on top of these
     * criteria.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Update the {@link com.smartgwt.client.widgets.grid.Shuttle#getImplicitCriteria implicitCriteria} for the shuttle.
     *
     * @param implicitCriteria new implicitCriteria. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     */
    public Shuttle setImplicitCriteria(Criteria implicitCriteria) {
        if (implicitCriteria instanceof Criterion) {
            implicitCriteria.setAttribute("_constructor", "AdvancedCriteria");
        }
        return (Shuttle)setAttribute("implicitCriteria", implicitCriteria == null ? null : implicitCriteria.getJsObj(), true);
    }

    /**
     * Implicit criteria for retrieving records from this shuttle's dataSource. <P> These criteria may be combined with
     * <code>"inSet"</code> or <code>"notInSet"</code> sub criteria for the {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getValueField valueField} in order to populate the set of unselected records in
     * the {@link com.smartgwt.client.widgets.grid.Shuttle#getSourceGrid sourceGrid}. They are {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getImplicitCriteria ListGrid.implicitCriteria} meaning that any user-entered
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter criteria} will be overlayed on top of these
     * criteria.
     *
     * @return Current implicitCriteria value. Default value is null
     */
    public Criteria getImplicitCriteria()  {
        return new Criteria(getAttributeAsJavaScriptObject("implicitCriteria"));
    }
    

    /**
     * Warning to display when the user attempts to {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectAllButton select
     * all} records from a {@link com.smartgwt.client.data.ResultSet#allMatchingRowsCached partially loaded} data set.
     *
     * @param incompleteDataWarning New incompleteDataWarning value. Default value is "Unable to select all - the data set does not have all matching records loaded from the dataSource."
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setIncompleteDataWarning(String incompleteDataWarning)  throws IllegalStateException {
        return (Shuttle)setAttribute("incompleteDataWarning", incompleteDataWarning, false);
    }

    /**
     * Warning to display when the user attempts to {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectAllButton select
     * all} records from a {@link com.smartgwt.client.data.ResultSet#allMatchingRowsCached partially loaded} data set.
     *
     * @return Current incompleteDataWarning value. Default value is "Unable to select all - the data set does not have all matching records loaded from the dataSource."
     */
    public String getIncompleteDataWarning()  {
        return getAttributeAsString("incompleteDataWarning");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getInitialSort Initial sort specifiers} for this item's list of
     * options. Will be applied to {@link com.smartgwt.client.widgets.grid.Shuttle#getSourceGrid sourceGrid} and {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getTargetGrid targetGrid}. To specify initial sort for each grid separately,
     * these properties may be set per grid using the standard {@link com.smartgwt.client.types.AutoChild autoChild pattern}.
     *
     * @param initialSort New initialSort value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setInitialSort(SortSpecifier... initialSort)  throws IllegalStateException {
        return (Shuttle)setAttribute("initialSort", initialSort, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getInitialSort Initial sort specifiers} for this item's list of
     * options. Will be applied to {@link com.smartgwt.client.widgets.grid.Shuttle#getSourceGrid sourceGrid} and {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getTargetGrid targetGrid}. To specify initial sort for each grid separately,
     * these properties may be set per grid using the standard {@link com.smartgwt.client.types.AutoChild autoChild pattern}.
     *
     * @return Current initialSort value. Default value is null
     */
    public SortSpecifier[] getInitialSort()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfSortSpecifier(getAttributeAsJavaScriptObject("initialSort"));
    }
    

    /**
     * This attribute will be set to true for any loading placeholder records returned by {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getSelectedRecords getSelectedRecords()}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param loadingPlaceholderAttribute New loadingPlaceholderAttribute value. Default value is "_isLoadingPlaceholder"
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setLoadingPlaceholderAttribute(String loadingPlaceholderAttribute)  throws IllegalStateException {
        return (Shuttle)setAttribute("loadingPlaceholderAttribute", loadingPlaceholderAttribute, false);
    }

    /**
     * This attribute will be set to true for any loading placeholder records returned by {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getSelectedRecords getSelectedRecords()}
     *
     * @return Current loadingPlaceholderAttribute value. Default value is "_isLoadingPlaceholder"
     */
    public String getLoadingPlaceholderAttribute()  {
        return getAttributeAsString("loadingPlaceholderAttribute");
    }
    

    /**
     * ImgButton for selecting the full set of data in the shuttle.
     * <p>
     * This component is an AutoChild named "selectAllButton".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current selectAllButton value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ImgButton getSelectAllButton() throws IllegalStateException {
        errorIfNotCreated("selectAllButton");
        return (ImgButton)ImgButton.getByJSObject(getAttributeAsJavaScriptObject("selectAllButton"));
    }
    

    /**
     * Height for the {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectAllButton selectAllButton}
     *
     * @param selectAllButtonHeight New selectAllButtonHeight value. Default value is 22
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setSelectAllButtonHeight(Integer selectAllButtonHeight)  throws IllegalStateException {
        return (Shuttle)setAttribute("selectAllButtonHeight", selectAllButtonHeight, false);
    }

    /**
     * Height for the {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectAllButton selectAllButton}
     *
     * @return Current selectAllButtonHeight value. Default value is 22
     */
    public Integer getSelectAllButtonHeight()  {
        return getAttributeAsInt("selectAllButtonHeight");
    }
    

    /**
     * Icon for the {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectAllButton selectAllButton}
     *
     * @param selectAllButtonIcon New selectAllButtonIcon value. Default value is "[SKINIMG]TransferIcons/right_all.png"
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public Shuttle setSelectAllButtonIcon(String selectAllButtonIcon)  throws IllegalStateException {
        return (Shuttle)setAttribute("selectAllButtonIcon", selectAllButtonIcon, false);
    }

    /**
     * Icon for the {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectAllButton selectAllButton}
     *
     * @return Current selectAllButtonIcon value. Default value is "[SKINIMG]TransferIcons/right_all.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getSelectAllButtonIcon()  {
        return getAttributeAsString("selectAllButtonIcon");
    }
    

    /**
     * Width for the {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectAllButton selectAllButton}
     *
     * @param selectAllButtonWidth New selectAllButtonWidth value. Default value is 24
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setSelectAllButtonWidth(Integer selectAllButtonWidth)  throws IllegalStateException {
        return (Shuttle)setAttribute("selectAllButtonWidth", selectAllButtonWidth, false);
    }

    /**
     * Width for the {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectAllButton selectAllButton}
     *
     * @return Current selectAllButtonWidth value. Default value is 24
     */
    public Integer getSelectAllButtonWidth()  {
        return getAttributeAsInt("selectAllButtonWidth");
    }
    

    /**
     * ImgButton for selecting a single record
     * <p>
     * This component is an AutoChild named "selectButton".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current selectButton value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ImgButton getSelectButton() throws IllegalStateException {
        errorIfNotCreated("selectButton");
        return (ImgButton)ImgButton.getByJSObject(getAttributeAsJavaScriptObject("selectButton"));
    }
    

    /**
     * Height for the {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectButton selectButton}
     *
     * @param selectButtonHeight New selectButtonHeight value. Default value is 22
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setSelectButtonHeight(Integer selectButtonHeight)  throws IllegalStateException {
        return (Shuttle)setAttribute("selectButtonHeight", selectButtonHeight, false);
    }

    /**
     * Height for the {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectButton selectButton}
     *
     * @return Current selectButtonHeight value. Default value is 22
     */
    public Integer getSelectButtonHeight()  {
        return getAttributeAsInt("selectButtonHeight");
    }
    

    /**
     * Icon for the {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectButton selectButton}
     *
     * @param selectButtonIcon New selectButtonIcon value. Default value is "[SKINIMG]TransferIcons/right.png"
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public Shuttle setSelectButtonIcon(String selectButtonIcon)  throws IllegalStateException {
        return (Shuttle)setAttribute("selectButtonIcon", selectButtonIcon, false);
    }

    /**
     * Icon for the {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectButton selectButton}
     *
     * @return Current selectButtonIcon value. Default value is "[SKINIMG]TransferIcons/right.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getSelectButtonIcon()  {
        return getAttributeAsString("selectButtonIcon");
    }
    

    /**
     * Width for the {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectButton selectButton}
     *
     * @param selectButtonWidth New selectButtonWidth value. Default value is 24
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setSelectButtonWidth(Integer selectButtonWidth)  throws IllegalStateException {
        return (Shuttle)setAttribute("selectButtonWidth", selectButtonWidth, false);
    }

    /**
     * Width for the {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectButton selectButton}
     *
     * @return Current selectButtonWidth value. Default value is 24
     */
    public Integer getSelectButtonWidth()  {
        return getAttributeAsInt("selectButtonWidth");
    }
    

    /**
     * A shuttle may be initialized with a set of selected records via <code>setSelectedRecords()</code> before the shuttle has
     * been created. <P> See also {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectedValues selectedValues} for
     * initializing selection based on record values. <P> To update the selection at runtime use {@link
     * com.smartgwt.client.widgets.grid.Shuttle#selectRecords selectRecords()} and {@link
     * com.smartgwt.client.widgets.grid.Shuttle#deselectRecords deselectRecords()}.
     *
     * @param selectedRecords New selectedRecords value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setSelectedRecords(ListGridRecord selectedRecords)  throws IllegalStateException {
        return (Shuttle)setAttribute("selectedRecords", selectedRecords == null ? null : selectedRecords.getJsObj(), false);
    }

    /**
     * A shuttle may be initialized with a set of selected records via <code>setSelectedRecords()</code> before the shuttle has
     * been created. <P> See also {@link com.smartgwt.client.widgets.grid.Shuttle#getSelectedValues selectedValues} for
     * initializing selection based on record values. <P> To update the selection at runtime use {@link
     * com.smartgwt.client.widgets.grid.Shuttle#selectRecords selectRecords()} and {@link
     * com.smartgwt.client.widgets.grid.Shuttle#deselectRecords deselectRecords()}.
     *
     * @return Returns the current set of selected records. <P> Note that if a user called {@link
     * com.smartgwt.client.widgets.grid.Shuttle#setSelectedByValue setSelectedByValue()} for a record that was not loaded in
     * the source list, we may not yet have a selected record for that value. See {@link
     * com.smartgwt.client.widgets.grid.Shuttle#valuesFetchInProgress valuesFetchInProgress()}. <P> In this case no record will
     * be returned by this method for that record by default. The <code>includeLoadingPlaceholders</code> parameter will cause
     * this method to also return placeholder record objects for these unloaded records, which have two properties specified -
     * the {@link com.smartgwt.client.widgets.grid.Shuttle#getValueField valueField} value  {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getLoadingPlaceholderAttribute _isLoadingPlaceholder:true}. Default value is null
     */
    public ListGridRecord getSelectedRecords()  {
        return ListGridRecord.getOrCreateRef(getAttributeAsJavaScriptObject("selectedRecords"));
    }
    

    /**
     * Initial selected values for the shuttle. <P> If specified, the shuttle will be initialized with records with matching
     * {@link com.smartgwt.client.widgets.grid.Shuttle#getValueField valueField} being selected. <P> See also {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getSelectedRecords selectedRecords} for initializing selection with specific
     * records. If both properties are specified, <code>selectedValues</code> will have no effect <P> To update the selection
     * by value at runtime use {@link com.smartgwt.client.widgets.grid.Shuttle#setSelectedByValue setSelectedByValue()}
     *
     * @param selectedValues New selectedValues value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setSelectedValues(String... selectedValues)  throws IllegalStateException {
        return (Shuttle)setAttribute("selectedValues", selectedValues, false);
    }

    /**
     * Initial selected values for the shuttle. <P> If specified, the shuttle will be initialized with records with matching
     * {@link com.smartgwt.client.widgets.grid.Shuttle#getValueField valueField} being selected. <P> See also {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getSelectedRecords selectedRecords} for initializing selection with specific
     * records. If both properties are specified, <code>selectedValues</code> will have no effect <P> To update the selection
     * by value at runtime use {@link com.smartgwt.client.widgets.grid.Shuttle#setSelectedByValue setSelectedByValue()}
     *
     * @return Returns the {@link com.smartgwt.client.widgets.grid.Shuttle#getValueFieldName valueField} value from the  current set of
     * selected records. <P> Note that if a user called {@link com.smartgwt.client.widgets.grid.Shuttle#setSelectedByValue
     * setSelectedByValue()} for a record that was not loaded in the source list, we may not yet have a selected record for
     * that value. See {@link com.smartgwt.client.widgets.grid.Shuttle#valuesFetchInProgress valuesFetchInProgress()}. <P> The
     * <code>includeUnloadedValues</code> parameter can be used to return values for these unloaded records. Default value is null
     */
    public String[] getSelectedValues()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("selectedValues"));
    }

    /**
     * Initial selected values for the shuttle. <P> If specified, the shuttle will be initialized with records with matching
     * {@link com.smartgwt.client.widgets.grid.Shuttle#getValueField valueField} being selected. <P> See also {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getSelectedRecords selectedRecords} for initializing selection with specific
     * records. If both properties are specified, <code>selectedValues</code> will have no effect <P> To update the selection
     * by value at runtime use {@link com.smartgwt.client.widgets.grid.Shuttle#setSelectedByValue setSelectedByValue()}
     *
     * @param selectedValues New selectedValues value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setSelectedValues(int... selectedValues)  throws IllegalStateException {
        return (Shuttle)setAttribute("selectedValues", selectedValues, false);
    }

    /**
     * Initial selected values for the shuttle. <P> If specified, the shuttle will be initialized with records with matching
     * {@link com.smartgwt.client.widgets.grid.Shuttle#getValueField valueField} being selected. <P> See also {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getSelectedRecords selectedRecords} for initializing selection with specific
     * records. If both properties are specified, <code>selectedValues</code> will have no effect <P> To update the selection
     * by value at runtime use {@link com.smartgwt.client.widgets.grid.Shuttle#setSelectedByValue setSelectedByValue()}
     *
     * @return Returns the {@link com.smartgwt.client.widgets.grid.Shuttle#getValueFieldName valueField} value from the  current set of
     * selected records. <P> Note that if a user called {@link com.smartgwt.client.widgets.grid.Shuttle#setSelectedByValue
     * setSelectedByValue()} for a record that was not loaded in the source list, we may not yet have a selected record for
     * that value. See {@link com.smartgwt.client.widgets.grid.Shuttle#valuesFetchInProgress valuesFetchInProgress()}. <P> The
     * <code>includeUnloadedValues</code> parameter can be used to return values for these unloaded records. Default value is null
     */
    public int[] getSelectedValuesAsIntArray()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfint(getAttributeAsJavaScriptObject("selectedValues"));
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortDirection Sort direction} for this item's list of options. Will
     * be applied to {@link com.smartgwt.client.widgets.grid.Shuttle#getSourceGrid sourceGrid} and {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getTargetGrid targetGrid}. To specify initial sort for each grid separately,
     * these properties may be set per grid using the standard {@link com.smartgwt.client.types.AutoChild autoChild pattern}.
     *
     * @param sortDirection New sortDirection value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setSortDirection(SortDirection sortDirection)  throws IllegalStateException {
        return (Shuttle)setAttribute("sortDirection", sortDirection == null ? null : sortDirection.getValue(), false);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortDirection Sort direction} for this item's list of options. Will
     * be applied to {@link com.smartgwt.client.widgets.grid.Shuttle#getSourceGrid sourceGrid} and {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getTargetGrid targetGrid}. To specify initial sort for each grid separately,
     * these properties may be set per grid using the standard {@link com.smartgwt.client.types.AutoChild autoChild pattern}.
     *
     * @return Current sortDirection value. Default value is null
     */
    public SortDirection getSortDirection()  {
        return EnumUtil.getEnum(SortDirection.values(), getAttribute("sortDirection"));
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField Sort field} for this item's list of options. Will be
     * applied to {@link com.smartgwt.client.widgets.grid.Shuttle#getSourceGrid sourceGrid} and {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getTargetGrid targetGrid}. To specify initial sort for each grid separately,
     * these properties may be set per grid using the standard {@link com.smartgwt.client.types.AutoChild autoChild pattern}.
     *
     * @param sortField New sortField value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setSortField(String sortField)  throws IllegalStateException {
        return (Shuttle)setAttribute("sortField", sortField, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField Sort field} for this item's list of options. Will be
     * applied to {@link com.smartgwt.client.widgets.grid.Shuttle#getSourceGrid sourceGrid} and {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getTargetGrid targetGrid}. To specify initial sort for each grid separately,
     * these properties may be set per grid using the standard {@link com.smartgwt.client.types.AutoChild autoChild pattern}.
     *
     * @return Current sortField value. Default value is null
     */
    public String getSortField()  {
        return getAttributeAsString("sortField");
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField Sort field} for this item's list of options. Will be
     * applied to {@link com.smartgwt.client.widgets.grid.Shuttle#getSourceGrid sourceGrid} and {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getTargetGrid targetGrid}. To specify initial sort for each grid separately,
     * these properties may be set per grid using the standard {@link com.smartgwt.client.types.AutoChild autoChild pattern}.
     *
     * @param sortField New sortField value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setSortField(String... sortField)  throws IllegalStateException {
        return (Shuttle)setAttribute("sortField", sortField, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField Sort field} for this item's list of options. Will be
     * applied to {@link com.smartgwt.client.widgets.grid.Shuttle#getSourceGrid sourceGrid} and {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getTargetGrid targetGrid}. To specify initial sort for each grid separately,
     * these properties may be set per grid using the standard {@link com.smartgwt.client.types.AutoChild autoChild pattern}.
     *
     * @return Current sortField value. Default value is null
     */
    public String[] getSortFieldAsStringArray()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("sortField"));
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField Sort field} for this item's list of options. Will be
     * applied to {@link com.smartgwt.client.widgets.grid.Shuttle#getSourceGrid sourceGrid} and {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getTargetGrid targetGrid}. To specify initial sort for each grid separately,
     * these properties may be set per grid using the standard {@link com.smartgwt.client.types.AutoChild autoChild pattern}.
     *
     * @param sortField New sortField value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setSortField(Integer sortField)  throws IllegalStateException {
        return (Shuttle)setAttribute("sortField", sortField, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField Sort field} for this item's list of options. Will be
     * applied to {@link com.smartgwt.client.widgets.grid.Shuttle#getSourceGrid sourceGrid} and {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getTargetGrid targetGrid}. To specify initial sort for each grid separately,
     * these properties may be set per grid using the standard {@link com.smartgwt.client.types.AutoChild autoChild pattern}.
     *
     * @return Current sortField value. Default value is null
     */
    public Integer getSortFieldAsInt()  {
        return getAttributeAsInt("sortField");
    }
    

    /**
     * List grid containing the (unselected) set of records. The user may select items by dragging them from this grid to the
     * {@link com.smartgwt.client.widgets.grid.Shuttle#getTargetGrid targetGrid}.
     * <p>
     * This component is an AutoChild named "sourceGrid".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current sourceGrid value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ListGrid getSourceGrid() throws IllegalStateException {
        errorIfNotCreated("sourceGrid");
        return (ListGrid)ListGrid.getByJSObject(getAttributeAsJavaScriptObject("sourceGrid"));
    }
    

    /**
     * Title for the source grid, shown as a {@link com.smartgwt.client.widgets.Canvas#getGroupTitle Canvas.groupTitle}
     *
     * @param sourceGridTitle New sourceGridTitle value. Default value is "Unselected Values"
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setSourceGridTitle(String sourceGridTitle)  throws IllegalStateException {
        return (Shuttle)setAttribute("sourceGridTitle", sourceGridTitle, false);
    }

    /**
     * Title for the source grid, shown as a {@link com.smartgwt.client.widgets.Canvas#getGroupTitle Canvas.groupTitle}
     *
     * @return Current sourceGridTitle value. Default value is "Unselected Values"
     */
    public String getSourceGridTitle()  {
        return getAttributeAsString("sourceGridTitle");
    }
    

    /**
     * List grid containing the selected set of records. The user may unselect items by dragging them from this grid to the
     * {@link com.smartgwt.client.widgets.grid.Shuttle#getSourceGrid sourceGrid}.
     * <p>
     * This component is an AutoChild named "targetGrid".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current targetGrid value. Default value is null
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ListGrid getTargetGrid() throws IllegalStateException {
        errorIfNotCreated("targetGrid");
        return (ListGrid)ListGrid.getByJSObject(getAttributeAsJavaScriptObject("targetGrid"));
    }
    

    /**
     * Title for the target grid, shown as a {@link com.smartgwt.client.widgets.Canvas#getGroupTitle Canvas.groupTitle}
     *
     * @param targetGridTitle New targetGridTitle value. Default value is "Selected Values"
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setTargetGridTitle(String targetGridTitle)  throws IllegalStateException {
        return (Shuttle)setAttribute("targetGridTitle", targetGridTitle, false);
    }

    /**
     * Title for the target grid, shown as a {@link com.smartgwt.client.widgets.Canvas#getGroupTitle Canvas.groupTitle}
     *
     * @return Current targetGridTitle value. Default value is "Selected Values"
     */
    public String getTargetGridTitle()  {
        return getAttributeAsString("targetGridTitle");
    }
    

    /**
     * TextMatchStyle for retrieving records from this shuttle's dataSource.
     *
     * @param textMatchStyle New textMatchStyle value. Default value is "substring"
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setTextMatchStyle(TextMatchStyle textMatchStyle)  throws IllegalStateException {
        return (Shuttle)setAttribute("textMatchStyle", textMatchStyle == null ? null : textMatchStyle.getValue(), false);
    }

    /**
     * TextMatchStyle for retrieving records from this shuttle's dataSource.
     *
     * @return Current textMatchStyle value. Default value is "substring"
     */
    public TextMatchStyle getTextMatchStyle()  {
        return EnumUtil.getEnum(TextMatchStyle.values(), getAttribute("textMatchStyle"));
    }
    

    /**
     * This field is expected to be unique for records within the shuttle's data set. If not explicitly specified the {@link
     * com.smartgwt.client.data.DataSource dataSource.primaryKey} will be used. <P> May be used to {@link
     * com.smartgwt.client.widgets.grid.Shuttle#setSelectedByValue select records by value} and to retrieve the current {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getSelectedValues selected values}.
     *
     * @param valueField New valueField value. Default value is null
     * @return {@link com.smartgwt.client.widgets.grid.Shuttle Shuttle} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public Shuttle setValueField(String valueField)  throws IllegalStateException {
        return (Shuttle)setAttribute("valueField", valueField, false);
    }

    /**
     * This field is expected to be unique for records within the shuttle's data set. If not explicitly specified the {@link
     * com.smartgwt.client.data.DataSource dataSource.primaryKey} will be used. <P> May be used to {@link
     * com.smartgwt.client.widgets.grid.Shuttle#setSelectedByValue select records by value} and to retrieve the current {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getSelectedValues selected values}.
     *
     * @return Current valueField value. Default value is null
     */
    public String getValueField()  {
        return getAttributeAsString("valueField");
    }
    

    // ********************* Methods ***********************
	/**
     * Deselect all currently selected records
     */
    public native void clearSelection() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "clearSelection", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.clearSelection();
    }-*/;

	/**
     * Deselect all currently selected records
     * @param fireSelectionChanged Fire the {@link com.smartgwt.client.widgets.grid.Shuttle#selectionUpdated selectionUpdated()} notification?
     */
    public native void clearSelection(boolean fireSelectionChanged) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "clearSelection", "boolean");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.clearSelection(fireSelectionChanged);
    }-*/;
	
	/**
     * Programmatically deselect a set of records that are currently selected  and displayed in the target grid.
     * @param records Records to deselect
     */
    public native void deselectRecords(ListGridRecord[] records) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "deselectRecords", "ListGridRecord[]");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.deselectRecords(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(records));
    }-*/;

	/**
     * Programmatically deselect a set of records that are currently selected  and displayed in the target grid.
     * @param records Records to deselect
     * @param fireSelectionChanged Fire the {@link com.smartgwt.client.widgets.grid.Shuttle#selectionUpdated selectionUpdated()} notification?
     */
    public native void deselectRecords(ListGridRecord[] records, boolean fireSelectionChanged) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "deselectRecords", "ListGridRecord[],boolean");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.deselectRecords(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(records), fireSelectionChanged);
    }-*/;
	
	/**
     * Returns the {@link com.smartgwt.client.widgets.grid.Shuttle#getValueField valueField} for this shuttle
     *
     * @return value field name
     */
    public native String getValueFieldName() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getValueFieldName", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getValueFieldName();
        return ret;
    }-*/;

	/**
     * Notification method fired when records are selected or unselected in this shuttle. <P> Use {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getSelectedRecords getSelectedRecords()} or {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getSelectedValues getSelectedValues()}  to retrieve the current selection.
     */
    public native void selectionUpdated() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "selectionUpdated", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.selectionUpdated();
    }-*/;

	/**
     * Programmatically select a set of records from this shuttle's dataSource. The specified records will be added to any
     * existing selection.
     * @param records Records to select
     */
    public native void selectRecords(ListGridRecord[] records) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "selectRecords", "ListGridRecord[]");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.selectRecords(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(records));
    }-*/;

	/**
     * Programmatically select a set of records from this shuttle's dataSource. The specified records will be added to any
     * existing selection.
     * @param records Records to select
     * @param fireSelectionChanged Fire the {@link com.smartgwt.client.widgets.grid.Shuttle#selectionUpdated selectionUpdated()} notification?
     */
    public native void selectRecords(ListGridRecord[] records, boolean fireSelectionChanged) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "selectRecords", "ListGridRecord[],boolean");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.selectRecords(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(records), fireSelectionChanged);
    }-*/;
	
	/**
     * Method to add or remove records from the current selection where the {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getValueField valueField} matches the values passed in. <P> If the source
     * listGrid does not have a  {@link com.smartgwt.client.data.ResultSet#allMatchingRowsCached complete data set} and does
     * not contain an entry for any of the requested values, a separate fetch request will be issued against our {@link
     * com.smartgwt.client.data.DataSource} to pick up the  records for the specified value(s). The {@link
     * com.smartgwt.client.widgets.grid.Shuttle#valuesFetchInProgress valuesFetchInProgress()} and  {@link
     * com.smartgwt.client.widgets.grid.Shuttle#valuesFetchComplete valuesFetchComplete()} methods provide information about
     * this fetch.
     * @param value Array of values to select
     * @param selected New selected state for the records
     */
    public native void setSelectedByValue(String[] value, Boolean selected) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setSelectedByValue", "String[],Boolean");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.setSelectedByValue(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(value), selected == null ? null : selected.@java.lang.Boolean::booleanValue()());
    }-*/;

	/**
     * Method to add or remove records from the current selection where the {@link
     * com.smartgwt.client.widgets.grid.Shuttle#getValueField valueField} matches the values passed in. <P> If the source
     * listGrid does not have a  {@link com.smartgwt.client.data.ResultSet#allMatchingRowsCached complete data set} and does
     * not contain an entry for any of the requested values, a separate fetch request will be issued against our {@link
     * com.smartgwt.client.data.DataSource} to pick up the  records for the specified value(s). The {@link
     * com.smartgwt.client.widgets.grid.Shuttle#valuesFetchInProgress valuesFetchInProgress()} and  {@link
     * com.smartgwt.client.widgets.grid.Shuttle#valuesFetchComplete valuesFetchComplete()} methods provide information about
     * this fetch.
     * @param value Array of values to select
     * @param selected New selected state for the records
     */
    public native void setSelectedByValue(int[] value, Boolean selected) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setSelectedByValue", "int[],Boolean");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.setSelectedByValue(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([I)(value), selected == null ? null : selected.@java.lang.Boolean::booleanValue()());
    }-*/;

	/**
     * Notification method fired when a fetch to retrieve records for an array of values passed to {@link
     * com.smartgwt.client.widgets.grid.Shuttle#setSelectedByValue setSelectedByValue()} is complete. <P> Note that if no
     * associated record for the specified value was found in the dataSource, this method will still fire.
     *
     * @return true if there is an outstanding values fetch
     */
    public native boolean valuesFetchComplete() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "valuesFetchComplete", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.valuesFetchComplete();
        return ret == null ? false : ret;
    }-*/;

	/**
     * Returns true if this shuttle is currently fetching record(s) associated with values passed to {@link
     * com.smartgwt.client.widgets.grid.Shuttle#setSelectedByValue setSelectedByValue()} <P> If no explicit <code>value</code>
     * parameter was passed, this method will return true if this shuttle has any outstanding values fetches.
     *
     * @return true if there is an outstanding values fetch
     */
    public native boolean valuesFetchInProgress() /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "valuesFetchInProgress", "");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.valuesFetchInProgress();
        return ret == null ? false : ret;
    }-*/;

	/**
     * Returns true if this shuttle is currently fetching record(s) associated with values passed to {@link
     * com.smartgwt.client.widgets.grid.Shuttle#setSelectedByValue setSelectedByValue()} <P> If no explicit <code>value</code>
     * parameter was passed, this method will return true if this shuttle has any outstanding values fetches.
     * @param value if passed, this method will return true only if   there is an outstanding fetch to retrieve the associated record for  
     * this specified value
     *
     * @return true if there is an outstanding values fetch
     */
    public native boolean valuesFetchInProgress(Object value) /*-{
        if (this.@com.smartgwt.client.widgets.BaseWidget::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "valuesFetchInProgress", "Object");
        }
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.valuesFetchInProgress(value);
        return ret == null ? false : ret;
    }-*/;
	

    // ********************* Static Methods ***********************

    /** 
     * Class level method to set the default properties of this class.  If set, then all
     * existing and subsequently created instances of this class will automatically have
     * default properties corresponding to
     * the properties set on the SmartGWT class instance passed to this function before its
     * underlying SmartClient JS object was created.
     * This is a powerful feature that eliminates the need for users to create a separate
     * hierarchy of subclasses that only alter the default properties of this class. Can also
     * be used for skinning / styling purposes.  <P> <b>Note:</b> This method is intended for
     * setting default attributes only and will affect all instances of the underlying class
     * (including those automatically generated in JavaScript).  This method should not be used
     * to apply standard EventHandlers or override methods for a class - use a custom subclass
     * instead.  Calling this method after instances have been created can result in undefined
     * behavior, since it bypasses any setters and a class instance may have already examined 
     * a particular property and not be expecting any changes through this route.
     *
     * @param shuttleProperties properties that should be used as new defaults when instances of this class are created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public static native void setDefaultProperties(Shuttle shuttleProperties) /*-{
        if (shuttleProperties.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)(Shuttle.@java.lang.Object::getClass()(), "setDefaultProperties", shuttleProperties.@java.lang.Object::getClass()());
        }
        shuttleProperties.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
    	var properties = shuttleProperties.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        properties = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(properties,true);
        $wnd.isc.Shuttle.addProperties(properties);
    }-*/;

    // ***********************************************************

    /**
     * Setter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject setLogicalStructure(ShuttleLogicalStructure s) {
        super.setLogicalStructure(s);
        try {
            s.dataSource = getDataSource();
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.dataSource:" + t.getMessage() + "\n";
        }
        try {
            s.deselectAllButtonHeight = getAttributeAsString("deselectAllButtonHeight");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.deselectAllButtonHeight:" + t.getMessage() + "\n";
        }
        try {
            s.deselectAllButtonIcon = getAttributeAsString("deselectAllButtonIcon");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.deselectAllButtonIcon:" + t.getMessage() + "\n";
        }
        try {
            s.deselectAllButtonWidth = getAttributeAsString("deselectAllButtonWidth");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.deselectAllButtonWidth:" + t.getMessage() + "\n";
        }
        try {
            s.deselectButtonHeight = getAttributeAsString("deselectButtonHeight");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.deselectButtonHeight:" + t.getMessage() + "\n";
        }
        try {
            s.deselectButtonIcon = getAttributeAsString("deselectButtonIcon");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.deselectButtonIcon:" + t.getMessage() + "\n";
        }
        try {
            s.deselectButtonWidth = getAttributeAsString("deselectButtonWidth");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.deselectButtonWidth:" + t.getMessage() + "\n";
        }
        try {
            s.fetchOperation = getAttributeAsString("fetchOperation");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.fetchOperation:" + t.getMessage() + "\n";
        }
        try {
            s.fields = getFields();
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.fieldsArray:" + t.getMessage() + "\n";
        }
        try {
            s.implicitCriteria = getImplicitCriteria();
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.implicitCriteria:" + t.getMessage() + "\n";
        }
        try {
            s.incompleteDataWarning = getAttributeAsString("incompleteDataWarning");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.incompleteDataWarning:" + t.getMessage() + "\n";
        }
        try {
            s.initialSort = getInitialSort();
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.initialSortArray:" + t.getMessage() + "\n";
        }
        try {
            s.loadingPlaceholderAttribute = getAttributeAsString("loadingPlaceholderAttribute");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.loadingPlaceholderAttribute:" + t.getMessage() + "\n";
        }
        try {
            s.selectAllButtonHeight = getAttributeAsString("selectAllButtonHeight");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.selectAllButtonHeight:" + t.getMessage() + "\n";
        }
        try {
            s.selectAllButtonIcon = getAttributeAsString("selectAllButtonIcon");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.selectAllButtonIcon:" + t.getMessage() + "\n";
        }
        try {
            s.selectAllButtonWidth = getAttributeAsString("selectAllButtonWidth");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.selectAllButtonWidth:" + t.getMessage() + "\n";
        }
        try {
            s.selectButtonHeight = getAttributeAsString("selectButtonHeight");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.selectButtonHeight:" + t.getMessage() + "\n";
        }
        try {
            s.selectButtonIcon = getAttributeAsString("selectButtonIcon");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.selectButtonIcon:" + t.getMessage() + "\n";
        }
        try {
            s.selectButtonWidth = getAttributeAsString("selectButtonWidth");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.selectButtonWidth:" + t.getMessage() + "\n";
        }
        try {
            s.selectedRecords = getSelectedRecords();
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.selectedRecords:" + t.getMessage() + "\n";
        }
        try {
            s.selectedValuesAsStringArrayArray = getAttributeAsStringArray("selectedValues");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.selectedValuesAsStringArrayArray:" + t.getMessage() + "\n";
        }
        try {
            s.sortDirection = getAttributeAsString("sortDirection");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.sortDirection:" + t.getMessage() + "\n";
        }
        try {
            s.sortFieldAsString = getAttributeAsString("sortField");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.sortFieldAsString:" + t.getMessage() + "\n";
        }
        try {
            s.sourceGridTitle = getAttributeAsString("sourceGridTitle");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.sourceGridTitle:" + t.getMessage() + "\n";
        }
        try {
            s.targetGridTitle = getAttributeAsString("targetGridTitle");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.targetGridTitle:" + t.getMessage() + "\n";
        }
        try {
            s.textMatchStyle = getAttributeAsString("textMatchStyle");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.textMatchStyle:" + t.getMessage() + "\n";
        }
        try {
            s.valueField = getAttributeAsString("valueField");
        } catch (Throwable t) {
            s.logicalStructureErrors += "Shuttle.valueField:" + t.getMessage() + "\n";
        }
        return s;
    }

    /**
     * Getter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject getLogicalStructure() {
        ShuttleLogicalStructure s = new ShuttleLogicalStructure();
        setLogicalStructure(s);
        return s;
    }
}
