
package com.smartgwt.client.docs;

/**
 * <h3>DataBound Component Methods</h3>
 * An Action Method initiates an orchestrated client-server flow that stores or retrieves data and
 * updates one or more components. <P> For example, the {@link
 * com.smartgwt.client.widgets.form.DynamicForm#saveData editor.saveData()} Action Method saves
 * the record currently being edited in the form, transparently handling the trip to the server,
 * standard error conditions such as validation errors (whether the validation error happens on
 * the client or server), and update of client-side caches. <P> Action Methods are available on
 * DataBoundComponents.
 * @see com.smartgwt.client.widgets.form.DynamicForm#editNewRecord
 * @see com.smartgwt.client.widgets.form.DynamicForm#editRecord
 * @see com.smartgwt.client.widgets.form.DynamicForm#editSelectedData
 * @see com.smartgwt.client.widgets.form.DynamicForm#submit
 * @see com.smartgwt.client.widgets.form.DynamicForm#saveData
 * @see com.smartgwt.client.widgets.form.DynamicForm#fetchData
 * @see com.smartgwt.client.widgets.form.DynamicForm#filterData
 * @see com.smartgwt.client.widgets.form.ValuesManager#editNewRecord
 * @see com.smartgwt.client.widgets.form.ValuesManager#editRecord
 * @see com.smartgwt.client.widgets.form.ValuesManager#editSelectedData
 * @see com.smartgwt.client.widgets.form.ValuesManager#saveData
 * @see com.smartgwt.client.widgets.form.ValuesManager#submit
 * @see com.smartgwt.client.widgets.form.ValuesManager#filterData
 * @see com.smartgwt.client.widgets.form.ValuesManager#fetchData
 * @see com.smartgwt.client.widgets.viewer.DetailViewer#viewSelectedData
 * @see com.smartgwt.client.widgets.calendar.Calendar#fetchData
 * @see com.smartgwt.client.widgets.calendar.Calendar#filterData
 * @see com.smartgwt.client.widgets.grid.ListGrid#removeData
 * @see com.smartgwt.client.widgets.tile.TileGrid#fetchData
 * @see com.smartgwt.client.widgets.tile.TileGrid#filterData
 * @see com.smartgwt.client.widgets.tile.TileGrid#invalidateCache
 * @see com.smartgwt.client.widgets.tile.TileGrid#removeSelectedData
 * @see com.smartgwt.client.widgets.tile.TileGrid#addData
 * @see com.smartgwt.client.widgets.tile.TileGrid#removeData
 * @see com.smartgwt.client.widgets.grid.ColumnTree#fetchData
 * @see com.smartgwt.client.widgets.grid.ColumnTree#filterData
 * @see com.smartgwt.client.widgets.grid.ListGrid#fetchData
 * @see com.smartgwt.client.widgets.grid.ListGrid#exportData
 * @see com.smartgwt.client.widgets.grid.ListGrid#filterData
 * @see com.smartgwt.client.widgets.grid.ListGrid#fetchRelatedData
 * @see com.smartgwt.client.widgets.grid.ListGrid#clearCriteria
 * @see com.smartgwt.client.widgets.grid.ListGrid#getCriteria
 * @see com.smartgwt.client.widgets.grid.ListGrid#setCriteria
 * @see com.smartgwt.client.widgets.grid.ListGrid#invalidateCache
 * @see com.smartgwt.client.widgets.grid.ListGrid#willFetchData
 * @see com.smartgwt.client.widgets.grid.ListGrid#addData
 * @see com.smartgwt.client.widgets.grid.ListGrid#updateData
 * @see com.smartgwt.client.widgets.grid.ListGrid#removeSelectedData
 * @see com.smartgwt.client.widgets.tree.TreeGrid#fetchData
 * @see com.smartgwt.client.widgets.tree.TreeGrid#filterData
 * @see com.smartgwt.client.widgets.tile.TileGrid#exportData
 * @see com.smartgwt.client.widgets.viewer.DetailViewer#exportData
 */
public interface DataBoundComponentMethods {
}
