/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.ImeActivationFailedException;
import org.openqa.selenium.ImeNotAvailableException;
import org.openqa.selenium.InvalidCookieDomainException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.UnableToSetCookieException;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.interactions.InvalidCoordinatesException;
import org.openqa.selenium.interactions.MoveTargetOutOfBoundsException;
import org.openqa.selenium.remote.SessionNotFoundException;

public class ErrorCodes {
    @Beta
    public static final String SUCCESS_STRING = "success";
    public static final int SUCCESS = 0;
    public static final int NO_SUCH_SESSION = 6;
    public static final int NO_SUCH_ELEMENT = 7;
    public static final int NO_SUCH_FRAME = 8;
    public static final int UNKNOWN_COMMAND = 9;
    public static final int STALE_ELEMENT_REFERENCE = 10;
    public static final int ELEMENT_NOT_VISIBLE = 11;
    public static final int INVALID_ELEMENT_STATE = 12;
    public static final int UNHANDLED_ERROR = 13;
    public static final int ELEMENT_NOT_SELECTABLE = 15;
    public static final int JAVASCRIPT_ERROR = 17;
    public static final int XPATH_LOOKUP_ERROR = 19;
    public static final int TIMEOUT = 21;
    public static final int NO_SUCH_WINDOW = 23;
    public static final int INVALID_COOKIE_DOMAIN = 24;
    public static final int UNABLE_TO_SET_COOKIE = 25;
    public static final int UNEXPECTED_ALERT_PRESENT = 26;
    public static final int NO_ALERT_PRESENT = 27;
    public static final int ASYNC_SCRIPT_TIMEOUT = 28;
    public static final int INVALID_ELEMENT_COORDINATES = 29;
    public static final int IME_NOT_AVAILABLE = 30;
    public static final int IME_ENGINE_ACTIVATION_FAILED = 31;
    public static final int INVALID_SELECTOR_ERROR = 32;
    public static final int SESSION_NOT_CREATED = 33;
    public static final int MOVE_TARGET_OUT_OF_BOUNDS = 34;
    public static final int INVALID_XPATH_SELECTOR = 51;
    public static final int INVALID_XPATH_SELECTOR_RETURN_TYPER = 52;
    public static final int METHOD_NOT_ALLOWED = 405;
    private static Map<Integer, String> statusToState = ImmutableMap.builder().put((Object)28, (Object)"async script timeout").put((Object)15, (Object)"element not selectable").put((Object)11, (Object)"element not visible").put((Object)31, (Object)"ime engine activation failed").put((Object)30, (Object)"ime not available").put((Object)24, (Object)"invalid cookie domain").put((Object)29, (Object)"invalid element coordinates").put((Object)12, (Object)"invalid element state").put((Object)32, (Object)"invalid selector").put((Object)51, (Object)"invalid selector").put((Object)52, (Object)"invalid selector").put((Object)17, (Object)"javascript error").put((Object)405, (Object)"method not allowed").put((Object)34, (Object)"move target out of bounds").put((Object)7, (Object)"no such element").put((Object)8, (Object)"no such frame").put((Object)6, (Object)"no such session").put((Object)23, (Object)"no such window").put((Object)33, (Object)"session not created").put((Object)10, (Object)"stale element reference").put((Object)0, (Object)"success").put((Object)21, (Object)"timeout").put((Object)25, (Object)"unable to set cookie").put((Object)26, (Object)"no such alert").put((Object)13, (Object)"unhandled error").put((Object)9, (Object)"unknown command").put((Object)19, (Object)"invalid selector").build();
    private static Map<String, Integer> stateToStatus;

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Integer, String> pair : statusToState.entrySet()) {
            if (pair.getValue().equals("invalid selector") && pair.getKey() != 32) continue;
            builder.put((Object)pair.getValue(), (Object)pair.getKey());
        }
        stateToStatus = builder.build();
    }

    public Class<? extends WebDriverException> getExceptionType(int statusCode) {
        switch (statusCode) {
            case 0: {
                return null;
            }
            case 6: {
                return SessionNotFoundException.class;
            }
            case 24: {
                return InvalidCookieDomainException.class;
            }
            case 25: {
                return UnableToSetCookieException.class;
            }
            case 23: {
                return NoSuchWindowException.class;
            }
            case 7: {
                return NoSuchElementException.class;
            }
            case 19: 
            case 32: 
            case 51: 
            case 52: {
                return InvalidSelectorException.class;
            }
            case 34: {
                return MoveTargetOutOfBoundsException.class;
            }
            case 8: {
                return NoSuchFrameException.class;
            }
            case 9: 
            case 405: {
                return UnsupportedCommandException.class;
            }
            case 10: {
                return StaleElementReferenceException.class;
            }
            case 11: {
                return ElementNotVisibleException.class;
            }
            case 12: 
            case 15: {
                return InvalidElementStateException.class;
            }
            case 21: 
            case 28: {
                return TimeoutException.class;
            }
            case 29: {
                return InvalidCoordinatesException.class;
            }
            case 30: {
                return ImeNotAvailableException.class;
            }
            case 31: {
                return ImeActivationFailedException.class;
            }
            case 27: {
                return NoAlertPresentException.class;
            }
            case 33: {
                return SessionNotCreatedException.class;
            }
            case 26: {
                return UnhandledAlertException.class;
            }
        }
        return WebDriverException.class;
    }

    public int toStatusCode(Throwable thrown) {
        if (thrown == null) {
            return 0;
        }
        if (thrown instanceof TimeoutException) {
            return 28;
        }
        if (thrown instanceof ElementNotVisibleException) {
            return 11;
        }
        if (thrown instanceof InvalidCookieDomainException) {
            return 24;
        }
        if (thrown instanceof InvalidCoordinatesException) {
            return 29;
        }
        if (thrown instanceof InvalidElementStateException) {
            return 12;
        }
        if (thrown instanceof InvalidSelectorException) {
            return 32;
        }
        if (thrown instanceof ImeNotAvailableException) {
            return 30;
        }
        if (thrown instanceof ImeActivationFailedException) {
            return 31;
        }
        if (thrown instanceof NoAlertPresentException) {
            return 27;
        }
        if (thrown instanceof NoSuchElementException) {
            return 7;
        }
        if (thrown instanceof NoSuchFrameException) {
            return 8;
        }
        if (thrown instanceof NoSuchWindowException) {
            return 23;
        }
        if (thrown instanceof MoveTargetOutOfBoundsException) {
            return 34;
        }
        if (thrown instanceof SessionNotCreatedException) {
            return 33;
        }
        if (thrown instanceof StaleElementReferenceException) {
            return 10;
        }
        if (thrown instanceof UnableToSetCookieException) {
            return 25;
        }
        if (thrown instanceof UnhandledAlertException) {
            return 26;
        }
        return 13;
    }

    public boolean isMappableError(Throwable thrown) {
        int statusCode = this.toStatusCode(thrown);
        return statusCode != 0 && statusCode != 13;
    }

    public static String toState(int status) {
        return statusToState.get(status);
    }

    public static int toStatus(String state) {
        return stateToStatus.get(state);
    }
}

