/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByScLocator
extends By {
    public static final String GET_ELEMENT = "isc.AutoTest.getElement";
    private static final int WAIT_TIMEOUT_MILLIS = 5000;
    private static final int WAIT_QUANTUM_MILLIS = 200;
    private final String scLocator;

    ByScLocator(String scLocator) {
        this.scLocator = scLocator.replaceAll("\\\"", "'").replaceAll("\\'", "'").trim();
    }

    public List<WebElement> findElements(SearchContext context) {
        JavascriptExecutor js = (JavascriptExecutor)context;
        ArrayList<WebElement> list = new ArrayList<WebElement>();
        Object element = js.executeScript("return isc.AutoTest.getElement(\"" + this.scLocator + "\")", new Object[0]);
        if (element != null) {
            list.add((WebElement)element);
        }
        return list;
    }

    public WebElement findElement(SearchContext context) {
        JavascriptExecutor js = (JavascriptExecutor)context;
        int maximumTicks = 25;
        for (int tick = 0; tick <= maximumTicks; ++tick) {
            try {
                Object element = js.executeScript("return isc.AutoTest.getElement(\"" + this.scLocator + "\")", new Object[0]);
                if (element == null) continue;
                return (WebElement)element;
            }
            catch (Exception e) {
                System.err.println("ByScLocator.findElement failed:" + e);
            }
        }
        throw new NoSuchElementException(this.scLocator);
    }

    public Point findElementCoordinates(JavascriptExecutor js) {
        String command = "isc.AutoTest.getPageCoords(arguments[0])";
        List coords = (List)js.executeScript("return " + command, new Object[]{this.scLocator});
        return coords == null || coords.size() != 2 ? null : new Point(((Long)coords.get(0)).intValue(), ((Long)coords.get(1)).intValue());
    }

    public String toJavaString() {
        return "ByScLocator.scLocator(\"" + this.scLocator.replace("\"", "\\\"") + "\")";
    }

    public String toString() {
        return "By.scLocator: " + this.scLocator;
    }

    public String getLocatorString() {
        return this.scLocator.replace("\\", "");
    }

    public static By scLocator(String scLocator) {
        if (scLocator == null) {
            throw new IllegalArgumentException("Cannot find elements with a null scLocator attribute.");
        }
        return new ByScLocator(scLocator);
    }

    int getEdgeOffsetX(long width, long margin) {
        if (this.getPartLocator().contains("L")) {
            return (int)margin;
        }
        if (this.getPartLocator().contains("R")) {
            return (int)(width - margin);
        }
        return (int)(width / 2L);
    }

    int getEdgeOffsetY(long height, long margin) {
        if (this.getPartLocator().contains("T")) {
            return (int)margin;
        }
        if (this.getPartLocator().contains("B")) {
            return (int)(height - margin);
        }
        return (int)(height / 2L);
    }

    boolean isEdgeLocator() {
        String partLocator = this.getPartLocator();
        if (partLocator.length() == 1) {
            return "TBLR".contains(partLocator);
        }
        if (partLocator.length() == 2) {
            return !(!partLocator.startsWith("T") && !partLocator.startsWith("B") || !partLocator.endsWith("L") && !partLocator.endsWith("R"));
        }
        return false;
    }

    String getBaseLocator() {
        return this.scLocator.substring(0, this.scLocator.lastIndexOf(47));
    }

    private String getPartLocator() {
        if (this.scLocator != null && this.scLocator.contains("/")) {
            return this.scLocator.substring(this.scLocator.lastIndexOf(47) + 1);
        }
        return "";
    }
}

