/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.Operation;
import com.isomorphic.webdriver.SmartClientWebDriver;
import java.io.PrintStream;
import org.htmlparser.Tag;
import org.htmlparser.util.NodeList;
import org.htmlparser.visitors.NodeVisitor;

class SeleneseTestCaseParser
extends NodeVisitor {
    private Operation operation = null;
    private SmartClientWebDriver driver;
    private boolean successful = true;
    private boolean found = false;
    private PrintStream output;
    private boolean debug;

    public SeleneseTestCaseParser(SmartClientWebDriver driver, PrintStream output, boolean debug) {
        this.driver = driver;
        this.output = output;
        this.debug = debug;
    }

    public void visitTag(Tag tag) {
        NodeList children;
        String name = tag.getTagName();
        if ("tr".equalsIgnoreCase(name) && (children = tag.getChildren()).size() == 6) {
            this.found = true;
            try {
                RowVisitor rowVisitor = null;
                rowVisitor = new RowVisitor(this.output);
                children.visitAllNodesWith((NodeVisitor)rowVisitor);
                this.operation = rowVisitor.getOperation();
                if (this.debug) {
                    System.err.println(this.operation.toString());
                }
                Object result = this.operation.execute(this.driver);
                if (this.operation.isVerify()) {
                    if (result == null) {
                        result = Boolean.FALSE;
                    }
                    boolean bl = this.successful = this.successful && (Boolean)result != false;
                    if (result.equals(Boolean.FALSE) && this.output != null) {
                        this.output.println("/**FAIL**/");
                    }
                }
                if (this.output != null) {
                    this.output.println("    " + this.operation.toJavaString());
                }
                if (this.debug) {
                    Thread.sleep(5000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.successful = false;
            }
        }
    }

    public boolean getResult() {
        this.driver.close();
        if (!this.found) {
            System.err.println("No valid selenese found");
        }
        return this.successful && this.found;
    }

    private static class RowVisitor
    extends NodeVisitor {
        private int col = 0;
        private String operator;
        private String operand1;
        private String operand2;

        public RowVisitor(PrintStream output) {
        }

        public void reset() {
            this.col = 0;
        }

        public Operation getOperation() {
            return new Operation(this.operator, this.operand1, this.operand2);
        }

        public void visitTag(Tag tag) {
            String name = tag.getTagName();
            if ("td".equalsIgnoreCase(name)) {
                if (this.col == 0) {
                    this.operator = tag.getChildren().asString();
                    ++this.col;
                } else if (this.col == 1) {
                    this.operand1 = tag.getChildren() != null ? tag.getChildren().asString().replace("scLocator=", "").replace("&quot;", "\"") : null;
                    ++this.col;
                } else if (this.col == 2) {
                    this.operand2 = tag.getChildren() != null ? tag.getChildren().asString().replace("scLocator=", "").replace("&quot;", "\"") : null;
                    this.reset();
                }
            }
        }
    }
}

