
/*

  SmartClient Ajax RIA system
  Version v10.0p_2021-05-26/LGPL Deployment (2021-05-26)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
isc.defineClass("ExpressionItem", "PopUpTextAreaItem");

isc.ExpressionItem.addMethods({
    mapValueToDisplay : function (value) {
        if (isc.isA.StringMethod(value)) return value.getDisplayValue();
        else if (isc.isA.Function(value)) {
            if (value.iscAction) {
                return "[" + value.iscAction.title + "]";
            }
            return isc.Func.getBody(value);
        }
        else return this.Super("mapValueToDisplay", arguments);
    },
    
    getValue : function () {
        var value = this.Super("getValue");
        if (isc.isA.Function(value)) return isc.Func.getBody(value);
        else return value;
    },
    textAreaWidth:400,

    // ---------------------------------------------------------------------------------------

    showActionIcon:true,
    actionIconSrc:"[SKIN]/actions/add.png",
    actionIconWidth:20,
    actionIconHeight:20,
    
    // Where should the actionIcon show up in the icons array?
    
    actionIconPosition:1,
    _setUpIcons : function () {
        this.Super("_setUpIcons", arguments);
        if (this.showActionIcon) {
            if (this.icons == null) this.icons = [];
            var position = this.actionIconPosition;
            this.icons.addAt({
                name:"action",
                src:this.actionIconSrc,
                showOver:false,
                width:this.actionIconWidth,
                height:this.actionIconHeight,
                // return false from click handler so we don't fire standard cellclick
                // which would show the pop up (unless we also set popUpOnAnyClick to false)
                click:this.getID() + ".showActionMenu();return false;"
            }, position);
            
            // have to explicitly set the required icon properties - usually handled by
            // setUpIcons, but that's already run at this point.
            this._setUpIcon(this.icons[position]);
        }
    },
    
    // Override updateAppearance to refresh our element value. Required since
    // the element value isn't edited directly.
    updateAppearance : function (newValue) {    
        this.setElementValue(this.mapValueToDisplay(newValue));
    },

    showActionMenu : function () {
        var item = this,
            menu = isc.ActionMenu.create({
            sourceComponent : this.form.currentComponent,
            sourceMethod : this.name,
            components: this.form.allComponents,
            bindingComplete : function (binding) {
                // binding may be null - if the user selected top level "[None]" option
                item._updateValue(binding);
            }
        });
        // Need to draw the menu first or placeNear() might not have the correct dimensions
        menu.show();
        var iconRect = this.getIconPageRect(this.icons[1]); 
        menu.placeNear(iconRect[0] + this.actionIconWidth,
                       iconRect[1] + this.actionIconHeight);
    }

});
