/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.grid;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.drawing.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;
import com.smartgwt.client.util.*;
import com.smartgwt.client.util.workflow.*;
import com.google.gwt.event.shared.*;
import com.google.gwt.event.shared.HasHandlers;
import com.smartgwt.logicalstructure.core.*;
import com.smartgwt.logicalstructure.widgets.*;
import com.smartgwt.logicalstructure.widgets.drawing.*;
import com.smartgwt.logicalstructure.widgets.plugins.*;
import com.smartgwt.logicalstructure.widgets.form.*;
import com.smartgwt.logicalstructure.widgets.tile.*;
import com.smartgwt.logicalstructure.widgets.grid.*;
import com.smartgwt.logicalstructure.widgets.chart.*;
import com.smartgwt.logicalstructure.widgets.layout.*;
import com.smartgwt.logicalstructure.widgets.menu.*;
import com.smartgwt.logicalstructure.widgets.rte.*;
import com.smartgwt.logicalstructure.widgets.tab.*;
import com.smartgwt.logicalstructure.widgets.tableview.*;
import com.smartgwt.logicalstructure.widgets.toolbar.*;
import com.smartgwt.logicalstructure.widgets.tree.*;
import com.smartgwt.logicalstructure.widgets.viewer.*;
import com.smartgwt.logicalstructure.widgets.calendar.*;
import com.smartgwt.logicalstructure.widgets.cube.*;
import com.smartgwt.logicalstructure.widgets.tools.*;

/**
 * A ListGrid is a {@link com.smartgwt.client.widgets.DataBoundComponent} that displays a list of objects in a grid, where
 * each row represents one object and each cell in the row represents one property.
 * @see com.smartgwt.client.docs.Editing Editing overview and related methods
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("ListGrid")
public class ListGrid extends VLayout implements DataBoundComponent, com.smartgwt.client.widgets.grid.events.HasCellSavedHandlers, com.smartgwt.client.widgets.grid.events.HasCellClickHandlers, com.smartgwt.client.widgets.grid.events.HasCellContextClickHandlers, com.smartgwt.client.widgets.grid.events.HasCellDoubleClickHandlers, com.smartgwt.client.widgets.grid.events.HasCellHoverHandlers, com.smartgwt.client.widgets.grid.events.HasCellMouseDownHandlers, com.smartgwt.client.widgets.grid.events.HasCellMouseUpHandlers, com.smartgwt.client.widgets.grid.events.HasCellOutHandlers, com.smartgwt.client.widgets.grid.events.HasCellOverHandlers, com.smartgwt.client.widgets.grid.events.HasCellSelectionChangedHandlers, com.smartgwt.client.widgets.grid.events.HasCellValueHoverHandlers, com.smartgwt.client.widgets.grid.events.HasDataArrivedHandlers, com.smartgwt.client.widgets.grid.events.HasDrawAreaChangedHandlers, com.smartgwt.client.widgets.grid.events.HasEditCompleteHandlers, com.smartgwt.client.widgets.grid.events.HasEditFailedHandlers, com.smartgwt.client.widgets.grid.events.HasEditorEnterHandlers, com.smartgwt.client.widgets.grid.events.HasEditorExitHandlers, com.smartgwt.client.widgets.grid.events.HasFieldStateChangedHandlers, com.smartgwt.client.widgets.grid.events.HasFilterEditorSubmitHandlers, com.smartgwt.client.widgets.events.HasFormulaUpdatedHandlers, com.smartgwt.client.widgets.grid.events.HasGroupByCompleteHandlers, com.smartgwt.client.widgets.grid.events.HasGroupStateChangedHandlers, com.smartgwt.client.widgets.grid.events.HasGroupByHandlers, com.smartgwt.client.widgets.grid.events.HasHeaderDoubleClickHandlers, com.smartgwt.client.widgets.grid.events.HasHeaderHoverHandlers, com.smartgwt.client.widgets.grid.events.HasHilitesChangedHandlers, com.smartgwt.client.widgets.grid.events.HasBodyKeyPressHandlers, com.smartgwt.client.widgets.grid.events.HasRecordCollapseHandlers, com.smartgwt.client.widgets.grid.events.HasRecordExpandHandlers, com.smartgwt.client.widgets.grid.events.HasHeaderClickHandlers, com.smartgwt.client.widgets.grid.events.HasRecordClickHandlers, com.smartgwt.client.widgets.grid.events.HasRecordDropHandlers, com.smartgwt.client.widgets.grid.events.HasRemoveRecordClickHandlers, com.smartgwt.client.widgets.grid.events.HasRecordDoubleClickHandlers, com.smartgwt.client.widgets.grid.events.HasRowContextClickHandlers, com.smartgwt.client.widgets.grid.events.HasRowEditorEnterHandlers, com.smartgwt.client.widgets.grid.events.HasRowEditorExitHandlers, com.smartgwt.client.widgets.grid.events.HasRowHoverHandlers, com.smartgwt.client.widgets.grid.events.HasRowMouseDownHandlers, com.smartgwt.client.widgets.grid.events.HasRowMouseUpHandlers, com.smartgwt.client.widgets.grid.events.HasRowOutHandlers, com.smartgwt.client.widgets.grid.events.HasRowOverHandlers, com.smartgwt.client.widgets.grid.events.HasSelectionChangedHandlers, com.smartgwt.client.widgets.grid.events.HasSelectionUpdatedHandlers, com.smartgwt.client.widgets.grid.events.HasSortChangedHandlers, com.smartgwt.client.widgets.grid.events.HasSorterClickHandlers, com.smartgwt.client.widgets.grid.events.HasSorterContextClickHandlers, com.smartgwt.client.widgets.grid.events.HasViewStateChangedHandlers {

    public static ListGrid getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;
        final BaseWidget refInstance = BaseWidget.getRef(jsObj);
        if (refInstance == null) {
            return new ListGrid(jsObj);
        } else {
            assert refInstance instanceof ListGrid;
            return (ListGrid)refInstance;
        }
    }

    private static final ListGrid TEST_INSTANCE = new ListGrid();
    static {
        TEST_INSTANCE.setID("isc_ListGrid_testInstance");
    }

    @Override
    protected ListGrid getTestInstance() {
        return TEST_INSTANCE;
    }


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.ListGrid.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
    	var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.core.RefDataClass::getJsObj()(), true);
        $wnd.isc.ListGrid.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public ListGrid(){
        setModalEditing(true);scClassName = "ListGrid";
    }

    public ListGrid(JavaScriptObject jsObj){
        scClassName = "ListGrid";
        setJavaScriptObject(jsObj);
    }


    public ListGrid(DataSource dataSource) {
        setDataSource(dataSource);
                setModalEditing(true);scClassName = "ListGrid";
    }

    protected native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
        var widget = $wnd.isc[scClassName].create(config);
        if ($wnd.isc.keepGlobals) this.@com.smartgwt.client.widgets.BaseWidget::internalSetID(Lcom/google/gwt/core/client/JavaScriptObject;)(widget);
        this.@com.smartgwt.client.widgets.BaseWidget::doInit()();
        return widget;
    }-*/;

    // ********************* Properties / Attributes ***********************

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getUseAdvancedFieldPicker useAdvancedFieldPicker} is set, total
     * number of available fields that must be present in the grid before the advanced field picker interface is used instead
     * of the normal columns submenu. <P> Set to 0 to have the advanced picker always used (when useAdvancedFieldPicker is
     * true).
     *
     * @param advancedFieldPickerThreshold  Default value is 25
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAdvancedFieldPickerThreshold(int advancedFieldPickerThreshold)  throws IllegalStateException {
        setAttribute("advancedFieldPickerThreshold", advancedFieldPickerThreshold, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getUseAdvancedFieldPicker useAdvancedFieldPicker} is set, total
     * number of available fields that must be present in the grid before the advanced field picker interface is used instead
     * of the normal columns submenu. <P> Set to 0 to have the advanced picker always used (when useAdvancedFieldPicker is
     * true).
     *
     * @return int
     */
    public int getAdvancedFieldPickerThreshold()  {
        return getAttributeAsInt("advancedFieldPickerThreshold");
    }
    

    /**
     * For use with {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor}:true, allows simple
     * search expressions to be entered into filter fields, as though {@link
     * com.smartgwt.client.widgets.form.DynamicForm#getAllowExpressions allowExpressions} were true. <P> Can also be enabled or
     * disabled on a field-by-field basis via {@link com.smartgwt.client.widgets.grid.ListGridField#getFilterEditorProperties
     * filterEditorProperties}.
     *
     * @param allowFilterExpressions  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAllowFilterExpressions(Boolean allowFilterExpressions)  throws IllegalStateException {
        setAttribute("allowFilterExpressions", allowFilterExpressions, false);
    }

    /**
     * For use with {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor}:true, allows simple
     * search expressions to be entered into filter fields, as though {@link
     * com.smartgwt.client.widgets.form.DynamicForm#getAllowExpressions allowExpressions} were true. <P> Can also be enabled or
     * disabled on a field-by-field basis via {@link com.smartgwt.client.widgets.grid.ListGridField#getFilterEditorProperties
     * filterEditorProperties}.
     *
     * @return Boolean
     */
    public Boolean getAllowFilterExpressions()  {
        return getAttributeAsBoolean("allowFilterExpressions");
    }
    

    /**
     * Should cells in this grid be allowed to span multiple rows? If set to <code>true</code>, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan ListGrid.getRowSpan()} method will be called for every cell when
     * rendering out the listGrid to determine how many rows the cell should span. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan ListGrid.getRowSpan()} for more details
     *
     * @param allowRowSpanning  Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAllowRowSpanning(Boolean allowRowSpanning)  throws IllegalStateException {
        setAttribute("allowRowSpanning", allowRowSpanning, false);
    }

    /**
     * Should cells in this grid be allowed to span multiple rows? If set to <code>true</code>, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan ListGrid.getRowSpan()} method will be called for every cell when
     * rendering out the listGrid to determine how many rows the cell should span. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan ListGrid.getRowSpan()} for more details
     *
     * @return Boolean
     */
    public Boolean getAllowRowSpanning()  {
        Boolean result = getAttributeAsBoolean("allowRowSpanning");
        return result == null ? false : result;
    }
    

    /**
     * Optional css style to apply to the body if {@link com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles
     * alternateRecordStyles} is true for this grid. If unset {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyStyleName
     * bodyStyleName} will be used to style the body regardless of the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles alternateRecordStyles} setting.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Update the {@link com.smartgwt.client.widgets.grid.ListGrid#getAlternateBodyStyleName alternateBodyStyleName} for this listGrid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param alternateBodyStyleName new body style name when showing alternateRecordStyles See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is null
     */
    public void setAlternateBodyStyleName(String alternateBodyStyleName) {
        setAttribute("alternateBodyStyleName", alternateBodyStyleName, true);
    }

    /**
     * Optional css style to apply to the body if {@link com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles
     * alternateRecordStyles} is true for this grid. If unset {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyStyleName
     * bodyStyleName} will be used to style the body regardless of the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles alternateRecordStyles} setting.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     */
    public String getAlternateBodyStyleName()  {
        return getAttributeAsString("alternateBodyStyleName");
    }
    

    /**
     * The number of consecutive columns to draw in the same style before alternating, when {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles alternateColumnStyles} is true.
     *
     * @param alternateFieldFrequency  Default value is 1
     */
    public void setAlternateFieldFrequency(int alternateFieldFrequency) {
        setAttribute("alternateFieldFrequency", alternateFieldFrequency, true);
    }

    /**
     * The number of consecutive columns to draw in the same style before alternating, when {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateColumnStyles alternateColumnStyles} is true.
     *
     * @return int
     */
    public int getAlternateFieldFrequency()  {
        return getAttributeAsInt("alternateFieldFrequency");
    }
    

    /**
     * Whether alternating columns should be drawn in alternating styles, in order to create a  vertical "ledger" effect for
     * easier reading.  If enabled, the cell style for alternate  columns will have "Dark" appended to it.
     *
     * @param alternateFieldStyles  Default value is false
     */
    public void setAlternateFieldStyles(boolean alternateFieldStyles) {
        setAttribute("alternateFieldStyles", alternateFieldStyles, true);
    }

    /**
     * Whether alternating columns should be drawn in alternating styles, in order to create a  vertical "ledger" effect for
     * easier reading.  If enabled, the cell style for alternate  columns will have "Dark" appended to it.
     *
     * @return boolean
     */
    public boolean getAlternateFieldStyles()  {
        Boolean result = getAttributeAsBoolean("alternateFieldStyles");
        return result == null ? false : result;
    }
    

    /**
     * The number of consecutive rows to draw in the same style before alternating, when {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles alternateRowStyles} is true.
     *
     * @param alternateRecordFrequency  Default value is 1
     */
    public void setAlternateRecordFrequency(int alternateRecordFrequency) {
        setAttribute("alternateRecordFrequency", alternateRecordFrequency, true);
    }

    /**
     * The number of consecutive rows to draw in the same style before alternating, when {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getAlternateRowStyles alternateRowStyles} is true.
     *
     * @return int
     */
    public int getAlternateRecordFrequency()  {
        return getAttributeAsInt("alternateRecordFrequency");
    }
    

    /**
     * Whether alternating rows should be drawn in alternating styles, in order to create a "ledger" effect for easier reading.
     *  If enabled, the cell style for alternate rows will have "Dark" appended to it.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles alternateRecordStyles}
     *
     * @param alternateRecordStyles New value for <code>this.alternateRecordStyles</code>. Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_lf_grid_cells" target="examples">Grid cells Example</a>
     */
    public void setAlternateRecordStyles(Boolean alternateRecordStyles) {
        setAttribute("alternateRecordStyles", alternateRecordStyles, true);
    }

    /**
     * Whether alternating rows should be drawn in alternating styles, in order to create a "ledger" effect for easier reading.
     *  If enabled, the cell style for alternate rows will have "Dark" appended to it.
     *
     * @return Boolean
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_lf_grid_cells" target="examples">Grid cells Example</a>
     */
    public Boolean getAlternateRecordStyles()  {
        Boolean result = getAttributeAsBoolean("alternateRecordStyles");
        return result == null ? false : result;
    }
    

    /**
     * When this attribute is set, editors will be rendered into every row of the grid rather than showing up in a single
     * record at a time. This attribute is only valid when {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell
     * editByCell} is false
     *
     * @param alwaysShowEditors  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setAlwaysShowEditors(Boolean alwaysShowEditors)  throws IllegalStateException {
        setAttribute("alwaysShowEditors", alwaysShowEditors, false);
    }

    /**
     * When this attribute is set, editors will be rendered into every row of the grid rather than showing up in a single
     * record at a time. This attribute is only valid when {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell
     * editByCell} is false
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getAlwaysShowEditors()  {
        return getAttributeAsBoolean("alwaysShowEditors");
    }
    

    /**
     * When animating folder opening / closing, this property can be set to apply an animated acceleration effect. This allows
     * the animation speed to be "weighted", for example expanding or collapsing at a faster rate toward the beginning of the
     * animation than at the end. <P> For a ListGrid, this property applies when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is enabled.
     *
     * @param animateFolderEffect  Default value is null
     */
    public void setAnimateFolderEffect(AnimationAcceleration animateFolderEffect) {
        setAttribute("animateFolderEffect", animateFolderEffect == null ? null : animateFolderEffect.getValue(), true);
    }

    /**
     * When animating folder opening / closing, this property can be set to apply an animated acceleration effect. This allows
     * the animation speed to be "weighted", for example expanding or collapsing at a faster rate toward the beginning of the
     * animation than at the end. <P> For a ListGrid, this property applies when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is enabled.
     *
     * @return AnimationAcceleration
     */
    public AnimationAcceleration getAnimateFolderEffect()  {
        return EnumUtil.getEnum(AnimationAcceleration.values(), getAttribute("animateFolderEffect"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateFolders animateFolders} is true for this grid, this number
     * can be set to designate the maximum number of rows to animate at a time when opening / closing a folder. <P> For a
     * ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is
     * enabled.
     *
     * @param animateFolderMaxRows  Default value is null
     * @see com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderMaxRows
     */
    public void setAnimateFolderMaxRows(Integer animateFolderMaxRows) {
        setAttribute("animateFolderMaxRows", animateFolderMaxRows, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateFolders animateFolders} is true for this grid, this number
     * can be set to designate the maximum number of rows to animate at a time when opening / closing a folder. <P> For a
     * ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is
     * enabled.
     *
     * @return Integer
     * @see com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderMaxRows
     */
    public Integer getAnimateFolderMaxRows()  {
        return getAttributeAsInt("animateFolderMaxRows");
    }
    

    /**
     * If true, when folders are opened / closed children will be animated into view. <P> For a ListGrid, this property applies
     * when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is enabled.
     *
     * @param animateFolders  Default value is true
     */
    public void setAnimateFolders(Boolean animateFolders) {
        setAttribute("animateFolders", animateFolders, true);
    }

    /**
     * If true, when folders are opened / closed children will be animated into view. <P> For a ListGrid, this property applies
     * when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is enabled.
     *
     * @return Boolean
     */
    public Boolean getAnimateFolders()  {
        Boolean result = getAttributeAsBoolean("animateFolders");
        return result == null ? true : result;
    }
    

    /**
     * When animating folder opening / closing, this property designates the speed of the animation in pixels shown (or hidden)
     * per second. Takes precedence over the {@link com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderTime
     * animateFolderTime} property, which allows the developer to specify a duration for the animation rather than a speed. <P>
     * For a ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is
     * enabled.
     *
     * @param animateFolderSpeed  Default value is 3000
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateFolderTime
     */
    public void setAnimateFolderSpeed(int animateFolderSpeed) {
        setAttribute("animateFolderSpeed", animateFolderSpeed, true);
    }

    /**
     * When animating folder opening / closing, this property designates the speed of the animation in pixels shown (or hidden)
     * per second. Takes precedence over the {@link com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderTime
     * animateFolderTime} property, which allows the developer to specify a duration for the animation rather than a speed. <P>
     * For a ListGrid, this property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is
     * enabled.
     *
     * @return int
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateFolderTime
     */
    public int getAnimateFolderSpeed()  {
        return getAttributeAsInt("animateFolderSpeed");
    }
    

    /**
     * When animating folder opening / closing, if {@link com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderSpeed
     * animateFolderSpeed} is not set, this property designates the duration of the animation in ms. <P> For a ListGrid, this
     * property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is enabled.
     *
     * @param animateFolderTime  Default value is 100
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateFolderSpeed
     */
    public void setAnimateFolderTime(int animateFolderTime) {
        setAttribute("animateFolderTime", animateFolderTime, true);
    }

    /**
     * When animating folder opening / closing, if {@link com.smartgwt.client.widgets.tree.TreeGrid#getAnimateFolderSpeed
     * animateFolderSpeed} is not set, this property designates the duration of the animation in ms. <P> For a ListGrid, this
     * property applies when {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping} is enabled.
     *
     * @return int
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateFolderSpeed
     */
    public int getAnimateFolderTime()  {
        return getAttributeAsInt("animateFolderTime");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, should records
     * be animated out of view when they are removed by the user?
     *
     * @param animateRemoveRecord  Default value is true
     */
    public void setAnimateRemoveRecord(Boolean animateRemoveRecord) {
        setAttribute("animateRemoveRecord", animateRemoveRecord, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, should records
     * be animated out of view when they are removed by the user?
     *
     * @return Boolean
     */
    public Boolean getAnimateRemoveRecord()  {
        Boolean result = getAttributeAsBoolean("animateRemoveRecord");
        return result == null ? true : result;
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord animating record removal}, this property
     * designates the speed of the animation in pixels per second. Takes precedence over the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveTime animateRemoveTime} property, which allows the developer
     * to specify a duration for the animation rather than a speed.
     *
     * @param animateRemoveSpeed  Default value is 200
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateRemoveRecord
     */
    public void setAnimateRemoveSpeed(int animateRemoveSpeed) {
        setAttribute("animateRemoveSpeed", animateRemoveSpeed, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord animating record removal}, this property
     * designates the speed of the animation in pixels per second. Takes precedence over the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveTime animateRemoveTime} property, which allows the developer
     * to specify a duration for the animation rather than a speed.
     *
     * @return int
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord
     */
    public int getAnimateRemoveSpeed()  {
        return getAttributeAsInt("animateRemoveSpeed");
    }
    

    /**
     * When animating record removal {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord (see
     * animateRemoveRecord)}, if {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveSpeed animateRemoveSpeed} is
     * not set, this property designates the duration of the animation in ms.
     *
     * @param animateRemoveTime  Default value is 100
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateRemoveRecord
     */
    public void setAnimateRemoveTime(int animateRemoveTime) {
        setAttribute("animateRemoveTime", animateRemoveTime, true);
    }

    /**
     * When animating record removal {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord (see
     * animateRemoveRecord)}, if {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveSpeed animateRemoveSpeed} is
     * not set, this property designates the duration of the animation in ms.
     *
     * @return int
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord
     */
    public int getAnimateRemoveTime()  {
        return getAttributeAsInt("animateRemoveTime");
    }
    

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas rollOverCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>rollOverCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration animateShowAcceleration} set in
     * <code>rollOverCanvasProperties</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param animateRollOver  Default value is false
     */
    public void setAnimateRollOver(Boolean animateRollOver) {
        setAttribute("animateRollOver", animateRollOver, true);
    }

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas rollOverCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>rollOverCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration animateShowAcceleration} set in
     * <code>rollOverCanvasProperties</code>.
     *
     * @return Boolean
     */
    public Boolean getAnimateRollOver()  {
        Boolean result = getAttributeAsBoolean("animateRollOver");
        return result == null ? false : result;
    }
    

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas rollUnderCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>rollUnderCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration animateShowAcceleration} set in
     * <code>rollUnderCanvasProperties</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param animateRollUnder  Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public void setAnimateRollUnder(Boolean animateRollUnder) {
        setAttribute("animateRollUnder", animateRollUnder, true);
    }

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas rollUnderCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>rollUnderCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration animateShowAcceleration} set in
     * <code>rollUnderCanvasProperties</code>.
     *
     * @return Boolean
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public Boolean getAnimateRollUnder()  {
        Boolean result = getAttributeAsBoolean("animateRollUnder");
        return result == null ? false : result;
    }
    

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionCanvas selectionCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>selectionCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration animateShowAcceleration} set in
     * <code>selectionCanvasProperties</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param animateSelection  Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateSelectionUnder
     */
    public void setAnimateSelection(Boolean animateSelection) {
        setAttribute("animateSelection", animateSelection, true);
    }

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionCanvas selectionCanvas} is enabled, setting this
     * property to <code>true</code> ensures that when the <code>selectionCanvas</code> is displayed it is animated into view
     * via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the animation effect may be
     * customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect animateShowEffect}, {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowTime animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration animateShowAcceleration} set in
     * <code>selectionCanvasProperties</code>.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateSelectionUnder
     */
    public Boolean getAnimateSelection()  {
        Boolean result = getAttributeAsBoolean("animateSelection");
        return result == null ? false : result;
    }
    

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionUnderCanvas selectionUnderCanvas} is enabled,
     * setting this property to <code>true</code> ensures that when the <code>selectionUnderCanvas</code> is displayed it is
     * animated into view via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the
     * animation effect may be customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect
     * animateShowEffect}, {@link com.smartgwt.client.widgets.Canvas#getAnimateShowTime animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration animateShowAcceleration} set in
     * <code>selectionUnderCanvasProperties</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param animateSelectionUnder  Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAnimateSelection
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public void setAnimateSelectionUnder(Boolean animateSelectionUnder) {
        setAttribute("animateSelectionUnder", animateSelectionUnder, true);
    }

    /**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionUnderCanvas selectionUnderCanvas} is enabled,
     * setting this property to <code>true</code> ensures that when the <code>selectionUnderCanvas</code> is displayed it is
     * animated into view via {@link com.smartgwt.client.widgets.Canvas#animateShow Canvas.animateShow()}. Note that the
     * animation effect may be customized via {@link com.smartgwt.client.widgets.Canvas#getAnimateShowEffect
     * animateShowEffect}, {@link com.smartgwt.client.widgets.Canvas#getAnimateShowTime animateShowTime} and {@link
     * com.smartgwt.client.widgets.Canvas#getAnimateShowAcceleration animateShowAcceleration} set in
     * <code>selectionUnderCanvasProperties</code>.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAnimateSelection
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public Boolean getAnimateSelectionUnder()  {
        Boolean result = getAttributeAsBoolean("animateSelectionUnder");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGridField#getUserFormula userFormula} is set for some field, and this
     * grid is showing {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summaries} or a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary}, this property determines what field value
     * should be present in those summary rows. Should the field apply the user-formula to the calculated summary row, or
     * should it apply a standard grid or group summary to the user-formula values displayed in the grid? <P> May be overridden
     * at the field level via {@link com.smartgwt.client.widgets.grid.ListGridField#getApplyAfterSummary applyAfterSummary}
     *
     * @param applyFormulaAfterSummary  Default value is false
     */
    public void setApplyFormulaAfterSummary(Boolean applyFormulaAfterSummary) {
        setAttribute("applyFormulaAfterSummary", applyFormulaAfterSummary, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGridField#getUserFormula userFormula} is set for some field, and this
     * grid is showing {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summaries} or a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary}, this property determines what field value
     * should be present in those summary rows. Should the field apply the user-formula to the calculated summary row, or
     * should it apply a standard grid or group summary to the user-formula values displayed in the grid? <P> May be overridden
     * at the field level via {@link com.smartgwt.client.widgets.grid.ListGridField#getApplyAfterSummary applyAfterSummary}
     *
     * @return Boolean
     */
    public Boolean getApplyFormulaAfterSummary()  {
        Boolean result = getAttributeAsBoolean("applyFormulaAfterSummary");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true, should we apply the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRowNumberStyle rowNumberStyle} to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowNumberField rowNumberField}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param applyRowNumberStyle  Default value is true
     */
    public void setApplyRowNumberStyle(boolean applyRowNumberStyle) {
        setAttribute("applyRowNumberStyle", applyRowNumberStyle, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true, should we apply the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRowNumberStyle rowNumberStyle} to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowNumberField rowNumberField}
     *
     * @return boolean
     */
    public boolean getApplyRowNumberStyle()  {
        Boolean result = getAttributeAsBoolean("applyRowNumberStyle");
        return result == null ? true : result;
    }
    

    /**
     * Action to perform when the listGrid has keyboard focus (but not editing focus) and a user presses the up or down arrow
     * key. Possible values are: <ul> <li><code>"select"</code> : select the next row in the list (calls
     * <code>recordClick</code> handler)</li> <li><code>"focus"</code> : move focus to the next row in the list without
     * changing the selection</li> <li><code>"activate"</code> : select and activate the next row in the list (calls 
     * <code>recordDoubleClick</code> handler)</li> <li><code>"none"</code> : no action</li> <li> <code>null</code> : if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is "checkbox", behaves as if set 
     * to "focus"; otherwise, behaves as if set to "select"</li> </ul>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param arrowKeyAction  Default value is null
     */
    public void setArrowKeyAction(String arrowKeyAction) {
        setAttribute("arrowKeyAction", arrowKeyAction, true);
    }

    /**
     * Action to perform when the listGrid has keyboard focus (but not editing focus) and a user presses the up or down arrow
     * key. Possible values are: <ul> <li><code>"select"</code> : select the next row in the list (calls
     * <code>recordClick</code> handler)</li> <li><code>"focus"</code> : move focus to the next row in the list without
     * changing the selection</li> <li><code>"activate"</code> : select and activate the next row in the list (calls 
     * <code>recordDoubleClick</code> handler)</li> <li><code>"none"</code> : no action</li> <li> <code>null</code> : if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is "checkbox", behaves as if set 
     * to "focus"; otherwise, behaves as if set to "select"</li> </ul>
     *
     * @return String
     */
    public String getArrowKeyAction()  {
        return getAttributeAsString("arrowKeyAction");
    }
    

    /**
     * The prompt to display while interactivity is blocked during {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold asynchronous grouping}.
     *
     * @param asynchGroupingPrompt  See {@link com.smartgwt.client.docs.HTMLString HTMLString} . Default value is "${loadingImage}&amp;nbsp;Grouping data..."
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAsynchGroupingPrompt(String asynchGroupingPrompt)  throws IllegalStateException {
        setAttribute("asynchGroupingPrompt", asynchGroupingPrompt, false);
    }

    /**
     * The prompt to display while interactivity is blocked during {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold asynchronous grouping}.
     *
     * @return  See {@link com.smartgwt.client.docs.HTMLString HTMLString} 
     */
    public String getAsynchGroupingPrompt()  {
        return getAttributeAsString("asynchGroupingPrompt");
    }
    

    /**
     * Whether to do inline autoComplete in text fields during inline editing<br> Overridden by {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoComplete autoComplete} if specified. If unset picks up the default
     * from the appropriate editor class (subclass of FormItem).
     *
     * @param autoComplete  Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField#setAutoComplete
     */
    public void setAutoComplete(AutoComplete autoComplete) {
        setAttribute("autoComplete", autoComplete == null ? null : autoComplete.getValue(), true);
    }

    /**
     * Whether to do inline autoComplete in text fields during inline editing<br> Overridden by {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoComplete autoComplete} if specified. If unset picks up the default
     * from the appropriate editor class (subclass of FormItem).
     *
     * @return AutoComplete
     * @see com.smartgwt.client.widgets.grid.ListGridField#getAutoComplete
     */
    public AutoComplete getAutoComplete()  {
        return EnumUtil.getEnum(AutoComplete.values(), getAttribute("autoComplete"));
    }
    
    

    /**
     * If true, for fields where {@link com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource optionDataSource} is
     * specified, a valueMap will be automatically created by making a {@link com.smartgwt.client.data.DataSource#fetchData
     * DataSource.fetchData()} call against the specified dataSource and extracting a valueMap from the returned records based
     * on the displayField and valueField. <P> If set to false, valueMaps will not be automatically fetched.  In this case,
     * setting field.optionDataSource is effectively a shortcut for setting optionDataSource on the editor via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getEditorProperties editorProperties}. <P> Can also be disabled on a
     * per-field basis with {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFetchDisplayMap autoFetchDisplayMap}.
     *
     * @param autoFetchDisplayMap  Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGridField#setAutoFetchDisplayMap
     * @see com.smartgwt.client.widgets.grid.ListGridField#setOptionDataSource
     */
    public void setAutoFetchDisplayMap(Boolean autoFetchDisplayMap) {
        setAttribute("autoFetchDisplayMap", autoFetchDisplayMap, true);
    }

    /**
     * If true, for fields where {@link com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource optionDataSource} is
     * specified, a valueMap will be automatically created by making a {@link com.smartgwt.client.data.DataSource#fetchData
     * DataSource.fetchData()} call against the specified dataSource and extracting a valueMap from the returned records based
     * on the displayField and valueField. <P> If set to false, valueMaps will not be automatically fetched.  In this case,
     * setting field.optionDataSource is effectively a shortcut for setting optionDataSource on the editor via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getEditorProperties editorProperties}. <P> Can also be disabled on a
     * per-field basis with {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFetchDisplayMap autoFetchDisplayMap}.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGridField#getAutoFetchDisplayMap
     * @see com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource
     */
    public Boolean getAutoFetchDisplayMap()  {
        Boolean result = getAttributeAsBoolean("autoFetchDisplayMap");
        return result == null ? true : result;
    }
    
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} is true, this attribute
     * will be shown as the menu item title for an item to perform a one-time autoFit of all visible fields via the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#autoFitField ListGrid.autoFitField()} method.
     *
     * @param autoFitAllText  Default value is "Auto Fit All Columns"
     */
    public void setAutoFitAllText(String autoFitAllText) {
        setAttribute("autoFitAllText", autoFitAllText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} is true, this attribute
     * will be shown as the menu item title for an item to perform a one-time autoFit of all visible fields via the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#autoFitField ListGrid.autoFitField()} method.
     *
     * @return String
     */
    public String getAutoFitAllText()  {
        return getAttributeAsString("autoFitAllText");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} is enabled and the
     * calculated field sizes are wide enough that horizontal scrolling would be introduced, this attribute may be set to an
     * array of fieldNames, causing those fields to be clipped rather than forcing horizontal scrollbars to appear. <P> Note:
     * If any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen columns} are included in this list they
     * will not be clipped.
     *
     * @param autoFitClipFields  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAutoFitClipFields(String... autoFitClipFields)  throws IllegalStateException {
        setAttribute("autoFitClipFields", autoFitClipFields, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} is enabled and the
     * calculated field sizes are wide enough that horizontal scrolling would be introduced, this attribute may be set to an
     * array of fieldNames, causing those fields to be clipped rather than forcing horizontal scrollbars to appear. <P> Note:
     * If any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen columns} are included in this list they
     * will not be clipped.
     *
     * @return String...
     */
    public String[] getAutoFitClipFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("autoFitClipFields"));
    }
    

    /**
     * Should this ListGrid automatically expand to accommodate the size of records and fields? <P> Valid settings are
     * <ul><li><code>"vertical"</code>: expand vertically to accommodate records.</li>     <li><code>"horizontal"</code>:
     * expand horizontally to accommodate fields.</li>     <li><code>"both"</code>: expand horizontally and vertically to
     * accommodate content.</li> </ul> How far the ListGrid will expand may be limited via the following properties: {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxHeight autoFitMaxHeight}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxWidth autoFitMaxWidth}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns}. <P> Note that this property causes
     * the grid as a whole to expand to fit records or fields. To have the fields or records themselves expand to fit cell
     * contents, see {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData}.
     *
     * @param autoFitData One of <code>"vertical"</code>, <code>"horizontal"</code>  or <code>"both"</code>. To disable auto fit behavior, pass in
     * <code>null</code>.. Default value is null
     */
    public void setAutoFitData(Autofit autoFitData) {
        setAttribute("autoFitData", autoFitData == null ? null : autoFitData.getValue(), true);
    }

    /**
     * Should this ListGrid automatically expand to accommodate the size of records and fields? <P> Valid settings are
     * <ul><li><code>"vertical"</code>: expand vertically to accommodate records.</li>     <li><code>"horizontal"</code>:
     * expand horizontally to accommodate fields.</li>     <li><code>"both"</code>: expand horizontally and vertically to
     * accommodate content.</li> </ul> How far the ListGrid will expand may be limited via the following properties: {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxHeight autoFitMaxHeight}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxWidth autoFitMaxWidth}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns}. <P> Note that this property causes
     * the grid as a whole to expand to fit records or fields. To have the fields or records themselves expand to fit cell
     * contents, see {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights}.
     *
     * @return Autofit
     */
    public Autofit getAutoFitData()  {
        return EnumUtil.getEnum(Autofit.values(), getAttribute("autoFitData"));
    }
    

    /**
     * The field to expand if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldsFillViewport autoFitFieldsFillViewport} are enabled and
     * auto-fitting will not fill all available horizontal space. <P> If unset, will default to the text field with the longest
     * {@link com.smartgwt.client.data.DataSourceField#getLength length} if length is set, otherwise, the first text field with
     * no width specified. <P> Note that expanding {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen
     * columns} is not supported.
     *
     * @param autoFitExpandField  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAutoFitExpandField(String autoFitExpandField)  throws IllegalStateException {
        setAttribute("autoFitExpandField", autoFitExpandField, false);
    }

    /**
     * The field to expand if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldsFillViewport autoFitFieldsFillViewport} are enabled and
     * auto-fitting will not fill all available horizontal space. <P> If unset, will default to the text field with the longest
     * {@link com.smartgwt.client.data.DataSourceField#getLength length} if length is set, otherwise, the first text field with
     * no width specified. <P> Note that expanding {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen
     * columns} is not supported.
     *
     * @return String
     */
    public String getAutoFitExpandField()  {
        return getAttributeAsString("autoFitExpandField");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code> this property specifies the number of additional records for which the grid will expand. If more
     * records are present, scrolling will be introduced to reach them as normal.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitExtraRecords autoFitExtraRecords}.
     *
     * @param autoFitExtraRecords Number of extra rows beyond the data-size we'll expand to accommodate if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData auto fit} is enabled vertically.. Default value is null
     */
    public void setAutoFitExtraRecords(Integer autoFitExtraRecords) {
        setAttribute("autoFitExtraRecords", autoFitExtraRecords, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code> this property specifies the number of additional records for which the grid will expand. If more
     * records are present, scrolling will be introduced to reach them as normal.
     *
     * @return Integer
     */
    public Integer getAutoFitExtraRecords()  {
        return getAttributeAsInt("autoFitExtraRecords");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} is enabled, and extra
     * space is available after autofitting all fields, should the grid automatically expand one field to fill the extra space.
     * <P> When enabled, the field to expand may be specified via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitExpandField autoFitExpandField}. <P> Note this logic will not expand
     * a {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen column}.
     *
     * @param autoFitFieldsFillViewport  Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAutoFitFieldsFillViewport(Boolean autoFitFieldsFillViewport)  throws IllegalStateException {
        setAttribute("autoFitFieldsFillViewport", autoFitFieldsFillViewport, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} is enabled, and extra
     * space is available after autofitting all fields, should the grid automatically expand one field to fill the extra space.
     * <P> When enabled, the field to expand may be specified via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitExpandField autoFitExpandField}. <P> Note this logic will not expand
     * a {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen column}.
     *
     * @return Boolean
     */
    public Boolean getAutoFitFieldsFillViewport()  {
        Boolean result = getAttributeAsBoolean("autoFitFieldsFillViewport");
        return result == null ? true : result;
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} is true, this attribute
     * will be shown as the menu item title for an item to perform a one-time autoFit of the field to its title or content via
     * a call to {@link com.smartgwt.client.widgets.grid.ListGrid#autoFitField ListGrid.autoFitField()}.
     *
     * @param autoFitFieldText  Default value is "Auto Fit"
     */
    public void setAutoFitFieldText(String autoFitFieldText) {
        setAttribute("autoFitFieldText", autoFitFieldText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} is true, this attribute
     * will be shown as the menu item title for an item to perform a one-time autoFit of the field to its title or content via
     * a call to {@link com.smartgwt.client.widgets.grid.ListGrid#autoFitField ListGrid.autoFitField()}.
     *
     * @return String
     */
    public String getAutoFitFieldText()  {
        return getAttributeAsString("autoFitFieldText");
    }
    

    /**
     * Enables autofitting of fields to values or titles. This property may be overridden on a per-field basis via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autoFitWidth}. <P> The {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach autoFitWidthApproach} controls whether fitting is to
     * values, titles or both. This property may also be overridden on a per field basis. <P> If {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getWidth field.width} is also set on the field, it will be taken as a
     * minimum width. {@link com.smartgwt.client.widgets.grid.ListGrid#getMinFieldWidth minFieldWidth} will also be respected.
     * <P> By default, the entire available width of the grid will still be used, by allocating any "extra" space to specific
     * columns - see {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldsFillViewport autoFitFieldsFillViewport}
     * for details on controlling this behavior. <P> Autofitting will be performed: <ul>  <li> whenever the dataset is
     * completely changed or rows are added or removed  <li> whenever a field which is autofitting is changed  <li> on a manual
     * call to {@link com.smartgwt.client.widgets.grid.ListGrid#autoFitField ListGrid.autoFitField()} or       {@link
     * com.smartgwt.client.widgets.grid.ListGrid#autoFitFields ListGrid.autoFitFields()} </ul> Auto-fitting behavior continues
     * until the user resizes the field manually, at which point it stops. The user can also perform a one-time auto-fit of
     * fields via the header context menu if {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields
     * canAutoFitFields} is enabled. <P> When autofitting to column values, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth ListGrid.getDefaultFieldWidth()} will be called to
     * determine the space required for a field's values. This method uses values from the rendered set of rows to calculate
     * the required column width, which means the field width may still be smaller than values from non-rendered rows.  See
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllRecords showAllRecords} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio}) to control incremental rendering of rows.
     * <P> Note that for <code>icon</code> type fields, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitIconFields autoFitIconFields} property setting may turn on
     * auto-fit-width behavior for specific fields by default, even if <code>autoFitFieldWidths</code> is false for the grid as
     * a whole. <P> Using this feature has a performance penalty roughly comparable to always rendering one additional field
     * per field where autofitting is enabled.  Specifically, enabling it for all fields would be comparable to <i>both</i>
     * doubling the number of fields <i>and</i> disabling {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllColumns
     * horizontal incremental rendering}. In a grid where only half the fields are normally visible and hence only half are
     * normally rendered, this would be roughly 4 times slower overall. <P> This performance penalty is a result of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth ListGrid.getDefaultFieldWidth()} having to render out the
     * data set offscreen and measure the rendered content - it does not apply for cases where this method can return a simple
     * fixed values (as with icon fields). <P> Which fields are currently autofitting is saved as part of the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getViewState view state} of the ListGrid.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths}. Modifies the default auto-fit-width behavior for fields in this grid. Note that this may be overridden at the field level via {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autoFitWidth}.
     *
     * @param autoFitFieldWidths New value for autoFitFieldWidths. Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAutoFitFieldWidths(Boolean autoFitFieldWidths)  throws IllegalStateException {
        setAttribute("autoFitFieldWidths", autoFitFieldWidths, false);
    }

    /**
     * Enables autofitting of fields to values or titles. This property may be overridden on a per-field basis via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autoFitWidth}. <P> The {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach autoFitWidthApproach} controls whether fitting is to
     * values, titles or both. This property may also be overridden on a per field basis. <P> If {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getWidth field.width} is also set on the field, it will be taken as a
     * minimum width. {@link com.smartgwt.client.widgets.grid.ListGrid#getMinFieldWidth minFieldWidth} will also be respected.
     * <P> By default, the entire available width of the grid will still be used, by allocating any "extra" space to specific
     * columns - see {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldsFillViewport autoFitFieldsFillViewport}
     * for details on controlling this behavior. <P> Autofitting will be performed: <ul>  <li> whenever the dataset is
     * completely changed or rows are added or removed  <li> whenever a field which is autofitting is changed  <li> on a manual
     * call to {@link com.smartgwt.client.widgets.grid.ListGrid#autoFitField ListGrid.autoFitField()} or       {@link
     * com.smartgwt.client.widgets.grid.ListGrid#autoFitFields ListGrid.autoFitFields()} </ul> Auto-fitting behavior continues
     * until the user resizes the field manually, at which point it stops. The user can also perform a one-time auto-fit of
     * fields via the header context menu if {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields
     * canAutoFitFields} is enabled. <P> When autofitting to column values, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth ListGrid.getDefaultFieldWidth()} will be called to
     * determine the space required for a field's values. This method uses values from the rendered set of rows to calculate
     * the required column width, which means the field width may still be smaller than values from non-rendered rows.  See
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllRecords showAllRecords} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio}) to control incremental rendering of rows.
     * <P> Note that for <code>icon</code> type fields, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitIconFields autoFitIconFields} property setting may turn on
     * auto-fit-width behavior for specific fields by default, even if <code>autoFitFieldWidths</code> is false for the grid as
     * a whole. <P> Using this feature has a performance penalty roughly comparable to always rendering one additional field
     * per field where autofitting is enabled.  Specifically, enabling it for all fields would be comparable to <i>both</i>
     * doubling the number of fields <i>and</i> disabling {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllColumns
     * horizontal incremental rendering}. In a grid where only half the fields are normally visible and hence only half are
     * normally rendered, this would be roughly 4 times slower overall. <P> This performance penalty is a result of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth ListGrid.getDefaultFieldWidth()} having to render out the
     * data set offscreen and measure the rendered content - it does not apply for cases where this method can return a simple
     * fixed values (as with icon fields). <P> Which fields are currently autofitting is saved as part of the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getViewState view state} of the ListGrid.
     *
     * @return Boolean
     */
    public Boolean getAutoFitFieldWidths()  {
        return getAttributeAsBoolean("autoFitFieldWidths");
    }
    

    /**
     * If this property is set to true, header buttons for either {@link com.smartgwt.client.widgets.grid.ListGrid#getFields
     * fields} or {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans header spans} will automatically expand to
     * accommodate their titles vertically. This means if you have a "tall" title - typically a long string where {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getWrap wrap} is set to true such that you end up with several lines of
     * text - the button will render large enough to accommodate it. If necessary this will cause the header for the grid as a
     * whole to expand beyond the specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight}.
     *
     * @param autoFitHeaderHeights  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAutoFitHeaderHeights(Boolean autoFitHeaderHeights)  throws IllegalStateException {
        setAttribute("autoFitHeaderHeights", autoFitHeaderHeights, false);
    }

    /**
     * If this property is set to true, header buttons for either {@link com.smartgwt.client.widgets.grid.ListGrid#getFields
     * fields} or {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans header spans} will automatically expand to
     * accommodate their titles vertically. This means if you have a "tall" title - typically a long string where {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getWrap wrap} is set to true such that you end up with several lines of
     * text - the button will render large enough to accommodate it. If necessary this will cause the header for the grid as a
     * whole to expand beyond the specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight}.
     *
     * @return Boolean
     */
    public Boolean getAutoFitHeaderHeights()  {
        return getAttributeAsBoolean("autoFitHeaderHeights");
    }
    

    /**
     * Smart GWT listGrids have special logic to automatically size fields that are displayed as an icon - that is fields with
     * {@link com.smartgwt.client.types.ListGridFieldType type:"icon"}, fields displaying only {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowValueIconOnly value icons}, and boolean fields (which are rendered
     * as a checkmark type icon by default. <P> This attribute controls this behavior - governing whether icon fields should be
     * sized to fit their content (icon), title, or whether to disable this behavior. Setting this value to
     * <code>"title"</code> or <code>"iconWidth"</code> will cause {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autoFitWidth} to be enabled by default for all icon
     * fields with the {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach autoFitWidthApproach} set
     * to <code>"value"</code> or <code>"both"</code> as appropriate. Note that the width required for the icons is calculated
     * by {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth ListGrid.getDefaultFieldWidth()} which performs
     * a simple calculation based on the specified icon width for these types of fields. <P> This setting governs default
     * behavior for icon fields - for specific fields within a grid, this default behavior can be overridden by setting an
     * explicit {@link com.smartgwt.client.widgets.grid.ListGridField#getWidth width} or explicitly enabling {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autoFitWidth} and setting {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach autoFitWidthApproach} on the field in question.
     *
     * @param autoFitIconFields  Default value is "title"
     * @see com.smartgwt.client.widgets.grid.ListGrid#setAutoFitFieldWidths
     */
    public void setAutoFitIconFields(AutoFitIconFieldType autoFitIconFields) {
        setAttribute("autoFitIconFields", autoFitIconFields == null ? null : autoFitIconFields.getValue(), true);
    }

    /**
     * Smart GWT listGrids have special logic to automatically size fields that are displayed as an icon - that is fields with
     * {@link com.smartgwt.client.types.ListGridFieldType type:"icon"}, fields displaying only {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowValueIconOnly value icons}, and boolean fields (which are rendered
     * as a checkmark type icon by default. <P> This attribute controls this behavior - governing whether icon fields should be
     * sized to fit their content (icon), title, or whether to disable this behavior. Setting this value to
     * <code>"title"</code> or <code>"iconWidth"</code> will cause {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autoFitWidth} to be enabled by default for all icon
     * fields with the {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach autoFitWidthApproach} set
     * to <code>"value"</code> or <code>"both"</code> as appropriate. Note that the width required for the icons is calculated
     * by {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFieldWidth ListGrid.getDefaultFieldWidth()} which performs
     * a simple calculation based on the specified icon width for these types of fields. <P> This setting governs default
     * behavior for icon fields - for specific fields within a grid, this default behavior can be overridden by setting an
     * explicit {@link com.smartgwt.client.widgets.grid.ListGridField#getWidth width} or explicitly enabling {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autoFitWidth} and setting {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach autoFitWidthApproach} on the field in question.
     *
     * @return AutoFitIconFieldType
     * @see com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths
     */
    public AutoFitIconFieldType getAutoFitIconFields()  {
        return EnumUtil.getEnum(AutoFitIconFieldType.values(), getAttribute("autoFitIconFields"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides the maximum number of columns for which the ListGrid will expand. If more
     * columns are present, scrolling will be introduced to reach them as normal. If unset the ListGrid will expand to
     * accommodate as many columns as are defined for the grid.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns}.
     *
     * @param autoFitMaxColumns Maximum number of fields we'll expand to accommodate if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData
     * auto fit} is enabled horizontally.. Default value is 50
     */
    public void setAutoFitMaxColumns(int autoFitMaxColumns) {
        setAttribute("autoFitMaxColumns", autoFitMaxColumns, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides the maximum number of columns for which the ListGrid will expand. If more
     * columns are present, scrolling will be introduced to reach them as normal. If unset the ListGrid will expand to
     * accommodate as many columns as are defined for the grid.
     *
     * @return int
     */
    public int getAutoFitMaxColumns()  {
        return getAttributeAsInt("autoFitMaxColumns");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand vertically to accommodate
     * its content. If content exceeds this height, scrollbars will be introduced as usual. In addition to this property,
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords} allows you to limit vertical
     * expansion based on the number of rows to be rendered.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxHeight autoFitMaxHeight}.
     *
     * @param autoFitMaxHeight Maximum height in px we'll expand to accommodate if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData auto
     * fit} is enabled vertically.. Default value is null
     */
    public void setAutoFitMaxHeight(Integer autoFitMaxHeight) {
        setAttribute("autoFitMaxHeight", autoFitMaxHeight, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand vertically to accommodate
     * its content. If content exceeds this height, scrollbars will be introduced as usual. In addition to this property,
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords} allows you to limit vertical
     * expansion based on the number of rows to be rendered.
     *
     * @return Integer
     */
    public Integer getAutoFitMaxHeight()  {
        return getAttributeAsInt("autoFitMaxHeight");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code> this property provides the maximum number of records for which the ListGrid will expand. If more
     * records are present, scrolling will be introduced to reach them as normal. If unset, by default the ListGrid will expand
     * to accommodate as many records as are present.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxRecords autoFitMaxRecords}.
     *
     * @param autoFitMaxRecords Maximum number of rows we'll expand to accommodate if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData
     * auto fit} is enabled vertically.. Default value is 50
     */
    public void setAutoFitMaxRecords(int autoFitMaxRecords) {
        setAttribute("autoFitMaxRecords", autoFitMaxRecords, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"vertical"</code> or
     * <code>"both"</code> this property provides the maximum number of records for which the ListGrid will expand. If more
     * records are present, scrolling will be introduced to reach them as normal. If unset, by default the ListGrid will expand
     * to accommodate as many records as are present.
     *
     * @return int
     */
    public int getAutoFitMaxRecords()  {
        return getAttributeAsInt("autoFitMaxRecords");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand horizontally to
     * accommodate its content. If content exceeds this width, scrollbars will be introduced as usual. In addition to this
     * property, {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns} allows you to limit
     * horizontal expansion based on the number of columns to be rendered.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxWidth autoFitMaxWidth}.
     *
     * @param autoFitMaxWidth Width in px we'll expand to accommodate if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData auto fit} is
     * enabled horizontally.. Default value is null
     */
    public void setAutoFitMaxWidth(Integer autoFitMaxWidth) {
        setAttribute("autoFitMaxWidth", autoFitMaxWidth, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData autoFitData} is set to <code>"horizontal"</code> or
     * <code>"both"</code> this property provides an upper limit on how far the ListGrid will expand horizontally to
     * accommodate its content. If content exceeds this width, scrollbars will be introduced as usual. In addition to this
     * property, {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitMaxColumns autoFitMaxColumns} allows you to limit
     * horizontal expansion based on the number of columns to be rendered.
     *
     * @return Integer
     */
    public Integer getAutoFitMaxWidth()  {
        return getAttributeAsInt("autoFitMaxWidth");
    }
    

    /**
     * When a user requests column autofitting via the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenuItems header context menu} or via a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderAutoFitEvent mouse gesture}, what autofit approach is used.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach autoFitWidthApproach}.
     *
     * @param autoFitWidthApproach new AutoFitWidth approach. Default value is "value"
     */
    public void setAutoFitWidthApproach(AutoFitWidthApproach autoFitWidthApproach) {
        setAttribute("autoFitWidthApproach", autoFitWidthApproach == null ? null : autoFitWidthApproach.getValue(), true);
    }

    /**
     * When a user requests column autofitting via the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenuItems header context menu} or via a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderAutoFitEvent mouse gesture}, what autofit approach is used.
     *
     * @return AutoFitWidthApproach
     */
    public AutoFitWidthApproach getAutoFitWidthApproach()  {
        return EnumUtil.getEnum(AutoFitWidthApproach.values(), getAttribute("autoFitWidthApproach"));
    }
    

    /**
     * If this ListGrid is editable, should edits be saved out when the user finishes editing a row (or a cell if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell saveByCell} is true). <P> The default of <code>true</code>
     * indicates that edits will be {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell automatically saved} as the
     * user navigates through the grid and/or ${isc.DocUtils.linkForRef('type:EnterKeyEditAction','hits \'Enter\'')} to end
     * editing.  See the {@link com.smartgwt.client.docs.Editing Grid Editing} overview for details. <P> Setting
     * <code>autoSaveEdits</code> false creates a "mass update" / "mass delete" interaction where edits will be retained for
     * all edited cells (across rows if appropriate) until {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits
     * ListGrid.saveEdits()} is called to save a particular row, or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#saveAllEdits ListGrid.saveAllEdits()} is called to save all changes in a
     * batch.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param autoSaveEdits  Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setAutoSaveEdits(Boolean autoSaveEdits) {
        setAttribute("autoSaveEdits", autoSaveEdits, true);
    }

    /**
     * If this ListGrid is editable, should edits be saved out when the user finishes editing a row (or a cell if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell saveByCell} is true). <P> The default of <code>true</code>
     * indicates that edits will be {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell automatically saved} as the
     * user navigates through the grid and/or ${isc.DocUtils.linkForRef('type:EnterKeyEditAction','hits \'Enter\'')} to end
     * editing.  See the {@link com.smartgwt.client.docs.Editing Grid Editing} overview for details. <P> Setting
     * <code>autoSaveEdits</code> false creates a "mass update" / "mass delete" interaction where edits will be retained for
     * all edited cells (across rows if appropriate) until {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits
     * ListGrid.saveEdits()} is called to save a particular row, or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#saveAllEdits ListGrid.saveAllEdits()} is called to save all changes in a
     * batch.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getAutoSaveEdits()  {
        Boolean result = getAttributeAsBoolean("autoSaveEdits");
        return result == null ? true : result;
    }
    

    /**
     * If this listGrid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, setting
     * this attribute to true will cause spans to expand to accommodate long titles if necessary.
     *
     * @param autoSizeHeaderSpans  Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setAutoSizeHeaderSpans(Boolean autoSizeHeaderSpans)  throws IllegalStateException {
        setAttribute("autoSizeHeaderSpans", autoSizeHeaderSpans, false);
    }

    /**
     * If this listGrid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, setting
     * this attribute to true will cause spans to expand to accommodate long titles if necessary.
     *
     * @return Boolean
     */
    public Boolean getAutoSizeHeaderSpans()  {
        Boolean result = getAttributeAsBoolean("autoSizeHeaderSpans");
        return result == null ? false : result;
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Has no effect unless {@link com.smartgwt.client.widgets.grid.ListGrid#getShowBackgroundComponents
     * showBackgroundComponents} is <code>true</code>. <P> Canvas created and embedded in the body behind a given record.  
     * When {@link com.smartgwt.client.widgets.grid.ListGridRecord#getBackgroundComponent backgroundComponent} is set, this
     * autoChild canvas will be constructed (if listGridRecord.backgroundComponent is not already a Canvas) and its properties
     * combined with those of listGridRecord.backgroundComponent and then displayed behind a specific record in the page's
     * z-order, meaning it will only be visible if the cell styling is transparent.
     *
     * @return null
     */
    public Canvas getBackgroundComponent()  {
        return null;
    }
    

    /**
     * If the result of a formula evaluation is invalid (specifically, if isNaN(result)==true), badFormulaResultValue is
     * displayed instead.  The default value is ".".
     *
     * @param badFormulaResultValue  Default value is "."
     * @see com.smartgwt.client.docs.FormulaFields FormulaFields overview and related methods
     */
    public void setBadFormulaResultValue(String badFormulaResultValue) {
        setAttribute("badFormulaResultValue", badFormulaResultValue, true);
    }

    /**
     * If the result of a formula evaluation is invalid (specifically, if isNaN(result)==true), badFormulaResultValue is
     * displayed instead.  The default value is ".".
     *
     * @return String
     * @see com.smartgwt.client.docs.FormulaFields FormulaFields overview and related methods
     */
    public String getBadFormulaResultValue()  {
        return getAttributeAsString("badFormulaResultValue");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.GridRenderer#getBaseStyle base cell style} for this listGrid. If this property
     * is unset, base style may be derived from {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle
     * normalBaseStyle} or {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} as described in
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle ListGrid.getBaseStyle()}. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellStyleSuffixes cellStyleSuffixes} for details on how stateful suffixes
     * are combined with the base style to generate stateful cell styles.
     *
     * @param baseStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setBaseStyle(String baseStyle)  throws IllegalStateException {
        setAttribute("baseStyle", baseStyle, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.GridRenderer#getBaseStyle base cell style} for this listGrid. If this property
     * is unset, base style may be derived from {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle
     * normalBaseStyle} or {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} as described in
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle ListGrid.getBaseStyle()}. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellStyleSuffixes cellStyleSuffixes} for details on how stateful suffixes
     * are combined with the base style to generate stateful cell styles.
     *
     * @return Return the base stylename for this cell.  Has the following implementation by default: <ul> <li>If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditFailedBaseStyle this.editFailedBaseStyle} is defined, and the     cell
     * is displaying a validation error return this value.</li> <li>If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditPendingBaseStyle this.editFailedPendingStyle} is defined, and     the
     * cell is displaying an edit value that has not yet been saved (see     {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits}) return this value.</li> <li>Otherwise return
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordBaseStyleProperty record[listGrid.recordBaseStyleProperty]},  
     * if defined, otherwise {@link com.smartgwt.client.widgets.grid.ListGridField#getBaseStyle field.baseStyle}.</li> </ul> If
     * no custom style is found for the cell as described above, the default baseStyle will be returned. If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} is specified this will be used. Otherwise for grids
     * showing fixed height rows which match {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalCellHeight
     * normalCellHeight} {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle} will be used. For
     * grids with variable, or modified cell heights, {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle
     * tallBaseStyle} will be used. <P> Note also that enabling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFastCellUpdates fastCellUpdates} will cause the <code>tallBaseStyle</code>
     * to be used rather than {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle}. <p>
     * <b>Note: This is an override point.</b> See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getBaseStyle()  {
        return getAttributeAsString("baseStyle");
    }
    
    

    /**
     * Background color applied to the ListGrid body (that is, the area of the grid where data values are rendered).<br> Note
     * that this will typically not be visible to the user unless there are few enough rows that there is visible space in the
     * body below the last row. To style data cells, override {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} instead.
     *
     * @param bodyBackgroundColor  Default value is "white"
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setBodyBackgroundColor(String bodyBackgroundColor) {
        setAttribute("bodyBackgroundColor", bodyBackgroundColor, true);
    }

    /**
     * Background color applied to the ListGrid body (that is, the area of the grid where data values are rendered).<br> Note
     * that this will typically not be visible to the user unless there are few enough rows that there is visible space in the
     * body below the last row. To style data cells, override {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} instead.
     *
     * @return String
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getBodyBackgroundColor()  {
        return getAttributeAsString("bodyBackgroundColor");
    }
    

    /**
     * Overflow setting for the "body", that is, the area of the grid where data values are rendered. <P> By setting both the
     * grid itself and the body to overflow:visible, it is possible to "auto-fit" to the rendered height or width of the rows. 
     * Note that in this case <code>grid.width</code> and <code>grid.height</code> act as minimums.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Update the {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyOverflow bodyOverflow} for this listGrid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param bodyOverflow new overflow setting for the body. Default value is Canvas.AUTO
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public void setBodyOverflow(Overflow bodyOverflow) {
        setAttribute("bodyOverflow", bodyOverflow == null ? null : bodyOverflow.getValue(), true);
    }

    /**
     * Overflow setting for the "body", that is, the area of the grid where data values are rendered. <P> By setting both the
     * grid itself and the body to overflow:visible, it is possible to "auto-fit" to the rendered height or width of the rows. 
     * Note that in this case <code>grid.width</code> and <code>grid.height</code> act as minimums.
     *
     * @return Overflow
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public Overflow getBodyOverflow()  {
        return EnumUtil.getEnum(Overflow.values(), getAttribute("bodyOverflow"));
    }
    

    /**
     * CSS style used for the body of this grid.  If applying a background-color to the body via a CSS style applied using this
     * property, be sure to set {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyBackgroundColor bodyBackgroundColor} to
     * <code>null</code>.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Update the {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyStyleName bodyStyleName} for this listGrid.
     *
     * @param bodyStyleName new body style name See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is null
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setBodyStyleName(String bodyStyleName) {
        setAttribute("bodyStyleName", bodyStyleName, true);
    }

    /**
     * CSS style used for the body of this grid.  If applying a background-color to the body via a CSS style applied using this
     * property, be sure to set {@link com.smartgwt.client.widgets.grid.ListGrid#getBodyBackgroundColor bodyBackgroundColor} to
     * <code>null</code>.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getBodyStyleName()  {
        return getAttributeAsString("bodyStyleName");
    }
    

    /**
     * An optional CSS style to apply to the checkbox image. If supplied, and the checkbox is enabled, the base style is
     * suffixed with "True", "False", or "Partial" if the checkbox is selected, unselected, or partially selected; if the
     * checkbox is disabled, the suffix is "TrueDisabled", "FalseDisabled", or "PartialDisabled". <p> <b>NOTE:</b> This
     * attribute is not supported by {@link com.smartgwt.client.widgets.tree.TreeGrid}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanBaseStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintBooleanBaseStyle
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setBooleanBaseStyle(String booleanBaseStyle)  throws IllegalStateException {
        setAttribute("booleanBaseStyle", booleanBaseStyle, false);
    }

    /**
     * An optional CSS style to apply to the checkbox image. If supplied, and the checkbox is enabled, the base style is
     * suffixed with "True", "False", or "Partial" if the checkbox is selected, unselected, or partially selected; if the
     * checkbox is disabled, the suffix is "TrueDisabled", "FalseDisabled", or "PartialDisabled". <p> <b>NOTE:</b> This
     * attribute is not supported by {@link com.smartgwt.client.widgets.tree.TreeGrid}.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanBaseStyle
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getBooleanBaseStyle()  {
        return getAttributeAsString("booleanBaseStyle");
    }
    

    /**
     * Image to display for a false value in a boolean field. Default <code>null</code> value or the special value "blank"
     * means no image will be displayed. <P> To turn this off explicitly set {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon suppressValueIcon} to true <P> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} are undefined, this will be set to
     * {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getUncheckedImage uncheckedImage}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanFalseImage  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanPartialImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintBooleanFalseImage
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setBooleanFalseImage(String booleanFalseImage) {
        setAttribute("booleanFalseImage", booleanFalseImage, true);
    }

    /**
     * Image to display for a false value in a boolean field. Default <code>null</code> value or the special value "blank"
     * means no image will be displayed. <P> To turn this off explicitly set {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon suppressValueIcon} to true <P> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} are undefined, this will be set to
     * {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getUncheckedImage uncheckedImage}.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanFalseImage
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getBooleanFalseImage()  {
        return getAttributeAsString("booleanFalseImage");
    }
    

    /**
     * Height for the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage}. Note: If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} is unset, the {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage checkedImage} will be used to indicate a true value
     * in a boolean field. In this case this property is ignored in favor of {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getValueIconHeight valueIconHeight}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanImageHeight  Default value is 16
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setBooleanImageHeight(int booleanImageHeight) {
        setAttribute("booleanImageHeight", booleanImageHeight, true);
    }

    /**
     * Height for the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage}. Note: If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} is unset, the {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage checkedImage} will be used to indicate a true value
     * in a boolean field. In this case this property is ignored in favor of {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getValueIconHeight valueIconHeight}.
     *
     * @return int
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public int getBooleanImageHeight()  {
        return getAttributeAsInt("booleanImageHeight");
    }
    

    /**
     * Width for the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage}. Note: If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} is unset, the {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage checkedImage} will be used to indicate a true value
     * in a boolean field. In this case this property is ignored in favor of {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getValueIconWidth valueIconWidth}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanImageWidth  Default value is 16
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setBooleanImageWidth(int booleanImageWidth) {
        setAttribute("booleanImageWidth", booleanImageWidth, true);
    }

    /**
     * Width for the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage}. Note: If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} is unset, the {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage checkedImage} will be used to indicate a true value
     * in a boolean field. In this case this property is ignored in favor of {@link
     * com.smartgwt.client.widgets.form.fields.CheckboxItem#getValueIconWidth valueIconWidth}.
     *
     * @return int
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public int getBooleanImageWidth()  {
        return getAttributeAsInt("booleanImageWidth");
    }
    

    /**
     * Image to display for a partially true value in a boolean field (typically selection). The special value "blank" means
     * that no image will be shown. <P> To turn this off explicitly set {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon suppressValueIcon} to true. <P> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} are unset, this will be set to the
     * default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPartialSelectedImage partialSelectedImage}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanPartialImage  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintBooleanPartialImage
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setBooleanPartialImage(String booleanPartialImage) {
        setAttribute("booleanPartialImage", booleanPartialImage, true);
    }

    /**
     * Image to display for a partially true value in a boolean field (typically selection). The special value "blank" means
     * that no image will be shown. <P> To turn this off explicitly set {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon suppressValueIcon} to true. <P> If this, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} are unset, this will be set to the
     * default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getPartialSelectedImage partialSelectedImage}.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanPartialImage
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getBooleanPartialImage()  {
        return getAttributeAsString("booleanPartialImage");
    }
    

    /**
     * Image to display for a true value in a boolean field. The special value "blank" means that no image will be shown. <P>
     * To turn this off explicitly set {@link com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon
     * suppressValueIcon} to true. <P> If this, {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage
     * booleanFalseImage} and {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} are
     * unset, this will be set to the default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage
     * checkedImage}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param booleanTrueImage  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanPartialImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintBooleanTrueImage
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setBooleanTrueImage(String booleanTrueImage) {
        setAttribute("booleanTrueImage", booleanTrueImage, true);
    }

    /**
     * Image to display for a true value in a boolean field. The special value "blank" means that no image will be shown. <P>
     * To turn this off explicitly set {@link com.smartgwt.client.widgets.grid.ListGridField#getSuppressValueIcon
     * suppressValueIcon} to true. <P> If this, {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage
     * booleanFalseImage} and {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} are
     * unset, this will be set to the default {@link com.smartgwt.client.widgets.form.fields.CheckboxItem#getCheckedImage
     * checkedImage}.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintBooleanTrueImage
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public String getBooleanTrueImage()  {
        return getAttributeAsString("booleanTrueImage");
    }
    

    /**
     * Indicates whether records can be dropped into this listGrid.
     *
     * @param canAcceptDroppedRecords  Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanAcceptDrop
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     */
    public void setCanAcceptDroppedRecords(Boolean canAcceptDroppedRecords) {
        setAttribute("canAcceptDroppedRecords", canAcceptDroppedRecords, true);
    }

    /**
     * Indicates whether records can be dropped into this listGrid.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanAcceptDrop
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     */
    public Boolean getCanAcceptDroppedRecords()  {
        Boolean result = getAttributeAsBoolean("canAcceptDroppedRecords");
        return result == null ? false : result;
    }
    
    
    

    /**
     * Whether the user able to autofit specific columns to their data and/or title via a context menu item or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderAutoFitEvent headerAutoFitEvent}. <P> Autofitting can also be
     * programmatically enabled by setting {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autoFitWidth}.
     * <P> When canResizeFields is set to false, canAutoFitFields will also be set to false
     *
     * @param canAutoFitFields  Default value is true
     */
    public void setCanAutoFitFields(Boolean canAutoFitFields) {
        setAttribute("canAutoFitFields", canAutoFitFields, true);
    }

    /**
     * Whether the user able to autofit specific columns to their data and/or title via a context menu item or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderAutoFitEvent headerAutoFitEvent}. <P> Autofitting can also be
     * programmatically enabled by setting {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autoFitWidth}.
     * <P> When canResizeFields is set to false, canAutoFitFields will also be set to false
     *
     * @return Boolean
     */
    public Boolean getCanAutoFitFields()  {
        Boolean result = getAttributeAsBoolean("canAutoFitFields");
        return result == null ? true : result;
    }
    

    /**
     * If this is an editable listGrid, and <code>this.confirmCancelEditing</code> is true this property is used as the message
     * to display in the confirmation dismissal prompt.
     *
     * @param cancelEditingConfirmationMessage  Default value is Cancelling this edit will discard unsaved changes for this record. Continue?
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setCancelEditingConfirmationMessage(String cancelEditingConfirmationMessage) {
        setAttribute("cancelEditingConfirmationMessage", cancelEditingConfirmationMessage, true);
    }

    /**
     * If this is an editable listGrid, and <code>this.confirmCancelEditing</code> is true this property is used as the message
     * to display in the confirmation dismissal prompt.
     *
     * @return String
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getCancelEditingConfirmationMessage()  {
        return getAttributeAsString("cancelEditingConfirmationMessage");
    }
    

    /**
     * Can a group be collapsed/expanded? When true a collapse/expand icon is shown ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupIcon groupIcon}) and the user can collapse or expand the group by
     * clicking either the row as a whole or the opener icon (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCollapseGroupOnRowClick collapseGroupOnRowClick}); When false the group
     * icon is not shown and clicking on the row does not change group state. Additionally {@link
     * com.smartgwt.client.types.GroupStartOpen groupStartOpen} is initialized to "all".
     *
     * @param canCollapseGroup  Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setCanCollapseGroup(Boolean canCollapseGroup)  throws IllegalStateException {
        setAttribute("canCollapseGroup", canCollapseGroup, false);
    }

    /**
     * Can a group be collapsed/expanded? When true a collapse/expand icon is shown ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupIcon groupIcon}) and the user can collapse or expand the group by
     * clicking either the row as a whole or the opener icon (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCollapseGroupOnRowClick collapseGroupOnRowClick}); When false the group
     * icon is not shown and clicking on the row does not change group state. Additionally {@link
     * com.smartgwt.client.types.GroupStartOpen groupStartOpen} is initialized to "all".
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public Boolean getCanCollapseGroup()  {
        Boolean result = getAttributeAsBoolean("canCollapseGroup");
        return result == null ? true : result;
    }
    

    /**
     * Indicates whether records can be dragged from this listGrid and dropped elsewhere. <p> <strong>NOTE:</strong> If
     * <code>canDragRecordsOut</code> is initially enabled or might be dynamically enabled after the grid is created, it may be
     * desirable to disable {@link com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that
     * touch-dragging a record starts a drag operation rather than a scroll. If {@link
     * com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag disableTouchScrollingForDrag} is set to
     * <code>true</code>, then touch scrolling will be disabled automatically. However, for {@link
     * com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch scrolling enabled and
     * provide an alternative set of controls that can be used to perform drag and drop of records out of the grid.
     *
     * @param canDragRecordsOut  Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanAcceptDrop
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_records_across_windows" target="examples">Records across Windows Example</a>
     */
    public void setCanDragRecordsOut(Boolean canDragRecordsOut) {
        setAttribute("canDragRecordsOut", canDragRecordsOut, true);
    }

    /**
     * Indicates whether records can be dragged from this listGrid and dropped elsewhere. <p> <strong>NOTE:</strong> If
     * <code>canDragRecordsOut</code> is initially enabled or might be dynamically enabled after the grid is created, it may be
     * desirable to disable {@link com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that
     * touch-dragging a record starts a drag operation rather than a scroll. If {@link
     * com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag disableTouchScrollingForDrag} is set to
     * <code>true</code>, then touch scrolling will be disabled automatically. However, for {@link
     * com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch scrolling enabled and
     * provide an alternative set of controls that can be used to perform drag and drop of records out of the grid.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanAcceptDrop
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_records_across_windows" target="examples">Records across Windows Example</a>
     */
    public Boolean getCanDragRecordsOut()  {
        Boolean result = getAttributeAsBoolean("canDragRecordsOut");
        return result == null ? false : result;
    }
    

    /**
     * If this property is true, users can drag the mouse to select several rows or cells.  This is mutually exclusive with
     * rearranging rows or cells by dragging. <p> <strong>NOTE:</strong> If <code>canDragSelect</code> is initially enabled or
     * might be dynamically enabled after the grid is created, it may be desirable to disable {@link
     * com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that touch-dragging records/cells selects
     * them rather than starting a scroll. If {@link com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag
     * disableTouchScrollingForDrag} is set to <code>true</code>, then touch scrolling will be disabled automatically. However,
     * for {@link com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch scrolling
     * enabled and provide an alternative set of controls that can be used to perform drag-selection.
     *
     * @param canDragSelect  Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_select_list" target="examples">Drag list (select) Example</a>
     */
    public void setCanDragSelect(Boolean canDragSelect) {
        setAttribute("canDragSelect", canDragSelect, true);
    }

    /**
     * If this property is true, users can drag the mouse to select several rows or cells.  This is mutually exclusive with
     * rearranging rows or cells by dragging. <p> <strong>NOTE:</strong> If <code>canDragSelect</code> is initially enabled or
     * might be dynamically enabled after the grid is created, it may be desirable to disable {@link
     * com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that touch-dragging records/cells selects
     * them rather than starting a scroll. If {@link com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag
     * disableTouchScrollingForDrag} is set to <code>true</code>, then touch scrolling will be disabled automatically. However,
     * for {@link com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch scrolling
     * enabled and provide an alternative set of controls that can be used to perform drag-selection.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_select_list" target="examples">Drag list (select) Example</a>
     */
    public Boolean getCanDragSelect()  {
        Boolean result = getAttributeAsBoolean("canDragSelect");
        return result == null ? false : result;
    }
    

    /**
     * If this property is true, users can drag the mouse to select text within grid rows. This is mutually exclusive with
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCanReorderRecords rearranging rows or cells by dragging}, and with
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCanDragSelect drag selection of rows}.
     *
     * @param canDragSelectText  Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public void setCanDragSelectText(Boolean canDragSelectText) {
        setAttribute("canDragSelectText", canDragSelectText, true);
    }

    /**
     * If this property is true, users can drag the mouse to select text within grid rows. This is mutually exclusive with
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCanReorderRecords rearranging rows or cells by dragging}, and with
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCanDragSelect drag selection of rows}.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public Boolean getCanDragSelectText()  {
        Boolean result = getAttributeAsBoolean("canDragSelectText");
        return result == null ? false : result;
    }
    

    /**
     * If set to false, dropping over an empty part of the grid body is disallowed and the no-drop indicator is displayed.
     *
     * @param canDropInEmptyArea  Default value is true
     * @see com.smartgwt.client.docs.Dragdrop Dragdrop overview and related methods
     */
    public void setCanDropInEmptyArea(Boolean canDropInEmptyArea) {
        setAttribute("canDropInEmptyArea", canDropInEmptyArea, true);
    }

    /**
     * If set to false, dropping over an empty part of the grid body is disallowed and the no-drop indicator is displayed.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Dragdrop Dragdrop overview and related methods
     */
    public Boolean getCanDropInEmptyArea()  {
        Boolean result = getAttributeAsBoolean("canDropInEmptyArea");
        return result == null ? true : result;
    }
    

    /**
     * Can the user edit cells in this listGrid? Can be set for the listGrid, and overridden for      individual fields.<br>   
     * If 'canEdit' is false at the listGrid level, fields can never be edited - in this case      the canEdit property on
     * individual fields will be ignored.<br>      If 'canEdit' is set to true at the listGrid level, setting the 'canEdit'
     * property to      false at the field level will prevent the field from being edited inline.<br>      If 'canEdit' is not
     * set at the listGrid level, setting 'canEdit' to true at the field      level enables the field to be edited inline.
     *
     * @param canEdit  Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#startEditing
     * @see com.smartgwt.client.widgets.grid.ListGridField#setCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGrid#setRecordEditProperty
     * @see com.smartgwt.client.widgets.grid.ListGrid#canEditCell
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFields
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_row" target="examples">Edit by row Example</a>
     */
    public void setCanEdit(Boolean canEdit) {
        setAttribute("canEdit", canEdit, true);
    }

    /**
     * Can the user edit cells in this listGrid? Can be set for the listGrid, and overridden for      individual fields.<br>   
     * If 'canEdit' is false at the listGrid level, fields can never be edited - in this case      the canEdit property on
     * individual fields will be ignored.<br>      If 'canEdit' is set to true at the listGrid level, setting the 'canEdit'
     * property to      false at the field level will prevent the field from being edited inline.<br>      If 'canEdit' is not
     * set at the listGrid level, setting 'canEdit' to true at the field      level enables the field to be edited inline.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#startEditing
     * @see com.smartgwt.client.widgets.grid.ListGridField#getCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGrid#getRecordEditProperty
     * @see com.smartgwt.client.widgets.grid.ListGrid#canEditCell
     * @see com.smartgwt.client.widgets.grid.ListGrid#getFields
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_row" target="examples">Edit by row Example</a>
     */
    public Boolean getCanEdit()  {
        return getAttributeAsBoolean("canEdit");
    }
    

    /**
     * If this component is bound to a dataSource, this attribute may be specified to customize what fields from the dataSource
     * may be edited by default. For example the {@link com.smartgwt.client.widgets.form.SearchForm} class has this attribute
     * set to <code>"canFilter"</code> which allows search forms to edit dataSource fields marked as <code>canEdit:false</code>
     * (but not those marked as <code>canFilter:false</code>). <P> Note that if <code>canEdit</code> is explicitly specified on
     * a field in  the {@link com.smartgwt.client.widgets.DataBoundComponent#getFields fields} array, that property will be
     * respected in preference to  the canEditAttribute value. (See {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getCanEdit canEdit}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanEdit canEdit}). Also note that individual dataBoundComponents may
     * have additional logic around whether a field can be edited - for example {@link
     * com.smartgwt.client.widgets.grid.ListGrid#canEditCell ListGrid.canEditCell()} may be overridden.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param canEditFieldAttribute  Default value is "canEdit"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setCanEditFieldAttribute(String canEditFieldAttribute)  throws IllegalStateException {
        setAttribute("canEditFieldAttribute", canEditFieldAttribute, false);
    }

    /**
     * If this component is bound to a dataSource, this attribute may be specified to customize what fields from the dataSource
     * may be edited by default. For example the {@link com.smartgwt.client.widgets.form.SearchForm} class has this attribute
     * set to <code>"canFilter"</code> which allows search forms to edit dataSource fields marked as <code>canEdit:false</code>
     * (but not those marked as <code>canFilter:false</code>). <P> Note that if <code>canEdit</code> is explicitly specified on
     * a field in  the {@link com.smartgwt.client.widgets.DataBoundComponent#getFields fields} array, that property will be
     * respected in preference to  the canEditAttribute value. (See {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getCanEdit canEdit}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanEdit canEdit}). Also note that individual dataBoundComponents may
     * have additional logic around whether a field can be edited - for example {@link
     * com.smartgwt.client.widgets.grid.ListGrid#canEditCell ListGrid.canEditCell()} may be overridden.
     *
     * @return String
     */
    public String getCanEditFieldAttribute()  {
        return getAttributeAsString("canEditFieldAttribute");
    }
    

    /**
     * Adds an item to the header context menu allowing users to launch a dialog to define grid hilites using the {@link
     * com.smartgwt.client.widgets.grid.HiliteEditor}. <P> User-added hilites can be persisted via {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getHiliteState DataBoundComponent.getHiliteState()} and  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#setHiliteState DataBoundComponent.setHiliteState()}.
     *
     * @param canEditHilites  Default value is false
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setCanEditHilites(boolean canEditHilites) {
        setAttribute("canEditHilites", canEditHilites, true);
    }

    /**
     * Adds an item to the header context menu allowing users to launch a dialog to define grid hilites using the {@link
     * com.smartgwt.client.widgets.grid.HiliteEditor}. <P> User-added hilites can be persisted via {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getHiliteState DataBoundComponent.getHiliteState()} and  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#setHiliteState DataBoundComponent.setHiliteState()}.
     *
     * @return boolean
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public boolean getCanEditHilites()  {
        Boolean result = getAttributeAsBoolean("canEditHilites");
        return result == null ? false : result;
    }
    

    /**
     * If set to true, the {@link com.smartgwt.client.widgets.grid.ListGrid#getUseAdvancedFieldPicker advanced field picker}
     * provides an interface allowing users to modify fields' titles. <P> Note that when enabled, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFieldState field state} for this component will include field titles.
     *
     * @param canEditTitles  Default value is false
     */
    public void setCanEditTitles(boolean canEditTitles) {
        setAttribute("canEditTitles", canEditTitles, true);
    }

    /**
     * If set to true, the {@link com.smartgwt.client.widgets.grid.ListGrid#getUseAdvancedFieldPicker advanced field picker}
     * provides an interface allowing users to modify fields' titles. <P> Note that when enabled, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFieldState field state} for this component will include field titles.
     *
     * @return boolean
     */
    public boolean getCanEditTitles()  {
        Boolean result = getAttributeAsBoolean("canEditTitles");
        return result == null ? false : result;
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true, this property
     * indicates whether multiple records can be expanded simultaneously.  If set to false, expanding a record will
     * automatically collapse any record which is already expanded.  The default value is <code>true</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param canExpandMultipleRecords  Default value is true
     */
    public void setCanExpandMultipleRecords(Boolean canExpandMultipleRecords) {
        setAttribute("canExpandMultipleRecords", canExpandMultipleRecords, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true, this property
     * indicates whether multiple records can be expanded simultaneously.  If set to false, expanding a record will
     * automatically collapse any record which is already expanded.  The default value is <code>true</code>.
     *
     * @return Boolean
     */
    public Boolean getCanExpandMultipleRecords()  {
        Boolean result = getAttributeAsBoolean("canExpandMultipleRecords");
        return result == null ? true : result;
    }
    

    /**
     * Property name on a record that will be checked to determine whether a record can be expanded.
     *
     * @param canExpandRecordProperty  Default value is "canExpand"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanExpand
     */
    public void setCanExpandRecordProperty(String canExpandRecordProperty)  throws IllegalStateException {
        setAttribute("canExpandRecordProperty", canExpandRecordProperty, false);
    }

    /**
     * Property name on a record that will be checked to determine whether a record can be expanded.
     *
     * @return String
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanExpand
     */
    public String getCanExpandRecordProperty()  {
        return getAttributeAsString("canExpandRecordProperty");
    }
    

    /**
     * When set to true, shows an additional field at the beginning of the field-list (respecting RTL) to allow users to expand
     * and collapse individual records. See {@link com.smartgwt.client.widgets.grid.ListGrid#expandRecord
     * ListGrid.expandRecord()} and {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} for
     * details on record expansion. <P> {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}
     * is automatically enabled when canExpandRecords is set to true. <P> Note that expanded records are not currently
     * supported in conjunction with {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param canExpandRecords new value for listGrid.canExpandRecords.. Default value is false
     */
    public void setCanExpandRecords(Boolean canExpandRecords) {
        setAttribute("canExpandRecords", canExpandRecords, true);
    }

    /**
     * When set to true, shows an additional field at the beginning of the field-list (respecting RTL) to allow users to expand
     * and collapse individual records. See {@link com.smartgwt.client.widgets.grid.ListGrid#expandRecord
     * ListGrid.expandRecord()} and {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} for
     * details on record expansion. <P> {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}
     * is automatically enabled when canExpandRecords is set to true. <P> Note that expanded records are not currently
     * supported in conjunction with {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}.
     *
     * @return Boolean
     */
    public Boolean getCanExpandRecords()  {
        Boolean result = getAttributeAsBoolean("canExpandRecords");
        return result == null ? false : result;
    }
    

    /**
     * If the listGrid is empty, should the user be able to put focus into the grid body by tabbing to it? <P> Note that if
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditOnFocus editOnFocus} is true for this grid and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getListEndEditAction listEndEditAction} is set to next, having this property
     * set to true will allow users to automatically create a new edit row by simply tabbing into the grid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param canFocusInEmptyGrid  Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setCanFocusInEmptyGrid(boolean canFocusInEmptyGrid)  throws IllegalStateException {
        setAttribute("canFocusInEmptyGrid", canFocusInEmptyGrid, false);
    }

    /**
     * If the listGrid is empty, should the user be able to put focus into the grid body by tabbing to it? <P> Note that if
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditOnFocus editOnFocus} is true for this grid and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getListEndEditAction listEndEditAction} is set to next, having this property
     * set to true will allow users to automatically create a new edit row by simply tabbing into the grid.
     *
     * @return boolean
     */
    public boolean getCanFocusInEmptyGrid()  {
        Boolean result = getAttributeAsBoolean("canFocusInEmptyGrid");
        return result == null ? true : result;
    }
    

    /**
     * Whether an interface should be shown to allow user is allowed to dynamically "freeze" or "unfreeze" columns with respect
     * to horizontally scrolling. If unset, this property defaults to <code>true</code> unless:<ul> <li>{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights this.fixedRecordHeights} is <code>false</code></li>
     * <li>{@link com.smartgwt.client.widgets.grid.ListGrid#getBodyOverflow this.bodyOverflow} is <code>"visible"</code></li>
     * <li>{@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData this.autoFitData} is set to
     * <code>"horizontal"</code> or <code>"both"</code></li> <li>Any field has overflow set to <code>"visible"</code></li></ul>
     * <P> Note that the <code>canFreezeFields</code> setting enables or disables the user interface for freezing and
     * unfreezing fields only.  Fields can be programmatically frozen via setting {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen field.frozen} to true when the grid is created, or dynamically
     * frozen and unfrozen via {@link com.smartgwt.client.widgets.grid.ListGrid#freezeField ListGrid.freezeField()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#unfreezeField ListGrid.unfreezeField()}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter method for {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields canFreezeFields}
     *
     * @param canFreezeFields New value for <code>listGrid.canFreezeFields</code>. Default value is null
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public void setCanFreezeFields(Boolean canFreezeFields) {
        setAttribute("canFreezeFields", canFreezeFields, true);
    }

    /**
     * Whether an interface should be shown to allow user is allowed to dynamically "freeze" or "unfreeze" columns with respect
     * to horizontally scrolling. If unset, this property defaults to <code>true</code> unless:<ul> <li>{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights this.fixedRecordHeights} is <code>false</code></li>
     * <li>{@link com.smartgwt.client.widgets.grid.ListGrid#getBodyOverflow this.bodyOverflow} is <code>"visible"</code></li>
     * <li>{@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData this.autoFitData} is set to
     * <code>"horizontal"</code> or <code>"both"</code></li> <li>Any field has overflow set to <code>"visible"</code></li></ul>
     * <P> Note that the <code>canFreezeFields</code> setting enables or disables the user interface for freezing and
     * unfreezing fields only.  Fields can be programmatically frozen via setting {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen field.frozen} to true when the grid is created, or dynamically
     * frozen and unfrozen via {@link com.smartgwt.client.widgets.grid.ListGrid#freezeField ListGrid.freezeField()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#unfreezeField ListGrid.unfreezeField()}.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public Boolean getCanFreezeFields()  {
        return getAttributeAsBoolean("canFreezeFields");
    }
    

    /**
     * If false, grouping via context menu will be disabled.
     *
     * @param canGroupBy  Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setCanGroupBy(Boolean canGroupBy) {
        setAttribute("canGroupBy", canGroupBy, true);
    }

    /**
     * If false, grouping via context menu will be disabled.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public Boolean getCanGroupBy()  {
        Boolean result = getAttributeAsBoolean("canGroupBy");
        return result == null ? true : result;
    }
    

    /**
     * If true, cellHover and rowHover events will fire and then a hover will be shown (if not canceled) when the user leaves
     * the mouse over a row / cell unless the corresponding field has {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowHover showHover} set to false. If unset or null, the hover will be
     * shown if the corresponding field has showHover:true. If false, then hovers are disabled. <p> Note that standard hovers
     * override {@link com.smartgwt.client.widgets.grid.ListGrid#getShowClippedValuesOnHover clipped value hovers}. Thus, to
     * enable clipped value hovers, canHover must be unset or null and the corresponding field must have showHover unset or
     * null as well.
     *
     * @param canHover  Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowHover
     * @see com.smartgwt.client.widgets.grid.ListGridField#setShowHover
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_value_hover" target="examples">Value hover tips Example</a>
     */
    public void setCanHover(Boolean canHover) {
        setAttribute("canHover", canHover, true);
    }

    /**
     * If true, cellHover and rowHover events will fire and then a hover will be shown (if not canceled) when the user leaves
     * the mouse over a row / cell unless the corresponding field has {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowHover showHover} set to false. If unset or null, the hover will be
     * shown if the corresponding field has showHover:true. If false, then hovers are disabled. <p> Note that standard hovers
     * override {@link com.smartgwt.client.widgets.grid.ListGrid#getShowClippedValuesOnHover clipped value hovers}. Thus, to
     * enable clipped value hovers, canHover must be unset or null and the corresponding field must have showHover unset or
     * null as well.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowHover
     * @see com.smartgwt.client.widgets.grid.ListGridField#getShowHover
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_value_hover" target="examples">Value hover tips Example</a>
     */
    public Boolean getCanHover()  {
        return getAttributeAsBoolean("canHover");
    }
    

    /**
     * When true, indicates that this ListGrid supports grouping on multiple fields.
     *
     * @param canMultiGroup  Default value is false
     */
    public void setCanMultiGroup(boolean canMultiGroup) {
        setAttribute("canMultiGroup", canMultiGroup, true);
    }

    /**
     * When true, indicates that this ListGrid supports grouping on multiple fields.
     *
     * @return boolean
     */
    public boolean getCanMultiGroup()  {
        Boolean result = getAttributeAsBoolean("canMultiGroup");
        return result == null ? false : result;
    }
    

    /**
     * When true, indicates that this ListGrid supports sorting on multiple fields.  Note that even when set to true,
     * multi-field sorting may not be available if the grid is databound and the
     * ${isc.DocUtils.linkForRef('attr:DataSource.canMultiSort','DataSource doesn\'t support multi-sort')}, or if sorting for a
     * field is {@link com.smartgwt.client.widgets.grid.ListGridField#getCanSortClientOnly client-only} but not all data is
     * available.
     *
     * @param canMultiSort  Default value is true
     */
    public void setCanMultiSort(Boolean canMultiSort) {
        setAttribute("canMultiSort", canMultiSort, true);
    }

    /**
     * When true, indicates that this ListGrid supports sorting on multiple fields.  Note that even when set to true,
     * multi-field sorting may not be available if the grid is databound and the
     * ${isc.DocUtils.linkForRef('attr:DataSource.canMultiSort','DataSource doesn\'t support multi-sort')}, or if sorting for a
     * field is {@link com.smartgwt.client.widgets.grid.ListGridField#getCanSortClientOnly client-only} but not all data is
     * available.
     *
     * @return Boolean
     */
    public Boolean getCanMultiSort()  {
        Boolean result = getAttributeAsBoolean("canMultiSort");
        return result == null ? true : result;
    }
    

    /**
     * Indicates whether the field picker item and submenu should be present in the header context menu. This menu allows the
     * user to hide visible fields and show hidden fields. <p> By default only fields explicitly included in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array will be available in this menu, unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanPickOmittedFields canPickOmittedFields} is set to true for a databound
     * grid. <p> A specific field can be omitted from the column picker via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanHide canHide}.
     *
     * @param canPickFields  Default value is true
     */
    public void setCanPickFields(Boolean canPickFields) {
        setAttribute("canPickFields", canPickFields, true);
    }

    /**
     * Indicates whether the field picker item and submenu should be present in the header context menu. This menu allows the
     * user to hide visible fields and show hidden fields. <p> By default only fields explicitly included in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array will be available in this menu, unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanPickOmittedFields canPickOmittedFields} is set to true for a databound
     * grid. <p> A specific field can be omitted from the column picker via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCanHide canHide}.
     *
     * @return Boolean
     */
    public Boolean getCanPickFields()  {
        Boolean result = getAttributeAsBoolean("canPickFields");
        return result == null ? true : result;
    }
    

    /**
     * If this grid has a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseAllDataSourceFields useAllDataSourceFields} is false, setting this
     * property to true will cause all dataSource fields not included in the specified set of fields to show up in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields field picker menu item}. <P> Has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFields fields} is unset (as in this case all dataSource fields will be
     * displayed by default), or if {@link com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields canPickFields} is false.
     *
     * @param canPickOmittedFields  Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setCanPickOmittedFields(Boolean canPickOmittedFields)  throws IllegalStateException {
        setAttribute("canPickOmittedFields", canPickOmittedFields, false);
    }

    /**
     * If this grid has a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseAllDataSourceFields useAllDataSourceFields} is false, setting this
     * property to true will cause all dataSource fields not included in the specified set of fields to show up in the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields field picker menu item}. <P> Has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFields fields} is unset (as in this case all dataSource fields will be
     * displayed by default), or if {@link com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields canPickFields} is false.
     *
     * @return Boolean
     */
    public Boolean getCanPickOmittedFields()  {
        Boolean result = getAttributeAsBoolean("canPickOmittedFields");
        return result == null ? false : result;
    }
    

    /**
     * If set, provide UI for the user to remove records from the grid as an additional field showing the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon removeIcon}, which, when clicked, will call {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeRecordClick ListGrid.removeRecordClick()} which removes the row from the
     * data set (or if {@link com.smartgwt.client.widgets.grid.ListGrid#getDeferRemoval deferRemoval} is true changes the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved ListGrid.markRecordRemoved()} status for the record).
     * Individual records can be marked to prevent removal - see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordCanRemoveProperty recordCanRemoveProperty}. <P> To add a confirmation
     * dialog before a record is removed, set {@link com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemoval warnOnRemoval}.
     * <P> If deferring removal, the record will appear marked with the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemovedCSSText removedCSSText} until the removal is committed via a call to
     * {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits ListGrid.saveEdits()}. Otherwise, the record will disappear
     * from view. If {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord animateRemoveRecord} is true, the
     * removed record will appear to shrink out of view when it is removed. <P> By default the field will display the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon removeIcon} next to each record, and will be rendered as the
     * rightmost column. Two mechanisms exist to further modify this field: <ul> <li>To change the position of the
     * remove-field, include an explicitly specified field with     the attribute {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getIsRemoveField isRemoveField:true} set. This will then     be used as
     * the remove field instead of adding a field to the beginning of the set of     columns.</li> <li>Additional direct
     * configuration of the remove field may be achieved by modifying     {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldProperties removeFieldProperties}.</li> </ul> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDeferRemoval deferRemoval} is true, when a record is marked as removed, the
     * the icon will change to display the {@link com.smartgwt.client.widgets.grid.ListGrid#getUnremoveIcon unremoveIcon} for
     * this row. Clicking on this icon will call {@link com.smartgwt.client.widgets.grid.ListGrid#unmarkRecordRemoved
     * ListGrid.unmarkRecordRemoved()} to mark the record as no longer pending deletion.
     *
     * @param canRemoveRecords  Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public void setCanRemoveRecords(Boolean canRemoveRecords)  throws IllegalStateException {
        setAttribute("canRemoveRecords", canRemoveRecords, false);
    }

    /**
     * If set, provide UI for the user to remove records from the grid as an additional field showing the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon removeIcon}, which, when clicked, will call {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeRecordClick ListGrid.removeRecordClick()} which removes the row from the
     * data set (or if {@link com.smartgwt.client.widgets.grid.ListGrid#getDeferRemoval deferRemoval} is true changes the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved ListGrid.markRecordRemoved()} status for the record).
     * Individual records can be marked to prevent removal - see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordCanRemoveProperty recordCanRemoveProperty}. <P> To add a confirmation
     * dialog before a record is removed, set {@link com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemoval warnOnRemoval}.
     * <P> If deferring removal, the record will appear marked with the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemovedCSSText removedCSSText} until the removal is committed via a call to
     * {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits ListGrid.saveEdits()}. Otherwise, the record will disappear
     * from view. If {@link com.smartgwt.client.widgets.grid.ListGrid#getAnimateRemoveRecord animateRemoveRecord} is true, the
     * removed record will appear to shrink out of view when it is removed. <P> By default the field will display the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon removeIcon} next to each record, and will be rendered as the
     * rightmost column. Two mechanisms exist to further modify this field: <ul> <li>To change the position of the
     * remove-field, include an explicitly specified field with     the attribute {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getIsRemoveField isRemoveField:true} set. This will then     be used as
     * the remove field instead of adding a field to the beginning of the set of     columns.</li> <li>Additional direct
     * configuration of the remove field may be achieved by modifying     {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldProperties removeFieldProperties}.</li> </ul> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDeferRemoval deferRemoval} is true, when a record is marked as removed, the
     * the icon will change to display the {@link com.smartgwt.client.widgets.grid.ListGrid#getUnremoveIcon unremoveIcon} for
     * this row. Clicking on this icon will call {@link com.smartgwt.client.widgets.grid.ListGrid#unmarkRecordRemoved
     * ListGrid.unmarkRecordRemoved()} to mark the record as no longer pending deletion.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public Boolean getCanRemoveRecords()  {
        Boolean result = getAttributeAsBoolean("canRemoveRecords");
        return result == null ? false : result;
    }
    

    /**
     * Indicates whether fields in this listGrid can be reordered by dragging and dropping header fields.
     *
     * @param canReorderFields  Default value is true
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_columnorder" target="examples">Column order Example</a>
     */
    public void setCanReorderFields(Boolean canReorderFields) {
        setAttribute("canReorderFields", canReorderFields, true);
    }

    /**
     * Indicates whether fields in this listGrid can be reordered by dragging and dropping header fields.
     *
     * @return Boolean
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_columnorder" target="examples">Column order Example</a>
     */
    public Boolean getCanReorderFields()  {
        Boolean result = getAttributeAsBoolean("canReorderFields");
        return result == null ? true : result;
    }
    

    /**
     * Indicates whether records can be reordered by dragging within this <code>ListGrid</code>. <p> <strong>NOTE:</strong> If
     * <code>canReorderRecords</code> is initially enabled or might be {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCanReorderRecords dynamically enabled} after the grid is created, it may be
     * desirable to disable {@link com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that
     * touch-dragging a record starts a reorder operation rather than a scroll. If {@link
     * com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag disableTouchScrollingForDrag} is set to
     * <code>true</code>, then touch scrolling will be disabled automatically. However, for {@link
     * com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch scrolling enabled and
     * provide an alternative set of controls that can be used to perform drag-reordering of records.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getCanReorderRecords canReorderRecords} attribute.
     *
     * @param canReorderRecords new value for <code>this.canReorderRecords</code>. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setCanAcceptDrop
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_drag_reorder" target="examples">Drag reorder Example</a>
     */
    public void setCanReorderRecords(Boolean canReorderRecords) {
        setAttribute("canReorderRecords", canReorderRecords, true);
    }

    /**
     * Indicates whether records can be reordered by dragging within this <code>ListGrid</code>. <p> <strong>NOTE:</strong> If
     * <code>canReorderRecords</code> is initially enabled or might be {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCanReorderRecords dynamically enabled} after the grid is created, it may be
     * desirable to disable {@link com.smartgwt.client.widgets.Canvas#getUseTouchScrolling touch scrolling} so that
     * touch-dragging a record starts a reorder operation rather than a scroll. If {@link
     * com.smartgwt.client.widgets.Canvas#getDisableTouchScrollingForDrag disableTouchScrollingForDrag} is set to
     * <code>true</code>, then touch scrolling will be disabled automatically. However, for {@link
     * com.smartgwt.client.docs.Accessibility accessibility} reasons, it is recommended to leave touch scrolling enabled and
     * provide an alternative set of controls that can be used to perform drag-reordering of records.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanDrag
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getCanAcceptDrop
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#effects_dd_move_list" target="examples">Drag list (move) Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_drag_reorder" target="examples">Drag reorder Example</a>
     */
    public Boolean getCanReorderRecords()  {
        Boolean result = getAttributeAsBoolean("canReorderRecords");
        return result == null ? false : result;
    }
    

    /**
     * Indicates whether fields in this listGrid can be resized by dragging header fields.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter method for updating {@link com.smartgwt.client.widgets.grid.ListGrid#getCanResizeFields canResizeFields} at runtime.
     *
     * @param canResizeFields new value for this.canResizeFields. Default value is true
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_columnsize" target="examples">Column size Example</a>
     */
    public void setCanResizeFields(Boolean canResizeFields) {
        setAttribute("canResizeFields", canResizeFields, true);
    }

    /**
     * Indicates whether fields in this listGrid can be resized by dragging header fields.
     *
     * @return Boolean
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_columnsize" target="examples">Column size Example</a>
     */
    public Boolean getCanResizeFields()  {
        Boolean result = getAttributeAsBoolean("canResizeFields");
        return result == null ? true : result;
    }
    

    /**
     * Controls whether a checkbox for selecting all records appears in the header with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} set to "checkbox"
     *
     * @param canSelectAll  Default value is null
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public void setCanSelectAll(Boolean canSelectAll) {
        setAttribute("canSelectAll", canSelectAll, true);
    }

    /**
     * Controls whether a checkbox for selecting all records appears in the header with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} set to "checkbox"
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public Boolean getCanSelectAll()  {
        return getAttributeAsBoolean("canSelectAll");
    }
    

    /**
     * Enables cell-level selection behavior as well as {@link com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers
     * cell-level rollover}. <P> To query and manipulate cell-level selections, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellSelection ListGrid.getCellSelection()} to retrieve the {@link
     * com.smartgwt.client.widgets.grid.CellSelection}. <P> Note that the ListGrid has a data model of one {@link
     * com.smartgwt.client.data.Record} per row, unlike the {@link com.smartgwt.client.widgets.cube.CubeGrid} which supports
     * one {@link com.smartgwt.client.widgets.cube.CellRecord} per cell.  For this reason record-oriented APIs that act on the
     * selection will act on entire Records that have <i>any</i> selected cells (examples include drag and drop and
     * transferSelectedData()). <P> More generally, <code>canSelectCells</code> is primarily intended to enable developers to
     * build Excel-like interactions on local datasets, by using {@link com.smartgwt.client.widgets.grid.ListGrid#setData
     * ListGrid.setData()} plus {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally}:true rather than
     * record-oriented DataSources and data binding. <P> The following keyboard selection behaviors are enabled with this
     * property in addition to standard single-selection Arrow Key navigation: <P> SHIFT +        [Arrow Key]:  begin or
     * continue incremental selection <P> SHIFT + CTRL + [Arrow Key]:  incremental selection to the end of row or column <P>
     * CTRL  + A: select all cells (enabled only with {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectAll
     * canSelectAll}) <P> Incremental selection allows selection of rows and columns of cells via keyboard or mouse provided
     * the shift key is down.  Behavior is designed to match Excel. Thus, if a previous selection has begun, cells will be
     * selected from that origin. <P> Users may also navigate through cells using the <i>Tab</i> and <i>Shift+Tab</i>
     * keypresses if {@link com.smartgwt.client.widgets.grid.ListGrid#getNavigateOnTab navigateOnTab} is true. When a user tabs
     * to the end of the row, the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowEndEditAction rowEndEditAction} is
     * used to determine whether to shift selection to the next row, return to the beginning of the same row, or simply move on
     * through the page's tab order.
     *
     * @param canSelectCells  Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setCanSelectCells(Boolean canSelectCells)  throws IllegalStateException {
        setAttribute("canSelectCells", canSelectCells, false);
    }

    /**
     * Enables cell-level selection behavior as well as {@link com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers
     * cell-level rollover}. <P> To query and manipulate cell-level selections, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellSelection ListGrid.getCellSelection()} to retrieve the {@link
     * com.smartgwt.client.widgets.grid.CellSelection}. <P> Note that the ListGrid has a data model of one {@link
     * com.smartgwt.client.data.Record} per row, unlike the {@link com.smartgwt.client.widgets.cube.CubeGrid} which supports
     * one {@link com.smartgwt.client.widgets.cube.CellRecord} per cell.  For this reason record-oriented APIs that act on the
     * selection will act on entire Records that have <i>any</i> selected cells (examples include drag and drop and
     * transferSelectedData()). <P> More generally, <code>canSelectCells</code> is primarily intended to enable developers to
     * build Excel-like interactions on local datasets, by using {@link com.smartgwt.client.widgets.grid.ListGrid#setData
     * ListGrid.setData()} plus {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally}:true rather than
     * record-oriented DataSources and data binding. <P> The following keyboard selection behaviors are enabled with this
     * property in addition to standard single-selection Arrow Key navigation: <P> SHIFT +        [Arrow Key]:  begin or
     * continue incremental selection <P> SHIFT + CTRL + [Arrow Key]:  incremental selection to the end of row or column <P>
     * CTRL  + A: select all cells (enabled only with {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectAll
     * canSelectAll}) <P> Incremental selection allows selection of rows and columns of cells via keyboard or mouse provided
     * the shift key is down.  Behavior is designed to match Excel. Thus, if a previous selection has begun, cells will be
     * selected from that origin. <P> Users may also navigate through cells using the <i>Tab</i> and <i>Shift+Tab</i>
     * keypresses if {@link com.smartgwt.client.widgets.grid.ListGrid#getNavigateOnTab navigateOnTab} is true. When a user tabs
     * to the end of the row, the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowEndEditAction rowEndEditAction} is
     * used to determine whether to shift selection to the next row, return to the beginning of the same row, or simply move on
     * through the page's tab order.
     *
     * @return Boolean
     */
    public Boolean getCanSelectCells()  {
        Boolean result = getAttributeAsBoolean("canSelectCells");
        return result == null ? false : result;
    }
    

    /**
     * Controls whether a checkbox for selecting {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groups} appears in
     * the group node if {@link com.smartgwt.client.types.SelectionAppearance} is set to <code>"checkbox"</code>
     *
     * @param canSelectGroups  Default value is false
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public void setCanSelectGroups(boolean canSelectGroups) {
        setAttribute("canSelectGroups", canSelectGroups, true);
    }

    /**
     * Controls whether a checkbox for selecting {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy groups} appears in
     * the group node if {@link com.smartgwt.client.types.SelectionAppearance} is set to <code>"checkbox"</code>
     *
     * @return boolean
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public boolean getCanSelectGroups()  {
        Boolean result = getAttributeAsBoolean("canSelectGroups");
        return result == null ? false : result;
    }
    

    /**
     * Enables or disables interactive sorting behavior for this listGrid. Does not affect sorting by direct calls to the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#sort sort} or {@link com.smartgwt.client.widgets.grid.ListGrid#setSort
     * setSort} methods.
     *
     * @param canSort  Default value is true
     */
    public void setCanSort(Boolean canSort) {
        setAttribute("canSort", canSort, true);
    }

    /**
     * Enables or disables interactive sorting behavior for this listGrid. Does not affect sorting by direct calls to the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#sort sort} or {@link com.smartgwt.client.widgets.grid.ListGrid#setSort
     * setSort} methods.
     *
     * @return Boolean
     */
    public Boolean getCanSort()  {
        Boolean result = getAttributeAsBoolean("canSort");
        return result == null ? true : result;
    }
    

    /**
     * Should the header be included in the tab-order for the page? If not explicitly specified, the header will be included in
     * the tab order for the page if {@link com.smartgwt.client.util.isc#setScreenReaderMode isc.setScreenReaderMode()} is
     * called.
     *
     * @param canTabToHeader  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public void setCanTabToHeader(Boolean canTabToHeader)  throws IllegalStateException {
        setAttribute("canTabToHeader", canTabToHeader, false);
    }

    /**
     * Should the header be included in the tab-order for the page? If not explicitly specified, the header will be included in
     * the tab order for the page if {@link com.smartgwt.client.util.isc#setScreenReaderMode isc.setScreenReaderMode()} is
     * called.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public Boolean getCanTabToHeader()  {
        return getAttributeAsBoolean("canTabToHeader");
    }
    

    /**
     * The menu displayed when a cell is right clicked on.
     * <p>
     * For an overview of how to use and configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Layout
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Layout getCellContextMenu() throws IllegalStateException {
        errorIfNotCreated("cellContextMenu");
        return (Layout)Layout.getByJSObject(getAttributeAsJavaScriptObject("cellContextMenu"));
    }
    

    /**
     * The default height of each row in pixels.
     *
     * @param cellHeight  Default value is 20
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_multiline" target="examples">Multiline values Example</a>
     */
    public void setCellHeight(int cellHeight) {
        setAttribute("cellHeight", cellHeight, true);
    }

    /**
     * The default height of each row in pixels.
     *
     * @return int
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_multiline" target="examples">Multiline values Example</a>
     */
    public int getCellHeight()  {
        return getAttributeAsInt("cellHeight");
    }
    

    /**
     * The amount of empty space, in pixels, surrounding each value in its cell.
     *
     * @param cellPadding  Default value is 2
     */
    public void setCellPadding(int cellPadding) {
        setAttribute("cellPadding", cellPadding, true);
    }

    /**
     * The amount of empty space, in pixels, surrounding each value in its cell.
     *
     * @return int
     */
    public int getCellPadding()  {
        return getAttributeAsInt("cellPadding");
    }
    

    /**
     * Name of the Smart GWT Class to be used when creating charts.  Must support the Chart interface.
     *
     * @param chartConstructor  Default value is "FacetChart"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setChartConstructor(String chartConstructor)  throws IllegalStateException {
        setAttribute("chartConstructor", chartConstructor, false);
    }

    /**
     * Name of the Smart GWT Class to be used when creating charts.  Must support the Chart interface.
     *
     * @return String
     */
    public String getChartConstructor()  {
        return getAttributeAsString("chartConstructor");
    }
    

    /**
     * Default type of chart to plot.
     *
     * @param chartType  Default value is "Column"
     */
    public void setChartType(ChartType chartType) {
        setAttribute("chartType", chartType == null ? null : chartType.getValue(), true);
    }

    /**
     * Default type of chart to plot.
     *
     * @return ChartType
     */
    public ChartType getChartType()  {
        return EnumUtil.getEnum(ChartType.values(), getAttribute("chartType"));
    }
    
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for an unselected row. If
     * unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} will be used. Note
     * that the special value "blank" means that no image will be shown.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param checkboxFieldFalseImage  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintCheckboxFieldFalseImage
     */
    public void setCheckboxFieldFalseImage(String checkboxFieldFalseImage) {
        setAttribute("checkboxFieldFalseImage", checkboxFieldFalseImage, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for an unselected row. If
     * unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} will be used. Note
     * that the special value "blank" means that no image will be shown.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintCheckboxFieldFalseImage
     */
    public String getCheckboxFieldFalseImage()  {
        return getAttributeAsString("checkboxFieldFalseImage");
    }
    
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property may be set to govern the height of the checkbox image displayed to indicate
     * whether a row is selected. If unset, the checkboxField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageHeight booleanImageHeight} for this grid.
     *
     * @param checkboxFieldImageHeight  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setCheckboxFieldImageHeight(Integer checkboxFieldImageHeight)  throws IllegalStateException {
        setAttribute("checkboxFieldImageHeight", checkboxFieldImageHeight, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property may be set to govern the height of the checkbox image displayed to indicate
     * whether a row is selected. If unset, the checkboxField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageHeight booleanImageHeight} for this grid.
     *
     * @return Integer
     */
    public Integer getCheckboxFieldImageHeight()  {
        return getAttributeAsInt("checkboxFieldImageHeight");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property may be set to govern the width of the checkbox image displayed to indicate whether
     * a row is selected. If unset, the checkboxField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageWidth booleanImageWidth} for this grid.
     *
     * @param checkboxFieldImageWidth  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setCheckboxFieldImageWidth(Integer checkboxFieldImageWidth)  throws IllegalStateException {
        setAttribute("checkboxFieldImageWidth", checkboxFieldImageWidth, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property may be set to govern the width of the checkbox image displayed to indicate whether
     * a row is selected. If unset, the checkboxField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageWidth booleanImageWidth} for this grid.
     *
     * @return Integer
     */
    public Integer getCheckboxFieldImageWidth()  {
        return getAttributeAsInt("checkboxFieldImageWidth");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for a partially selected
     * row. If unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} will be
     * used. Note that the special value "blank" means that no image will be shown.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param checkboxFieldPartialImage  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintCheckboxFieldPartialImage
     */
    public void setCheckboxFieldPartialImage(String checkboxFieldPartialImage) {
        setAttribute("checkboxFieldPartialImage", checkboxFieldPartialImage, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for a partially selected
     * row. If unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} will be
     * used. Note that the special value "blank" means that no image will be shown.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintCheckboxFieldPartialImage
     */
    public String getCheckboxFieldPartialImage()  {
        return getAttributeAsString("checkboxFieldPartialImage");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for a selected row. If
     * unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} will be used. Note
     * that the special value "blank" means that no image will be shown.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param checkboxFieldTrueImage  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#setPrintCheckboxFieldTrueImage
     */
    public void setCheckboxFieldTrueImage(String checkboxFieldTrueImage) {
        setAttribute("checkboxFieldTrueImage", checkboxFieldTrueImage, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance} is set to
     * <code>"checkbox"</code> this property determines the image to display in the checkbox field for a selected row. If
     * unset, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} will be used. Note
     * that the special value "blank" means that no image will be shown.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldImageHeight
     * @see com.smartgwt.client.widgets.grid.ListGrid#getPrintCheckboxFieldTrueImage
     */
    public String getCheckboxFieldTrueImage()  {
        return getAttributeAsString("checkboxFieldTrueImage");
    }
    

    /**
     * For {@link com.smartgwt.client.types.ExpansionMode expansionModes} that show another grid or tree, what the child's
     * expansionMode should be. <P>Default value <code>null</code> means no further expansion.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param childExpansionMode  Default value is null
     */
    public void setChildExpansionMode(ExpansionMode childExpansionMode) {
        setAttribute("childExpansionMode", childExpansionMode == null ? null : childExpansionMode.getValue(), true);
    }

    /**
     * For {@link com.smartgwt.client.types.ExpansionMode expansionModes} that show another grid or tree, what the child's
     * expansionMode should be. <P>Default value <code>null</code> means no further expansion.
     *
     * @return ExpansionMode
     */
    public ExpansionMode getChildExpansionMode()  {
        return EnumUtil.getEnum(ExpansionMode.values(), getAttribute("childExpansionMode"));
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to clear any existing sort on all fields.  This menu-item is
     * displayed only in the context menu for the sorter button.
     *
     * @param clearAllSortingText  Default value is "Clear All Sorting"
     */
    public void setClearAllSortingText(String clearAllSortingText) {
        setAttribute("clearAllSortingText", clearAllSortingText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to clear any existing sort on all fields.  This menu-item is
     * displayed only in the context menu for the sorter button.
     *
     * @return String
     */
    public String getClearAllSortingText()  {
        return getAttributeAsString("clearAllSortingText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter-editor} is visible, this
     * attribute will be shown as the menu item title to clear any existing filter.  This menu-item is displayed only in the
     * context menu for the sorter button.
     *
     * @param clearFilterText  Default value is "Clear Filter"
     */
    public void setClearFilterText(String clearFilterText) {
        setAttribute("clearFilterText", clearFilterText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor filter-editor} is visible, this
     * attribute will be shown as the menu item title to clear any existing filter.  This menu-item is displayed only in the
     * context menu for the sorter button.
     *
     * @return String
     */
    public String getClearFilterText()  {
        return getAttributeAsString("clearFilterText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to clear an existing sort on this field.
     *
     * @param clearSortFieldText  Default value is "Clear Sort"
     */
    public void setClearSortFieldText(String clearSortFieldText) {
        setAttribute("clearSortFieldText", clearSortFieldText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to clear an existing sort on this field.
     *
     * @return String
     */
    public String getClearSortFieldText()  {
        return getAttributeAsString("clearSortFieldText");
    }
    

    /**
     * Whether the ListGrid should manage the clipping of titles of header buttons, showing ellipses if the title is clipped,
     * and potentially showing the full title on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowClippedHeaderTitlesOnHover hover}. <p> In some cases this may be
     * preferable to the button component's default clipping behavior because if a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSortArrow sort arrow} or sort numeral is displayed for a header, then
     * the button's default clipping behavior may clip the sort arrow/numeral whereas ListGrid-managed title clipping utilizes
     * special HTML which keeps the sort arrow/numeral visible. <p> This feature is automatically enabled if supported by the
     * browser. The only supported use of this attribute is to <em>disable</em> the feature by setting clipHeaderTitles to
     * false. <P> Note that this feature is incompatible with {@link com.smartgwt.client.widgets.grid.ListGridField#getWrap
     * wrap}, and will automatically be disabled for wrapping fields.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param clipHeaderTitles  Default value is varies
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public void setClipHeaderTitles(Boolean clipHeaderTitles)  throws IllegalStateException {
        setAttribute("clipHeaderTitles", clipHeaderTitles, false);
    }

    /**
     * Whether the ListGrid should manage the clipping of titles of header buttons, showing ellipses if the title is clipped,
     * and potentially showing the full title on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowClippedHeaderTitlesOnHover hover}. <p> In some cases this may be
     * preferable to the button component's default clipping behavior because if a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSortArrow sort arrow} or sort numeral is displayed for a header, then
     * the button's default clipping behavior may clip the sort arrow/numeral whereas ListGrid-managed title clipping utilizes
     * special HTML which keeps the sort arrow/numeral visible. <p> This feature is automatically enabled if supported by the
     * browser. The only supported use of this attribute is to <em>disable</em> the feature by setting clipHeaderTitles to
     * false. <P> Note that this feature is incompatible with {@link com.smartgwt.client.widgets.grid.ListGridField#getWrap
     * wrap}, and will automatically be disabled for wrapping fields.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public Boolean getClipHeaderTitles()  {
        return getAttributeAsBoolean("clipHeaderTitles");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanCollapseGroup canCollapseGroup} is true, will a click anywhere
     * on the group row toggle the group's expanded state? If false, the user must click the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupIcon groupIcon} directly to toggle the group.
     *
     * @param collapseGroupOnRowClick  Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setCollapseGroupOnRowClick(boolean collapseGroupOnRowClick)  throws IllegalStateException {
        setAttribute("collapseGroupOnRowClick", collapseGroupOnRowClick, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanCollapseGroup canCollapseGroup} is true, will a click anywhere
     * on the group row toggle the group's expanded state? If false, the user must click the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupIcon groupIcon} directly to toggle the group.
     *
     * @return boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public boolean getCollapseGroupOnRowClick()  {
        Boolean result = getAttributeAsBoolean("collapseGroupOnRowClick");
        return result == null ? true : result;
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and multi-grouping is enabled, this attribute is used as the title for a menu item that opens a {@link
     * com.smartgwt.client.widgets.MultiGroupDialog} to configure the grouping for this grid.
     *
     * @param configureGroupingText  Default value is "Configure Grouping..."
     */
    public void setConfigureGroupingText(String configureGroupingText) {
        setAttribute("configureGroupingText", configureGroupingText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and multi-grouping is enabled, this attribute is used as the title for a menu item that opens a {@link
     * com.smartgwt.client.widgets.MultiGroupDialog} to configure the grouping for this grid.
     *
     * @return String
     */
    public String getConfigureGroupingText()  {
        return getAttributeAsString("configureGroupingText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and multi-sorting is enabled, this attribute is used as the title for a menu item that opens a MultiSortDialog to
     * configure the sort-specification for this grid.  This menu-item is displayed only in the context menu for the sorter
     * button.
     *
     * @param configureSortText  Default value is "Configure Sort..."
     */
    public void setConfigureSortText(String configureSortText) {
        setAttribute("configureSortText", configureSortText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and multi-sorting is enabled, this attribute is used as the title for a menu item that opens a MultiSortDialog to
     * configure the sort-specification for this grid.  This menu-item is displayed only in the context menu for the sorter
     * button.
     *
     * @return String
     */
    public String getConfigureSortText()  {
        return getAttributeAsString("configureSortText");
    }
    

    /**
     * If this is an editable listGrid, when the user attempts to cancel an edit, should we display a confirmation prompt
     * before discarding the edited values for the record?
     *
     * @param confirmCancelEditing  Default value is false
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setConfirmCancelEditing(Boolean confirmCancelEditing) {
        setAttribute("confirmCancelEditing", confirmCancelEditing, true);
    }

    /**
     * If this is an editable listGrid, when the user attempts to cancel an edit, should we display a confirmation prompt
     * before discarding the edited values for the record?
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getConfirmCancelEditing()  {
        Boolean result = getAttributeAsBoolean("confirmCancelEditing");
        return result == null ? false : result;
    }
    

    /**
     * For editable listGrids, outstanding unsaved edits when the user performs a new filter or sort will be discarded. This
     * flag determines whether we should display a confirmation dialog with options to save or discard the edits, or cancel the
     * action in this case.
     *
     * @param confirmDiscardEdits  Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setConfirmDiscardEdits(Boolean confirmDiscardEdits) {
        setAttribute("confirmDiscardEdits", confirmDiscardEdits, true);
    }

    /**
     * For editable listGrids, outstanding unsaved edits when the user performs a new filter or sort will be discarded. This
     * flag determines whether we should display a confirmation dialog with options to save or discard the edits, or cancel the
     * action in this case.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getConfirmDiscardEdits()  {
        Boolean result = getAttributeAsBoolean("confirmDiscardEdits");
        return result == null ? true : result;
    }
    

    /**
     * If <code>this.confirmDiscardEdits</code> is true, this property can be used to customize the error message string
     * displayed to the user in a dialog with options to cancel the action, or save or discard pending edits in response to
     * sort/filter actions that would otherwise drop unsaved edit values.
     *
     * @param confirmDiscardEditsMessage  Default value is "This action will discard unsaved changes for this list."
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setConfirmDiscardEditsMessage(String confirmDiscardEditsMessage) {
        setAttribute("confirmDiscardEditsMessage", confirmDiscardEditsMessage, true);
    }

    /**
     * If <code>this.confirmDiscardEdits</code> is true, this property can be used to customize the error message string
     * displayed to the user in a dialog with options to cancel the action, or save or discard pending edits in response to
     * sort/filter actions that would otherwise drop unsaved edit values.
     *
     * @return String
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getConfirmDiscardEditsMessage()  {
        return getAttributeAsString("confirmDiscardEditsMessage");
    }
    

    /**
     * A list of ListGridRecord objects, specifying the data to be used to populate the ListGrid.  In ListGrids, the data array
     * specifies rows. <p> When using a {@link com.smartgwt.client.data.DataSource}, rather than directly provide
     * <code>data</code>, you will typically call {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData
     * ListGrid.fetchData()} instead, which will automatically establish <code>data</code> as a {@link
     * com.smartgwt.client.data.ResultSet} (see the {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData
     * ListGrid.fetchData()} docs for details). <p> If you call <code>fetchData</code>, any previously supplied
     * <code>data</code> is discarded.  Also, it is not necessary to call <code>setData()</code> after calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()}. <p> When calling <code>setData()</code>, if
     * <code>data</code> is provided as a RecordList or ResultSet, direct changes to the list such as adding or removing
     * records will be automatically observed and the ListGrid will redraw in response.  Direct changes to individual Records
     * will not be automatically observed and require calls to {@link com.smartgwt.client.widgets.grid.ListGrid#refreshCell
     * ListGrid.refreshCell()} or {@link com.smartgwt.client.widgets.grid.ListGrid#refreshRow ListGrid.refreshRow()} to cause
     * the ListGrid to visually update.  Calling methods such as {@link com.smartgwt.client.widgets.grid.ListGrid#updateData
     * ListGrid.updateData()}, {@link com.smartgwt.client.widgets.grid.ListGrid#removeData ListGrid.removeData()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addData ListGrid.addData()} always causes automatic visual refresh.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Provides a new data set to the ListGrid after the grid has been created or drawn. The ListGrid will redraw to show the new data automatically.
     *
     * @param data data to show in the list. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridRecord
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_inline_data" target="examples">Inline data Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_local_data" target="examples">Local data Example</a>
     */
    public void setData(ListGridRecord... data) {
        setAttribute("data", data, true);
    }
    

    /**
     * How to fetch and manage records retrieve from the server.  See {@link com.smartgwt.client.types.FetchMode}. <P> This
     * setting only applies to the {@link com.smartgwt.client.data.ResultSet} automatically created by calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}.  If a pre-existing ResultSet is passed to setData()
     * instead, it's existing setting for {@link com.smartgwt.client.data.ResultSet#getFetchMode fetchMode} applies.
     *
     * @param dataFetchMode  Default value is "paged"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public void setDataFetchMode(FetchMode dataFetchMode)  throws IllegalStateException {
        setAttribute("dataFetchMode", dataFetchMode == null ? null : dataFetchMode.getValue(), false);
    }

    /**
     * How to fetch and manage records retrieve from the server.  See {@link com.smartgwt.client.types.FetchMode}. <P> This
     * setting only applies to the {@link com.smartgwt.client.data.ResultSet} automatically created by calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData fetchData()}.  If a pre-existing ResultSet is passed to setData()
     * instead, it's existing setting for {@link com.smartgwt.client.data.ResultSet#getFetchMode fetchMode} applies.
     *
     * @return FetchMode
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public FetchMode getDataFetchMode()  {
        return EnumUtil.getEnum(FetchMode.values(), getAttribute("dataFetchMode"));
    }
    
    
    
    

    /**
     * How should Date type values be displayed in this ListGrid by default? <P> This property specifies the default
     * DateDisplayFormat to apply to Date values displayed in this grid for all fields except those of {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getType type "time"} (See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getTimeFormatter timeFormatter}).<br> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDatetimeFormatter datetimeFormatter} is specified, that will be applied by
     * default to fields of type <code>"datetime"</code>. <P> Note that if {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter dateFormatter} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getTimeFormatter timeFormatter} are specified those properties will take
     * precedence over the component level settings. <P> If unset, date values will be formatted according to the system wide
     * {@link com.smartgwt.client.util.Date#setShortDisplayFormat short display format} or {@link
     * com.smartgwt.client.util.Date#setShortDatetimeDisplayFormat short datetime display format} for datetime type fields. <P>
     * If this field is editable the dateFormatter will also be passed to the editor created to edit this field as {@link
     * com.smartgwt.client.widgets.form.fields.DateItem#getDateFormatter dateFormatter}. In this case you may also need to set
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDateInputFormat dateInputFormat}.
     *
     * @param dateFormatter  Default value is null
     */
    public void setDateFormatter(DateDisplayFormat dateFormatter) {
        setAttribute("dateFormatter", dateFormatter == null ? null : dateFormatter.getValue(), true);
    }

    /**
     * How should Date type values be displayed in this ListGrid by default? <P> This property specifies the default
     * DateDisplayFormat to apply to Date values displayed in this grid for all fields except those of {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getType type "time"} (See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getTimeFormatter timeFormatter}).<br> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDatetimeFormatter datetimeFormatter} is specified, that will be applied by
     * default to fields of type <code>"datetime"</code>. <P> Note that if {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter dateFormatter} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getTimeFormatter timeFormatter} are specified those properties will take
     * precedence over the component level settings. <P> If unset, date values will be formatted according to the system wide
     * {@link com.smartgwt.client.util.Date#setShortDisplayFormat short display format} or {@link
     * com.smartgwt.client.util.Date#setShortDatetimeDisplayFormat short datetime display format} for datetime type fields. <P>
     * If this field is editable the dateFormatter will also be passed to the editor created to edit this field as {@link
     * com.smartgwt.client.widgets.form.fields.DateItem#getDateFormatter dateFormatter}. In this case you may also need to set
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDateInputFormat dateInputFormat}.
     *
     * @return DateDisplayFormat
     */
    public DateDisplayFormat getDateFormatter()  {
        return EnumUtil.getEnum(DateDisplayFormat.values(), getAttribute("dateFormatter"));
    }
    

    /**
     * If this is an editable listGrid, this property will specify the {@link
     * com.smartgwt.client.widgets.form.fields.DateItem#getInputFormat inputFormat} applied to editors for fields of type
     * <code>"date"</code>. May be overridden per field via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getInputFormat inputFormat}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param dateInputFormat  See {@link com.smartgwt.client.docs.DateInputFormat DateInputFormat} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setDateFormatter
     */
    public void setDateInputFormat(String dateInputFormat) {
        setAttribute("dateInputFormat", dateInputFormat, true);
    }
    

    /**
     * Display format to use for fields specified as type 'datetime'.  Default is to use the system-wide default date time
     * format, configured via {@link com.smartgwt.client.util.Date#setShortDatetimeDisplayFormat
     * Date.setShortDatetimeDisplayFormat()}.  Specify any valid {@link com.smartgwt.client.types.DateDisplayFormat} to change
     * the display format for datetimes used by this grid.  <P> May also be specified at the field level via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter dateFormatter} <P> If this field is editable the
     * dateFormatter will also be passed to the editor created to edit this field as {@link
     * com.smartgwt.client.widgets.form.fields.DateItem#getDateFormatter dateFormatter}. In this case you may also need to set
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDateInputFormat dateInputFormat}.
     *
     * @param datetimeFormatter  Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField#setDateFormatter
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setDatetimeFormatter(DateDisplayFormat datetimeFormatter) {
        setAttribute("datetimeFormatter", datetimeFormatter == null ? null : datetimeFormatter.getValue(), true);
    }

    /**
     * Display format to use for fields specified as type 'datetime'.  Default is to use the system-wide default date time
     * format, configured via {@link com.smartgwt.client.util.Date#setShortDatetimeDisplayFormat
     * Date.setShortDatetimeDisplayFormat()}.  Specify any valid {@link com.smartgwt.client.types.DateDisplayFormat} to change
     * the display format for datetimes used by this grid.  <P> May also be specified at the field level via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter dateFormatter} <P> If this field is editable the
     * dateFormatter will also be passed to the editor created to edit this field as {@link
     * com.smartgwt.client.widgets.form.fields.DateItem#getDateFormatter dateFormatter}. In this case you may also need to set
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDateInputFormat dateInputFormat}.
     *
     * @return DateDisplayFormat
     * @see com.smartgwt.client.widgets.grid.ListGridField#getDateFormatter
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public DateDisplayFormat getDatetimeFormatter()  {
        return EnumUtil.getEnum(DateDisplayFormat.values(), getAttribute("datetimeFormatter"));
    }
    

    /**
     * An array of listGrid field configuration objects.  When a listGrid is initialized, if this property is set and there is
     * no value for the <code>fields</code> attribute, this.fields will be defaulted to a generated array of field objects
     * duplicated from this array. <P> This property is useful for cases where a standard set of fields will be displayed in
     * multiple listGrids - for example a subclass of ListGrid intended to display a particular type of data:<br> In this
     * example we would not assign a single {@link com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array directly
     * to the class via <code>addProperties()</code> as every generated instance of this class would then point to the same
     * fields array object. This would cause unexpected behavior such as changes to the field order in one grid effecting other
     * grids on the page.<br> Instead we could use <code>addProperties()</code> on our new subclass to set
     * <code>defaultFields</code> to a standard array of fields to display. Each generated instance of the subclass would then
     * show up with default fields duplicated from this array.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param defaultFields  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setDefaultFields(ListGridField... defaultFields)  throws IllegalStateException {
        setAttribute("defaultFields", defaultFields, false);
    }

    /**
     * An array of listGrid field configuration objects.  When a listGrid is initialized, if this property is set and there is
     * no value for the <code>fields</code> attribute, this.fields will be defaulted to a generated array of field objects
     * duplicated from this array. <P> This property is useful for cases where a standard set of fields will be displayed in
     * multiple listGrids - for example a subclass of ListGrid intended to display a particular type of data:<br> In this
     * example we would not assign a single {@link com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array directly
     * to the class via <code>addProperties()</code> as every generated instance of this class would then point to the same
     * fields array object. This would cause unexpected behavior such as changes to the field order in one grid effecting other
     * grids on the page.<br> Instead we could use <code>addProperties()</code> on our new subclass to set
     * <code>defaultFields</code> to a standard array of fields to display. Each generated instance of the subclass would then
     * show up with default fields duplicated from this array.
     *
     * @return ListGridField...
     */
    public ListGridField[] getDefaultFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfListGridField(getAttributeAsJavaScriptObject("defaultFields"));
    }
    

    /**
     * When enabled, the field shown by {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}
     * causes records to be marked for future removal via {@link com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved
     * ListGrid.markRecordRemoved()} instead of immediately being removed. <P> When a record has been marked for removal, an
     * icon in the <code>canRemoveRecords</code> field allowing it to be unmarked will be displayed. <P> If not explicitly
     * specified by this property, removal of records will be deferred if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits} is false for the grid.
     *
     * @param deferRemoval  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setDeferRemoval(Boolean deferRemoval)  throws IllegalStateException {
        setAttribute("deferRemoval", deferRemoval, false);
    }

    /**
     * When enabled, the field shown by {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}
     * causes records to be marked for future removal via {@link com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved
     * ListGrid.markRecordRemoved()} instead of immediately being removed. <P> When a record has been marked for removal, an
     * icon in the <code>canRemoveRecords</code> field allowing it to be unmarked will be displayed. <P> If not explicitly
     * specified by this property, removal of records will be deferred if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits} is false for the grid.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getDeferRemoval()  {
        return getAttributeAsBoolean("deferRemoval");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>"related"</code>, this property specifies the
     * dataSource for the related records grid to be shown embedded in expanded records. <P> This property may also be
     * specified on a per-record basis - see {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordDetailDSProperty
     * recordDetailDSProperty}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param detailDS  Default value is null
     */
    public void setDetailDS(String detailDS) {
        setAttribute("detailDS", detailDS, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>"related"</code>, this property specifies the
     * dataSource for the related records grid to be shown embedded in expanded records. <P> This property may also be
     * specified on a per-record basis - see {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordDetailDSProperty
     * recordDetailDSProperty}
     *
     * @return String
     */
    public String getDetailDS()  {
        return getAttributeAsString("detailDS");
    }
    

    /**
     * The field whose contents to show in the expanded portion of a record when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is <code>true</code> and {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>detailField</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param detailField  Default value is null
     */
    public void setDetailField(String detailField) {
        setAttribute("detailField", detailField, true);
    }

    /**
     * The field whose contents to show in the expanded portion of a record when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is <code>true</code> and {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>detailField</code>.
     *
     * @return String
     */
    public String getDetailField()  {
        return getAttributeAsString("detailField");
    }
    

    /**
     * If a user is editing a {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit:true} listGrid, and they hide
     * a field while the editor is showing, should we discard any edits in the edit row for the field being hidden? <P> Default
     * behavior is to discard the edits - set this flag to false to preserve edits <P> Note that the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDropCriteriaOnHideField dropCriteriaOnHideField} attribute allows
     * developers to  control behavior for filter-editor criteria when a field is hidden.
     *
     * @param discardEditsOnHideField  Default value is true
     */
    public void setDiscardEditsOnHideField(boolean discardEditsOnHideField) {
        setAttribute("discardEditsOnHideField", discardEditsOnHideField, true);
    }

    /**
     * If a user is editing a {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit:true} listGrid, and they hide
     * a field while the editor is showing, should we discard any edits in the edit row for the field being hidden? <P> Default
     * behavior is to discard the edits - set this flag to false to preserve edits <P> Note that the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDropCriteriaOnHideField dropCriteriaOnHideField} attribute allows
     * developers to  control behavior for filter-editor criteria when a field is hidden.
     *
     * @return boolean
     */
    public boolean getDiscardEditsOnHideField()  {
        Boolean result = getAttributeAsBoolean("discardEditsOnHideField");
        return result == null ? true : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getConfirmDiscardEdits confirmDiscardEdits} is true this is the
     * title for the save button appearing in the lost edits confirmation dialog. Override this for localization if necessary.
     *
     * @param discardEditsSaveButtonTitle  Default value is "Save"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setDiscardEditsSaveButtonTitle(String discardEditsSaveButtonTitle) {
        setAttribute("discardEditsSaveButtonTitle", discardEditsSaveButtonTitle, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getConfirmDiscardEdits confirmDiscardEdits} is true this is the
     * title for the save button appearing in the lost edits confirmation dialog. Override this for localization if necessary.
     *
     * @return String
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getDiscardEditsSaveButtonTitle()  {
        return getAttributeAsString("discardEditsSaveButtonTitle");
    }
    
    

    /**
     * When records are being dragged from within a ListGrid, what sort of drag-tracker should be displayed?<br> Note that if
     * multiple records are being dragged the displayed tracker will be based on the first selected record.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param dragTrackerMode  Default value is "icon"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setDragTrackerMode(DragTrackerMode dragTrackerMode)  throws IllegalStateException {
        setAttribute("dragTrackerMode", dragTrackerMode == null ? null : dragTrackerMode.getValue(), false);
    }

    /**
     * When records are being dragged from within a ListGrid, what sort of drag-tracker should be displayed?<br> Note that if
     * multiple records are being dragged the displayed tracker will be based on the first selected record.
     *
     * @return DragTrackerMode
     */
    public DragTrackerMode getDragTrackerMode()  {
        return EnumUtil.getEnum(DragTrackerMode.values(), getAttribute("dragTrackerMode"));
    }
    
    

    /**
     * How far should we render rows ahead of the currently visible area?  This is expressed as a ratio from viewport size to
     * rendered area size. <P> Tweaking drawAheadRatio allows you to make tradeoffs between continuous scrolling speed vs
     * initial render time and render time when scrolling by large amounts. <P> NOTE: Only applies when showAllRows is false.
     *
     * @param drawAheadRatio  Default value is 1.3
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_dataoperations_fetch" target="examples">Databound fetch Example</a>
     */
    public void setDrawAheadRatio(float drawAheadRatio) {
        setAttribute("drawAheadRatio", drawAheadRatio, true);
    }

    /**
     * How far should we render rows ahead of the currently visible area?  This is expressed as a ratio from viewport size to
     * rendered area size. <P> Tweaking drawAheadRatio allows you to make tradeoffs between continuous scrolling speed vs
     * initial render time and render time when scrolling by large amounts. <P> NOTE: Only applies when showAllRows is false.
     *
     * @return float
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_dataoperations_fetch" target="examples">Databound fetch Example</a>
     */
    public float getDrawAheadRatio()  {
        return getAttributeAsFloat("drawAheadRatio");
    }
    

    /**
     * If drawing all rows would cause less than <code>drawAllMaxCells</code> cells to be rendered, the full dataset will
     * instead be drawn even if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllRecords showAllRecords} is false and
     * the viewport size and {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} setting would
     * normally have caused incremental rendering to be used. <P> The <code>drawAllMaxCells</code> setting prevents incremental
     * rendering from being used in situations where it's really unnecessary, such as a 40 row, 5 column dataset (only 200
     * cells) which happens to be in a grid with a viewport showing only 20 or so rows. Incremental rendering causes a brief
     * "flash" during scrolling as the visible portion of the dataset is redrawn, and a better scrolling experience can be
     * obtained in this situation by drawing the entire dataset up front, which in this example would have negligible effect on
     * initial draw time. <P> <code>drawAllMaxCells:0</code> disables this features.  You may want to disable this feature if
     * performance is an issue and: <ul> <li> you are very frequently redraw a grid <li> you do a lot of computation when
     * rendering each cell (eg formulas) <li> you are showing many grids on one screen and the user won't scroll most of them
     * </ul>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param drawAllMaxCells  Default value is 250
     */
    public void setDrawAllMaxCells(int drawAllMaxCells) {
        setAttribute("drawAllMaxCells", drawAllMaxCells, true);
    }

    /**
     * If drawing all rows would cause less than <code>drawAllMaxCells</code> cells to be rendered, the full dataset will
     * instead be drawn even if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowAllRecords showAllRecords} is false and
     * the viewport size and {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} setting would
     * normally have caused incremental rendering to be used. <P> The <code>drawAllMaxCells</code> setting prevents incremental
     * rendering from being used in situations where it's really unnecessary, such as a 40 row, 5 column dataset (only 200
     * cells) which happens to be in a grid with a viewport showing only 20 or so rows. Incremental rendering causes a brief
     * "flash" during scrolling as the visible portion of the dataset is redrawn, and a better scrolling experience can be
     * obtained in this situation by drawing the entire dataset up front, which in this example would have negligible effect on
     * initial draw time. <P> <code>drawAllMaxCells:0</code> disables this features.  You may want to disable this feature if
     * performance is an issue and: <ul> <li> you are very frequently redraw a grid <li> you do a lot of computation when
     * rendering each cell (eg formulas) <li> you are showing many grids on one screen and the user won't scroll most of them
     * </ul>
     *
     * @return int
     */
    public int getDrawAllMaxCells()  {
        return getAttributeAsInt("drawAllMaxCells");
    }
    

    /**
     * For ListGrids with {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} set to true,
     * if the user hides a field, should we discard the criteria for the hidden field when the user next performs a  filter?
     * This is an equivalent of using the AutoChild system to set  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDiscardEditsOnHideField discardEditsOnHideField} on the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filterEditor}.
     *
     * @param dropCriteriaOnHideField  Default value is true
     */
    public void setDropCriteriaOnHideField(boolean dropCriteriaOnHideField) {
        setAttribute("dropCriteriaOnHideField", dropCriteriaOnHideField, true);
    }

    /**
     * For ListGrids with {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} set to true,
     * if the user hides a field, should we discard the criteria for the hidden field when the user next performs a  filter?
     * This is an equivalent of using the AutoChild system to set  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDiscardEditsOnHideField discardEditsOnHideField} on the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor filterEditor}.
     *
     * @return boolean
     */
    public boolean getDropCriteriaOnHideField()  {
        Boolean result = getAttributeAsBoolean("dropCriteriaOnHideField");
        return result == null ? true : result;
    }
    

    /**
     * Determines whether when the user edits a cell in this listGrid the entire row becomes editable, or just the cell that
     * received the edit event. <P> No effect if this.canEdit is false or null.
     *
     * @param editByCell  Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCanEdit
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_cell" target="examples">Edit by cell Example</a>
     */
    public void setEditByCell(Boolean editByCell) {
        setAttribute("editByCell", editByCell, true);
    }

    /**
     * Determines whether when the user edits a cell in this listGrid the entire row becomes editable, or just the cell that
     * received the edit event. <P> No effect if this.canEdit is false or null.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCanEdit
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_cell" target="examples">Edit by cell Example</a>
     */
    public Boolean getEditByCell()  {
        return getAttributeAsBoolean("editByCell");
    }
    

    /**
     * Event that will trigger inline editing, see {@link com.smartgwt.client.types.ListGridEditEvent} for options. <P> Note
     * this setting has no effect unless {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit} has been set to
     * enable editing. <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getEditOnFocus editOnFocus} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#startEditing ListGrid.startEditing()}.
     *
     * @param editEvent  Default value is "doubleClick"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_row" target="examples">Edit by row Example</a>
     */
    public void setEditEvent(ListGridEditEvent editEvent) {
        setAttribute("editEvent", editEvent == null ? null : editEvent.getValue(), true);
    }

    /**
     * Event that will trigger inline editing, see {@link com.smartgwt.client.types.ListGridEditEvent} for options. <P> Note
     * this setting has no effect unless {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit} has been set to
     * enable editing. <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getEditOnFocus editOnFocus} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#startEditing ListGrid.startEditing()}.
     *
     * @return ListGridEditEvent
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_row" target="examples">Edit by row Example</a>
     */
    public ListGridEditEvent getEditEvent()  {
        return EnumUtil.getEnum(ListGridEditEvent.values(), getAttribute("editEvent"));
    }
    

    /**
     * A base name for the CSS class applied to cells when editing has failed.<br>  If this listGrid is editable, this style
     * will be applied to any edited cells for which  validation failed.<br>  As with the default 'baseStyle' property, this
     * style will have "Dark", "Over", "Selected",  or "Disabled" appended to it according to the state of the cell.<br> If
     * null, cells for which editing has failed will be rendered using the normal base style classNames, but with custom
     * CSSText applied as derived from <code>this.editFailedCSSText</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editFailedBaseStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGrid#setEditFailedCSSText
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setEditFailedBaseStyle(String editFailedBaseStyle) {
        setAttribute("editFailedBaseStyle", editFailedBaseStyle, true);
    }

    /**
     * A base name for the CSS class applied to cells when editing has failed.<br>  If this listGrid is editable, this style
     * will be applied to any edited cells for which  validation failed.<br>  As with the default 'baseStyle' property, this
     * style will have "Dark", "Over", "Selected",  or "Disabled" appended to it according to the state of the cell.<br> If
     * null, cells for which editing has failed will be rendered using the normal base style classNames, but with custom
     * CSSText applied as derived from <code>this.editFailedCSSText</code>
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEditFailedCSSText
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getEditFailedBaseStyle()  {
        return getAttributeAsString("editFailedBaseStyle");
    }
    

    /**
     * Custom CSS text to be applied to cells when editing has failed.<br>  If this listGrid is editable, this css text will be
     * applied to any edited cells for which  validation failed, on top of the base style for the cell.<br> For further
     * customization of styling for cells that failed editing validation, use <code>this.editFailedBaseStyle</code> instead.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editFailedCSSText  Default value is "color:red;border:1px solid red;"
     * @see com.smartgwt.client.widgets.grid.ListGrid#setEditFailedBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setEditFailedCSSText(String editFailedCSSText) {
        setAttribute("editFailedCSSText", editFailedCSSText, true);
    }

    /**
     * Custom CSS text to be applied to cells when editing has failed.<br>  If this listGrid is editable, this css text will be
     * applied to any edited cells for which  validation failed, on top of the base style for the cell.<br> For further
     * customization of styling for cells that failed editing validation, use <code>this.editFailedBaseStyle</code> instead.
     *
     * @return String
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEditFailedBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getEditFailedCSSText()  {
        return getAttributeAsString("editFailedCSSText");
    }
    

    /**
     * Should we start editing when the widget has focus and the user presses the "f2" key (if this ListGrid supports editing)?
     * <P> Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is set to <code>"click"</code>
     * or <code>"doubleClick"</code>, the <code>Space</code> or <code>Enter</code> key may also be used to start editing,
     * depending on the value for {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnSpace
     * generateClickOnSpace}, {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnSpace
     * generateDoubleClickOnSpace}, {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnEnter
     * generateClickOnEnter} and {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnEnter
     * generateDoubleClickOnEnter}. <P> If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit} is false, or
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is set to "none" this property has no effect.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editOnF2Keypress  Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setEditOnF2Keypress(Boolean editOnF2Keypress) {
        setAttribute("editOnF2Keypress", editOnF2Keypress, true);
    }

    /**
     * Should we start editing when the widget has focus and the user presses the "f2" key (if this ListGrid supports editing)?
     * <P> Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is set to <code>"click"</code>
     * or <code>"doubleClick"</code>, the <code>Space</code> or <code>Enter</code> key may also be used to start editing,
     * depending on the value for {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnSpace
     * generateClickOnSpace}, {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnSpace
     * generateDoubleClickOnSpace}, {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateClickOnEnter
     * generateClickOnEnter} and {@link com.smartgwt.client.widgets.grid.ListGrid#getGenerateDoubleClickOnEnter
     * generateDoubleClickOnEnter}. <P> If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit canEdit} is false, or
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is set to "none" this property has no effect.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getEditOnF2Keypress()  {
        Boolean result = getAttributeAsBoolean("editOnF2Keypress");
        return result == null ? true : result;
    }
    

    /**
     * Should we start editing when this widget receives focus (if this ListGrid supports editing)? <P> Note that this property
     * being set to true will cause editing to occur on a single click, even if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is <code>"doubleClick"</code>, because single clicking
     * the grid will place keyboard focus there automatically. <P> If this property is set together with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getListEndEditAction listEndEditAction} being set to "next",  users can create
     * a new edit row in an empty grid by simply tabbing into the grid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editOnFocus  Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setEditOnFocus(Boolean editOnFocus) {
        setAttribute("editOnFocus", editOnFocus, true);
    }

    /**
     * Should we start editing when this widget receives focus (if this ListGrid supports editing)? <P> Note that this property
     * being set to true will cause editing to occur on a single click, even if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditEvent editEvent} is <code>"doubleClick"</code>, because single clicking
     * the grid will place keyboard focus there automatically. <P> If this property is set together with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getListEndEditAction listEndEditAction} being set to "next",  users can create
     * a new edit row in an empty grid by simply tabbing into the grid.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getEditOnFocus()  {
        return getAttributeAsBoolean("editOnFocus");
    }
    

    /**
     * A base name for the CSS class applied to cells containing pending (unsaved) edits<br> As with the default 'baseStyle'
     * property, this style will have "Dark", "Over", "Selected", or "Disabled" appended to it according to the state of the
     * cell. <P> If this property is null (the default setting), cells with pending edits will pick up custom css text to be
     * applied on top of the normal base style from <code>this.editPendingCSSText</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editPendingBaseStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setEditPendingBaseStyle(String editPendingBaseStyle)  throws IllegalStateException {
        setAttribute("editPendingBaseStyle", editPendingBaseStyle, false);
    }

    /**
     * A base name for the CSS class applied to cells containing pending (unsaved) edits<br> As with the default 'baseStyle'
     * property, this style will have "Dark", "Over", "Selected", or "Disabled" appended to it according to the state of the
     * cell. <P> If this property is null (the default setting), cells with pending edits will pick up custom css text to be
     * applied on top of the normal base style from <code>this.editPendingCSSText</code>.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getEditPendingBaseStyle()  {
        return getAttributeAsString("editPendingBaseStyle");
    }
    

    /**
     * Custom CSS text to be applied to cells with pending edits that have not yet been submitted.<br> For further
     * customization of styling for cells with pending edits use <code>this.editPendingBaseStyle</code> instead.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param editPendingCSSText  Default value is "color:#0066CC;"
     * @see com.smartgwt.client.widgets.grid.ListGrid#setEditFailedBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setEditPendingCSSText(String editPendingCSSText) {
        setAttribute("editPendingCSSText", editPendingCSSText, true);
    }

    /**
     * Custom CSS text to be applied to cells with pending edits that have not yet been submitted.<br> For further
     * customization of styling for cells with pending edits use <code>this.editPendingBaseStyle</code> instead.
     *
     * @return String
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEditFailedBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getEditPendingCSSText()  {
        return getAttributeAsString("editPendingCSSText");
    }
    

    /**
     * Default class used to construct the {@link com.smartgwt.client.tools.EditProxy} for this component when the component is
     * {@link com.smartgwt.client.widgets.Canvas#setEditMode first placed into edit mode}.
     *
     * @param editProxyConstructor  See {@link com.smartgwt.client.docs.SCClassName SCClassName} . Default value is "GridEditProxy"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setEditProxyConstructor(String editProxyConstructor)  throws IllegalStateException {
        setAttribute("editProxyConstructor", editProxyConstructor, false);
    }

    /**
     * Default class used to construct the {@link com.smartgwt.client.tools.EditProxy} for this component when the component is
     * {@link com.smartgwt.client.widgets.Canvas#setEditMode first placed into edit mode}.
     *
     * @return  See {@link com.smartgwt.client.docs.SCClassName SCClassName} 
     */
    public String getEditProxyConstructor()  {
        return getAttributeAsString("editProxyConstructor");
    }
    

    /**
     * The value to display for cells whose value is null or the empty string after applying {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter formatting} and valueMap (if any). <p> This is the grid-wide
     * attribute.  You may also set the emptyCellValue on a per-field basis.
     *
     * @param emptyCellValue  See {@link com.smartgwt.client.docs.HTMLString HTMLString} . Default value is "&amp;nbsp;"
     * @see com.smartgwt.client.widgets.grid.ListGridField#setEmptyCellValue
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_values" target="examples">Empty values Example</a>
     */
    public void setEmptyCellValue(String emptyCellValue) {
        setAttribute("emptyCellValue", emptyCellValue, true);
    }

    /**
     * The value to display for cells whose value is null or the empty string after applying {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter formatting} and valueMap (if any). <p> This is the grid-wide
     * attribute.  You may also set the emptyCellValue on a per-field basis.
     *
     * @return  See {@link com.smartgwt.client.docs.HTMLString HTMLString} 
     * @see com.smartgwt.client.widgets.grid.ListGridField#getEmptyCellValue
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_values" target="examples">Empty values Example</a>
     */
    public String getEmptyCellValue()  {
        return getAttributeAsString("emptyCellValue");
    }
    

    /**
     * The string to display in the body of a listGrid with an empty data array, if showEmptyMessage is true.
     *
     * @param emptyMessage  See {@link com.smartgwt.client.docs.HTMLString HTMLString} . Default value is "No items to show."
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_grid" target="examples">Empty grid Example</a>
     */
    public void setEmptyMessage(String emptyMessage) {
        setAttribute("emptyMessage", emptyMessage, true);
    }

    /**
     * The string to display in the body of a listGrid with an empty data array, if showEmptyMessage is true.
     *
     * @return  See {@link com.smartgwt.client.docs.HTMLString HTMLString} 
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_grid" target="examples">Empty grid Example</a>
     */
    public String getEmptyMessage()  {
        return getAttributeAsString("emptyMessage");
    }
    

    /**
     * The CSS style name applied to the {@link com.smartgwt.client.widgets.grid.ListGrid#getEmptyMessage emptyMessage} if
     * displayed.
     *
     * @param emptyMessageStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is "emptyMessage"
     */
    public void setEmptyMessageStyle(String emptyMessageStyle) {
        setAttribute("emptyMessageStyle", emptyMessageStyle, true);
    }

    /**
     * The CSS style name applied to the {@link com.smartgwt.client.widgets.grid.ListGrid#getEmptyMessage emptyMessage} if
     * displayed.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     */
    public String getEmptyMessageStyle()  {
        return getAttributeAsString("emptyMessageStyle");
    }
    

    /**
     * For performance reasons, even when {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights
     * fixedRecordHeights} is set, vertical clipping is not enforced by default for some kinds of content (such as images) on
     * all browsers. Set {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping enforceVClipping:true} to enforce
     * clipping for all types of content on all browsers. <P> This additional setting is likely to be phased out as browsers
     * improve.
     *
     * @param enforceVClipping  Default value is false
     */
    public void setEnforceVClipping(Boolean enforceVClipping) {
        setAttribute("enforceVClipping", enforceVClipping, true);
    }

    /**
     * For performance reasons, even when {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights
     * fixedRecordHeights} is set, vertical clipping is not enforced by default for some kinds of content (such as images) on
     * all browsers. Set {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping enforceVClipping:true} to enforce
     * clipping for all types of content on all browsers. <P> This additional setting is likely to be phased out as browsers
     * improve.
     *
     * @return Boolean
     */
    public Boolean getEnforceVClipping()  {
        Boolean result = getAttributeAsBoolean("enforceVClipping");
        return result == null ? false : result;
    }
    

    /**
     * What to do when a user hits enter while editing a cell: <ul> <li>"nextCell": start editing the next editable cell in
     * this record (or the first     editable cell in the next record if focus is in the last editable cell in the row)
     * <li>"nextRow": start editing the same field in the next row (skipping any rows where      that would be a non-editable
     * cell. <li>"nextRowStart": start editing the first editable cell in the next row. <li>"done": hide the editor (editing is
     * complete) </ul> Note that if this.autoSaveEdits is true, this may cause a save of the current edit values
     *
     * @param enterKeyEditAction  Default value is "done"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setEnterKeyEditAction(EnterKeyEditAction enterKeyEditAction) {
        setAttribute("enterKeyEditAction", enterKeyEditAction == null ? null : enterKeyEditAction.getValue(), true);
    }

    /**
     * What to do when a user hits enter while editing a cell: <ul> <li>"nextCell": start editing the next editable cell in
     * this record (or the first     editable cell in the next record if focus is in the last editable cell in the row)
     * <li>"nextRow": start editing the same field in the next row (skipping any rows where      that would be a non-editable
     * cell. <li>"nextRowStart": start editing the first editable cell in the next row. <li>"done": hide the editor (editing is
     * complete) </ul> Note that if this.autoSaveEdits is true, this may cause a save of the current edit values
     *
     * @return EnterKeyEditAction
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public EnterKeyEditAction getEnterKeyEditAction()  {
        return EnumUtil.getEnum(EnterKeyEditAction.values(), getAttribute("enterKeyEditAction"));
    }
    

    /**
     * In a ListGrid that has a DataSource and has filter criteria that include values for fields declared as {@link
     * com.smartgwt.client.types.FieldType type "enum"} in the DataSource, by default a newly edited row will use those filter
     * criteria as initial values. <P> For example, if a ListGrid is showing all Accounts that have status:"Active" and a new
     * row is created, the new row will default to status:"Active" unless this flag is set to false.
     *
     * @param enumCriteriaAsInitialValues  Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setEnumCriteriaAsInitialValues(Boolean enumCriteriaAsInitialValues)  throws IllegalStateException {
        setAttribute("enumCriteriaAsInitialValues", enumCriteriaAsInitialValues, false);
    }

    /**
     * In a ListGrid that has a DataSource and has filter criteria that include values for fields declared as {@link
     * com.smartgwt.client.types.FieldType type "enum"} in the DataSource, by default a newly edited row will use those filter
     * criteria as initial values. <P> For example, if a ListGrid is showing all Accounts that have status:"Active" and a new
     * row is created, the new row will default to status:"Active" unless this flag is set to false.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getEnumCriteriaAsInitialValues()  {
        Boolean result = getAttributeAsBoolean("enumCriteriaAsInitialValues");
        return result == null ? true : result;
    }
    

    /**
     * Height of the error icon, if we're showing icons when validation errors occur.
     *
     * @param errorIconHeight  Default value is 16
     */
    public void setErrorIconHeight(Integer errorIconHeight) {
        setAttribute("errorIconHeight", errorIconHeight, true);
    }

    /**
     * Height of the error icon, if we're showing icons when validation errors occur.
     *
     * @return Integer
     */
    public Integer getErrorIconHeight()  {
        return getAttributeAsInt("errorIconHeight");
    }
    

    /**
     * Src of the image to show as an error icon, if we're showing icons when validation      errors occur.
     *
     * @param errorIconSrc  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is "[SKIN]/ListGrid/validation_error_icon.png"
     */
    public void setErrorIconSrc(String errorIconSrc) {
        setAttribute("errorIconSrc", errorIconSrc, true);
    }

    /**
     * Src of the image to show as an error icon, if we're showing icons when validation      errors occur.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     */
    public String getErrorIconSrc()  {
        return getAttributeAsString("errorIconSrc");
    }
    

    /**
     * Height of the error icon, if we're showing icons when validation errors occur.
     *
     * @param errorIconWidth  Default value is 16
     */
    public void setErrorIconWidth(Integer errorIconWidth) {
        setAttribute("errorIconWidth", errorIconWidth, true);
    }

    /**
     * Height of the error icon, if we're showing icons when validation errors occur.
     *
     * @return Integer
     */
    public Integer getErrorIconWidth()  {
        return getAttributeAsInt("errorIconWidth");
    }
    

    /**
     * What to do when a user hits escape while editing a cell:<ul> <li>"cancel": close the editor and discard the current set
     * of edit values <li>"done": just close the editor (the edit is complete, but the edited values are retained). </ul> Note
     * that if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits} is true, this may cause a save
     * of the current edit values
     *
     * @param escapeKeyEditAction  Default value is "cancel"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setEscapeKeyEditAction(EscapeKeyEditAction escapeKeyEditAction) {
        setAttribute("escapeKeyEditAction", escapeKeyEditAction == null ? null : escapeKeyEditAction.getValue(), true);
    }

    /**
     * What to do when a user hits escape while editing a cell:<ul> <li>"cancel": close the editor and discard the current set
     * of edit values <li>"done": just close the editor (the edit is complete, but the edited values are retained). </ul> Note
     * that if {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits} is true, this may cause a save
     * of the current edit values
     *
     * @return EscapeKeyEditAction
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public EscapeKeyEditAction getEscapeKeyEditAction()  {
        return EnumUtil.getEnum(EscapeKeyEditAction.values(), getAttribute("escapeKeyEditAction"));
    }
    

    /**
     * For {@link com.smartgwt.client.types.ExpansionMode expansionModes} that show another grid or tree, is that component
     * editable? <P>The default value for this property is <code>false</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionCanEdit  Default value is null
     */
    public void setExpansionCanEdit(Boolean expansionCanEdit) {
        setAttribute("expansionCanEdit", expansionCanEdit, true);
    }

    /**
     * For {@link com.smartgwt.client.types.ExpansionMode expansionModes} that show another grid or tree, is that component
     * editable? <P>The default value for this property is <code>false</code>.
     *
     * @return Boolean
     */
    public Boolean getExpansionCanEdit()  {
        return getAttributeAsBoolean("expansionCanEdit");
    }
    

    /**
     * The method of {@link com.smartgwt.client.types.RecordComponentPoolingMode component-pooling} to employ for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords expansionComponents}. <P> The default mode is "destroy",
     * which means that automatically created expansionComponents are destroyed when rows are collapsed.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionComponentPoolingMode  Default value is "destroy"
     */
    public void setExpansionComponentPoolingMode(ExpansionComponentPoolingMode expansionComponentPoolingMode) {
        setAttribute("expansionComponentPoolingMode", expansionComponentPoolingMode == null ? null : expansionComponentPoolingMode.getValue(), true);
    }

    /**
     * The method of {@link com.smartgwt.client.types.RecordComponentPoolingMode component-pooling} to employ for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords expansionComponents}. <P> The default mode is "destroy",
     * which means that automatically created expansionComponents are destroyed when rows are collapsed.
     *
     * @return ExpansionComponentPoolingMode
     */
    public ExpansionComponentPoolingMode getExpansionComponentPoolingMode()  {
        return EnumUtil.getEnum(ExpansionComponentPoolingMode.values(), getAttribute("expansionComponentPoolingMode"));
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.HTMLFlow} for displaying the contents of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDetailField a specified field} in a record's expanded section when {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>detailField</code>. <P> This component is an
     * {@link com.smartgwt.client.types.AutoChild} and as such may be customized via
     * <code>listGrid.expansionDetailFieldProperties</code> and <code>listGrid.expansionDetailFieldDefaults</code>. <P> Note,
     * however, that this is a multi-instance component (potentially one per record), so it is created using  createAutoChild()
     * not  addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public HTMLFlow getExpansionDetailField()  {
        return null;
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.layout.HLayout} appearing in a record's expanded section when
     * {@link com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>detailRelated</code>. This component
     * contains two other autoChild components, a {@link com.smartgwt.client.widgets.viewer.DetailViewer} for viewing fields
     * from the record which are not already present in the grid and a separate embedded {@link
     * com.smartgwt.client.widgets.grid.ListGrid} for displaying other data related to this record via record.detailDS.  See
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionDetails expansionDetails} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionRelated expansionRelated} for more information. <P> This component
     * is an {@link com.smartgwt.client.types.AutoChild} and as such may be customized via
     * <code>listGrid.expansionDetailRelatedProperties</code> and <code>listGrid.expansionDetailRelatedDefaults</code>. <P>
     * Note, however, that this is a multi-instance component (potentially one per record), so it is created using 
     * createAutoChild() not  addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public HLayout getExpansionDetailRelated()  {
        return null;
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.viewer.DetailViewer} for displaying the details of a record
     * in its expanded section when {@link com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is
     * <code>details</code>.  Note that only those fields which do not already appear in the grid are displayed in the expanded
     * section. <P> This component is an {@link com.smartgwt.client.types.AutoChild} and as such may be customized via
     * <code>listGrid.expansionDetailsProperties</code> and <code>listGrid.expansionDetailsDefaults</code>. <P> Note, however,
     * that this is a multi-instance component (potentially one per record), so it is created using  createAutoChild() not 
     * addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public DetailViewer getExpansionDetails()  {
        return null;
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.form.DynamicForm} for editing the details of a record in its
     * expanded section when {@link com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>editor</code>. 
     * Note that only those fields which do not already appear in the grid will appear in the expanded section. <P> According
     * to the value of {@link com.smartgwt.client.widgets.grid.ListGrid#getShowExpansionEditorSaveButton
     * showExpansionEditorSaveButton}, a save button is shown beneath the editor.  You can save the values in the editor by
     * clicking this button <P> This component is an {@link com.smartgwt.client.types.AutoChild} and as such may be customized
     * via <code>listGrid.expansionEditorProperties</code> and <code>listGrid.expansionEditorDefaults</code>. <P> Note,
     * however, that this is a multi-instance component (potentially one per record), so it is created using  createAutoChild()
     * not  addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public DynamicForm getExpansionEditor()  {
        return null;
    }
    

    /**
     * When {@link com.smartgwt.client.types.ExpansionMode} is <i>editor</i>, should the row be collapsed following a save
     * initiated by the expansion-component's {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionEditorSaveButton
     * save button}.
     * <p>
     * <b>Note :</b> This method should be called only after the widget has been rendered.
     *
     * @return Boolean
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Boolean getExpansionEditorCollapseOnSave() throws IllegalStateException {
        errorIfNotCreated("expansionEditorCollapseOnSave");
        Boolean result = getAttributeAsBoolean("expansionEditorCollapseOnSave");
        return result == null ? true : result;
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.IButton} for saving the values in the expanded portion of a
     * ListGrid row. <P> This component is an {@link com.smartgwt.client.types.AutoChild} and as such may be customized via
     * <code>listGrid.expansionEditorSaveButtonProperties</code> and <code>listGrid.expansionEditorSaveButtonDefaults</code>.
     * <P> Note, however, that this is a multi-instance component (potentially one per record), so it is created using 
     * createAutoChild() not  addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public IButton getExpansionEditorSaveButton()  {
        return null;
    }
    

    /**
     * The title for the {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionEditorSaveButton
     * expansionEditorSaveButton}.
     * <p>
     * <b>Note :</b> This method should be called only after the widget has been rendered.
     *
     * @return String
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public String getExpansionEditorSaveButtonTitle() throws IllegalStateException {
        errorIfNotCreated("expansionEditorSaveButtonTitle");
        return getAttributeAsString("expansionEditorSaveButtonTitle");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} is <i>editor</i>, the prompt to display in a
     * dialog when an expanded row is collapsed while it's nested editor has changed values.
     *
     * @param expansionEditorSaveDialogPrompt  Default value is "You have unsaved changes - do you want to save them now?"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setExpansionEditorSaveDialogPrompt(String expansionEditorSaveDialogPrompt)  throws IllegalStateException {
        setAttribute("expansionEditorSaveDialogPrompt", expansionEditorSaveDialogPrompt, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} is <i>editor</i>, the prompt to display in a
     * dialog when an expanded row is collapsed while it's nested editor has changed values.
     *
     * @return String
     */
    public String getExpansionEditorSaveDialogPrompt()  {
        return getAttributeAsString("expansionEditorSaveDialogPrompt");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} is <i>editor</i>, whether a dialog should be
     * displayed when an expanded row is collapsed while it's nested editor has changed values.
     *
     * @param expansionEditorShowSaveDialog  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setExpansionEditorShowSaveDialog(Boolean expansionEditorShowSaveDialog)  throws IllegalStateException {
        setAttribute("expansionEditorShowSaveDialog", expansionEditorShowSaveDialog, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionMode expansionMode} is <i>editor</i>, whether a dialog should be
     * displayed when an expanded row is collapsed while it's nested editor has changed values.
     *
     * @return Boolean
     */
    public Boolean getExpansionEditorShowSaveDialog()  {
        return getAttributeAsBoolean("expansionEditorShowSaveDialog");
    }
    

    /**
     * The field providing the facility to expand and collapse rows.
     * <p>
     * For an overview of how to use and configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Returns the specially generated expansion field used when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true. <P> Called during {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setFields ListGrid.setFields()}, this method can be overridden to add advanced
     * dynamic defaults to the expansion field (call Super, modify the default field returned by Super, return the modified
     * field).  Normal customization can be handled by just setting {@link com.smartgwt.client.types.AutoChild} properties, as
     * mentioned under the docs for {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionField expansionField}.
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ListGridField getExpansionField() throws IllegalStateException {
        errorIfNotCreated("expansionField");
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("expansionField"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property determines the image to display in the expansion field for collapsed rows. If unset, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} will be used.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionFieldFalseImage  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldImageHeight
     */
    public void setExpansionFieldFalseImage(String expansionFieldFalseImage) {
        setAttribute("expansionFieldFalseImage", expansionFieldFalseImage, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property determines the image to display in the expansion field for collapsed rows. If unset, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} will be used.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldTrueImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageHeight
     */
    public String getExpansionFieldFalseImage()  {
        return getAttributeAsString("expansionFieldFalseImage");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property may be set to govern the height of the expansion image displayed to indicate whether a row is expanded. If
     * unset, the expansionField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageHeight booleanImageHeight} for this grid.
     *
     * @param expansionFieldImageHeight  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setExpansionFieldImageHeight(Integer expansionFieldImageHeight)  throws IllegalStateException {
        setAttribute("expansionFieldImageHeight", expansionFieldImageHeight, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property may be set to govern the height of the expansion image displayed to indicate whether a row is expanded. If
     * unset, the expansionField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageHeight booleanImageHeight} for this grid.
     *
     * @return Integer
     */
    public Integer getExpansionFieldImageHeight()  {
        return getAttributeAsInt("expansionFieldImageHeight");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property may be set to govern the width of the expansion image displayed to indicate whether a row is expanded. If
     * unset, the expansionField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageWidth booleanImageWidth} for this grid.
     *
     * @param expansionFieldImageWidth  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setExpansionFieldImageWidth(Integer expansionFieldImageWidth)  throws IllegalStateException {
        setAttribute("expansionFieldImageWidth", expansionFieldImageWidth, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property may be set to govern the width of the expansion image displayed to indicate whether a row is expanded. If
     * unset, the expansionField image will be sized to match the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanImageWidth booleanImageWidth} for this grid.
     *
     * @return Integer
     */
    public Integer getExpansionFieldImageWidth()  {
        return getAttributeAsInt("expansionFieldImageWidth");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property determines the image to display in the expansion field for expanded rows. If unset, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} will be used.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionFieldTrueImage  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setExpansionFieldImageHeight
     */
    public void setExpansionFieldTrueImage(String expansionFieldTrueImage) {
        setAttribute("expansionFieldTrueImage", expansionFieldTrueImage, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is set to <code>true</code>,
     * this property determines the image to display in the expansion field for expanded rows. If unset, the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} will be used.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldFalseImage
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getExpansionFieldImageHeight
     */
    public String getExpansionFieldTrueImage()  {
        return getAttributeAsString("expansionFieldTrueImage");
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.layout.VLayout} which fills a record's expanded section and
     * contains other builtin {@link com.smartgwt.client.types.ExpansionMode expansion-components}.  You can also override
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionComponent getExpansionComponent()} to provide components of
     * your own specification. <P> This component is an {@link com.smartgwt.client.types.AutoChild} and as such may be
     * customized via <code>listGrid.expansionLayoutProperties</code> and <code>listGrid.expansionLayoutDefaults</code>. <P>
     * Note, however, that this is a multi-instance component (potentially one per record), so it is created using 
     * createAutoChild() not  addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public VLayout getExpansionLayout()  {
        return null;
    }
    

    /**
     * The {@link com.smartgwt.client.types.ExpansionMode} for records in this grid. Default <code>null</code> value means no
     * expansion.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param expansionMode  Default value is null
     */
    public void setExpansionMode(ExpansionMode expansionMode) {
        setAttribute("expansionMode", expansionMode == null ? null : expansionMode.getValue(), true);
    }

    /**
     * The {@link com.smartgwt.client.types.ExpansionMode} for records in this grid. Default <code>null</code> value means no
     * expansion.
     *
     * @return ExpansionMode
     */
    public ExpansionMode getExpansionMode()  {
        return EnumUtil.getEnum(ExpansionMode.values(), getAttribute("expansionMode"));
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * Automatically generated {@link com.smartgwt.client.widgets.grid.ListGrid} for displaying data related to a record in its
     * expanded section when {@link com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is <code>related</code>.
     * The {@link com.smartgwt.client.data.DataSource} containing the related data is provided by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRelatedDataSource getRelatedDataSource()} which, by default, returns the
     * DataSource referred to in {@link com.smartgwt.client.widgets.grid.ListGridRecord#getDetailDS detailDS}. <P> This
     * component is an {@link com.smartgwt.client.types.AutoChild} and as such may be customized via
     * <code>listGrid.expansionRelatedProperties</code> and <code>listGrid.expansionRelatedDefaults</code>. <P> Note, however,
     * that this is a multi-instance component (potentially one per record), so it is created using  createAutoChild() not 
     * addAutoChild(), and no default single instance is created by name on the grid.
     *
     * @return null
     */
    public ListGrid getExpansionRelated()  {
        return null;
    }
    

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, background color
     * to use  for even-numbered rows, to create a "banded" or "ledger" effect.  Odd-numbered rows will  use the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExportDefaultBGColor exportDefaultBGColor}. <p> See {@link
     * com.smartgwt.client.docs.ExportBGColor} for an overview.
     *
     * @param exportAlternateRowBGColor  See {@link com.smartgwt.client.docs.CSSColor CSSColor} . Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setExportAlternateRowBGColor(String exportAlternateRowBGColor)  throws IllegalStateException {
        setAttribute("exportAlternateRowBGColor", exportAlternateRowBGColor, false);
    }

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, background color
     * to use  for even-numbered rows, to create a "banded" or "ledger" effect.  Odd-numbered rows will  use the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExportDefaultBGColor exportDefaultBGColor}. <p> See {@link
     * com.smartgwt.client.docs.ExportBGColor} for an overview.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSColor CSSColor} 
     */
    public String getExportAlternateRowBGColor()  {
        return getAttributeAsString("exportAlternateRowBGColor");
    }
    

    /**
     * Default background color to use when exporting data to Excel/OpenOffice format using {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportData exportData()} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}. <p> If unset (the default), cells that
     * are not provided a background color by more specific APIs will be the default background color used by the spreadsheet
     * program where they are viewed. <p> See {@link com.smartgwt.client.docs.ExportBGColor} for an overview.
     *
     * @param exportDefaultBGColor  See {@link com.smartgwt.client.docs.CSSColor CSSColor} . Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setExportDefaultBGColor(String exportDefaultBGColor)  throws IllegalStateException {
        setAttribute("exportDefaultBGColor", exportDefaultBGColor, false);
    }

    /**
     * Default background color to use when exporting data to Excel/OpenOffice format using {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportData exportData()} or  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}. <p> If unset (the default), cells that
     * are not provided a background color by more specific APIs will be the default background color used by the spreadsheet
     * program where they are viewed. <p> See {@link com.smartgwt.client.docs.ExportBGColor} for an overview.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSColor CSSColor} 
     */
    public String getExportDefaultBGColor()  {
        return getAttributeAsString("exportDefaultBGColor");
    }
    

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * ListGrid.exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData
     * ListGrid.exportClientData()}, whether field {@link com.smartgwt.client.widgets.grid.ListGridField#getAlign horizontal
     * header alignments} and  {@link com.smartgwt.client.widgets.grid.ListGridField#getCellAlign data value alignments} should
     * be replicated in the resulting  spreadsheet.  <p> If this attribute is not set, cells will be assigned a default
     * alignment by the spreadsheet, which is typically right-aligned for numeric and date values, and left-aligned for 
     * everything else (including dates and numbers that have been exported as strings, as would be the case, for example, if
     * {@link com.smartgwt.client.data.DSRequest#getExportDatesAsFormattedString exportDatesAsFormattedString} is set)
     *
     * @param exportFieldAlignments  Default value is false
     */
    public void setExportFieldAlignments(boolean exportFieldAlignments) {
        setAttribute("exportFieldAlignments", exportFieldAlignments, true);
    }

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * ListGrid.exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData
     * ListGrid.exportClientData()}, whether field {@link com.smartgwt.client.widgets.grid.ListGridField#getAlign horizontal
     * header alignments} and  {@link com.smartgwt.client.widgets.grid.ListGridField#getCellAlign data value alignments} should
     * be replicated in the resulting  spreadsheet.  <p> If this attribute is not set, cells will be assigned a default
     * alignment by the spreadsheet, which is typically right-aligned for numeric and date values, and left-aligned for 
     * everything else (including dates and numbers that have been exported as strings, as would be the case, for example, if
     * {@link com.smartgwt.client.data.DSRequest#getExportDatesAsFormattedString exportDatesAsFormattedString} is set)
     *
     * @return boolean
     */
    public boolean getExportFieldAlignments()  {
        Boolean result = getAttributeAsBoolean("exportFieldAlignments");
        return result == null ? false : result;
    }
    

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * ListGrid.exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData
     * ListGrid.exportClientData()}, whether widths of fields should be replicated in the resulting spreadsheet. <p> Because
     * Excel's unit of measurement for field widths is based on the default system font, there is no exact way to translate
     * field widths in pixels to Excel column widths.  The {@link com.smartgwt.client.widgets.grid.ListGrid#getExportWidthScale
     * exportWidthScale} property can be set to adjust scaling; it's default value errs on the side of making Excel's columns
     * slightly wider than the ListGrid field's actual width to avoid clipping. <p> Note that you can switch off width export
     * for individual fields with the  {@link com.smartgwt.client.widgets.grid.ListGridField#getExportFieldWidth
     * exportFieldWidth} flag.
     *
     * @param exportFieldWidths  Default value is false
     */
    public void setExportFieldWidths(boolean exportFieldWidths) {
        setAttribute("exportFieldWidths", exportFieldWidths, true);
    }

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * ListGrid.exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData
     * ListGrid.exportClientData()}, whether widths of fields should be replicated in the resulting spreadsheet. <p> Because
     * Excel's unit of measurement for field widths is based on the default system font, there is no exact way to translate
     * field widths in pixels to Excel column widths.  The {@link com.smartgwt.client.widgets.grid.ListGrid#getExportWidthScale
     * exportWidthScale} property can be set to adjust scaling; it's default value errs on the side of making Excel's columns
     * slightly wider than the ListGrid field's actual width to avoid clipping. <p> Note that you can switch off width export
     * for individual fields with the  {@link com.smartgwt.client.widgets.grid.ListGridField#getExportFieldWidth
     * exportFieldWidth} flag.
     *
     * @return boolean
     */
    public boolean getExportFieldWidths()  {
        Boolean result = getAttributeAsBoolean("exportFieldWidths");
        return result == null ? false : result;
    }
    

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * ListGrid.exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData
     * ListGrid.exportClientData()}, causes the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight}
     * and {@link com.smartgwt.client.widgets.grid.HeaderSpan#getHeight headerSpan heights} to be applied to the corresponding
     * cells in the spreadsheet.
     *
     * @param exportHeaderHeights  Default value is false
     */
    public void setExportHeaderHeights(boolean exportHeaderHeights) {
        setAttribute("exportHeaderHeights", exportHeaderHeights, true);
    }

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * ListGrid.exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData
     * ListGrid.exportClientData()}, causes the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight}
     * and {@link com.smartgwt.client.widgets.grid.HeaderSpan#getHeight headerSpan heights} to be applied to the corresponding
     * cells in the spreadsheet.
     *
     * @return boolean
     */
    public boolean getExportHeaderHeights()  {
        Boolean result = getAttributeAsBoolean("exportHeaderHeights");
        return result == null ? false : result;
    }
    

    /**
     * Dictates whether the data in this grid should be exported raw by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}.  If set to true, data will not be
     * processed by field-formatters during exports. Decreases the time taken for large exports.  This property can also be set
     * at the {@link com.smartgwt.client.widgets.grid.ListGridField#getExportRawValues field level}.
     *
     * @param exportRawValues  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setExportRawValues(Boolean exportRawValues)  throws IllegalStateException {
        setAttribute("exportRawValues", exportRawValues, false);
    }

    /**
     * Dictates whether the data in this grid should be exported raw by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}.  If set to true, data will not be
     * processed by field-formatters during exports. Decreases the time taken for large exports.  This property can also be set
     * at the {@link com.smartgwt.client.widgets.grid.ListGridField#getExportRawValues field level}.
     *
     * @return Boolean
     */
    public Boolean getExportRawValues()  {
        return getAttributeAsBoolean("exportRawValues");
    }
    

    /**
     * Scaling factor to translate from ListGrid field widths in pixels to Excel/OpenOffice units for field width, which are
     * 1/256th of the width of the widest digit character in the default font for the spreadsheet.  See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExportFieldWidths exportFieldWidths} for where this is used.
     *
     * @param exportWidthScale  Default value is 0.12
     */
    public void setExportWidthScale(double exportWidthScale) {
        setAttribute("exportWidthScale", exportWidthScale, true);
    }

    /**
     * Scaling factor to translate from ListGrid field widths in pixels to Excel/OpenOffice units for field width, which are
     * 1/256th of the width of the widest digit character in the default font for the spreadsheet.  See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExportFieldWidths exportFieldWidths} for where this is used.
     *
     * @return double
     */
    public double getExportWidthScale()  {
        return getAttributeAsDouble("exportWidthScale");
    }
    

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * ListGrid.exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData
     * ListGrid.exportClientData()}, whether titles in the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeader ListGrid
     * header} and {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans} should be allowed to wrap. <p>
     * Excel will wrap at the column boundary automatically; for explicit control over wrapping, insert "&lt;br&gt;" tags into
     * your titles. <p> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getExportFieldWidths exportFieldWidths} for
     * replicating the widths of fields in the exported spreadsheet.
     *
     * @param exportWrapHeaderTitles  Default value is false
     */
    public void setExportWrapHeaderTitles(boolean exportWrapHeaderTitles) {
        setAttribute("exportWrapHeaderTitles", exportWrapHeaderTitles, true);
    }

    /**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * ListGrid.exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData
     * ListGrid.exportClientData()}, whether titles in the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeader ListGrid
     * header} and {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans} should be allowed to wrap. <p>
     * Excel will wrap at the column boundary automatically; for explicit control over wrapping, insert "&lt;br&gt;" tags into
     * your titles. <p> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getExportFieldWidths exportFieldWidths} for
     * replicating the widths of fields in the exported spreadsheet.
     *
     * @return boolean
     */
    public boolean getExportWrapHeaderTitles()  {
        Boolean result = getAttributeAsBoolean("exportWrapHeaderTitles");
        return result == null ? false : result;
    }
    

    /**
     * <b>Note: This property only has an effect in Internet Explorer</b> <P> Advanced property to improve performance for
     * dynamic styling of gridRenderer cells in Internet Explorer, at the expense of slightly slower initial drawing, and some 
     * limitations on supported styling options. <P> <code>fastCellUpdates</code> speeds up the dynamic styling system used by
     * rollovers, selections, and custom styling that calls {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#refreshCellStyle GridRenderer.refreshCellStyle()}, at the cost of slightly
     * slower draw() and redraw() times. <P> Notes: <ul> <li>When this property is set, ListGrid cells may be styled using the 
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle}. See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle ListGrid.getBaseStyle()} for      more information.</li> <li>If
     * any cell styles specify a a background image URL, the URL will be resolved relative     to the page location rather than
     * the location of the CSS stylesheet. This means cell     styles with a background URL should either supply a fully
     * qualified path, or the     background image media should be made available at a second location for IE.</li>
     * <li>fastCellUpdates will not work if the styles involved are in an external stylesheet loaded     from a remote host.
     * Either the stylesheet containing cell styles needs to be loaded     from the same host as the main page, or the cell
     * styles need to be inlined in the html      of the bootstrap page.</li> <li>fastCellUpdates will not work if the css
     * styles for cells are defined in     a <code>.css</code> file loaded via <code>@import</code>. Instead the
     * <code>.css</code>     file should be loaded via a <code>&lt;link ...&gt;</code> tag.</li> </ul>
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.GridRenderer#getFastCellUpdates fastCellUpdates}. Has no effect in browsers other than Internet Explorer.
     *
     * @param fastCellUpdates whether to enable fastCellUpdates.. Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setFastCellUpdates(Boolean fastCellUpdates)  throws IllegalStateException {
        setAttribute("fastCellUpdates", fastCellUpdates, false);
    }
    

    /**
     * If we're showing the filterEditor ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor} is true), and we're re-filtering on every keypress ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterOnKeypress filterOnKeypress} is true), this property is the delay in
     * milliseconds between the user changing the filter and the filter request being kicked off. If multiple changes are made
     * to the filter within this fetch delay, only the most recent will actually cause a re-filter
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param fetchDelay  Default value is 300
     */
    public void setFetchDelay(int fetchDelay) {
        setAttribute("fetchDelay", fetchDelay, true);
    }

    /**
     * If we're showing the filterEditor ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor} is true), and we're re-filtering on every keypress ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFilterOnKeypress filterOnKeypress} is true), this property is the delay in
     * milliseconds between the user changing the filter and the filter request being kicked off. If multiple changes are made
     * to the filter within this fetch delay, only the most recent will actually cause a re-filter
     *
     * @return int
     */
    public int getFetchDelay()  {
        return getAttributeAsInt("fetchDelay");
    }
    

    /**
     * Names of properties on {@link com.smartgwt.client.widgets.grid.ListGridField} for which the {@link
     * com.smartgwt.client.widgets.FieldPicker} should show an editing interface, for convenience. <P> For example, specify
     * ["frozen", "decimalPrecision"] to allow end users to modify {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDecimalPrecision decimalPrecision} respectively.
     *
     * @param fieldPickerFieldProperties  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setFieldPickerFieldProperties(String... fieldPickerFieldProperties)  throws IllegalStateException {
        setAttribute("fieldPickerFieldProperties", fieldPickerFieldProperties, false);
    }

    /**
     * Names of properties on {@link com.smartgwt.client.widgets.grid.ListGridField} for which the {@link
     * com.smartgwt.client.widgets.FieldPicker} should show an editing interface, for convenience. <P> For example, specify
     * ["frozen", "decimalPrecision"] to allow end users to modify {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getDecimalPrecision decimalPrecision} respectively.
     *
     * @return String...
     */
    public String[] getFieldPickerFieldProperties()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("fieldPickerFieldProperties"));
    }
    

    /**
     * When set to false, sample values of the FieldPicker are never shown. This property applies to the entire FieldPicker.
     *
     * @param fieldPickerShowSampleValues  Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setFieldPickerShowSampleValues(Boolean fieldPickerShowSampleValues)  throws IllegalStateException {
        setAttribute("fieldPickerShowSampleValues", fieldPickerShowSampleValues, false);
    }

    /**
     * When set to false, sample values of the FieldPicker are never shown. This property applies to the entire FieldPicker.
     *
     * @return Boolean
     */
    public Boolean getFieldPickerShowSampleValues()  {
        Boolean result = getAttributeAsBoolean("fieldPickerShowSampleValues");
        return result == null ? true : result;
    }
    

    /**
     * Instance of {@link com.smartgwt.client.widgets.FieldPickerWindow} used if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseAdvancedFieldPicker useAdvancedFieldPicker} is set.
     * <p>
     * For an overview of how to use and configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return FieldPickerWindow
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public FieldPickerWindow getFieldPickerWindow() throws IllegalStateException {
        errorIfNotCreated("fieldPickerWindow");
        return (FieldPickerWindow)FieldPickerWindow.getByJSObject(getAttributeAsJavaScriptObject("fieldPickerWindow"));
    }
    

    /**
     * An array of field objects, specifying the order, layout, formatting, and sorting behavior of each field in the listGrid
     * object.  In ListGrids, the fields array specifies columns.  Each field in the fields array is a ListGridField object.
     * Any listGrid that will display data should have at least one visible field. <p> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} is also set, this value acts as a set of overrides
     * as explained in {@link com.smartgwt.client.widgets.DataBoundComponent#getFields fields}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Sets the fields array and/or field widths to newFields and sizes, respectively.<br><br> If newFields is specified, it is assumed that the new fields may have nothing in common with the old fields, and the component is substantially rebuilt.  Furthermore, it's invalid to modify any of the existing {@link com.smartgwt.client.widgets.grid.ListGridField}s after they've been passed to this function. Consider the following methods for more efficient, more incremental changes: {@link com.smartgwt.client.widgets.grid.ListGrid#resizeField ListGrid.resizeField()}, {@link com.smartgwt.client.widgets.grid.ListGrid#reorderField ListGrid.reorderField()}, {@link com.smartgwt.client.widgets.grid.ListGrid#showField ListGrid.showField()}, {@link com.smartgwt.client.widgets.grid.ListGrid#hideField ListGrid.hideField()}, or {@link com.smartgwt.client.widgets.grid.ListGrid#setFieldProperties ListGrid.setFieldProperties()}.
     *
     * @param fields array of fields to draw. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFields
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_lg_fields" target="examples">ListGrid fields Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_merged_fields" target="examples">Merged fields Example</a>
     */
    public void setFields(ListGridField... fields) {
        setAttribute("fields", fields, true);
    }

    /**
     * An array of field objects, specifying the order, layout, formatting, and sorting behavior of each field in the listGrid
     * object.  In ListGrids, the fields array specifies columns.  Each field in the fields array is a ListGridField object.
     * Any listGrid that will display data should have at least one visible field. <p> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} is also set, this value acts as a set of overrides
     * as explained in {@link com.smartgwt.client.widgets.DataBoundComponent#getFields fields}.
     *
     * @return ListGridField...
     * @see com.smartgwt.client.widgets.grid.ListGridField
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFields
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_lg_fields" target="examples">ListGrid fields Example</a>
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_databinding_merged_fields" target="examples">Merged fields Example</a>
     */
    public ListGridField[] getFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfListGridField(getAttributeAsJavaScriptObject("fields"));
    }
    

    /**
     * Initial {@link com.smartgwt.client.docs.ListGridFieldState field state} for the grid. <p> {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getViewState viewState} can be used to initialize all view properties of the
     * grid. When doing so, <code>fieldState</code> is not needed because <code>viewState</code> includes it as well. If both
     * are provided, <code>fieldState</code> has priority for field state.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Sets some presentation properties (visibility, width, userFormula and userSummary) of the listGrid fields based on the {@link com.smartgwt.client.docs.ListGridFieldState} object passed in.<br> Used to restore previous state retrieved from the grid by a call to {@link com.smartgwt.client.widgets.grid.ListGrid#getFieldState ListGrid.getFieldState()}.
     *
     * @param fieldState state to apply to the listGrid's fields.. Default value is null
     */
    public void setFieldState(String fieldState) {
        setAttribute("fieldState", fieldState, true);
    }

    /**
     * Initial {@link com.smartgwt.client.docs.ListGridFieldState field state} for the grid. <p> {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getViewState viewState} can be used to initialize all view properties of the
     * grid. When doing so, <code>fieldState</code> is not needed because <code>viewState</code> includes it as well. If both
     * are provided, <code>fieldState</code> has priority for field state.
     *
     * @return Returns a snapshot of the current presentation of this listGrid's fields as a {@link
     * com.smartgwt.client.docs.ListGridFieldState} object. <P> This object can later be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setFieldState ListGrid.setFieldState()} to reset this grid's fields to the
     * current state. <P> Note that the information stored includes the current width and visibility of each of this grid's
     * fields, as well as any {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAddFormulaFields formula} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanAddSummaryFields summary fields} added by the user.
     */
    public String getFieldState()  {
        return getAttributeAsString("fieldState");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields this.canPickFields} is true, this attribute
     * will be shown as the title for the menu item which contains a submenu with items allowing the user to show and hide
     * fields in the grid.
     *
     * @param fieldVisibilitySubmenuTitle  Default value is "Columns"
     */
    public void setFieldVisibilitySubmenuTitle(String fieldVisibilitySubmenuTitle) {
        setAttribute("fieldVisibilitySubmenuTitle", fieldVisibilitySubmenuTitle, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanPickFields this.canPickFields} is true, this attribute
     * will be shown as the title for the menu item which contains a submenu with items allowing the user to show and hide
     * fields in the grid.
     *
     * @return String
     */
    public String getFieldVisibilitySubmenuTitle()  {
        return getAttributeAsString("fieldVisibilitySubmenuTitle");
    }
    

    /**
     * The prompt to show when the mouse hovers over the Filter button in the FilterEditor.
     *
     * @param filterButtonPrompt  Default value is "Filter"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setFilterButtonPrompt(String filterButtonPrompt)  throws IllegalStateException {
        setAttribute("filterButtonPrompt", filterButtonPrompt, false);
    }

    /**
     * The prompt to show when the mouse hovers over the Filter button in the FilterEditor.
     *
     * @return String
     */
    public String getFilterButtonPrompt()  {
        return getAttributeAsString("filterButtonPrompt");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is true, this attribute may be
     * used to customize the filter button shown to the right of the filterEditor row.
     *
     * @param filterButtonProperties  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setFilterButtonProperties(Button filterButtonProperties)  throws IllegalStateException {
        JavaScriptObject config = filterButtonProperties == null ? null : filterButtonProperties.getConfig();
        setAttribute("filterButtonProperties", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is true, this attribute may be
     * used to customize the filter button shown to the right of the filterEditor row.
     *
     * @return Button
     */
    public Button getFilterButtonProperties()  {
        Button properties = new Button();
        properties.setConfigOnly(true);
        properties.setConfig(getAttributeAsJavaScriptObject("filterButtonProperties"));
        return properties;
    }
    

    /**
     * If we're showing the filterEditor (this.showFilterEditor is true), this property determines whether this list should be
     * filtered every time the user puts focus in a different field in the filter editor.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param filterByCell  Default value is null
     */
    public void setFilterByCell(Boolean filterByCell) {
        setAttribute("filterByCell", filterByCell, true);
    }

    /**
     * If we're showing the filterEditor (this.showFilterEditor is true), this property determines whether this list should be
     * filtered every time the user puts focus in a different field in the filter editor.
     *
     * @return Boolean
     */
    public Boolean getFilterByCell()  {
        return getAttributeAsBoolean("filterByCell");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is set to true, the
     * <code>filterEditor</code> is automatically created as an AutoChild.<br> Developers may customize the AutoChild using
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorProperties filterEditorProperties}.
     * <p>
     * For an overview of how to use and configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return RecordEditor
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public RecordEditor getFilterEditor() throws IllegalStateException {
        errorIfNotCreated("filterEditor");
        return (RecordEditor)RecordEditor.getByJSObject(getAttributeAsJavaScriptObject("filterEditor"));
    }
    

    /**
     * Height for the filterEditor, if shown.
     *
     * @param filterEditorHeight  Default value is 22
     */
    public void setFilterEditorHeight(int filterEditorHeight) {
        setAttribute("filterEditorHeight", filterEditorHeight, true);
    }

    /**
     * Height for the filterEditor, if shown.
     *
     * @return int
     */
    public int getFilterEditorHeight()  {
        return getAttributeAsInt("filterEditorHeight");
    }
    

    /**
     * Properties to apply to the automatically generated {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor
     * filterEditor} if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is true.
     *
     * @param filterEditorProperties  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setFilterEditorProperties(RecordEditor filterEditorProperties)  throws IllegalStateException {
        JavaScriptObject config = filterEditorProperties == null ? null : filterEditorProperties.getConfig();
        setAttribute("filterEditorProperties", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * Properties to apply to the automatically generated {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditor
     * filterEditor} if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is true.
     *
     * @return RecordEditor
     */
    public RecordEditor getFilterEditorProperties()  {
        RecordEditor properties = new RecordEditor();
        properties.setConfigOnly(true);
        properties.setConfig(getAttributeAsJavaScriptObject("filterEditorProperties"));
        return properties;
    }
    

    /**
     * If this grid has its {@link com.smartgwt.client.widgets.grid.ListGrid#setData data property} set to a static array of
     * records, should {@link com.smartgwt.client.widgets.grid.ListGrid#filterData ListGrid.filterData()} filter this array?
     * <P> If this property is set to true, the static data array is applied as the  {@link
     * com.smartgwt.client.data.ResultSet#getAllRows complete dataset} of a {@link com.smartgwt.client.data.ResultSet}, which
     * is then  filtered according to the specified criteria, and the results displayed. If false, a  normal databound fetch
     * will occur, retrieving records that match the specified criteria  from this component's {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}. <P> If this property is not explicitly set, default
     * behavior will filter against the dataSource unless the grid has a specified {@link com.smartgwt.client.docs.DataPath
     * dataPath}, in which case filtering will occur locally. <P> Note that a specified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} is required for filtering to occur even when
     * filtering a local data array.
     *
     * @param filterLocalData  Default value is null
     */
    public void setFilterLocalData(Boolean filterLocalData) {
        setAttribute("filterLocalData", filterLocalData, true);
    }

    /**
     * If this grid has its {@link com.smartgwt.client.widgets.grid.ListGrid#setData data property} set to a static array of
     * records, should {@link com.smartgwt.client.widgets.grid.ListGrid#filterData ListGrid.filterData()} filter this array?
     * <P> If this property is set to true, the static data array is applied as the  {@link
     * com.smartgwt.client.data.ResultSet#getAllRows complete dataset} of a {@link com.smartgwt.client.data.ResultSet}, which
     * is then  filtered according to the specified criteria, and the results displayed. If false, a  normal databound fetch
     * will occur, retrieving records that match the specified criteria  from this component's {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}. <P> If this property is not explicitly set, default
     * behavior will filter against the dataSource unless the grid has a specified {@link com.smartgwt.client.docs.DataPath
     * dataPath}, in which case filtering will occur locally. <P> Note that a specified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource} is required for filtering to occur even when
     * filtering a local data array.
     *
     * @return Boolean
     */
    public Boolean getFilterLocalData()  {
        return getAttributeAsBoolean("filterLocalData");
    }
    

    /**
     * If we're showing the filterEditor (this.showFilterEditor is true), this property determines whether this list should be
     * filtered every time the user modifies the value in a field of the filter-editor. Can also be set at the field level.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param filterOnKeypress  Default value is null
     */
    public void setFilterOnKeypress(Boolean filterOnKeypress) {
        setAttribute("filterOnKeypress", filterOnKeypress, true);
    }

    /**
     * If we're showing the filterEditor (this.showFilterEditor is true), this property determines whether this list should be
     * filtered every time the user modifies the value in a field of the filter-editor. Can also be set at the field level.
     *
     * @return Boolean
     */
    public Boolean getFilterOnKeypress()  {
        return getAttributeAsBoolean("filterOnKeypress");
    }
    

    /**
     * Should we horizontally clip cell contents, or allow columns to expand horizontally to show all contents? <P> If we allow
     * columns to expand, the column width is treated as a minimum. <P> NOTE: the header does not automatically respond to
     * expanded field widths. If your grid is showing a header we'd recommend developers consider setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} rather than using this attribute.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param fixedFieldWidths  Default value is true
     */
    public void setFixedFieldWidths(Boolean fixedFieldWidths) {
        setAttribute("fixedFieldWidths", fixedFieldWidths, true);
    }

    /**
     * Should we horizontally clip cell contents, or allow columns to expand horizontally to show all contents? <P> If we allow
     * columns to expand, the column width is treated as a minimum. <P> NOTE: the header does not automatically respond to
     * expanded field widths. If your grid is showing a header we'd recommend developers consider setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths} rather than using this attribute.
     *
     * @return Boolean
     */
    public Boolean getFixedFieldWidths()  {
        Boolean result = getAttributeAsBoolean("fixedFieldWidths");
        return result == null ? true : result;
    }
    

    /**
     * Should we vertically clip cell contents, or allow rows to expand vertically to show all contents? <P> If we allow rows
     * to expand, the row height as derived from {@link com.smartgwt.client.widgets.grid.GridRenderer#getRowHeight
     * getRowHeight()} or the default {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} is treated as
     * a minimum. <P> Setting <code>fixedRecordHeights</code> to false enables the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling} system. <P> <b>NOTE:</b><ul> <li>Setting
     * fixedRecordHeights to false for {@link com.smartgwt.client.widgets.cube.CubeGrid} is not supported, though a similar
     * option for the row headers is available as {@link com.smartgwt.client.widgets.cube.CubeGrid#getAutoSizeHeaders
     * autoSizeHeaders}. <li>By default, for performance reasons, clipping is not enforced for some kinds of content (such as
     * images) on all browsers.  Set {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping
     * enforceVClipping:true} to enforce clipping for all types of content on all browsers. </ul>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param fixedRecordHeights  Default value is true
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_values" target="examples">Cell Values Example</a>
     */
    public void setFixedRecordHeights(Boolean fixedRecordHeights) {
        setAttribute("fixedRecordHeights", fixedRecordHeights, true);
    }

    /**
     * Should we vertically clip cell contents, or allow rows to expand vertically to show all contents? <P> If we allow rows
     * to expand, the row height as derived from {@link com.smartgwt.client.widgets.grid.GridRenderer#getRowHeight
     * getRowHeight()} or the default {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} is treated as
     * a minimum. <P> Setting <code>fixedRecordHeights</code> to false enables the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling} system. <P> <b>NOTE:</b><ul> <li>Setting
     * fixedRecordHeights to false for {@link com.smartgwt.client.widgets.cube.CubeGrid} is not supported, though a similar
     * option for the row headers is available as {@link com.smartgwt.client.widgets.cube.CubeGrid#getAutoSizeHeaders
     * autoSizeHeaders}. <li>By default, for performance reasons, clipping is not enforced for some kinds of content (such as
     * images) on all browsers.  Set {@link com.smartgwt.client.widgets.grid.ListGrid#getEnforceVClipping
     * enforceVClipping:true} to enforce clipping for all types of content on all browsers. </ul>
     *
     * @return Boolean
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_values" target="examples">Cell Values Example</a>
     */
    public Boolean getFixedRecordHeights()  {
        Boolean result = getAttributeAsBoolean("fixedRecordHeights");
        return result == null ? true : result;
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInFormulaBuilder showHeaderSpanTitlesInFormulaBuilder}
     * is true, this string will be inserted between the headerSpan title(s) and the field title in the field chooser grid in
     * the FormulaBuilder and SummaryBuilder.
     *
     * @param formulaBuilderSpanTitleSeparator  Default value is " - "
     */
    public void setFormulaBuilderSpanTitleSeparator(String formulaBuilderSpanTitleSeparator) {
        setAttribute("formulaBuilderSpanTitleSeparator", formulaBuilderSpanTitleSeparator, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInFormulaBuilder showHeaderSpanTitlesInFormulaBuilder}
     * is true, this string will be inserted between the headerSpan title(s) and the field title in the field chooser grid in
     * the FormulaBuilder and SummaryBuilder.
     *
     * @return String
     */
    public String getFormulaBuilderSpanTitleSeparator()  {
        return getAttributeAsString("formulaBuilderSpanTitleSeparator");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to freeze a currently unfrozen field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Freeze " + the field's summary title.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param freezeFieldText  See {@link com.smartgwt.client.docs.HTMLString HTMLString} . Default value is "Freeze ${title}"
     */
    public void setFreezeFieldText(String freezeFieldText) {
        setAttribute("freezeFieldText", freezeFieldText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to freeze a currently unfrozen field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Freeze " + the field's summary title.
     *
     * @return  See {@link com.smartgwt.client.docs.HTMLString HTMLString} 
     */
    public String getFreezeFieldText()  {
        return getAttributeAsString("freezeFieldText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to freeze fields on the left of the scrollable body.
     *
     * @param freezeOnLeftText  Default value is "Freeze on left"
     */
    public void setFreezeOnLeftText(String freezeOnLeftText) {
        setAttribute("freezeOnLeftText", freezeOnLeftText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to freeze fields on the left of the scrollable body.
     *
     * @return String
     */
    public String getFreezeOnLeftText()  {
        return getAttributeAsString("freezeOnLeftText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to freeze fields on the right of the scrollable body.
     *
     * @param freezeOnRightText  Default value is "Freeze on right"
     */
    public void setFreezeOnRightText(String freezeOnRightText) {
        setAttribute("freezeOnRightText", freezeOnRightText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to freeze fields on the right of the scrollable body.
     *
     * @return String
     */
    public String getFreezeOnRightText()  {
        return getAttributeAsString("freezeOnRightText");
    }
    

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom baseStyle to all cells in those
     * frozen fields. If unset, the standard base style will be used for both frozen and unfrozen cells.
     *
     * @param frozenBaseStyle  Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#setFrozen
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setFrozenBaseStyle(String frozenBaseStyle) {
        setAttribute("frozenBaseStyle", frozenBaseStyle, true);
    }

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom baseStyle to all cells in those
     * frozen fields. If unset, the standard base style will be used for both frozen and unfrozen cells.
     *
     * @return String
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#getFrozen
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getFrozenBaseStyle()  {
        return getAttributeAsString("frozenBaseStyle");
    }
    

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom headerBaseStyle to the frozen
     * set of fields. If unset, the standard headerBaseStyle will be used for both frozen and unfrozen cells.
     *
     * @param frozenHeaderBaseStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#setFrozen
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public void setFrozenHeaderBaseStyle(String frozenHeaderBaseStyle)  throws IllegalStateException {
        setAttribute("frozenHeaderBaseStyle", frozenHeaderBaseStyle, false);
    }

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom headerBaseStyle to the frozen
     * set of fields. If unset, the standard headerBaseStyle will be used for both frozen and unfrozen cells.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderBaseStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#getFrozen
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public String getFrozenHeaderBaseStyle()  {
        return getAttributeAsString("frozenHeaderBaseStyle");
    }
    

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom headerTitleStyle to the frozen
     * set of fields. If unset, the standard headerTitleStyle will be used for both frozen and unfrozen cells.
     *
     * @param frozenHeaderTitleStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHeaderTitleStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#setFrozen
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public void setFrozenHeaderTitleStyle(String frozenHeaderTitleStyle)  throws IllegalStateException {
        setAttribute("frozenHeaderTitleStyle", frozenHeaderTitleStyle, false);
    }

    /**
     * If this listGrid contains any frozen fields, this property can be used to apply a custom headerTitleStyle to the frozen
     * set of fields. If unset, the standard headerTitleStyle will be used for both frozen and unfrozen cells.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderTitleStyle
     * @see com.smartgwt.client.widgets.grid.ListGridField#getFrozen
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public String getFrozenHeaderTitleStyle()  {
        return getAttributeAsString("frozenHeaderTitleStyle");
    }
    

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Enter, the cell will respond to a click event.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param generateClickOnEnter  Default value is false
     */
    public void setGenerateClickOnEnter(Boolean generateClickOnEnter) {
        setAttribute("generateClickOnEnter", generateClickOnEnter, true);
    }

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Enter, the cell will respond to a click event.
     *
     * @return Boolean
     */
    public Boolean getGenerateClickOnEnter()  {
        Boolean result = getAttributeAsBoolean("generateClickOnEnter");
        return result == null ? false : result;
    }
    

    /**
     * If true, when the user navigates to a cell using arrow keys and hits space, the cell will respond to a click event.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param generateClickOnSpace  Default value is true
     */
    public void setGenerateClickOnSpace(Boolean generateClickOnSpace) {
        setAttribute("generateClickOnSpace", generateClickOnSpace, true);
    }

    /**
     * If true, when the user navigates to a cell using arrow keys and hits space, the cell will respond to a click event.
     *
     * @return Boolean
     */
    public Boolean getGenerateClickOnSpace()  {
        Boolean result = getAttributeAsBoolean("generateClickOnSpace");
        return result == null ? true : result;
    }
    

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Enter, the cell will respond to a double click
     * event.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param generateDoubleClickOnEnter  Default value is true
     */
    public void setGenerateDoubleClickOnEnter(Boolean generateDoubleClickOnEnter) {
        setAttribute("generateDoubleClickOnEnter", generateDoubleClickOnEnter, true);
    }

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Enter, the cell will respond to a double click
     * event.
     *
     * @return Boolean
     */
    public Boolean getGenerateDoubleClickOnEnter()  {
        Boolean result = getAttributeAsBoolean("generateDoubleClickOnEnter");
        return result == null ? true : result;
    }
    

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Space, the cell will respond to a double click
     * event.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param generateDoubleClickOnSpace  Default value is false
     */
    public void setGenerateDoubleClickOnSpace(Boolean generateDoubleClickOnSpace) {
        setAttribute("generateDoubleClickOnSpace", generateDoubleClickOnSpace, true);
    }

    /**
     * If true, when the user navigates to a cell using arrow keys and hits Space, the cell will respond to a double click
     * event.
     *
     * @return Boolean
     */
    public Boolean getGenerateDoubleClickOnSpace()  {
        Boolean result = getAttributeAsBoolean("generateDoubleClickOnSpace");
        return result == null ? false : result;
    }
    

    /**
     * Array of components that make up this grid. This array controls which standard and/or custom
     *  parts will be displayed within this ListGrid.
     *  <P>
     * ListGrid is a subclass of {@link com.smartgwt.client.widgets.layout.VLayout} and consists of a number of member
     * components. The
     *  standard set of members are automatically generated by the grid, and include (for example)
     *  the header (a Toolbar of buttons for each field) and the body
     *  (a GridRenderer displaying the actual data contained in the grid).<br>
     * The default value of <code>gridComponents</code> is an Array of {@link com.smartgwt.client.types.ListGridComponent}s
     * listing
     *  the standard components in their default order:
     *  
     *  
     *  <pre>
     *     [ListGridComponent.FILTER_EDITOR, ListGridComponent.HEADER, ListGridComponent.BODY,
     *      ListGridComponent.SUMMARY_ROW]
     *  </pre>
     *  
     * 
     *  You can override <code>gridComponents</code> to change the order of standard components.
     *  You can also omit standard components this way, although it more efficient to
     * use the related "show" property if available (eg {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor}). Note that
     *  this array must contain an entry for the <code>"body"</code> - listGrids with no body showing
     *  are unsupported.<br>
     *  <i>Advanced note:</i> The live components generated for each of these standard
     *  {@link com.smartgwt.client.types.ListGridComponent} types may differ across different listGrids. For example if this
     * grid has any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, the "body" entry will
     * actually
     *  be created as an HLayout containing two GridRenderers (one for frozen fields,
     *  and one for unfrozen fields). This is really an implementation detail - the "body" entry
     *  in the gridComponents array simply specifies where the UI for the body should render within
     *  the ListGrid layout.
     *  <P>
     *  By embedding a Canvas directly in this list you can add arbitrary additional components to the
     *  listGrid as members, and have them be displayed alongside the standard automatically generated
     *  parts of the ListGrid.
     *  <P>
     *  Note that having added controls to gridComponents, you can still call APIs directly on
     *  those controls to change their appearance, and you can also show() and hide() them if
     *  they should not be shown in some circumstances.
     *  <P>
     *  Tip: custom controls need to set layoutAlign:"center" to appear vertically centered.
     *
     * @param gridComponents  Default value is (see below)
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setGridComponents(ListGridComponent... gridComponents)  throws IllegalStateException {
        setAttribute("gridComponents", gridComponents, false);
    }

    /**
     * Array of components that make up this grid. This array controls which standard and/or custom
     *  parts will be displayed within this ListGrid.
     *  <P>
     * ListGrid is a subclass of {@link com.smartgwt.client.widgets.layout.VLayout} and consists of a number of member
     * components. The
     *  standard set of members are automatically generated by the grid, and include (for example)
     *  the header (a Toolbar of buttons for each field) and the body
     *  (a GridRenderer displaying the actual data contained in the grid).<br>
     * The default value of <code>gridComponents</code> is an Array of {@link com.smartgwt.client.types.ListGridComponent}s
     * listing
     *  the standard components in their default order:
     *  
     *  
     *  <pre>
     *     [ListGridComponent.FILTER_EDITOR, ListGridComponent.HEADER, ListGridComponent.BODY,
     *      ListGridComponent.SUMMARY_ROW]
     *  </pre>
     *  
     * 
     *  You can override <code>gridComponents</code> to change the order of standard components.
     *  You can also omit standard components this way, although it more efficient to
     * use the related "show" property if available (eg {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor}). Note that
     *  this array must contain an entry for the <code>"body"</code> - listGrids with no body showing
     *  are unsupported.<br>
     *  <i>Advanced note:</i> The live components generated for each of these standard
     *  {@link com.smartgwt.client.types.ListGridComponent} types may differ across different listGrids. For example if this
     * grid has any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, the "body" entry will
     * actually
     *  be created as an HLayout containing two GridRenderers (one for frozen fields,
     *  and one for unfrozen fields). This is really an implementation detail - the "body" entry
     *  in the gridComponents array simply specifies where the UI for the body should render within
     *  the ListGrid layout.
     *  <P>
     *  By embedding a Canvas directly in this list you can add arbitrary additional components to the
     *  listGrid as members, and have them be displayed alongside the standard automatically generated
     *  parts of the ListGrid.
     *  <P>
     *  Note that having added controls to gridComponents, you can still call APIs directly on
     *  those controls to change their appearance, and you can also show() and hide() them if
     *  they should not be shown in some circumstances.
     *  <P>
     *  Tip: custom controls need to set layoutAlign:"center" to appear vertically centered.
     *
     * @return ListGridComponent...
     */
    public ListGridComponent[] getGridComponents()  {
        final String[] strings = getAttributeAsStringArray("gridComponents");
        return EnumUtil.getEnums(ListGridComponent.values(), strings, strings == null ? null : new ListGridComponent[strings.length]);
    }

    /**
     * Array of components that make up this grid. This array controls which standard and/or custom
     *  parts will be displayed within this ListGrid.
     *  <P>
     * ListGrid is a subclass of {@link com.smartgwt.client.widgets.layout.VLayout} and consists of a number of member
     * components. The
     *  standard set of members are automatically generated by the grid, and include (for example)
     *  the header (a Toolbar of buttons for each field) and the body
     *  (a GridRenderer displaying the actual data contained in the grid).<br>
     * The default value of <code>gridComponents</code> is an Array of {@link com.smartgwt.client.types.ListGridComponent}s
     * listing
     *  the standard components in their default order:
     *  
     *  
     *  <pre>
     *     [ListGridComponent.FILTER_EDITOR, ListGridComponent.HEADER, ListGridComponent.BODY,
     *      ListGridComponent.SUMMARY_ROW]
     *  </pre>
     *  
     * 
     *  You can override <code>gridComponents</code> to change the order of standard components.
     *  You can also omit standard components this way, although it more efficient to
     * use the related "show" property if available (eg {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor
     * showFilterEditor}). Note that
     *  this array must contain an entry for the <code>"body"</code> - listGrids with no body showing
     *  are unsupported.<br>
     *  <i>Advanced note:</i> The live components generated for each of these standard
     *  {@link com.smartgwt.client.types.ListGridComponent} types may differ across different listGrids. For example if this
     * grid has any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, the "body" entry will
     * actually
     *  be created as an HLayout containing two GridRenderers (one for frozen fields,
     *  and one for unfrozen fields). This is really an implementation detail - the "body" entry
     *  in the gridComponents array simply specifies where the UI for the body should render within
     *  the ListGrid layout.
     *  <P>
     *  By embedding a Canvas directly in this list you can add arbitrary additional components to the
     *  listGrid as members, and have them be displayed alongside the standard automatically generated
     *  parts of the ListGrid.
     *  <P>
     *  Note that having added controls to gridComponents, you can still call APIs directly on
     *  those controls to change their appearance, and you can also show() and hide() them if
     *  they should not be shown in some circumstances.
     *  <P>
     *  Tip: custom controls need to set layoutAlign:"center" to appear vertically centered.
     *
     * @param gridComponents  Default value is (see below)
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setGridComponents(Object... gridComponents)  throws IllegalStateException {
        setAttribute("gridComponents", gridComponents, false);
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, this attribute will be
     * set to true on the record object representing the grid summary row.
     *
     * @param gridSummaryRecordProperty  Default value is "isGridSummary"
     */
    public void setGridSummaryRecordProperty(String gridSummaryRecordProperty) {
        setAttribute("gridSummaryRecordProperty", gridSummaryRecordProperty, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, this attribute will be
     * set to true on the record object representing the grid summary row.
     *
     * @return String
     */
    public String getGridSummaryRecordProperty()  {
        return getAttributeAsString("gridSummaryRecordProperty");
    }
    

    /**
     * When grouping is requested with this number of records or more, an asynchronous approach is used to avoid the browser
     * showing a "script is running slowly.." message prompting the user to stop execution of JavaScript. <p> Note that {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords groupByMaxRecords} must be set at least as high as {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold groupByAsyncThreshold} or asynchronous grouping will
     * never be used. <p> During asynch grouping, interactivity is blocked and the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAsynchGroupingPrompt asynchGroupingPrompt} is shown to the user, then
     * hidden when grouping completes; {@link com.smartgwt.client.widgets.grid.ListGrid#addGroupByCompleteHandler
     * ListGrid.groupByComplete()} then fires. <p> Note that this async processing covers grouping <b>only</b> - it does not
     * cover whole grid or per-group summaries, client-side sort or filter, or other operations that may cause the browser to
     * show the "script is running slowly" prompt when working with very large sets of records in a grid. <p> At this time,
     * there is no generally effective way to avoid this warning dialog appearing with very large datasets in Microsoft's
     * Internet Explorer (IE).  IE's severely flawed detection algorithm for runaway scripts has been shown to interrupt
     * computations after only 0.2 seconds elapsed time even if the computation would have finished in 0.3 seconds. 
     * Optimizations that reduce execution time can sometimes trigger the "script running slowly" dialog sooner.  Since not
     * every operation can reasonably be made asychronous, the current recommendation is to avoid working with overly large
     * datasets until the affected versions of IE are obsoleted.
     *
     * @param groupByAsyncThreshold  Default value is 50
     */
    public void setGroupByAsyncThreshold(int groupByAsyncThreshold) {
        setAttribute("groupByAsyncThreshold", groupByAsyncThreshold, true);
    }

    /**
     * When grouping is requested with this number of records or more, an asynchronous approach is used to avoid the browser
     * showing a "script is running slowly.." message prompting the user to stop execution of JavaScript. <p> Note that {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords groupByMaxRecords} must be set at least as high as {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold groupByAsyncThreshold} or asynchronous grouping will
     * never be used. <p> During asynch grouping, interactivity is blocked and the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAsynchGroupingPrompt asynchGroupingPrompt} is shown to the user, then
     * hidden when grouping completes; {@link com.smartgwt.client.widgets.grid.ListGrid#addGroupByCompleteHandler
     * ListGrid.groupByComplete()} then fires. <p> Note that this async processing covers grouping <b>only</b> - it does not
     * cover whole grid or per-group summaries, client-side sort or filter, or other operations that may cause the browser to
     * show the "script is running slowly" prompt when working with very large sets of records in a grid. <p> At this time,
     * there is no generally effective way to avoid this warning dialog appearing with very large datasets in Microsoft's
     * Internet Explorer (IE).  IE's severely flawed detection algorithm for runaway scripts has been shown to interrupt
     * computations after only 0.2 seconds elapsed time even if the computation would have finished in 0.3 seconds. 
     * Optimizations that reduce execution time can sometimes trigger the "script running slowly" dialog sooner.  Since not
     * every operation can reasonably be made asychronous, the current recommendation is to avoid working with overly large
     * datasets until the affected versions of IE are obsoleted.
     *
     * @return int
     */
    public int getGroupByAsyncThreshold()  {
        return getAttributeAsInt("groupByAsyncThreshold");
    }
    

    /**
     * List of fields to group grid records. If only a single field is used, that field may be specified as a string. After
     * initialization, use {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy ListGrid.groupBy()} to update the grouping
     * field list, instead of modifying groupByField directly.
     *
     * @param groupByField  Default value is see below
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_grouping_dynamic" target="examples">Dynamic Grouping Example</a>
     */
    public void setGroupByField(String groupByField)  throws IllegalStateException {
        setAttribute("groupByField", groupByField, false);
    }

    /**
     * List of fields to group grid records. If only a single field is used, that field may be specified as a string. After
     * initialization, use {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy ListGrid.groupBy()} to update the grouping
     * field list, instead of modifying groupByField directly.
     *
     * @param groupByField  Default value is see below
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_grouping_dynamic" target="examples">Dynamic Grouping Example</a>
     */
    public void setGroupByField(String... groupByField)  throws IllegalStateException {
        setAttribute("groupByField", groupByField, false);
    }
    

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByField grouped}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, this attribute may be set to an
     * array of groupBy field names for which group summaries should appear. <P> This is particularly useful for listGrids
     * grouped by more than one field as it allows developers to display the group summary for a particular nested group
     * without showing a summary for every level of the tree.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByFieldSummaries groupByFieldSummaries} attribute
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param groupByFieldSummaries new value for this.groupByFieldSummaries. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowGroupSummary
     */
    public void setGroupByFieldSummaries(String... groupByFieldSummaries) {
        setAttribute("groupByFieldSummaries", groupByFieldSummaries, true);
    }

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByField grouped}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, this attribute may be set to an
     * array of groupBy field names for which group summaries should appear. <P> This is particularly useful for listGrids
     * grouped by more than one field as it allows developers to display the group summary for a particular nested group
     * without showing a summary for every level of the tree.
     *
     * @return String...
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary
     */
    public String[] getGroupByFieldSummaries()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("groupByFieldSummaries"));
    }
    

    /**
     * Maximum number of records to which a groupBy can be applied. If there are more records, grouping will not be available
     * via the default header context menu, and calls to {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * ListGrid.groupBy()} will be ignored. <P> The maximum exists because ListGrid grouping is performed in-browser, hence
     * requires loading of all records that match the current filter criteria before records can be grouped.  The default
     * maximum represents a number of records which are safe to load in legacy browsers such as Internet Explorer 8 (modern
     * browsers can handle far more), and is also a good upper limit from the perspective of loading data from a database. <P>
     * Going beyond this limit can cause "script running slowly" errors from legacy browsers (as well as high database load). 
     * To build an interface for grouping that handles arbitrary data volume, use a TreeGrid with {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getLoadDataOnDemand loadDataOnDemand} with server-side grouping code.
     *
     * @param groupByMaxRecords  Default value is 1000
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setGroupByMaxRecords(int groupByMaxRecords) {
        setAttribute("groupByMaxRecords", groupByMaxRecords, true);
    }

    /**
     * Maximum number of records to which a groupBy can be applied. If there are more records, grouping will not be available
     * via the default header context menu, and calls to {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * ListGrid.groupBy()} will be ignored. <P> The maximum exists because ListGrid grouping is performed in-browser, hence
     * requires loading of all records that match the current filter criteria before records can be grouped.  The default
     * maximum represents a number of records which are safe to load in legacy browsers such as Internet Explorer 8 (modern
     * browsers can handle far more), and is also a good upper limit from the perspective of loading data from a database. <P>
     * Going beyond this limit can cause "script running slowly" errors from legacy browsers (as well as high database load). 
     * To build an interface for grouping that handles arbitrary data volume, use a TreeGrid with {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getLoadDataOnDemand loadDataOnDemand} with server-side grouping code.
     *
     * @return int
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public int getGroupByMaxRecords()  {
        return getAttributeAsInt("groupByMaxRecords");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy this.canGroupBy} is true, this string will be
     * shown as the title for the menu item to toggle the group by setting for a field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Group by " + the field's summary title.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param groupByText  See {@link com.smartgwt.client.docs.HTMLString HTMLString} . Default value is "Group by ${title}"
     */
    public void setGroupByText(String groupByText) {
        setAttribute("groupByText", groupByText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy this.canGroupBy} is true, this string will be
     * shown as the title for the menu item to toggle the group by setting for a field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Group by " + the field's summary title.
     *
     * @return If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy this.canGroupBy} is true, this string will be
     * shown as the title for the menu item to toggle the group by setting for a field.<br> Default implementation evaluates
     * and returns the dynamic {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByText groupByText} string. See {@link com.smartgwt.client.docs.HTMLString HTMLString} 
     */
    public String getGroupByText()  {
        return getAttributeAsString("groupByText");
    }
    

    /**
     * The URL of the base icon for the group icons in this listGrid. Default value may  be overridden by the {@link
     * com.smartgwt.client.docs.Skinning current skin}.
     *
     * @param groupIcon  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is "[SKINIMG]/TreeGrid/opener.gif"
     */
    public void setGroupIcon(String groupIcon) {
        setAttribute("groupIcon", groupIcon, true);
    }

    /**
     * The URL of the base icon for the group icons in this listGrid. Default value may  be overridden by the {@link
     * com.smartgwt.client.docs.Skinning current skin}.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     */
    public String getGroupIcon()  {
        return getAttributeAsString("groupIcon");
    }
    

    /**
     * Default width and height of group icons for this ListGrid.
     *
     * @param groupIconSize  Default value is 16
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setGroupIconSize(int groupIconSize) {
        setAttribute("groupIconSize", groupIconSize, true);
    }

    /**
     * Default width and height of group icons for this ListGrid.
     *
     * @return int
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public int getGroupIconSize()  {
        return getAttributeAsInt("groupIconSize");
    }
    

    /**
     * Default number of pixels by which to indent subgroups relative to parent group.
     *
     * @param groupIndentSize  Default value is 20
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeHTML
     */
    public void setGroupIndentSize(int groupIndentSize) {
        setAttribute("groupIndentSize", groupIndentSize, true);
    }

    /**
     * Default number of pixels by which to indent subgroups relative to parent group.
     *
     * @return int
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeHTML
     */
    public int getGroupIndentSize()  {
        return getAttributeAsInt("groupIndentSize");
    }
    

    /**
     * Default number of pixels by which to indent all groups.
     *
     * @param groupLeadingIndent  Default value is 10
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeHTML
     */
    public void setGroupLeadingIndent(int groupLeadingIndent) {
        setAttribute("groupLeadingIndent", groupLeadingIndent, true);
    }

    /**
     * Default number of pixels by which to indent all groups.
     *
     * @return int
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     * @see com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeHTML
     */
    public int getGroupLeadingIndent()  {
        return getAttributeAsInt("groupLeadingIndent");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle Base style} for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy group} rows. <P> Note that this property has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeStyle groupNodeStyle} is non null.
     *
     * @param groupNodeBaseStyle  Default value is null
     */
    public void setGroupNodeBaseStyle(String groupNodeBaseStyle) {
        setAttribute("groupNodeBaseStyle", groupNodeBaseStyle, true);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle Base style} for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy group} rows. <P> Note that this property has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeStyle groupNodeStyle} is non null.
     *
     * @return String
     */
    public String getGroupNodeBaseStyle()  {
        return getAttributeAsString("groupNodeBaseStyle");
    }
    

    /**
     * The CSS style that {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy group} rows will have. <P> Note that this is
     * not a {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle base style}, so, if this property is set, group
     * nodes will not show stateful styling (different styles for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles alternateRecordStyles}, etc). To enable stateful
     * styling for groupNodes, set this property to <code>null</code> and specify a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeBaseStyle groupNodeBaseStyle}
     *
     * @param groupNodeStyle  Default value is "groupNode"
     */
    public void setGroupNodeStyle(String groupNodeStyle) {
        setAttribute("groupNodeStyle", groupNodeStyle, true);
    }

    /**
     * The CSS style that {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy group} rows will have. <P> Note that this is
     * not a {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle base style}, so, if this property is set, group
     * nodes will not show stateful styling (different styles for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles alternateRecordStyles}, etc). To enable stateful
     * styling for groupNodes, set this property to <code>null</code> and specify a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupNodeBaseStyle groupNodeBaseStyle}
     *
     * @return String
     */
    public String getGroupNodeStyle()  {
        return getAttributeAsString("groupNodeStyle");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getSortByGroupFirst sortByGroupFirst} is active, the sorting
     * direction applied for implicit  sorting by the field(s) used for grouping. Default of null means that sort direction  is
     * based on the current direction of user-configured sort, or is "ascending" if the  user has not sorted the data.
     *
     * @param groupSortDirection  Default value is null
     */
    public void setGroupSortDirection(SortDirection groupSortDirection) {
        setAttribute("groupSortDirection", groupSortDirection == null ? null : groupSortDirection.getValue(), true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getSortByGroupFirst sortByGroupFirst} is active, the sorting
     * direction applied for implicit  sorting by the field(s) used for grouping. Default of null means that sort direction  is
     * based on the current direction of user-configured sort, or is "ascending" if the  user has not sorted the data.
     *
     * @return SortDirection
     */
    public SortDirection getGroupSortDirection()  {
        return EnumUtil.getEnum(SortDirection.values(), getAttribute("groupSortDirection"));
    }
    
    

    /**
     * Initial group state for the grid. <P> {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState viewState} can be
     * used to initialize all view properties of the grid. When doing so, <code>groupState</code> is not needed because
     * <code>viewState</code> includes it as well. If both are provided, <code>groupState</code> has priority for group state.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Reset this grid's grouping to match the {@link com.smartgwt.client.docs.ListGridGroupState} object passed in.<br> Used to restore previous state retrieved from the grid by a call to {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupState ListGrid.getGroupState()}.
     *
     * @param groupState Object describing the desired grouping state of                                              the grid See {@link com.smartgwt.client.docs.ListGridGroupState ListGridGroupState} . Default value is null
     */
    public void setGroupState(String groupState) {
        setAttribute("groupState", groupState, true);
    }

    /**
     * Initial group state for the grid. <P> {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState viewState} can be
     * used to initialize all view properties of the grid. When doing so, <code>groupState</code> is not needed because
     * <code>viewState</code> includes it as well. If both are provided, <code>groupState</code> has priority for group state.
     *
     * @return Returns a snapshot of the current grouping state of this ListGrid.<br> This object can be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setGroupState ListGrid.setGroupState()} to reset this grid's grouping to the
     * current state (assuming the same data / fields are present in the grid).<br> See {@link com.smartgwt.client.docs.ListGridGroupState ListGridGroupState} 
     */
    public String getGroupState()  {
        return getAttributeAsString("groupState");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, this attribute will
     * be set to true on each record object representing a group-level summary row.
     *
     * @param groupSummaryRecordProperty  Default value is "isGroupSummary"
     */
    public void setGroupSummaryRecordProperty(String groupSummaryRecordProperty) {
        setAttribute("groupSummaryRecordProperty", groupSummaryRecordProperty, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, this attribute will
     * be set to true on each record object representing a group-level summary row.
     *
     * @return String
     */
    public String getGroupSummaryRecordProperty()  {
        return getAttributeAsString("groupSummaryRecordProperty");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGridRecord#getCustomStyle customStyle} for the group-level summary row
     * displayed when {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true.
     *
     * @param groupSummaryStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is "gridSummaryCell"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setGroupSummaryStyle(String groupSummaryStyle)  throws IllegalStateException {
        setAttribute("groupSummaryStyle", groupSummaryStyle, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGridRecord#getCustomStyle customStyle} for the group-level summary row
     * displayed when {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     */
    public String getGroupSummaryStyle()  {
        return getAttributeAsString("groupSummaryStyle");
    }
    
    

    /**
     * Custom properties for the automatically generated <code>groupTitleColumn</code>. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn showGroupTitleColumn} for an overview of the
     * groupTitleColumn.
     *
     * @param groupTitleColumnProperties  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setGroupTitleColumnProperties(ListGridField groupTitleColumnProperties)  throws IllegalStateException {
        setAttribute("groupTitleColumnProperties", groupTitleColumnProperties.getJsObj(), false);
    }

    /**
     * Custom properties for the automatically generated <code>groupTitleColumn</code>. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn showGroupTitleColumn} for an overview of the
     * groupTitleColumn.
     *
     * @return ListGridField
     */
    public ListGridField getGroupTitleColumnProperties()  {
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("groupTitleColumnProperties"));
    }
    

    /**
     * When a list grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped}, each group shows under an auto
     * generated header node. By default the title of the group will be shown, with a hanging indent in this node, and will
     * span all columns in the grid. Setting this property causes the titles of auto-generated group nodes to appear as though
     * they were values of the designated field instead of spanning all columns and record values in the designated
     * groupTitleField will appear indented under the group title in a manner similar to how a TreeGrid shows a Tree. <P> Note
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, the
     * header nodes will not show a single spanning title value by default - instead they will show the summary values for each
     * field. In this case, if groupTitleField is unset, a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn groupTitleColumn} can be automatically generated to
     * show the title for each group.
     *
     * @param groupTitleField  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setGroupTitleField(String groupTitleField)  throws IllegalStateException {
        setAttribute("groupTitleField", groupTitleField, false);
    }

    /**
     * When a list grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped}, each group shows under an auto
     * generated header node. By default the title of the group will be shown, with a hanging indent in this node, and will
     * span all columns in the grid. Setting this property causes the titles of auto-generated group nodes to appear as though
     * they were values of the designated field instead of spanning all columns and record values in the designated
     * groupTitleField will appear indented under the group title in a manner similar to how a TreeGrid shows a Tree. <P> Note
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, the
     * header nodes will not show a single spanning title value by default - instead they will show the summary values for each
     * field. In this case, if groupTitleField is unset, a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn groupTitleColumn} can be automatically generated to
     * show the title for each group.
     *
     * @return String
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public String getGroupTitleField()  {
        return getAttributeAsString("groupTitleField");
    }
    
    

    /**
     * A Toolbar used to manager the headers shown for each column of the grid.
     * <p>
     * For an overview of how to use and configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Layout
     * @throws IllegalStateException if this widget has not yet been rendered.
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public Layout getHeader() throws IllegalStateException {
        errorIfNotCreated("header");
        return (Layout)Layout.getByJSObject(getAttributeAsJavaScriptObject("header"));
    }
    

    /**
     * Event on a ListGrid header that triggers auto fitting to data and/or title. <P> Note that if sorting is enabled for the
     * field and the headerAutoFitEvent is "click", both sorting and autofit occur on a click.
     *
     * @param headerAutoFitEvent  Default value is "doubleClick"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderAutoFitEvent(AutoFitEvent headerAutoFitEvent)  throws IllegalStateException {
        setAttribute("headerAutoFitEvent", headerAutoFitEvent == null ? null : headerAutoFitEvent.getValue(), false);
    }

    /**
     * Event on a ListGrid header that triggers auto fitting to data and/or title. <P> Note that if sorting is enabled for the
     * field and the headerAutoFitEvent is "click", both sorting and autofit occur on a click.
     *
     * @return AutoFitEvent
     */
    public AutoFitEvent getHeaderAutoFitEvent()  {
        return EnumUtil.getEnum(AutoFitEvent.values(), getAttribute("headerAutoFitEvent"));
    }
    

    /**
     * BackgroundColor for the header toolbar. Typically this is set to match the color of the header buttons.
     *
     * @param headerBackgroundColor  See {@link com.smartgwt.client.docs.Color Color} . Default value is "#CCCCCC"
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public void setHeaderBackgroundColor(String headerBackgroundColor) {
        setAttribute("headerBackgroundColor", headerBackgroundColor, true);
    }

    /**
     * BackgroundColor for the header toolbar. Typically this is set to match the color of the header buttons.
     *
     * @return  See {@link com.smartgwt.client.docs.Color Color} 
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public String getHeaderBackgroundColor()  {
        return getAttributeAsString("headerBackgroundColor");
    }
    

    /**
     * Set the CSS style used for the header as a whole.
     *
     * @param headerBarStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public void setHeaderBarStyle(String headerBarStyle)  throws IllegalStateException {
        setAttribute("headerBarStyle", headerBarStyle, false);
    }

    /**
     * Set the CSS style used for the header as a whole.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public String getHeaderBarStyle()  {
        return getAttributeAsString("headerBarStyle");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.Button#getBaseStyle baseStyle} to apply to the buttons in the header, and the sorter,
     * for this ListGrid. Note that, depending on the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor Class} of the header buttons, you may also need to
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderTitleStyle headerTitleStyle}.
     *
     * @param headerBaseStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public void setHeaderBaseStyle(String headerBaseStyle)  throws IllegalStateException {
        setAttribute("headerBaseStyle", headerBaseStyle, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.Button#getBaseStyle baseStyle} to apply to the buttons in the header, and the sorter,
     * for this ListGrid. Note that, depending on the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor Class} of the header buttons, you may also need to
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderTitleStyle headerTitleStyle}.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public String getHeaderBaseStyle()  {
        return getAttributeAsString("headerBaseStyle");
    }
    
    
    

    /**
     * Properties to apply to all header buttons. Overrides defaults applied via  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonDefaults headerButtonDefaults}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerButtonProperties  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public void setHeaderButtonProperties(Button headerButtonProperties)  throws IllegalStateException {
        JavaScriptObject config = headerButtonProperties == null ? null : headerButtonProperties.getConfig();
        setAttribute("headerButtonProperties", JSOHelper.cleanProperties(config, true), false);
    }

    /**
     * Properties to apply to all header buttons. Overrides defaults applied via  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonDefaults headerButtonDefaults}.
     *
     * @return Button
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public Button getHeaderButtonProperties()  {
        Button properties = new Button();
        properties.setConfigOnly(true);
        properties.setConfig(getAttributeAsJavaScriptObject("headerButtonProperties"));
        return properties;
    }
    

    /**
     * The context menu displayed for column headers.
     * <p>
     * For an overview of how to use and configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Canvas
     * @throws IllegalStateException if this widget has not yet been rendered.
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public Canvas getHeaderContextMenu() throws IllegalStateException {
        errorIfNotCreated("headerContextMenu");
        return (Canvas)Canvas.getByJSObject(getAttributeAsJavaScriptObject("headerContextMenu"));
    }
    

    /**
     * The height of this listGrid's header, in pixels.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Modify the height of a listGrid. To hide the header set height to zero.
     *
     * @param headerHeight new height for the header. Default value is 22
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public void setHeaderHeight(int headerHeight) {
        setAttribute("headerHeight", headerHeight, true);
    }

    /**
     * The height of this listGrid's header, in pixels.
     *
     * @return int
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public int getHeaderHeight()  {
        return getAttributeAsInt("headerHeight");
    }
    

    /**
     * This property may be set to customize the alignment for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @param headerHoverAlign  Default value is null
     */
    public void setHeaderHoverAlign(Alignment headerHoverAlign) {
        setAttribute("headerHoverAlign", headerHoverAlign == null ? null : headerHoverAlign.getValue(), true);
    }

    /**
     * This property may be set to customize the alignment for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @return Alignment
     */
    public Alignment getHeaderHoverAlign()  {
        return EnumUtil.getEnum(Alignment.values(), getAttribute("headerHoverAlign"));
    }
    

    /**
     * Optional default height for the hover shown on {@link com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler
     * ListGrid.headerHover()}.
     *
     * @param headerHoverHeight  Default value is null
     */
    public void setHeaderHoverHeight(Integer headerHoverHeight) {
        setAttribute("headerHoverHeight", headerHoverHeight, true);
    }

    /**
     * Optional default height for the hover shown on {@link com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler
     * ListGrid.headerHover()}.
     *
     * @return Integer
     */
    public Integer getHeaderHoverHeight()  {
        return getAttributeAsInt("headerHoverHeight");
    }
    

    /**
     * This property may be set to customize the opacity for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @param headerHoverOpacity  Default value is null
     */
    public void setHeaderHoverOpacity(Integer headerHoverOpacity) {
        setAttribute("headerHoverOpacity", headerHoverOpacity, true);
    }

    /**
     * This property may be set to customize the opacity for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @return Integer
     */
    public Integer getHeaderHoverOpacity()  {
        return getAttributeAsInt("headerHoverOpacity");
    }
    

    /**
     * This property may be set to customize the css style for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @param headerHoverStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is null
     */
    public void setHeaderHoverStyle(String headerHoverStyle) {
        setAttribute("headerHoverStyle", headerHoverStyle, true);
    }

    /**
     * This property may be set to customize the css style for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     */
    public String getHeaderHoverStyle()  {
        return getAttributeAsString("headerHoverStyle");
    }
    

    /**
     * This property may be set to customize the vertical alignment for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @param headerHoverVAlign  Default value is null
     */
    public void setHeaderHoverVAlign(VerticalAlignment headerHoverVAlign) {
        setAttribute("headerHoverVAlign", headerHoverVAlign == null ? null : headerHoverVAlign.getValue(), true);
    }

    /**
     * This property may be set to customize the vertical alignment for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @return VerticalAlignment
     */
    public VerticalAlignment getHeaderHoverVAlign()  {
        return EnumUtil.getEnum(VerticalAlignment.values(), getAttribute("headerHoverVAlign"));
    }
    

    /**
     * Optional default width for the hover shown on {@link com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler
     * ListGrid.headerHover()}.
     *
     * @param headerHoverWidth  Default value is null
     */
    public void setHeaderHoverWidth(Integer headerHoverWidth) {
        setAttribute("headerHoverWidth", headerHoverWidth, true);
    }

    /**
     * Optional default width for the hover shown on {@link com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler
     * ListGrid.headerHover()}.
     *
     * @return Integer
     */
    public Integer getHeaderHoverWidth()  {
        return getAttributeAsInt("headerHoverWidth");
    }
    

    /**
     * This property may be set to customize the <code>wrap</code> attribute for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @param headerHoverWrap  Default value is null
     */
    public void setHeaderHoverWrap(Boolean headerHoverWrap) {
        setAttribute("headerHoverWrap", headerHoverWrap, true);
    }

    /**
     * This property may be set to customize the <code>wrap</code> attribute for the hover shown on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler ListGrid.headerHover()}.
     *
     * @return Boolean
     */
    public Boolean getHeaderHoverWrap()  {
        return getAttributeAsBoolean("headerHoverWrap");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, when the user
     * rolls over the header buttons in this grid the headerMenuButton will be shown over the header button in question. When
     * clicked this button will display the standard header context menu (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#displayHeaderContextMenu ListGrid.displayHeaderContextMenu()}). <P> {@link
     * com.smartgwt.client.docs.HeaderMenuButton Several properties} exist to customize the appearance of the headerMenuButton.
     * Also see the {@link com.smartgwt.client.types.AutoChild} documentation for information on how to make freeform
     * modifications to autoChild widgets
     * <p>
     * For an overview of how to use and configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return StatefulCanvas
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public StatefulCanvas getHeaderMenuButton() throws IllegalStateException {
        errorIfNotCreated("headerMenuButton");
        return (StatefulCanvas)StatefulCanvas.getByJSObject(getAttributeAsJavaScriptObject("headerMenuButton"));
    }
    
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonHeight  Default value is "100%"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderMenuButtonHeight(int headerMenuButtonHeight)  throws IllegalStateException {
        setAttribute("headerMenuButtonHeight", headerMenuButtonHeight, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the auto-generated <code>headerMenuButton</code>
     *
     * @return int
     */
    public int getHeaderMenuButtonHeight()  {
        return getAttributeAsInt("headerMenuButtonHeight");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the icon shown on the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonIcon  Default value is "[SKIN]/ListGrid/headerMenuButton_icon.gif"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderMenuButtonIcon(String headerMenuButtonIcon)  throws IllegalStateException {
        setAttribute("headerMenuButtonIcon", headerMenuButtonIcon, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the icon shown on the auto-generated <code>headerMenuButton</code>
     *
     * @return String
     */
    public String getHeaderMenuButtonIcon()  {
        return getAttributeAsString("headerMenuButtonIcon");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the icon shown on the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonIconHeight  Default value is 7
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderMenuButtonIconHeight(int headerMenuButtonIconHeight)  throws IllegalStateException {
        setAttribute("headerMenuButtonIconHeight", headerMenuButtonIconHeight, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the height of the icon shown on the auto-generated <code>headerMenuButton</code>
     *
     * @return int
     */
    public int getHeaderMenuButtonIconHeight()  {
        return getAttributeAsInt("headerMenuButtonIconHeight");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the width of the icon shown on the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonIconWidth  Default value is 7
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderMenuButtonIconWidth(int headerMenuButtonIconWidth)  throws IllegalStateException {
        setAttribute("headerMenuButtonIconWidth", headerMenuButtonIconWidth, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the width of the icon shown on the auto-generated <code>headerMenuButton</code>
     *
     * @return int
     */
    public int getHeaderMenuButtonIconWidth()  {
        return getAttributeAsInt("headerMenuButtonIconWidth");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the width of the auto-generated <code>headerMenuButton</code>
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param headerMenuButtonWidth  Default value is 16
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderMenuButtonWidth(int headerMenuButtonWidth)  throws IllegalStateException {
        setAttribute("headerMenuButtonWidth", headerMenuButtonWidth, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, this property
     * governs the width of the auto-generated <code>headerMenuButton</code>
     *
     * @return int
     */
    public int getHeaderMenuButtonWidth()  {
        return getAttributeAsInt("headerMenuButtonWidth");
    }
    

    /**
     * <b>Note :</b> This API is non-functional (always returns null) and exists only to make
     * you aware that this MultiAutoChild exists.  See {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}
     * for details.
     * <p>
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans} are created via the {@link
     * com.smartgwt.client.types.AutoChild} pattern, hence <code>headerSpanConstructor</code>, <code>headerSpanDefaults</code>
     * and <code>headerSpanProperties</code> are valid.
     *
     * @return null
     */
    public StatefulCanvas getHeaderSpan()  {
        return null;
    }
    
    

    /**
     * Default height for a {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpan} with no height
     * specified. <P> If <code>headerSpanHeight</code> is not specified (the default), headerSpans will be 1/2 of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight}.
     *
     * @param headerSpanHeight  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHeaderSpanHeight(Integer headerSpanHeight)  throws IllegalStateException {
        setAttribute("headerSpanHeight", headerSpanHeight, false);
    }

    /**
     * Default height for a {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpan} with no height
     * specified. <P> If <code>headerSpanHeight</code> is not specified (the default), headerSpans will be 1/2 of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight headerHeight}.
     *
     * @return Integer
     */
    public Integer getHeaderSpanHeight()  {
        return getAttributeAsInt("headerSpanHeight");
    }
    

    /**
     * Header spans are a second level of headers that appear above the normal ListGrid headers,
     *  spanning one or more listGrid fields in a manner similar to a column-spanning cell in an
     *  HTML table.
     *  <P>
     *  A header span can be created by simply naming the fields the header should span.  The
     *  example below creates a headerSpan that spans the first two fields of the ListGrid.
     *  
     *  
     *  <pre>
     *       ListGrid grid = new ListGrid();
     *       grid.setHeaderHeight(40);
     *       grid.setFields(new ListGridField[] {
     *           new ListGridField("field1"),
     *           new ListGridField("field2"),
     *           new ListGridField("field3")
     *       });
     *       grid.setHeaderSpans(new HeaderSpan[] {
     *           new HeaderSpan("Field 1 and 2", new String[] {"field1", "field2"})
     *       });
     *  <pre>
     *  
     *  Header spans can be nested, allowing fields to be grouped by multiple levels of
     * granularity. See {@link com.smartgwt.client.widgets.grid.HeaderSpan#getSpans spans} for further information on nesting
     * spans.
     *  <P>
     *  Header spans will automatically react to resizing of the headers they span, and will be
     *  hidden automatically when all of the spanned fields are hidden.
     *  <P>
     * Header spans appear in the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeader header} area of the ListGrid,
     * sharing space
     * with the existing headers, so it's typical to set {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderHeight
     * headerHeight} to
     *  approximately double its normal height when using headerSpans, or if using nested header
     *  spans, the default header height multiplied by the number of levels of header spans to be
     *  shown.
     *  <P>
     *  See {@link com.smartgwt.client.widgets.grid.HeaderSpan} for many properties that allow the control of the appearance of
     *  headerSpans.
     *  
     *  <P>
     *  Neither headerSpans themselves nor the fields within them may be drag reordered, but other
     *  unspanned headers may be.
     *  <P>
     *  A span can only span adjacent fields - if a span is defined and the spanned fields don't
     *  sit next to each other in the specified fields array, the fields array will be automatically
     * reorded to match the order specified in the span's {@link com.smartgwt.client.widgets.grid.HeaderSpan#getFields fields}
     * array.
     *  <P>
     *  Note that headerSpans primarily provide a visual cue for grouping multiple headers
     *  together.  If you have an OLAP, data "cube" or multi-dimensional data model, the
     *  {@link com.smartgwt.client.widgets.cube.CubeGrid} component is the right choice.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Update the headerSpans configuration on the grid dynamically.
     *
     * @param headerSpans same configuration block as that passed to                                          {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}.. Default value is null
     */
    public void setHeaderSpans(HeaderSpan... headerSpans) {
        setAttribute("headerSpans", headerSpans, true);
    }
    
    

    /**
     * {@link com.smartgwt.client.widgets.StretchImgButton#getTitleStyle titleStyle} to apply to the buttons in the header, and
     * the sorter, for this ListGrid. Note that this will typically only have an effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor headerButtonConstructor} is set to {@link
     * com.smartgwt.client.widgets.StretchImgButton} or a subclass thereof.
     *
     * @param headerTitleStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public void setHeaderTitleStyle(String headerTitleStyle)  throws IllegalStateException {
        setAttribute("headerTitleStyle", headerTitleStyle, false);
    }

    /**
     * {@link com.smartgwt.client.widgets.StretchImgButton#getTitleStyle titleStyle} to apply to the buttons in the header, and
     * the sorter, for this ListGrid. Note that this will typically only have an effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderButtonConstructor headerButtonConstructor} is set to {@link
     * com.smartgwt.client.widgets.StretchImgButton} or a subclass thereof.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public String getHeaderTitleStyle()  {
        return getAttributeAsString("headerTitleStyle");
    }
    

    /**
     * If set, end users can create advanced hiliting rules that will use the {@link
     * com.smartgwt.client.data.Hilite#getReplacementValue replacementValue} feature to cause values in hilited cells to be
     * replaced with a user-entered value.  For example, a user could create a hilite rule that replaces numeric values ranging
     * from 0.5 to 1.0 with the text "LOW". <p> Specifically, when the "Add Advanced Rule" button is pressed and
     * <code>hiliteCanReplaceValue</code> is true, the user will see a text entry field titled "Replace value with" ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteReplaceValueFieldTitle hiliteReplaceValueFieldTitle}) and if they
     * enter a value, that value will appear in the grid cell in lieue of the cell's original value.
     *
     * @param hiliteCanReplaceValue  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteCanReplaceValue(Boolean hiliteCanReplaceValue)  throws IllegalStateException {
        setAttribute("hiliteCanReplaceValue", hiliteCanReplaceValue, false);
    }

    /**
     * If set, end users can create advanced hiliting rules that will use the {@link
     * com.smartgwt.client.data.Hilite#getReplacementValue replacementValue} feature to cause values in hilited cells to be
     * replaced with a user-entered value.  For example, a user could create a hilite rule that replaces numeric values ranging
     * from 0.5 to 1.0 with the text "LOW". <p> Specifically, when the "Add Advanced Rule" button is pressed and
     * <code>hiliteCanReplaceValue</code> is true, the user will see a text entry field titled "Replace value with" ({@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteReplaceValueFieldTitle hiliteReplaceValueFieldTitle}) and if they
     * enter a value, that value will appear in the grid cell in lieue of the cell's original value.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public Boolean getHiliteCanReplaceValue()  {
        return getAttributeAsBoolean("hiliteCanReplaceValue");
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInHiliteEditor showHeaderSpanTitlesInHiliteEditor} is
     * true, this string will be inserted between the headerSpan title and the field title in the hiliteEditor field chooser
     * grid.
     *
     * @param hiliteEditorSpanTitleSeparator  Default value is " - "
     */
    public void setHiliteEditorSpanTitleSeparator(String hiliteEditorSpanTitleSeparator) {
        setAttribute("hiliteEditorSpanTitleSeparator", hiliteEditorSpanTitleSeparator, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInHiliteEditor showHeaderSpanTitlesInHiliteEditor} is
     * true, this string will be inserted between the headerSpan title and the field title in the hiliteEditor field chooser
     * grid.
     *
     * @return String
     */
    public String getHiliteEditorSpanTitleSeparator()  {
        return getAttributeAsString("hiliteEditorSpanTitleSeparator");
    }
    

    /**
     * If set to true, custom HTML applied as part of hiliting will be applied after {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter formatting} for each cell. If false, hilite HTML will be
     * applied before formatting. <P> This applies to the following hilite properties: <ul> <li>{@link
     * com.smartgwt.client.data.Hilite#getReplacementValue replacementValue}</li> <li>{@link
     * com.smartgwt.client.data.Hilite#getHtmlBefore htmlBefore}</li> <li>{@link com.smartgwt.client.data.Hilite#getHtmlAfter
     * htmlAfter}</li> <li>{@link com.smartgwt.client.data.Hilite#getHtmlValue htmlValue}</li> </ul> <P> May be overridden per
     * field via {@link com.smartgwt.client.widgets.grid.ListGridField#getHiliteHTMLAfterFormat hiliteHTMLAfterFormat}
     *
     * @param hiliteHTMLAfterFormat  Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHiliteHTMLAfterFormat(boolean hiliteHTMLAfterFormat)  throws IllegalStateException {
        setAttribute("hiliteHTMLAfterFormat", hiliteHTMLAfterFormat, false);
    }

    /**
     * If set to true, custom HTML applied as part of hiliting will be applied after {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter formatting} for each cell. If false, hilite HTML will be
     * applied before formatting. <P> This applies to the following hilite properties: <ul> <li>{@link
     * com.smartgwt.client.data.Hilite#getReplacementValue replacementValue}</li> <li>{@link
     * com.smartgwt.client.data.Hilite#getHtmlBefore htmlBefore}</li> <li>{@link com.smartgwt.client.data.Hilite#getHtmlAfter
     * htmlAfter}</li> <li>{@link com.smartgwt.client.data.Hilite#getHtmlValue htmlValue}</li> </ul> <P> May be overridden per
     * field via {@link com.smartgwt.client.widgets.grid.ListGridField#getHiliteHTMLAfterFormat hiliteHTMLAfterFormat}
     *
     * @return boolean
     */
    public boolean getHiliteHTMLAfterFormat()  {
        Boolean result = getAttributeAsBoolean("hiliteHTMLAfterFormat");
        return result == null ? true : result;
    }
    

    /**
     * Height for hilite icons for this listGrid. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconSize
     * hiliteIconSize}. Can be overridden at the field level
     *
     * @param hiliteIconHeight  Default value is null
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteIconHeight(Integer hiliteIconHeight) {
        setAttribute("hiliteIconHeight", hiliteIconHeight, true);
    }

    /**
     * Height for hilite icons for this listGrid. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconSize
     * hiliteIconSize}. Can be overridden at the field level
     *
     * @return Integer
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public Integer getHiliteIconHeight()  {
        return getAttributeAsInt("hiliteIconHeight");
    }
    

    /**
     * How much padding should there be on the left of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite
     * icons} by default? Can be overridden at the field level
     *
     * @param hiliteIconLeftPadding  Default value is 2
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteIconLeftPadding(int hiliteIconLeftPadding) {
        setAttribute("hiliteIconLeftPadding", hiliteIconLeftPadding, true);
    }

    /**
     * How much padding should there be on the left of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite
     * icons} by default? Can be overridden at the field level
     *
     * @return int
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public int getHiliteIconLeftPadding()  {
        return getAttributeAsInt("hiliteIconLeftPadding");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hiliteIcons} are present, where the hilite icon
     * will be placed  relative to the field value.  See {@link com.smartgwt.client.types.HiliteIconPosition}. Can be overriden
     * at the field level.
     *
     * @param hiliteIconPosition  Default value is "before"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteIconPosition(HiliteIconPosition hiliteIconPosition)  throws IllegalStateException {
        setAttribute("hiliteIconPosition", hiliteIconPosition == null ? null : hiliteIconPosition.getValue(), false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hiliteIcons} are present, where the hilite icon
     * will be placed  relative to the field value.  See {@link com.smartgwt.client.types.HiliteIconPosition}. Can be overriden
     * at the field level.
     *
     * @return HiliteIconPosition
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public HiliteIconPosition getHiliteIconPosition()  {
        return EnumUtil.getEnum(HiliteIconPosition.values(), getAttribute("hiliteIconPosition"));
    }
    

    /**
     * How much padding should there be on the right of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite
     * icons} by default? Can be overridden at the field level
     *
     * @param hiliteIconRightPadding  Default value is 2
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteIconRightPadding(int hiliteIconRightPadding) {
        setAttribute("hiliteIconRightPadding", hiliteIconRightPadding, true);
    }

    /**
     * How much padding should there be on the right of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite
     * icons} by default? Can be overridden at the field level
     *
     * @return int
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public int getHiliteIconRightPadding()  {
        return getAttributeAsInt("hiliteIconRightPadding");
    }
    

    /**
     * Specifies a list of icons that can be used in {@link com.smartgwt.client.widgets.DataBoundComponent#editHilites
     * hilites}. <P> <code>hiliteIcons</code> should be specified as an Array of {@link com.smartgwt.client.docs.SCImgURL}.
     * When present, the hilite editing interface shown when {@link com.smartgwt.client.widgets.DataBoundComponent#editHilites
     * DataBoundComponent.editHilites()} is called  will offer the user a drop down for picking one of these icons when
     * defining either a  simple or advanced hilite rule. <P> If the user picks an icon, the created hiliting rule will have
     * {@link com.smartgwt.client.data.Hilite#getIcon icon} set to  the chosen icon.  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getHiliteIconPosition hiliteIconPosition} controls where the icon will 
     * appear for that field -- the default is that it appears in front of the normal cell content. This can also be overriden
     * at the field level.
     *
     * @param hiliteIcons  Default value is ["[SKINIMG]/Dialog/notify.png", "[SKINIMG]/Dialog/warn.png", "[SKINIMG]/actions/approve.png"]
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteIcons(String... hiliteIcons)  throws IllegalStateException {
        setAttribute("hiliteIcons", hiliteIcons, false);
    }

    /**
     * Specifies a list of icons that can be used in {@link com.smartgwt.client.widgets.DataBoundComponent#editHilites
     * hilites}. <P> <code>hiliteIcons</code> should be specified as an Array of {@link com.smartgwt.client.docs.SCImgURL}.
     * When present, the hilite editing interface shown when {@link com.smartgwt.client.widgets.DataBoundComponent#editHilites
     * DataBoundComponent.editHilites()} is called  will offer the user a drop down for picking one of these icons when
     * defining either a  simple or advanced hilite rule. <P> If the user picks an icon, the created hiliting rule will have
     * {@link com.smartgwt.client.data.Hilite#getIcon icon} set to  the chosen icon.  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getHiliteIconPosition hiliteIconPosition} controls where the icon will 
     * appear for that field -- the default is that it appears in front of the normal cell content. This can also be overriden
     * at the field level.
     *
     * @return String...
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public String[] getHiliteIcons()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("hiliteIcons"));
    }
    

    /**
     * Default width and height of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite icons} for this
     * component. Can be overridden at the component level via explicit  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconWidth hiliteIconWidth} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconHeight hiliteIconHeight}, or at the field level via  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconSize hiliteIconSize}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconWidth hiliteIconWidth} and  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconHeight hiliteIconHeight}
     *
     * @param hiliteIconSize  Default value is 12
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHiliteIconWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHiliteIconHeight
     * @see com.smartgwt.client.widgets.grid.ListGridField#setHiliteIconSize
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteIconSize(int hiliteIconSize) {
        setAttribute("hiliteIconSize", hiliteIconSize, true);
    }

    /**
     * Default width and height of {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIcons hilite icons} for this
     * component. Can be overridden at the component level via explicit  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconWidth hiliteIconWidth} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconHeight hiliteIconHeight}, or at the field level via  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconSize hiliteIconSize}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconWidth hiliteIconWidth} and  {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconHeight hiliteIconHeight}
     *
     * @return int
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconHeight
     * @see com.smartgwt.client.widgets.grid.ListGridField#getHiliteIconSize
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public int getHiliteIconSize()  {
        return getAttributeAsInt("hiliteIconSize");
    }
    

    /**
     * Width for hilite icons for this component. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconSize
     * hiliteIconSize}. Can be overridden at the field level.
     *
     * @param hiliteIconWidth  Default value is null
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public void setHiliteIconWidth(Integer hiliteIconWidth) {
        setAttribute("hiliteIconWidth", hiliteIconWidth, true);
    }

    /**
     * Width for hilite icons for this component. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteIconSize
     * hiliteIconSize}. Can be overridden at the field level.
     *
     * @return Integer
     * @see com.smartgwt.client.docs.Hiliting Hiliting overview and related methods
     */
    public Integer getHiliteIconWidth()  {
        return getAttributeAsInt("hiliteIconWidth");
    }
    

    /**
     * Title used for the text box shown when {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteCanReplaceValue
     * hiliteCanReplaceValue} is set.
     *
     * @param hiliteReplaceValueFieldTitle  Default value is "Replace value with"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setHiliteReplaceValueFieldTitle(String hiliteReplaceValueFieldTitle)  throws IllegalStateException {
        setAttribute("hiliteReplaceValueFieldTitle", hiliteReplaceValueFieldTitle, false);
    }

    /**
     * Title used for the text box shown when {@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteCanReplaceValue
     * hiliteCanReplaceValue} is set.
     *
     * @return String
     */
    public String getHiliteReplaceValueFieldTitle()  {
        return getAttributeAsString("hiliteReplaceValueFieldTitle");
    }
    

    /**
     * When the grid body gets keyboard focus, should we highlight the current focus row, using the rollover cell style? <P>
     * This property may be explicitly set to control this behavior independently of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver}. Otherwise (if this property is null), we will
     * show the roll-over styling for the keyboard focus row if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} is true.
     *
     * @param hiliteRowOnFocus  Default value is null
     */
    public void setHiliteRowOnFocus(Boolean hiliteRowOnFocus) {
        setAttribute("hiliteRowOnFocus", hiliteRowOnFocus, true);
    }

    /**
     * When the grid body gets keyboard focus, should we highlight the current focus row, using the rollover cell style? <P>
     * This property may be explicitly set to control this behavior independently of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver}. Otherwise (if this property is null), we will
     * show the roll-over styling for the keyboard focus row if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} is true.
     *
     * @return Boolean
     */
    public Boolean getHiliteRowOnFocus()  {
        return getAttributeAsBoolean("hiliteRowOnFocus");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHoverComponents showHoverComponents} is true, the builtin
     * mode to use when automatically creating a hover component for rows in this grid. <P> A number of builtin modes are
     * provided - see {@link com.smartgwt.client.types.HoverMode}.  You can also override {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellHoverComponent getCellHoverComponent()} to provide a custom hover
     * widget - in that case, this attribute is ignored.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param hoverMode  Default value is null
     */
    public void setHoverMode(HoverMode hoverMode) {
        setAttribute("hoverMode", hoverMode == null ? null : hoverMode.getValue(), true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHoverComponents showHoverComponents} is true, the builtin
     * mode to use when automatically creating a hover component for rows in this grid. <P> A number of builtin modes are
     * provided - see {@link com.smartgwt.client.types.HoverMode}.  You can also override {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellHoverComponent getCellHoverComponent()} to provide a custom hover
     * widget - in that case, this attribute is ignored.
     *
     * @return HoverMode
     */
    public HoverMode getHoverMode()  {
        return EnumUtil.getEnum(HoverMode.values(), getAttribute("hoverMode"));
    }
    

    /**
     * Style to apply to hovers shown over this grid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param hoverStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is "gridHover"
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowHover
     */
    public void setHoverStyle(String hoverStyle) {
        setAttribute("hoverStyle", hoverStyle, true);
    }

    /**
     * Style to apply to hovers shown over this grid.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowHover
     */
    public String getHoverStyle()  {
        return getAttributeAsString("hoverStyle");
    }
    

    /**
     * When using {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths}, padding in pixels
     * left on each side of fields that show images.
     *
     * @param iconPadding  Default value is 2
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setIconPadding(Integer iconPadding)  throws IllegalStateException {
        setAttribute("iconPadding", iconPadding, false);
    }

    /**
     * When using {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths autoFitFieldWidths}, padding in pixels
     * left on each side of fields that show images.
     *
     * @return Integer
     */
    public Integer getIconPadding()  {
        return getAttributeAsInt("iconPadding");
    }
    

    /**
     * Default size of thumbnails shown for fieldTypes image and imageFile.  Overrideable on a per-field basis via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageSize imageSize} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageWidth imageWidth}/{@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageHeight imageHeight}
     *
     * @param imageSize  Default value is 16
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setImageSize(int imageSize) {
        setAttribute("imageSize", imageSize, true);
    }

    /**
     * Default size of thumbnails shown for fieldTypes image and imageFile.  Overrideable on a per-field basis via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageSize imageSize} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageWidth imageWidth}/{@link
     * com.smartgwt.client.widgets.grid.ListGridField#getImageHeight imageHeight}
     *
     * @return int
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public int getImageSize()  {
        return getAttributeAsInt("imageSize");
    }
    

    /**
     * When assembling a value for a {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAddSummaryFields summary field}, if
     * a referenced field is hilited, should the hilite HTML be included in the summary field value? <P> To control hilites
     * showing in group summaries, see {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHilitesInGroupSummary
     * showHilitesInGroupSummary}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param includeHilitesInSummaryFields  Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#shouldIncludeHiliteInSummaryField
     */
    public void setIncludeHilitesInSummaryFields(boolean includeHilitesInSummaryFields) {
        setAttribute("includeHilitesInSummaryFields", includeHilitesInSummaryFields, true);
    }

    /**
     * When assembling a value for a {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAddSummaryFields summary field}, if
     * a referenced field is hilited, should the hilite HTML be included in the summary field value? <P> To control hilites
     * showing in group summaries, see {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHilitesInGroupSummary
     * showHilitesInGroupSummary}.
     *
     * @return boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#shouldIncludeHiliteInSummaryField
     */
    public boolean getIncludeHilitesInSummaryFields()  {
        Boolean result = getAttributeAsBoolean("includeHilitesInSummaryFields");
        return result == null ? false : result;
    }
    

    /**
     * Property name on a record that will be checked to determine whether a record should be included when calculating totals
     * for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary}.
     *
     * @param includeInSummaryProperty  Default value is "includeInSummary"
     */
    public void setIncludeInSummaryProperty(String includeInSummaryProperty) {
        setAttribute("includeInSummaryProperty", includeInSummaryProperty, true);
    }

    /**
     * Property name on a record that will be checked to determine whether a record should be included when calculating totals
     * for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary}.
     *
     * @return String
     */
    public String getIncludeInSummaryProperty()  {
        return getAttributeAsString("includeInSummaryProperty");
    }
    
    

    /**
     * An array of {@link com.smartgwt.client.data.SortSpecifier} objects used to set up the initial sort configuration for
     * this grid. If specified, this will be used instead of any {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField
     * sortField} specified.
     *
     * @param initialSort  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setInitialSort(SortSpecifier... initialSort)  throws IllegalStateException {
        setAttribute("initialSort", initialSort, false);
    }

    /**
     * An array of {@link com.smartgwt.client.data.SortSpecifier} objects used to set up the initial sort configuration for
     * this grid. If specified, this will be used instead of any {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField
     * sortField} specified.
     *
     * @return SortSpecifier...
     */
    public SortSpecifier[] getInitialSort()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfSortSpecifier(getAttributeAsJavaScriptObject("initialSort"));
    }
    

    /**
     * If true, if the user clicks on the scroll buttons at the end of the track or clicks once on the scroll track, there will
     * be an instant redraw of the grid content so that the user doesn't see any blank space.  For drag scrolling or other
     * types of scrolling, the {@link com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}
     * applies.
     *
     * @param instantScrollTrackRedraw  Default value is true
     */
    public void setInstantScrollTrackRedraw(Boolean instantScrollTrackRedraw) {
        setAttribute("instantScrollTrackRedraw", instantScrollTrackRedraw, true);
    }

    /**
     * If true, if the user clicks on the scroll buttons at the end of the track or clicks once on the scroll track, there will
     * be an instant redraw of the grid content so that the user doesn't see any blank space.  For drag scrolling or other
     * types of scrolling, the {@link com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}
     * applies.
     *
     * @return Boolean
     */
    public Boolean getInstantScrollTrackRedraw()  {
        Boolean result = getAttributeAsBoolean("instantScrollTrackRedraw");
        return result == null ? true : result;
    }
    

    /**
     * Value to display to the user if showing summary values (through {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} or {@link
     * com.smartgwt.client.types.ListGridFieldType listGridFieldType:"summary"}), and the summary function returns
     * <code>"null"</code> (implying it was unable to calculate a valid summary value). This property will only be used in the
     * default formatting behavior. If an explicit formatter has been specified - via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter ListGrid.setCellFormatter()} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFormatGridSummary formatGridSummary()}, for example - this property
     * has no effect.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param invalidSummaryValue  Default value is "&amp;nbsp;"
     */
    public void setInvalidSummaryValue(String invalidSummaryValue) {
        setAttribute("invalidSummaryValue", invalidSummaryValue, true);
    }

    /**
     * Value to display to the user if showing summary values (through {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} or {@link
     * com.smartgwt.client.types.ListGridFieldType listGridFieldType:"summary"}), and the summary function returns
     * <code>"null"</code> (implying it was unable to calculate a valid summary value). This property will only be used in the
     * default formatting behavior. If an explicit formatter has been specified - via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter ListGrid.setCellFormatter()} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFormatGridSummary formatGridSummary()}, for example - this property
     * has no effect.
     *
     * @return String
     */
    public String getInvalidSummaryValue()  {
        return getAttributeAsString("invalidSummaryValue");
    }
    

    /**
     * True if this listgrid is grouped, false otherwise
     * <p>
     * <b>Note :</b> This method should be called only after the widget has been rendered.
     *
     * @return boolean
     * @throws IllegalStateException if this widget has not yet been rendered.
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public boolean getIsGrouped() throws IllegalStateException {
        errorIfNotCreated("isGrouped");
        Boolean result = getAttributeAsBoolean("isGrouped");
        return result == null ? false : result;
    }
    

    /**
     * If <code>record[this.isSeparatorProperty]</code> is set for some record, the record will be displayed as a simple
     * separator row.
     *
     * @param isSeparatorProperty  Default value is "isSeparator"
     */
    public void setIsSeparatorProperty(String isSeparatorProperty) {
        setAttribute("isSeparatorProperty", isSeparatorProperty, true);
    }

    /**
     * If <code>record[this.isSeparatorProperty]</code> is set for some record, the record will be displayed as a simple
     * separator row.
     *
     * @return String
     */
    public String getIsSeparatorProperty()  {
        return getAttributeAsString("isSeparatorProperty");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderMenuButton showHeaderMenuButton} is true, when
     * auto-fitting fields to the title width via {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths
     * autoFitFieldWidths} or {@link com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autoFitWidth}, should the
     * button be sized such that there is enough space for the header menu button to show without covering the field title? <P>
     * May be explicitly specified at the {@link com.smartgwt.client.widgets.grid.ListGridField#getLeaveHeaderMenuButtonSpace
     * field level} or at the {@link com.smartgwt.client.widgets.grid.ListGrid#getLeaveHeaderMenuButtonSpace grid level}. If
     * not explicitly specified space will be left for fields with {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAlign align} set to <code>"left"</code> or <code>"right"</code>, but
     * not for fields with align set to <code>"center"</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param leaveHeaderMenuButtonSpace  Default value is null
     */
    public void setLeaveHeaderMenuButtonSpace(Boolean leaveHeaderMenuButtonSpace) {
        setAttribute("leaveHeaderMenuButtonSpace", leaveHeaderMenuButtonSpace, true);
    }
    

    /**
     * Whether to leave a gap for the vertical scrollbar, even when it's not present. <P> Note that if leaveScrollbarGap is
     * false and vertical scrolling is introduced, fields will be resized to fit the smaller body area if possible, in order to
     * avoid horizontal scrolling also being required.
     *
     * @param leaveScrollbarGap  Default value is true
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public void setLeaveScrollbarGap(Boolean leaveScrollbarGap) {
        setAttribute("leaveScrollbarGap", leaveScrollbarGap, true);
    }

    /**
     * Whether to leave a gap for the vertical scrollbar, even when it's not present. <P> Note that if leaveScrollbarGap is
     * false and vertical scrolling is introduced, fields will be resized to fit the smaller body area if possible, in order to
     * avoid horizontal scrolling also being required.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public Boolean getLeaveScrollbarGap()  {
        Boolean result = getAttributeAsBoolean("leaveScrollbarGap");
        return result == null ? true : result;
    }
    

    /**
     * Property name on a record that will hold the link text for that record. <P> This property is configurable to avoid
     * possible collision with data values in the record. <P> Use {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getLinkTextProperty linkTextProperty} if you have more than one link
     * field and
     *
     * @param linkTextProperty  Default value is "linkText"
     * @see com.smartgwt.client.types.ListGridFieldType
     * @see com.smartgwt.client.types.FieldType
     * @see com.smartgwt.client.widgets.grid.ListGridField#setLinkText
     * @see com.smartgwt.client.widgets.grid.ListGridField#setLinkTextProperty
     */
    public void setLinkTextProperty(String linkTextProperty) {
        setAttribute("linkTextProperty", linkTextProperty, true);
    }

    /**
     * Property name on a record that will hold the link text for that record. <P> This property is configurable to avoid
     * possible collision with data values in the record. <P> Use {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getLinkTextProperty linkTextProperty} if you have more than one link
     * field and
     *
     * @return String
     * @see com.smartgwt.client.types.ListGridFieldType
     * @see com.smartgwt.client.types.FieldType
     * @see com.smartgwt.client.widgets.grid.ListGridField#getLinkText
     * @see com.smartgwt.client.widgets.grid.ListGridField#getLinkTextProperty
     */
    public String getLinkTextProperty()  {
        return getAttributeAsString("linkTextProperty");
    }
    

    /**
     * If the user is editing the last record in this listGrid, and attempts to navigate beyond the last row either by tabbing
     * off the last editable field, or using the down arrow key, this property determines what action to take:<ul> <li>"next":
     * start editing a new record at the end of the list. <li>"done": hide the editor <li>"stop": leave focus in the cell being
     * edited <li>"none": no action </ul> <P> See the {@link com.smartgwt.client.docs.Editing Grid Editing overview} and also
     * the {@link com.smartgwt.client.docs.UnsavedRecords Editing Unsaved Records overview} for context about how newly added
     * records behave.
     *
     * @param listEndEditAction  Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_new_row" target="examples">Enter new rows Example</a>
     */
    public void setListEndEditAction(RowEndEditAction listEndEditAction) {
        setAttribute("listEndEditAction", listEndEditAction == null ? null : listEndEditAction.getValue(), true);
    }

    /**
     * If the user is editing the last record in this listGrid, and attempts to navigate beyond the last row either by tabbing
     * off the last editable field, or using the down arrow key, this property determines what action to take:<ul> <li>"next":
     * start editing a new record at the end of the list. <li>"done": hide the editor <li>"stop": leave focus in the cell being
     * edited <li>"none": no action </ul> <P> See the {@link com.smartgwt.client.docs.Editing Grid Editing overview} and also
     * the {@link com.smartgwt.client.docs.UnsavedRecords Editing Unsaved Records overview} for context about how newly added
     * records behave.
     *
     * @return RowEndEditAction
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_new_row" target="examples">Enter new rows Example</a>
     */
    public RowEndEditAction getListEndEditAction()  {
        return EnumUtil.getEnum(RowEndEditAction.values(), getAttribute("listEndEditAction"));
    }
    

    /**
     * The string to display in the body of a listGrid while data is being loaded. Use <code>"&#36;{loadingImage}"</code> to
     * include {@link com.smartgwt.client.widgets.Canvas#loadingImageSrc a loading image}.
     *
     * @param loadingDataMessage  See {@link com.smartgwt.client.docs.HTMLString HTMLString} . Default value is "${loadingImage}&amp;nbsp;Loading data..."
     * @see com.smartgwt.client.widgets.grid.ListGrid#setLoadingDataMessageStyle
     */
    public void setLoadingDataMessage(String loadingDataMessage) {
        setAttribute("loadingDataMessage", loadingDataMessage, true);
    }

    /**
     * The string to display in the body of a listGrid while data is being loaded. Use <code>"&#36;{loadingImage}"</code> to
     * include {@link com.smartgwt.client.widgets.Canvas#loadingImageSrc a loading image}.
     *
     * @return  See {@link com.smartgwt.client.docs.HTMLString HTMLString} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getLoadingDataMessageStyle
     */
    public String getLoadingDataMessage()  {
        return getAttributeAsString("loadingDataMessage");
    }
    

    /**
     * The CSS style name applied to the loadingDataMessage string if displayed.
     *
     * @param loadingDataMessageStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is "loadingDataMessage"
     */
    public void setLoadingDataMessageStyle(String loadingDataMessageStyle) {
        setAttribute("loadingDataMessageStyle", loadingDataMessageStyle, true);
    }

    /**
     * The CSS style name applied to the loadingDataMessage string if displayed.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     */
    public String getLoadingDataMessageStyle()  {
        return getAttributeAsString("loadingDataMessageStyle");
    }
    

    /**
     * If you have a databound listGrid and you scroll out of the currently loaded dataset, by default you will see blank rows
     * until the server returns the data for those rows.  The loadingMessage attribute allows you to specify arbitrary html
     * that will be shown in each such "blank" record while the data for that record is loading.
     *
     * @param loadingMessage  Default value is "&amp;nbsp;"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setLoadingMessage(String loadingMessage)  throws IllegalStateException {
        setAttribute("loadingMessage", loadingMessage, false);
    }

    /**
     * If you have a databound listGrid and you scroll out of the currently loaded dataset, by default you will see blank rows
     * until the server returns the data for those rows.  The loadingMessage attribute allows you to specify arbitrary html
     * that will be shown in each such "blank" record while the data for that record is loading.
     *
     * @return String
     */
    public String getLoadingMessage()  {
        return getAttributeAsString("loadingMessage");
    }
    

    /**
     * When {@link com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()} is used to parse locator strings
     * generated by {@link com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()} for a cell in this grid, how
     * should the column be identified? <br> Note that getLocator() will actually store all available information about the
     * column in the generated string -- this attribute effects how a stored string will be parsed only. <P> Valid options
     * area: <ul> <li><code>"fieldName"</code> Attempt to identify by fieldName.</li> <li><code>"index"</code> Attempt to
     * identify by colNum (index in the fields array).</li> </ul> If unset, default behavior is to identify by fieldName (if
     * available), otherwise by index.
     *
     * @param locateColumnsBy  Default value is null
     */
    public void setLocateColumnsBy(String locateColumnsBy) {
        setAttribute("locateColumnsBy", locateColumnsBy, true);
    }

    /**
     * When {@link com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()} is used to parse locator strings
     * generated by {@link com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()} for a cell in this grid, how
     * should the column be identified? <br> Note that getLocator() will actually store all available information about the
     * column in the generated string -- this attribute effects how a stored string will be parsed only. <P> Valid options
     * area: <ul> <li><code>"fieldName"</code> Attempt to identify by fieldName.</li> <li><code>"index"</code> Attempt to
     * identify by colNum (index in the fields array).</li> </ul> If unset, default behavior is to identify by fieldName (if
     * available), otherwise by index.
     *
     * @return String
     */
    public String getLocateColumnsBy()  {
        return getAttributeAsString("locateColumnsBy");
    }
    

    /**
     * When {@link com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()} is used to parse locator strings
     * generated by {@link com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()} for a cell in this grid, how
     * should the row be identified? <br> Note that getLocator() will actually store all available information about the row in
     * the generated string -- this attribute effects how a stored string will be parsed only. <P> Valid options area: <ul>
     * <li><code>"primaryKey"</code> Only applies to databound grids: If the cell in question has  a primary key cell value,
     * use it to identify cells in autoTest locator strings.</li> <li><code>"titleField"</code> If the cell in question has a
     * value for the  {@link com.smartgwt.client.widgets.grid.ListGrid#getTitleField titleField}, use it to identify cells in
     * autoTest  locator strings</li> <li><code>"targetCellValue"</code> Identify rows by storing the cell value for the target
     * row / field in autoTest locator strings</li> <li><code>"index"</code>The rowNum will be used to identify the row.</li>
     * </ul> If unset, default behavior is to identify by primary key (if available), otherwise by titleField (if available),
     * otherwise by cell value (if available), and lastly by index.
     *
     * @param locateRowsBy  Default value is null
     */
    public void setLocateRowsBy(String locateRowsBy) {
        setAttribute("locateRowsBy", locateRowsBy, true);
    }

    /**
     * When {@link com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()} is used to parse locator strings
     * generated by {@link com.smartgwt.client.util.AutoTest#getLocator AutoTest.getLocator()} for a cell in this grid, how
     * should the row be identified? <br> Note that getLocator() will actually store all available information about the row in
     * the generated string -- this attribute effects how a stored string will be parsed only. <P> Valid options area: <ul>
     * <li><code>"primaryKey"</code> Only applies to databound grids: If the cell in question has  a primary key cell value,
     * use it to identify cells in autoTest locator strings.</li> <li><code>"titleField"</code> If the cell in question has a
     * value for the  {@link com.smartgwt.client.widgets.grid.ListGrid#getTitleField titleField}, use it to identify cells in
     * autoTest  locator strings</li> <li><code>"targetCellValue"</code> Identify rows by storing the cell value for the target
     * row / field in autoTest locator strings</li> <li><code>"index"</code>The rowNum will be used to identify the row.</li>
     * </ul> If unset, default behavior is to identify by primary key (if available), otherwise by titleField (if available),
     * otherwise by cell value (if available), and lastly by index.
     *
     * @return String
     */
    public String getLocateRowsBy()  {
        return getAttributeAsString("locateRowsBy");
    }
    

    /**
     * When the length of the field specified by {@link com.smartgwt.client.data.DataSourceField#getLength length} exceeds this
     * value, the ListGrid shows an edit field of type {@link com.smartgwt.client.widgets.grid.ListGrid#getLongTextEditorType
     * longTextEditorType} rather than the standard text field when the field enters inline edit mode.
     *
     * @param longTextEditorThreshold  Default value is 255
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setLongTextEditorThreshold(int longTextEditorThreshold) {
        setAttribute("longTextEditorThreshold", longTextEditorThreshold, true);
    }

    /**
     * When the length of the field specified by {@link com.smartgwt.client.data.DataSourceField#getLength length} exceeds this
     * value, the ListGrid shows an edit field of type {@link com.smartgwt.client.widgets.grid.ListGrid#getLongTextEditorType
     * longTextEditorType} rather than the standard text field when the field enters inline edit mode.
     *
     * @return int
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public int getLongTextEditorThreshold()  {
        return getAttributeAsInt("longTextEditorThreshold");
    }
    

    /**
     * When the length of the field specified by {@link com.smartgwt.client.data.DataSourceField#getLength length} exceeds
     * <code>this.longTextEditorThreshold</code> show an edit field of this type rather than the standard text field when the
     * field enters inline edit mode.
     *
     * @param longTextEditorType  Default value is "PopUpTextAreaItem"
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setLongTextEditorType(String longTextEditorType) {
        setAttribute("longTextEditorType", longTextEditorType, true);
    }

    /**
     * When the length of the field specified by {@link com.smartgwt.client.data.DataSourceField#getLength length} exceeds
     * <code>this.longTextEditorThreshold</code> show an edit field of this type rather than the standard text field when the
     * field enters inline edit mode.
     *
     * @return String
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getLongTextEditorType()  {
        return getAttributeAsString("longTextEditorType");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandMultipleRecords canExpandMultipleRecords} are both true, this
     * property dictates the number of records which can be expanded simultaneously.  If the expanded record count hits the
     * value of this property, further attempts to expand records will result in a popup warning (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getMaxExpandedRecordsPrompt maxExpandedRecordsPrompt}) and expansion will be
     * cancelled. <P> The default value is null, meaning there is no limit on the number of expanded records.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param maxExpandedRecords  Default value is null
     */
    public void setMaxExpandedRecords(Integer maxExpandedRecords) {
        setAttribute("maxExpandedRecords", maxExpandedRecords, true);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandMultipleRecords canExpandMultipleRecords} are both true, this
     * property dictates the number of records which can be expanded simultaneously.  If the expanded record count hits the
     * value of this property, further attempts to expand records will result in a popup warning (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getMaxExpandedRecordsPrompt maxExpandedRecordsPrompt}) and expansion will be
     * cancelled. <P> The default value is null, meaning there is no limit on the number of expanded records.
     *
     * @return Integer
     */
    public Integer getMaxExpandedRecords()  {
        return getAttributeAsInt("maxExpandedRecords");
    }
    

    /**
     * This is a dynamic string - text within <code>&#36;{...}</code> will be evaluated as JS code when the message is
     * displayed. Note that the local variable <code>count</code> will be available and set to this.maxExpandedRecords. The
     * string will be executed in the scope of the ListGrid so <code>this</code> may also be used to determine other
     * information about this grid. <P> Default value returns <P> <code> <i>This grid is limited to <code>[{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getMaxExpandedRecords maxExpandedRecords}]</code> simultaneously expanded
     * records.  Please collapse some expanded records and retry.</i> </code>
     *
     * @param maxExpandedRecordsPrompt  See {@link com.smartgwt.client.docs.HTMLString HTMLString} . Default value is "This grid is limited to ${count} simultaneously expanded records.  Please collapse some expanded records and retry."
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setMaxExpandedRecordsPrompt(String maxExpandedRecordsPrompt)  throws IllegalStateException {
        setAttribute("maxExpandedRecordsPrompt", maxExpandedRecordsPrompt, false);
    }

    /**
     * This is a dynamic string - text within <code>&#36;{...}</code> will be evaluated as JS code when the message is
     * displayed. Note that the local variable <code>count</code> will be available and set to this.maxExpandedRecords. The
     * string will be executed in the scope of the ListGrid so <code>this</code> may also be used to determine other
     * information about this grid. <P> Default value returns <P> <code> <i>This grid is limited to <code>[{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getMaxExpandedRecords maxExpandedRecords}]</code> simultaneously expanded
     * records.  Please collapse some expanded records and retry.</i> </code>
     *
     * @return  See {@link com.smartgwt.client.docs.HTMLString HTMLString} 
     */
    public String getMaxExpandedRecordsPrompt()  {
        return getAttributeAsString("maxExpandedRecordsPrompt");
    }
    

    /**
     * Minimum size, in pixels, for ListGrid headers.
     *
     * @param minFieldWidth  Default value is 15
     */
    public void setMinFieldWidth(int minFieldWidth) {
        setAttribute("minFieldWidth", minFieldWidth, true);
    }

    /**
     * Minimum size, in pixels, for ListGrid headers.
     *
     * @return int
     */
    public int getMinFieldWidth()  {
        return getAttributeAsInt("minFieldWidth");
    }
    

    /**
     * If a summary format string contains an invalid field reference, replace the reference with the missingSummaryFieldValue.
     * The default value is "-".
     *
     * @param missingSummaryFieldValue  Default value is "-"
     */
    public void setMissingSummaryFieldValue(String missingSummaryFieldValue) {
        setAttribute("missingSummaryFieldValue", missingSummaryFieldValue, true);
    }

    /**
     * If a summary format string contains an invalid field reference, replace the reference with the missingSummaryFieldValue.
     * The default value is "-".
     *
     * @return String
     */
    public String getMissingSummaryFieldValue()  {
        return getAttributeAsString("missingSummaryFieldValue");
    }
    

    /**
     * If this property is true, any mouse click outside of the open cell editors      will end editing mode, hiding the cell
     * editors and saving any changes to those      cell values.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param modalEditing  Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_modal" target="examples">Modal editing Example</a>
     */
    public void setModalEditing(Boolean modalEditing) {
        setAttribute("modalEditing", modalEditing, true);
    }

    /**
     * If this property is true, any mouse click outside of the open cell editors      will end editing mode, hiding the cell
     * editors and saving any changes to those      cell values.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_editing_modal" target="examples">Modal editing Example</a>
     */
    public Boolean getModalEditing()  {
        return getAttributeAsBoolean("modalEditing");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true, this property allows the
     * user to navigate through the cells of a grid using Tab and Shift+Tab keypresses. When a user tabs to the end of the row,
     * the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowEndEditAction rowEndEditAction} is used to determine whether
     * to shift selection to the next row, return to the beginning of the same row, or simply move on through the page's tab
     * order.
     *
     * @param navigateOnTab  Default value is true
     */
    public void setNavigateOnTab(boolean navigateOnTab) {
        setAttribute("navigateOnTab", navigateOnTab, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true, this property allows the
     * user to navigate through the cells of a grid using Tab and Shift+Tab keypresses. When a user tabs to the end of the row,
     * the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowEndEditAction rowEndEditAction} is used to determine whether
     * to shift selection to the next row, return to the beginning of the same row, or simply move on through the page's tab
     * order.
     *
     * @return boolean
     */
    public boolean getNavigateOnTab()  {
        Boolean result = getAttributeAsBoolean("navigateOnTab");
        return result == null ? true : result;
    }
    

    /**
     * If true, validation will not occur as a result of cell editing for this grid.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param neverValidate  Default value is null
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public void setNeverValidate(Boolean neverValidate) {
        setAttribute("neverValidate", neverValidate, true);
    }

    /**
     * If true, validation will not occur as a result of cell editing for this grid.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public Boolean getNeverValidate()  {
        return getAttributeAsBoolean("neverValidate");
    }
    

    /**
     * "Normal" baseStyle for this listGrid. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} is set to null. <P> If <code>baseStyle</code> is unset, this property will be used as a base cell style if
     * the grid is showing fixed height rows, and the specified cellHeight matches {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNormalCellHeight normalCellHeight} (and in Internet Explorer, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFastCellUpdates fastCellUpdates} is false). Otherwise {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} will be used. <P> Having separate styles
     * defined for fixed vs. variable height rows allows the developer to specify css which is designed to render at a specific
     * height (typically using background images, which won't scale), without breaking support for styling rows of variable
     * height. <P> See {@link com.smartgwt.client.widgets.grid.ListGrid#getCellStyleSuffixes cellStyleSuffixes} for details on
     * how stateful suffixes are combined with the base style to generate stateful cell styles.
     *
     * @param normalBaseStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is "cell"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     */
    public void setNormalBaseStyle(String normalBaseStyle)  throws IllegalStateException {
        setAttribute("normalBaseStyle", normalBaseStyle, false);
    }

    /**
     * "Normal" baseStyle for this listGrid. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} is set to null. <P> If <code>baseStyle</code> is unset, this property will be used as a base cell style if
     * the grid is showing fixed height rows, and the specified cellHeight matches {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNormalCellHeight normalCellHeight} (and in Internet Explorer, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFastCellUpdates fastCellUpdates} is false). Otherwise {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} will be used. <P> Having separate styles
     * defined for fixed vs. variable height rows allows the developer to specify css which is designed to render at a specific
     * height (typically using background images, which won't scale), without breaking support for styling rows of variable
     * height. <P> See {@link com.smartgwt.client.widgets.grid.ListGrid#getCellStyleSuffixes cellStyleSuffixes} for details on
     * how stateful suffixes are combined with the base style to generate stateful cell styles.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     */
    public String getNormalBaseStyle()  {
        return getAttributeAsString("normalBaseStyle");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} is unset, base style will be derived from
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle} if this grid has fixed row heights
     * and the specified {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} matches this value.
     * Otherwise {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} will be used.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param normalCellHeight  Default value is 20
     */
    public void setNormalCellHeight(int normalCellHeight) {
        setAttribute("normalCellHeight", normalCellHeight, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} is unset, base style will be derived from
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle} if this grid has fixed row heights
     * and the specified {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} matches this value.
     * Otherwise {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle tallBaseStyle} will be used.
     *
     * @return int
     */
    public int getNormalCellHeight()  {
        return getAttributeAsInt("normalCellHeight");
    }
    

    /**
     * Default alias to use for groups with no value
     *
     * @param nullGroupTitle  Default value is '-none-'
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setNullGroupTitle(String nullGroupTitle) {
        setAttribute("nullGroupTitle", nullGroupTitle, true);
    }

    /**
     * Default alias to use for groups with no value
     *
     * @return String
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public String getNullGroupTitle()  {
        return getAttributeAsString("nullGroupTitle");
    }
    

    /**
     * The CSS style name applied to the {@link com.smartgwt.client.widgets.DataBoundComponent#getOfflineMessage
     * offlineMessage} if displayed.
     *
     * @param offlineMessageStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is "offlineMessage"
     */
    public void setOfflineMessageStyle(String offlineMessageStyle) {
        setAttribute("offlineMessageStyle", offlineMessageStyle, true);
    }

    /**
     * The CSS style name applied to the {@link com.smartgwt.client.widgets.DataBoundComponent#getOfflineMessage
     * offlineMessage} if displayed.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     */
    public String getOfflineMessageStyle()  {
        return getAttributeAsString("offlineMessageStyle");
    }
    
    

    /**
     * Name of a CSS Style to use as the {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} for a cell
     * that is currently a selection origin for shifted incremental cell selection. Only has an effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true. <P>
     *
     * @param originBaseStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is null
     */
    public void setOriginBaseStyle(String originBaseStyle) {
        setAttribute("originBaseStyle", originBaseStyle, true);
    }

    /**
     * Name of a CSS Style to use as the {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} for a cell
     * that is currently a selection origin for shifted incremental cell selection. Only has an effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true. <P>
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     */
    public String getOriginBaseStyle()  {
        return getAttributeAsString("originBaseStyle");
    }
    

    /**
     * Should recycled {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents record components}, be pooled
     * per column or per record. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell
     * showRecordComponentsByCell} is true. <P> When {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPoolingMode recordComponentPoolingMode} is "recycle" and you
     * have components of different types in different columns, set this property to true to ensure that components intended
     * for one column are not recycled for use in another column that should have a different component. <P> If no components
     * applicable to a particular column are available in the pool, the system calls {@link
     * com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent createRecordComponent}.
     *
     * @param poolComponentsPerColumn  Default value is true
     */
    public void setPoolComponentsPerColumn(Boolean poolComponentsPerColumn) {
        setAttribute("poolComponentsPerColumn", poolComponentsPerColumn, true);
    }

    /**
     * Should recycled {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents record components}, be pooled
     * per column or per record. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell
     * showRecordComponentsByCell} is true. <P> When {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPoolingMode recordComponentPoolingMode} is "recycle" and you
     * have components of different types in different columns, set this property to true to ensure that components intended
     * for one column are not recycled for use in another column that should have a different component. <P> If no components
     * applicable to a particular column are available in the pool, the system calls {@link
     * com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent createRecordComponent}.
     *
     * @return Boolean
     */
    public Boolean getPoolComponentsPerColumn()  {
        Boolean result = getAttributeAsBoolean("poolComponentsPerColumn");
        return result == null ? true : result;
    }
    

    /**
     * Whether cell contents should wrap during printing.  Equivalent to {@link com.smartgwt.client.types.Autofit}, but
     * specific to printed output.
     *
     * @param printAutoFit  Default value is true
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintAutoFit(Boolean printAutoFit) {
        setAttribute("printAutoFit", printAutoFit, true);
    }

    /**
     * Whether cell contents should wrap during printing.  Equivalent to {@link com.smartgwt.client.types.Autofit}, but
     * specific to printed output.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public Boolean getPrintAutoFit()  {
        Boolean result = getAttributeAsBoolean("printAutoFit");
        return result == null ? true : result;
    }
    

    /**
     * Style for non-header cells in printed output.  Defaults to {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} if null.
     *
     * @param printBaseStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is null
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintBaseStyle(String printBaseStyle) {
        setAttribute("printBaseStyle", printBaseStyle, true);
    }

    /**
     * Style for non-header cells in printed output.  Defaults to {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} if null.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintBaseStyle()  {
        return getAttributeAsString("printBaseStyle");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} to use when 
     * printing.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printBooleanBaseStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanBaseStyle
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintBooleanBaseStyle(String printBooleanBaseStyle)  throws IllegalStateException {
        setAttribute("printBooleanBaseStyle", printBooleanBaseStyle, false);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle booleanBaseStyle} to use when 
     * printing.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanBaseStyle
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintBooleanBaseStyle()  {
        return getAttributeAsString("printBooleanBaseStyle");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} to use when 
     * printing.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printBooleanFalseImage  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanFalseImage
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintBooleanFalseImage(String printBooleanFalseImage) {
        setAttribute("printBooleanFalseImage", printBooleanFalseImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage booleanFalseImage} to use when 
     * printing.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanFalseImage
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintBooleanFalseImage()  {
        return getAttributeAsString("printBooleanFalseImage");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} to use when 
     * printing.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printBooleanPartialImage  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanPartialImage
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintBooleanPartialImage(String printBooleanPartialImage) {
        setAttribute("printBooleanPartialImage", printBooleanPartialImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage booleanPartialImage} to use when 
     * printing.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanPartialImage
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintBooleanPartialImage()  {
        return getAttributeAsString("printBooleanPartialImage");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} to use when 
     * printing.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printBooleanTrueImage  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBooleanTrueImage
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintBooleanTrueImage(String printBooleanTrueImage) {
        setAttribute("printBooleanTrueImage", printBooleanTrueImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage booleanTrueImage} to use when 
     * printing.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBooleanTrueImage
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintBooleanTrueImage()  {
        return getAttributeAsString("printBooleanTrueImage");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldFalseImage checkboxFieldFalseImage} to use
     * when  printing.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printCheckboxFieldFalseImage  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldFalseImage
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintCheckboxFieldFalseImage(String printCheckboxFieldFalseImage) {
        setAttribute("printCheckboxFieldFalseImage", printCheckboxFieldFalseImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldFalseImage checkboxFieldFalseImage} to use
     * when  printing.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldFalseImage
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintCheckboxFieldFalseImage()  {
        return getAttributeAsString("printCheckboxFieldFalseImage");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldPartialImage checkboxFieldPartialImage} to
     * use when  printing.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printCheckboxFieldPartialImage  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldPartialImage
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintCheckboxFieldPartialImage(String printCheckboxFieldPartialImage) {
        setAttribute("printCheckboxFieldPartialImage", printCheckboxFieldPartialImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldPartialImage checkboxFieldPartialImage} to
     * use when  printing.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldPartialImage
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintCheckboxFieldPartialImage()  {
        return getAttributeAsString("printCheckboxFieldPartialImage");
    }
    

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldTrueImage checkboxFieldTrueImage} to use
     * when  printing.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printCheckboxFieldTrueImage  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCheckboxFieldTrueImage
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintCheckboxFieldTrueImage(String printCheckboxFieldTrueImage) {
        setAttribute("printCheckboxFieldTrueImage", printCheckboxFieldTrueImage, true);
    }

    /**
     * If set, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldTrueImage checkboxFieldTrueImage} to use
     * when  printing.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCheckboxFieldTrueImage
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintCheckboxFieldTrueImage()  {
        return getAttributeAsString("printCheckboxFieldTrueImage");
    }
    

    /**
     * Style for header cells in printed output.  Defaults to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderBaseStyle headerBaseStyle} if null.
     *
     * @param printHeaderStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is "printHeader"
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintHeaderStyle(String printHeaderStyle) {
        setAttribute("printHeaderStyle", printHeaderStyle, true);
    }

    /**
     * Style for header cells in printed output.  Defaults to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderBaseStyle headerBaseStyle} if null.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public String getPrintHeaderStyle()  {
        return getAttributeAsString("printHeaderStyle");
    }
    

    /**
     * Advanced property - when generating printHTML for a large ListGrid, rows are printed in batches in order to avoid
     * triggering a native "script is running slowly" browser dialog. <P> For grids with exceptional numbers of columns or
     * complex formatting logic, this number might need to be adjusted downward.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param printMaxRows  Default value is 100
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintMaxRows(int printMaxRows) {
        setAttribute("printMaxRows", printMaxRows, true);
    }

    /**
     * Advanced property - when generating printHTML for a large ListGrid, rows are printed in batches in order to avoid
     * triggering a native "script is running slowly" browser dialog. <P> For grids with exceptional numbers of columns or
     * complex formatting logic, this number might need to be adjusted downward.
     *
     * @return int
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public int getPrintMaxRows()  {
        return getAttributeAsInt("printMaxRows");
    }
    

    /**
     * Whether cell contents should wrap during printing.  Equivalent to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWrapCells wrapCells}, but specific to printed output.
     *
     * @param printWrapCells  Default value is true
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public void setPrintWrapCells(Boolean printWrapCells) {
        setAttribute("printWrapCells", printWrapCells, true);
    }

    /**
     * Whether cell contents should wrap during printing.  Equivalent to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWrapCells wrapCells}, but specific to printed output.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Printing Printing overview and related methods
     */
    public Boolean getPrintWrapCells()  {
        Boolean result = getAttributeAsBoolean("printWrapCells");
        return result == null ? true : result;
    }
    

    /**
     * Alternative to {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio}, to be used when the
     * user is rapidly changing the grids viewport (for example drag scrolling through the grid). If unspecified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} will be used in all cases
     *
     * @param quickDrawAheadRatio  Default value is 1.0
     */
    public void setQuickDrawAheadRatio(float quickDrawAheadRatio) {
        setAttribute("quickDrawAheadRatio", quickDrawAheadRatio, true);
    }

    /**
     * Alternative to {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio}, to be used when the
     * user is rapidly changing the grids viewport (for example drag scrolling through the grid). If unspecified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} will be used in all cases
     *
     * @return float
     */
    public float getQuickDrawAheadRatio()  {
        return getAttributeAsFloat("quickDrawAheadRatio");
    }
    

    /**
     * This attribute allows custom base styles to be displayed on a per-record basis. To specify a custom base-style for some
     * record set <code>record[listGrid.recordBaseStyleProperty]</code> to the desired base style name - for example if
     * <code>recordBaseStyleProperty</code> is <code>"_baseStyle"</code>, set <code>record._baseStyle</code> to the custom base
     * style name.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordBaseStyleProperty  Default value is "_baseStyle"
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setRecordBaseStyleProperty(String recordBaseStyleProperty) {
        setAttribute("recordBaseStyleProperty", recordBaseStyleProperty, true);
    }

    /**
     * This attribute allows custom base styles to be displayed on a per-record basis. To specify a custom base-style for some
     * record set <code>record[listGrid.recordBaseStyleProperty]</code> to the desired base style name - for example if
     * <code>recordBaseStyleProperty</code> is <code>"_baseStyle"</code>, set <code>record._baseStyle</code> to the custom base
     * style name.
     *
     * @return String
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getRecordBaseStyleProperty()  {
        return getAttributeAsString("recordBaseStyleProperty");
    }
    

    /**
     * If set to false on a record and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}
     * is true, removal of that record is disallowed in the UI. The icon in the remove field is not shown.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordCanRemoveProperty  Default value is "_canRemove"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setRecordCanRemoveProperty(String recordCanRemoveProperty)  throws IllegalStateException {
        setAttribute("recordCanRemoveProperty", recordCanRemoveProperty, false);
    }

    /**
     * If set to false on a record and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords}
     * is true, removal of that record is disallowed in the UI. The icon in the remove field is not shown.
     *
     * @return String
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getRecordCanRemoveProperty()  {
        return getAttributeAsString("recordCanRemoveProperty");
    }
    

    /**
     * If set to false on a record, selection of that record is disallowed.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordCanSelectProperty  Default value is "canSelect"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setRecordCanSelectProperty(String recordCanSelectProperty)  throws IllegalStateException {
        setAttribute("recordCanSelectProperty", recordCanSelectProperty, false);
    }

    /**
     * If set to false on a record, selection of that record is disallowed.
     *
     * @return String
     */
    public String getRecordCanSelectProperty()  {
        return getAttributeAsString("recordCanSelectProperty");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} is true, this
     * attribute may be used to specify a standard height for record components. If specified every row in the grid will be
     * sized tall enough to accommodate a recordComponent of this size. <P> Note that if this property is unset, the grid will
     * not be able to know row heights in advance, and {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen
     * fields} are not currently supported in this case.  If you are putting a recordComponent in every row, and they all have
     * a consistent height, set <code>recordComponentHeight</code> and you will then be able to use frozen fields <i>and</i>
     * avoid the whitespace side-effect of virtual scrolling by setting  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}:false. <P> Similarly, if your
     * recordComponents are never tall enough that they will expand the row beyond the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight}, set {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}:false to avoid the whitespace
     * side-effect of {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtual scrolling} and to allow 
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields} to be used.  In this mode, you can have
     * recordComponents on some rows but not others, and recordComponents of different heights, so long as no recordComponent
     * ever causes a row to grow beyond {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} (which would
     * happen if the recordComponents height + 2*{@link com.smartgwt.client.widgets.grid.ListGrid#getCellPadding cellPadding}
     * is larger than  {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight}).
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentHeight recordComponentHeight}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordComponentHeight recordComponent height. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setVirtualScrolling
     */
    public void setRecordComponentHeight(Integer recordComponentHeight) {
        setAttribute("recordComponentHeight", recordComponentHeight, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} is true, this
     * attribute may be used to specify a standard height for record components. If specified every row in the grid will be
     * sized tall enough to accommodate a recordComponent of this size. <P> Note that if this property is unset, the grid will
     * not be able to know row heights in advance, and {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen
     * fields} are not currently supported in this case.  If you are putting a recordComponent in every row, and they all have
     * a consistent height, set <code>recordComponentHeight</code> and you will then be able to use frozen fields <i>and</i>
     * avoid the whitespace side-effect of virtual scrolling by setting  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}:false. <P> Similarly, if your
     * recordComponents are never tall enough that they will expand the row beyond the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight}, set {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}:false to avoid the whitespace
     * side-effect of {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtual scrolling} and to allow 
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields} to be used.  In this mode, you can have
     * recordComponents on some rows but not others, and recordComponents of different heights, so long as no recordComponent
     * ever causes a row to grow beyond {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight} (which would
     * happen if the recordComponents height + 2*{@link com.smartgwt.client.widgets.grid.ListGrid#getCellPadding cellPadding}
     * is larger than  {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight cellHeight}).
     *
     * @return Integer
     * @see com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling
     */
    public Integer getRecordComponentHeight()  {
        return getAttributeAsInt("recordComponentHeight");
    }
    

    /**
     * The method of {@link com.smartgwt.client.types.RecordComponentPoolingMode component-pooling} to employ for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents}. <P> The default mode is "viewport",
     * which means that recordComponents are destroyed as soon their record is no longer being rendered (scrolled out of the
     * viewport, eliminated by search criteria, etc). <P> For a large or dynamic data set where the components shown on
     * different rows are similar, switch to "recycle" mode, which pools recordComponents by detaching them from records that
     * are not visible and re-using them in other records.  In this mode, you should implement {@link
     * com.smartgwt.client.widgets.grid.ListGrid#updateRecordComponent ListGrid.updateRecordComponent()} to apply any changes
     * to make reused components applicable to the new record they appear in, if necessary.  For example, if you have several
     * controls in your <code>recordComponents</code>, and not all of the controls apply to every record, your
     * <code>updateRecordComponent()</code> implementation could simply hide or disable inapplicable controls, and this would
     * be much faster than creating a whole new set of controls every time a given record is scrolled into view. <p> If you are
     * using {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell per-cell recordComponents}, and you
     * have components of different types in different columns and still want to take advantage of component recycling, you can
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getPoolComponentsPerColumn poolComponentsPerColumn} to ensure that
     * components intended for one column are not recycled for use in another column that should have a different component.
     * <P> Note that, if different records have distinctly different components embedded in them, or multiple columns in each
     * record embed different components, you should leave the recordComponentPoolingMode at "viewport" if your dataset is very
     * large or use "data" otherwise.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordComponentPoolingMode  Default value is "viewport"
     */
    public void setRecordComponentPoolingMode(RecordComponentPoolingMode recordComponentPoolingMode) {
        setAttribute("recordComponentPoolingMode", recordComponentPoolingMode == null ? null : recordComponentPoolingMode.getValue(), true);
    }

    /**
     * The method of {@link com.smartgwt.client.types.RecordComponentPoolingMode component-pooling} to employ for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents}. <P> The default mode is "viewport",
     * which means that recordComponents are destroyed as soon their record is no longer being rendered (scrolled out of the
     * viewport, eliminated by search criteria, etc). <P> For a large or dynamic data set where the components shown on
     * different rows are similar, switch to "recycle" mode, which pools recordComponents by detaching them from records that
     * are not visible and re-using them in other records.  In this mode, you should implement {@link
     * com.smartgwt.client.widgets.grid.ListGrid#updateRecordComponent ListGrid.updateRecordComponent()} to apply any changes
     * to make reused components applicable to the new record they appear in, if necessary.  For example, if you have several
     * controls in your <code>recordComponents</code>, and not all of the controls apply to every record, your
     * <code>updateRecordComponent()</code> implementation could simply hide or disable inapplicable controls, and this would
     * be much faster than creating a whole new set of controls every time a given record is scrolled into view. <p> If you are
     * using {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell per-cell recordComponents}, and you
     * have components of different types in different columns and still want to take advantage of component recycling, you can
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getPoolComponentsPerColumn poolComponentsPerColumn} to ensure that
     * components intended for one column are not recycled for use in another column that should have a different component.
     * <P> Note that, if different records have distinctly different components embedded in them, or multiple columns in each
     * record embed different components, you should leave the recordComponentPoolingMode at "viewport" if your dataset is very
     * large or use "data" otherwise.
     *
     * @return RecordComponentPoolingMode
     */
    public RecordComponentPoolingMode getRecordComponentPoolingMode()  {
        return EnumUtil.getEnum(RecordComponentPoolingMode.values(), getAttribute("recordComponentPoolingMode"));
    }
    

    /**
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} is true, how should
     * the component appear within the cell. Valid options are <ul><li><code>"within"</code>: the component will be rendered
     * inside the record / cell.  {@link com.smartgwt.client.widgets.Canvas#getSnapTo snapTo} may be set to specify where the
     * component should render within  the row or cell, and {@link com.smartgwt.client.widgets.Canvas#getSnapOffsetTop
     * snapOffsetTop} / {@link com.smartgwt.client.widgets.Canvas#getSnapOffsetLeft snapOffsetLeft} may  be set to indent
     * recordComponents within their parent cells.  Note that if unset, the component will show up at the top/left edge  for
     * components embedded within an entire row, or for per-cell components, cell  align and valign will be respected.  Note
     * also that, when rendering components "within"  cells, specified component heights will be respected and will change the
     * height of the  row.  However, if you want components to completely fill a cell at it's default height,  set height:
     * "100%" or rows will render at the default height of the component. </li> <li><code>"expand"</code>: the component will
     * be written into the cell below the  normal cell content, causing the cell to expand vertically to accommodate it.
     * <li><code>null</code>: If this attribute is unset, we will default to showing  recordComponents with position
     * <code>"within"</code> if  {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell
     * showRecordComponentsByCell} is true, otherwise using <code>"expand"</code>  logic. </ul>
     *
     * @param recordComponentPosition  Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowRecordComponents
     */
    public void setRecordComponentPosition(EmbeddedPosition recordComponentPosition) {
        setAttribute("recordComponentPosition", recordComponentPosition == null ? null : recordComponentPosition.getValue(), true);
    }

    /**
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} is true, how should
     * the component appear within the cell. Valid options are <ul><li><code>"within"</code>: the component will be rendered
     * inside the record / cell.  {@link com.smartgwt.client.widgets.Canvas#getSnapTo snapTo} may be set to specify where the
     * component should render within  the row or cell, and {@link com.smartgwt.client.widgets.Canvas#getSnapOffsetTop
     * snapOffsetTop} / {@link com.smartgwt.client.widgets.Canvas#getSnapOffsetLeft snapOffsetLeft} may  be set to indent
     * recordComponents within their parent cells.  Note that if unset, the component will show up at the top/left edge  for
     * components embedded within an entire row, or for per-cell components, cell  align and valign will be respected.  Note
     * also that, when rendering components "within"  cells, specified component heights will be respected and will change the
     * height of the  row.  However, if you want components to completely fill a cell at it's default height,  set height:
     * "100%" or rows will render at the default height of the component. </li> <li><code>"expand"</code>: the component will
     * be written into the cell below the  normal cell content, causing the cell to expand vertically to accommodate it.
     * <li><code>null</code>: If this attribute is unset, we will default to showing  recordComponents with position
     * <code>"within"</code> if  {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell
     * showRecordComponentsByCell} is true, otherwise using <code>"expand"</code>  logic. </ul>
     *
     * @return EmbeddedPosition
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents
     */
    public EmbeddedPosition getRecordComponentPosition()  {
        return EnumUtil.getEnum(EmbeddedPosition.values(), getAttribute("recordComponentPosition"));
    }
    
    

    /**
     * The name of the ListGridRecord property that specifies the DataSource to use when {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is "related".  The default is {@link
     * com.smartgwt.client.widgets.grid.ListGridRecord#getDetailDS detailDS}. Note that you can set the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDetailDS detailDS} at the grid level instead if the same dataSource is to
     * be used for all records.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordDetailDSProperty  Default value is "detailDS"
     */
    public void setRecordDetailDSProperty(String recordDetailDSProperty) {
        setAttribute("recordDetailDSProperty", recordDetailDSProperty, true);
    }

    /**
     * The name of the ListGridRecord property that specifies the DataSource to use when {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode} is "related".  The default is {@link
     * com.smartgwt.client.widgets.grid.ListGridRecord#getDetailDS detailDS}. Note that you can set the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDetailDS detailDS} at the grid level instead if the same dataSource is to
     * be used for all records.
     *
     * @return String
     */
    public String getRecordDetailDSProperty()  {
        return getAttributeAsString("recordDetailDSProperty");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAcceptDroppedRecords canAcceptDroppedRecords} is true for this
     * listGrid, this property governs whether the user can drop between, or over records within the grid. This controls what
     * {@link com.smartgwt.client.types.RecordDropPosition} is passed to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#recordDrop ListGrid.recordDrop()} event handler.
     *
     * @param recordDropAppearance  Default value is ListGrid.BETWEEN
     */
    public void setRecordDropAppearance(RecordDropAppearance recordDropAppearance) {
        setAttribute("recordDropAppearance", recordDropAppearance == null ? null : recordDropAppearance.getValue(), true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAcceptDroppedRecords canAcceptDroppedRecords} is true for this
     * listGrid, this property governs whether the user can drop between, or over records within the grid. This controls what
     * {@link com.smartgwt.client.types.RecordDropPosition} is passed to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#recordDrop ListGrid.recordDrop()} event handler.
     *
     * @return RecordDropAppearance
     */
    public RecordDropAppearance getRecordDropAppearance()  {
        return EnumUtil.getEnum(RecordDropAppearance.values(), getAttribute("recordDropAppearance"));
    }
    

    /**
     * Property name on a record that should be checked to determine whether the record may be edited. <br> This property is
     * configurable to avoid possible collision with data values in record. With the default setting of "_canEdit", a record
     * can be set non-editable by ensuring record._canEdit == false. <br> For controlling editability for the entire grid or
     * for a field, set grid.canEdit or field.canEdit.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordEditProperty  Default value is "_canEdit"
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGridField#setCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGrid#canEditCell
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setRecordEditProperty(String recordEditProperty) {
        setAttribute("recordEditProperty", recordEditProperty, true);
    }

    /**
     * Property name on a record that should be checked to determine whether the record may be edited. <br> This property is
     * configurable to avoid possible collision with data values in record. With the default setting of "_canEdit", a record
     * can be set non-editable by ensuring record._canEdit == false. <br> For controlling editability for the entire grid or
     * for a field, set grid.canEdit or field.canEdit.
     *
     * @return String
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGridField#getCanEdit
     * @see com.smartgwt.client.widgets.grid.ListGrid#canEditCell
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public String getRecordEditProperty()  {
        return getAttributeAsString("recordEditProperty");
    }
    

    /**
     * Property name on a record that will be checked to determine whether a record is enabled. <P> Setting this property on a
     * record will effect the visual style and interactivity of the record.  If set to <code>false</code> the record (row in a
     * {@link com.smartgwt.client.widgets.grid.ListGrid} or {@link com.smartgwt.client.widgets.tree.TreeGrid}) will not
     * highlight when the mouse moves over it, nor will it respond to mouse clicks.
     *
     * @param recordEnabledProperty  Default value is "enabled"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#setEnabled
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_disabled_rows" target="examples">Disabled rows Example</a>
     */
    public void setRecordEnabledProperty(String recordEnabledProperty)  throws IllegalStateException {
        setAttribute("recordEnabledProperty", recordEnabledProperty, false);
    }

    /**
     * Property name on a record that will be checked to determine whether a record is enabled. <P> Setting this property on a
     * record will effect the visual style and interactivity of the record.  If set to <code>false</code> the record (row in a
     * {@link com.smartgwt.client.widgets.grid.ListGrid} or {@link com.smartgwt.client.widgets.tree.TreeGrid}) will not
     * highlight when the mouse moves over it, nor will it respond to mouse clicks.
     *
     * @return String
     * @see com.smartgwt.client.widgets.grid.ListGridRecord#getEnabled
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_disabled_rows" target="examples">Disabled rows Example</a>
     */
    public String getRecordEnabledProperty()  {
        return getAttributeAsString("recordEnabledProperty");
    }
    

    /**
     * If showing any record summary fields (IE: fields of {@link com.smartgwt.client.types.ListGridFieldType type:"summary"}),
     * this attribute specifies a custom base style to apply to cells in the summary field
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param recordSummaryBaseStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is "recordSummaryCell"
     */
    public void setRecordSummaryBaseStyle(String recordSummaryBaseStyle) {
        setAttribute("recordSummaryBaseStyle", recordSummaryBaseStyle, true);
    }

    /**
     * If showing any record summary fields (IE: fields of {@link com.smartgwt.client.types.ListGridFieldType type:"summary"}),
     * this attribute specifies a custom base style to apply to cells in the summary field
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     */
    public String getRecordSummaryBaseStyle()  {
        return getAttributeAsString("recordSummaryBaseStyle");
    }
    

    /**
     * Custom CSS text to be applied to records that have been {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved marked for removal}. <P> This CSS text will be applied on
     * top of standard disabled styling for the cell.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param removedCSSText  Default value is "text-decoration:line-through;"
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setRemovedCSSText(String removedCSSText) {
        setAttribute("removedCSSText", removedCSSText, true);
    }

    /**
     * Custom CSS text to be applied to records that have been {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved marked for removal}. <P> This CSS text will be applied on
     * top of standard disabled styling for the cell.
     *
     * @return String
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getRemovedCSSText()  {
        return getAttributeAsString("removedCSSText");
    }
    
    

    /**
     * Configuration properties for the "remove field" displayed when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled.
     *
     * @param removeFieldProperties  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setRemoveFieldProperties(ListGridField removeFieldProperties)  throws IllegalStateException {
        setAttribute("removeFieldProperties", removeFieldProperties.getJsObj(), false);
    }

    /**
     * Configuration properties for the "remove field" displayed when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled.
     *
     * @return ListGridField
     */
    public ListGridField getRemoveFieldProperties()  {
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("removeFieldProperties"));
    }
    

    /**
     * The title to use for the {@link com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldDefaults remove field}. <P> By
     * default this title is not displayed in the remove column header button as the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldDefaults removeFieldDefaults} sets {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowTitle showTitle} to <code>false</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param removeFieldTitle  Default value is "&amp;nbsp;"
     */
    public void setRemoveFieldTitle(String removeFieldTitle) {
        setAttribute("removeFieldTitle", removeFieldTitle, true);
    }

    /**
     * The title to use for the {@link com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldDefaults remove field}. <P> By
     * default this title is not displayed in the remove column header button as the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRemoveFieldDefaults removeFieldDefaults} sets {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowTitle showTitle} to <code>false</code>.
     *
     * @return String
     */
    public String getRemoveFieldTitle()  {
        return getAttributeAsString("removeFieldTitle");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, default icon to
     * show in the auto-generated field that allows removing records.
     *
     * @param removeIcon  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is "[SKIN]/actions/remove.png"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setRemoveIcon(String removeIcon)  throws IllegalStateException {
        setAttribute("removeIcon", removeIcon, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, default icon to
     * show in the auto-generated field that allows removing records.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     */
    public String getRemoveIcon()  {
        return getAttributeAsString("removeIcon");
    }
    

    /**
     * Default width and height of {@link com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon remove icons} for this
     * ListGrid.
     *
     * @param removeIconSize  Default value is 16
     */
    public void setRemoveIconSize(int removeIconSize) {
        setAttribute("removeIconSize", removeIconSize, true);
    }

    /**
     * Default width and height of {@link com.smartgwt.client.widgets.grid.ListGrid#getRemoveIcon remove icons} for this
     * ListGrid.
     *
     * @return int
     */
    public int getRemoveIconSize()  {
        return getAttributeAsInt("removeIconSize");
    }
    

    /**
     * If true, when an update operation occurs on a selected record in a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource databound} listGrid, ensure the updated record is re-selected
     * when the operation completes. The {@link com.smartgwt.client.widgets.grid.ListGrid#getReselectOnUpdateNotifications
     * reselectOnUpdateNotifications} attributes governs whether {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addSelectionUpdatedHandler ListGrid.selectionUpdated()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addSelectionChangedHandler ListGrid.selectionChanged()} will fire when this
     * occurs.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param reselectOnUpdate  Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setReselectOnUpdate(boolean reselectOnUpdate)  throws IllegalStateException {
        setAttribute("reselectOnUpdate", reselectOnUpdate, false);
    }

    /**
     * If true, when an update operation occurs on a selected record in a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource databound} listGrid, ensure the updated record is re-selected
     * when the operation completes. The {@link com.smartgwt.client.widgets.grid.ListGrid#getReselectOnUpdateNotifications
     * reselectOnUpdateNotifications} attributes governs whether {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addSelectionUpdatedHandler ListGrid.selectionUpdated()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addSelectionChangedHandler ListGrid.selectionChanged()} will fire when this
     * occurs.
     *
     * @return boolean
     */
    public boolean getReselectOnUpdate()  {
        Boolean result = getAttributeAsBoolean("reselectOnUpdate");
        return result == null ? true : result;
    }
    

    /**
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getReselectOnUpdate reselectOnUpdate} is true, this property governs
     * what selection changed notifications should be triggered when a selected record is edited then automatically reselected
     * when the edited data is merged into the data set.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param reselectOnUpdateNotifications  Default value is "selectionChanged"
     */
    public void setReselectOnUpdateNotifications(SelectionNotificationType reselectOnUpdateNotifications) {
        setAttribute("reselectOnUpdateNotifications", reselectOnUpdateNotifications == null ? null : reselectOnUpdateNotifications.getValue(), true);
    }

    /**
     * if {@link com.smartgwt.client.widgets.grid.ListGrid#getReselectOnUpdate reselectOnUpdate} is true, this property governs
     * what selection changed notifications should be triggered when a selected record is edited then automatically reselected
     * when the edited data is merged into the data set.
     *
     * @return SelectionNotificationType
     */
    public SelectionNotificationType getReselectOnUpdateNotifications()  {
        return EnumUtil.getEnum(SelectionNotificationType.values(), getAttribute("reselectOnUpdateNotifications"));
    }
    

    /**
     * If <code>true</code>, the grid contents are redrawn in real time as fields are resized. This can be slow with a large
     * grid and/or on some platforms. By default, this is enabled in modern desktop browsers. This is automatically switched
     * off in mobile browsers.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param resizeFieldsInRealTime  Default value is see below
     */
    public void setResizeFieldsInRealTime(boolean resizeFieldsInRealTime) {
        setAttribute("resizeFieldsInRealTime", resizeFieldsInRealTime, true);
    }

    /**
     * If <code>true</code>, the grid contents are redrawn in real time as fields are resized. This can be slow with a large
     * grid and/or on some platforms. By default, this is enabled in modern desktop browsers. This is automatically switched
     * off in mobile browsers.
     *
     * @return boolean
     */
    public boolean getResizeFieldsInRealTime()  {
        return getAttributeAsBoolean("resizeFieldsInRealTime");
    }
    

    /**
     * If a page is rendered in {@link com.smartgwt.client.util.Page#isRTL RTL mode}, should cell alignments specified {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCellAlign cellAlign} be reversed (so an <code>align:"right"</code>
     * field will have content aligned on the left and vice versa)? <P> This is true by default to match user expectation that
     * text flows from start-to end and is aligned with the start of text flow (left in LTR mode, right in RTL mode) by
     * default. May be set to false to have the specified alignments be taken literally in RTL mode.
     *
     * @param reverseRTLAlign  Default value is true
     */
    public void setReverseRTLAlign(Boolean reverseRTLAlign) {
        setAttribute("reverseRTLAlign", reverseRTLAlign, true);
    }

    /**
     * If a page is rendered in {@link com.smartgwt.client.util.Page#isRTL RTL mode}, should cell alignments specified {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getCellAlign cellAlign} be reversed (so an <code>align:"right"</code>
     * field will have content aligned on the left and vice versa)? <P> This is true by default to match user expectation that
     * text flows from start-to end and is aligned with the start of text flow (left in LTR mode, right in RTL mode) by
     * default. May be set to false to have the specified alignments be taken literally in RTL mode.
     *
     * @return Boolean
     */
    public Boolean getReverseRTLAlign()  {
        Boolean result = getAttributeAsBoolean("reverseRTLAlign");
        return result == null ? true : result;
    }
    
    
    

    /**
     * If the user is editing a record in this listGrid, and attempts to navigate to a field beyond the end of the row, via tab
     * (or shift-tab off the first editable field), this property determines what action to take:<ul> <li>"next": start editing
     * the next (or previous) record in the list <li>"same": put focus back into the first editable field of the same record.
     * <li>"done": hide the editor <li>"stop": leave focus in the cell being edited <li>"none": no action </ul>
     *
     * @param rowEndEditAction  Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setRowEndEditAction(RowEndEditAction rowEndEditAction) {
        setAttribute("rowEndEditAction", rowEndEditAction == null ? null : rowEndEditAction.getValue(), true);
    }

    /**
     * If the user is editing a record in this listGrid, and attempts to navigate to a field beyond the end of the row, via tab
     * (or shift-tab off the first editable field), this property determines what action to take:<ul> <li>"next": start editing
     * the next (or previous) record in the list <li>"same": put focus back into the first editable field of the same record.
     * <li>"done": hide the editor <li>"stop": leave focus in the cell being edited <li>"none": no action </ul>
     *
     * @return RowEndEditAction
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public RowEndEditAction getRowEndEditAction()  {
        return EnumUtil.getEnum(RowEndEditAction.values(), getAttribute("rowEndEditAction"));
    }
    

    /**
     * An automatically generated field that displays the current row number when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true.
     * <p>
     * For an overview of how to use and configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return ListGridField
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ListGridField getRowNumberField() throws IllegalStateException {
        errorIfNotCreated("rowNumberField");
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("rowNumberField"));
    }
    

    /**
     * The number to start the row-count from - default value is 1.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param rowNumberStart  Default value is 1
     */
    public void setRowNumberStart(int rowNumberStart) {
        setAttribute("rowNumberStart", rowNumberStart, true);
    }

    /**
     * The number to start the row-count from - default value is 1.
     *
     * @return int
     */
    public int getRowNumberStart()  {
        return getAttributeAsInt("rowNumberStart");
    }
    

    /**
     * The CSS Style name for the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowNumberField rowNumberField}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param rowNumberStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is "specialCol"
     */
    public void setRowNumberStyle(String rowNumberStyle) {
        setAttribute("rowNumberStyle", rowNumberStyle, true);
    }

    /**
     * The CSS Style name for the {@link com.smartgwt.client.widgets.grid.ListGrid#getRowNumberField rowNumberField}.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     */
    public String getRowNumberStyle()  {
        return getAttributeAsString("rowNumberStyle");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowRowSpanning allowRowSpanning} is enabled, this property may
     * be used to specify editing behavior for cells that span multiple rows.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param rowSpanEditMode  Default value is "first"
     */
    public void setRowSpanEditMode(RowSpanEditMode rowSpanEditMode) {
        setAttribute("rowSpanEditMode", rowSpanEditMode == null ? null : rowSpanEditMode.getValue(), true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getAllowRowSpanning allowRowSpanning} is enabled, this property may
     * be used to specify editing behavior for cells that span multiple rows.
     *
     * @return RowSpanEditMode
     */
    public RowSpanEditMode getRowSpanEditMode()  {
        return EnumUtil.getEnum(RowSpanEditMode.values(), getAttribute("rowSpanEditMode"));
    }
    

    /**
     * Chooses the selection mode when {@link com.smartgwt.client.widgets.grid.ListGrid#getUseRowSpanStyling useRowSpanStyling}
     * is enabled.  See {@link com.smartgwt.client.types.RowSpanSelectionMode}.
     *
     * @param rowSpanSelectionMode  Default value is "forward"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setRowSpanSelectionMode(RowSpanSelectionMode rowSpanSelectionMode)  throws IllegalStateException {
        setAttribute("rowSpanSelectionMode", rowSpanSelectionMode == null ? null : rowSpanSelectionMode.getValue(), false);
    }

    /**
     * Chooses the selection mode when {@link com.smartgwt.client.widgets.grid.ListGrid#getUseRowSpanStyling useRowSpanStyling}
     * is enabled.  See {@link com.smartgwt.client.types.RowSpanSelectionMode}.
     *
     * @return RowSpanSelectionMode
     */
    public RowSpanSelectionMode getRowSpanSelectionMode()  {
        return EnumUtil.getEnum(RowSpanSelectionMode.values(), getAttribute("rowSpanSelectionMode"));
    }
    

    /**
     * Whether edits should be saved whenever the user moves between cells in the current edit row. <P> If unset, defaults to
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell this.editByCell}. <P> To avoid automatic saving entirely,
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits}:false.
     *
     * @param saveByCell  Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setEditByCell
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setSaveByCell(Boolean saveByCell) {
        setAttribute("saveByCell", saveByCell, true);
    }

    /**
     * Whether edits should be saved whenever the user moves between cells in the current edit row. <P> If unset, defaults to
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell this.editByCell}. <P> To avoid automatic saving entirely,
     * set {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits}:false.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEditByCell
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getSaveByCell()  {
        return getAttributeAsBoolean("saveByCell");
    }
    

    /**
     * For grids with a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, this property can
     * be set to <code>true</code> to prevent the grid from attempting to save / retrieve data from the server.  In this case
     * the grid's data should be specified as an array via the {@link com.smartgwt.client.widgets.grid.ListGrid#getData data}
     * attribute, and the datasource will simply act as a schema to describe the set of fields visible in the grid. {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanEdit Inline edits}, or removals via the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} mechanism will update the local data
     * array rather than attempting to perform operations against the dataSource.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param saveLocally  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setUseRemoteValidators
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public void setSaveLocally(Boolean saveLocally)  throws IllegalStateException {
        setAttribute("saveLocally", saveLocally, false);
    }

    /**
     * For grids with a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, this property can
     * be set to <code>true</code> to prevent the grid from attempting to save / retrieve data from the server.  In this case
     * the grid's data should be specified as an array via the {@link com.smartgwt.client.widgets.grid.ListGrid#getData data}
     * attribute, and the datasource will simply act as a schema to describe the set of fields visible in the grid. {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanEdit Inline edits}, or removals via the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} mechanism will update the local data
     * array rather than attempting to perform operations against the dataSource.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getUseRemoteValidators
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public Boolean getSaveLocally()  {
        return getAttributeAsBoolean("saveLocally");
    }
    

    /**
     * For editable grids with a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, where
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} is false, this attribute may be used to
     * specify standard DSRequest properties to apply to all save operations performed by this grid (whether triggered by user
     * interaction, or explicit saveEdits or saveAllEdits call). <P> An example usage would be to customize the prompt
     * displayed while saving is in progress if {@link com.smartgwt.client.widgets.grid.ListGrid#getWaitForSave waitForSave} is
     * true. <P> Note that for more advanced customization of save operations, {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getAddOperation addOperation} and {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getUpdateOperation updateOperation} are available to developers, allowing
     * specification of an explicit {@link com.smartgwt.client.data.OperationBinding} for the add / update operation performed
     * on save.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param saveRequestProperties  Default value is null
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setSaveRequestProperties(DSRequest saveRequestProperties) {
        setAttribute("saveRequestProperties", saveRequestProperties.getJsObj(), true);
    }

    /**
     * For editable grids with a specified {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}, where
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} is false, this attribute may be used to
     * specify standard DSRequest properties to apply to all save operations performed by this grid (whether triggered by user
     * interaction, or explicit saveEdits or saveAllEdits call). <P> An example usage would be to customize the prompt
     * displayed while saving is in progress if {@link com.smartgwt.client.widgets.grid.ListGrid#getWaitForSave waitForSave} is
     * true. <P> Note that for more advanced customization of save operations, {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getAddOperation addOperation} and {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getUpdateOperation updateOperation} are available to developers, allowing
     * specification of an explicit {@link com.smartgwt.client.data.OperationBinding} for the add / update operation performed
     * on save.
     *
     * @return DSRequest
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public DSRequest getSaveRequestProperties()  {
        return new DSRequest(getAttributeAsJavaScriptObject("saveRequestProperties"));
    }
    

    /**
     * When {@link com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode} is enabled, this invisible separator
     * string is written out between each cell value. This string will be picked up by screen readers allowing them to more
     * obviously identify to the user the different cell values as the contents of a row are read aloud. The {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderRowSeparator screenReaderRowSeparator} string if any will be
     * written out after the last cell in a row to separate the last cell's value from the screen reader's announcement of the
     * row's number and total number of rows in the grid (such as "3 of 20"). <P> This attribute may be set to null to disable
     * the feature. <P> Note that screen readers vary widely on which punctuation symbols are read aloud, and sometimes it
     * depends on the context of the punctuation. However, the widely-used JAWS, NVDA, and VoiceOver screen readers all read
     * the forward slash '/' as "slash". See <a
     * href='http://www.deque.com/blog/dont-screen-readers-read-whats-screen-part-1-punctuation-typographic-symbols/'
     * target='_blank'>Why Don?t Screen Readers Always Read What?s on the Screen? Part 1: Punctuation and Typographic
     * Symbols</a> for a table of findings on which punctuation symbols are read aloud by JAWS, NVDA, and VoiceOver.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param screenReaderCellSeparator  See {@link com.smartgwt.client.docs.HTMLString HTMLString} . Default value is "/"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public void setScreenReaderCellSeparator(String screenReaderCellSeparator)  throws IllegalStateException {
        setAttribute("screenReaderCellSeparator", screenReaderCellSeparator, false);
    }

    /**
     * When {@link com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode} is enabled, this invisible separator
     * string is written out between each cell value. This string will be picked up by screen readers allowing them to more
     * obviously identify to the user the different cell values as the contents of a row are read aloud. The {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderRowSeparator screenReaderRowSeparator} string if any will be
     * written out after the last cell in a row to separate the last cell's value from the screen reader's announcement of the
     * row's number and total number of rows in the grid (such as "3 of 20"). <P> This attribute may be set to null to disable
     * the feature. <P> Note that screen readers vary widely on which punctuation symbols are read aloud, and sometimes it
     * depends on the context of the punctuation. However, the widely-used JAWS, NVDA, and VoiceOver screen readers all read
     * the forward slash '/' as "slash". See <a
     * href='http://www.deque.com/blog/dont-screen-readers-read-whats-screen-part-1-punctuation-typographic-symbols/'
     * target='_blank'>Why Don?t Screen Readers Always Read What?s on the Screen? Part 1: Punctuation and Typographic
     * Symbols</a> for a table of findings on which punctuation symbols are read aloud by JAWS, NVDA, and VoiceOver.
     *
     * @return  See {@link com.smartgwt.client.docs.HTMLString HTMLString} 
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public String getScreenReaderCellSeparator()  {
        return getAttributeAsString("screenReaderCellSeparator");
    }
    

    /**
     * When {@link com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode} is enabled, this invisible string will
     * be written out after the last cell in a row. This string will be picked up by screen readers allowing them to more
     * obviously identify to the user the end of the row's contents and the screen reader's announcement of the row's number
     * and total number of rows in the grid (such as "3 of 20"). <p> This attribute may be set to null to disable writing out
     * an invisible string at the end of each row. <p> Note that screen readers vary widely on which punctuation symbols are
     * read aloud, and sometimes it depends on the context of the punctuation. However, the widely-used JAWS, NVDA, and
     * VoiceOver screen readers all pause briefly for a comma ',' that is within text. See <a
     * href='http://www.deque.com/blog/dont-screen-readers-read-whats-screen-part-1-punctuation-typographic-symbols/'
     * target='_blank'>Why Don?t Screen Readers Always Read What?s on the Screen? Part 1: Punctuation and Typographic
     * Symbols</a> for a table of findings on which punctuation symbols are read aloud by JAWS, NVDA, and VoiceOver.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param screenReaderRowSeparator  See {@link com.smartgwt.client.docs.HTMLString HTMLString} . Default value is ","
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setScreenReaderCellSeparator
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public void setScreenReaderRowSeparator(String screenReaderRowSeparator)  throws IllegalStateException {
        setAttribute("screenReaderRowSeparator", screenReaderRowSeparator, false);
    }

    /**
     * When {@link com.smartgwt.client.util.isc#setScreenReaderMode screen reader mode} is enabled, this invisible string will
     * be written out after the last cell in a row. This string will be picked up by screen readers allowing them to more
     * obviously identify to the user the end of the row's contents and the screen reader's announcement of the row's number
     * and total number of rows in the grid (such as "3 of 20"). <p> This attribute may be set to null to disable writing out
     * an invisible string at the end of each row. <p> Note that screen readers vary widely on which punctuation symbols are
     * read aloud, and sometimes it depends on the context of the punctuation. However, the widely-used JAWS, NVDA, and
     * VoiceOver screen readers all pause briefly for a comma ',' that is within text. See <a
     * href='http://www.deque.com/blog/dont-screen-readers-read-whats-screen-part-1-punctuation-typographic-symbols/'
     * target='_blank'>Why Don?t Screen Readers Always Read What?s on the Screen? Part 1: Punctuation and Typographic
     * Symbols</a> for a table of findings on which punctuation symbols are read aloud by JAWS, NVDA, and VoiceOver.
     *
     * @return  See {@link com.smartgwt.client.docs.HTMLString HTMLString} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getScreenReaderCellSeparator
     * @see com.smartgwt.client.docs.Accessibility Accessibility overview and related methods
     */
    public String getScreenReaderRowSeparator()  {
        return getAttributeAsString("screenReaderRowSeparator");
    }
    

    /**
     * While drag scrolling in an incrementally rendered grid, time in milliseconds to wait before redrawing, after the last
     * mouse movement by the user. This delay may be  separately customized for mouse-wheel scrolling via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollWheelRedrawDelay scrollWheelRedrawDelay}. <P> See also {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getInstantScrollTrackRedraw instantScrollTrackRedraw} for cases where this
     * delay is skipped. <P> <strong>NOTE:</strong> In {@link com.smartgwt.client.util.Browser#isTouch touch browsers}, {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getTouchScrollRedrawDelay touchScrollRedrawDelay} is used instead.
     *
     * @param scrollRedrawDelay  Default value is 75
     */
    public void setScrollRedrawDelay(int scrollRedrawDelay) {
        setAttribute("scrollRedrawDelay", scrollRedrawDelay, true);
    }

    /**
     * While drag scrolling in an incrementally rendered grid, time in milliseconds to wait before redrawing, after the last
     * mouse movement by the user. This delay may be  separately customized for mouse-wheel scrolling via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollWheelRedrawDelay scrollWheelRedrawDelay}. <P> See also {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getInstantScrollTrackRedraw instantScrollTrackRedraw} for cases where this
     * delay is skipped. <P> <strong>NOTE:</strong> In {@link com.smartgwt.client.util.Browser#isTouch touch browsers}, {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getTouchScrollRedrawDelay touchScrollRedrawDelay} is used instead.
     *
     * @return int
     */
    public int getScrollRedrawDelay()  {
        return getAttributeAsInt("scrollRedrawDelay");
    }
    

    /**
     * When scrollToCell is called, this is used as defaults if xPosition weren't explicitly passed into the method.
     *
     * @param scrollToCellXPosition  Default value is "center"
     */
    public void setScrollToCellXPosition(Alignment scrollToCellXPosition) {
        setAttribute("scrollToCellXPosition", scrollToCellXPosition == null ? null : scrollToCellXPosition.getValue(), true);
    }

    /**
     * When scrollToCell is called, this is used as defaults if xPosition weren't explicitly passed into the method.
     *
     * @return Alignment
     */
    public Alignment getScrollToCellXPosition()  {
        return EnumUtil.getEnum(Alignment.values(), getAttribute("scrollToCellXPosition"));
    }
    

    /**
     * When scrollToCell is called, this is used as defaults if yPosition weren't explicitly passed into the method.
     *
     * @param scrollToCellYPosition  Default value is "center"
     */
    public void setScrollToCellYPosition(VerticalAlignment scrollToCellYPosition) {
        setAttribute("scrollToCellYPosition", scrollToCellYPosition == null ? null : scrollToCellYPosition.getValue(), true);
    }

    /**
     * When scrollToCell is called, this is used as defaults if yPosition weren't explicitly passed into the method.
     *
     * @return VerticalAlignment
     */
    public VerticalAlignment getScrollToCellYPosition()  {
        return EnumUtil.getEnum(VerticalAlignment.values(), getAttribute("scrollToCellYPosition"));
    }
    

    /**
     * While scrolling an incrementally rendered grid, using the mouseWheel, time in  milliseconds to wait before redrawing,
     * after the last mouseWheel movement by the user.   If not specified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay} will be used as a default for both
     * drag scrolling and mouseWheel scrolling. <P> Note that if specified, this value will typically be larger than  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}. From experimentation, the default
     * setting of  <code>250</code> is typically enough time for a user to rapidly scroll through a grid (rotating the scroll
     * wheel with repeated flicks), without redrawing between rotations, but this will differ depending on how long the redraw
     * takes. A larger delay may be warranted for grids with large numbers of columns, heavy custom  formatting, etc. <P> See
     * also {@link com.smartgwt.client.widgets.grid.GridRenderer#getInstantScrollTrackRedraw instantScrollTrackRedraw} for
     * cases where this delay is skipped.
     *
     * @param scrollWheelRedrawDelay  Default value is 250
     */
    public void setScrollWheelRedrawDelay(Integer scrollWheelRedrawDelay) {
        setAttribute("scrollWheelRedrawDelay", scrollWheelRedrawDelay, true);
    }

    /**
     * While scrolling an incrementally rendered grid, using the mouseWheel, time in  milliseconds to wait before redrawing,
     * after the last mouseWheel movement by the user.   If not specified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay} will be used as a default for both
     * drag scrolling and mouseWheel scrolling. <P> Note that if specified, this value will typically be larger than  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getScrollRedrawDelay scrollRedrawDelay}. From experimentation, the default
     * setting of  <code>250</code> is typically enough time for a user to rapidly scroll through a grid (rotating the scroll
     * wheel with repeated flicks), without redrawing between rotations, but this will differ depending on how long the redraw
     * takes. A larger delay may be warranted for grids with large numbers of columns, heavy custom  formatting, etc. <P> See
     * also {@link com.smartgwt.client.widgets.grid.GridRenderer#getInstantScrollTrackRedraw instantScrollTrackRedraw} for
     * cases where this delay is skipped.
     *
     * @return Integer
     */
    public Integer getScrollWheelRedrawDelay()  {
        return getAttributeAsInt("scrollWheelRedrawDelay");
    }
    

    /**
     * Returns a snapshot of the current selection within this listGrid as a {@link
     * com.smartgwt.client.docs.ListGridSelectedState} object.<br> This object can be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSelectedState ListGrid.setSelectedState()} to reset this grid's selection
     * the current state (assuming the same data is present in the grid).<br>
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Reset this grid's selection to match the {@link com.smartgwt.client.docs.ListGridSelectedState} object passed in.<br> Used to restore previous state retrieved from the grid by a call to {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectedState ListGrid.getSelectedState()}.
     *
     * @param selectedState Object describing the desired selection state of                                              the grid See {@link com.smartgwt.client.docs.ListGridSelectedState ListGridSelectedState} . Default value is null
     */
    public void setSelectedState(String selectedState) {
        setAttribute("selectedState", selectedState, true);
    }

    /**
     * Returns a snapshot of the current selection within this listGrid as a {@link
     * com.smartgwt.client.docs.ListGridSelectedState} object.<br> This object can be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSelectedState ListGrid.setSelectedState()} to reset this grid's selection
     * the current state (assuming the same data is present in the grid).<br>
     *
     * @return Returns a snapshot of the current selection within this listGrid as a {@link
     * com.smartgwt.client.docs.ListGridSelectedState} object.<br> This object can be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSelectedState ListGrid.setSelectedState()} to reset this grid's current
     * selection state (assuming the same data is present in the grid).<br> See {@link com.smartgwt.client.docs.ListGridSelectedState ListGridSelectedState} 
     */
    public String getSelectedState()  {
        return getAttributeAsString("selectedState");
    }
    

    /**
     * If true, show the field-header for the sorted field (or the first field in a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanMultiSort multi-sort} grid) in the selected state.
     *
     * @param selectHeaderOnSort  Default value is true
     */
    public void setSelectHeaderOnSort(Boolean selectHeaderOnSort) {
        setAttribute("selectHeaderOnSort", selectHeaderOnSort, true);
    }

    /**
     * If true, show the field-header for the sorted field (or the first field in a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanMultiSort multi-sort} grid) in the selected state.
     *
     * @return Boolean
     */
    public Boolean getSelectHeaderOnSort()  {
        Boolean result = getAttributeAsBoolean("selectHeaderOnSort");
        return result == null ? true : result;
    }
    
    

    /**
     * How selection of rows should be presented to the user. <P> For <code>selectionAppearance:"checkbox"</code> with multiple
     * selection allowed, you would typically use {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType
     * selectionType}:"simple" (the default).  Because <code>selectionType</code> and <code>selectionAppearance</code> are
     * unrelated, the combination of <code>selectionAppearance:"checkbox"</code> and <code>selectionType:"multiple"</code>
     * results in a grid where multiple selection can only be achieved via shift-click or ctrl-click. <P> If using
     * <code>"checkbox"</code> for a {@link com.smartgwt.client.widgets.grid.ListGrid}, see also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCheckboxField checkboxField} for customization APIs. <P> If using
     * <code>"checkbox"</code> for a {@link com.smartgwt.client.widgets.tree.TreeGrid}, an extra icon, {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getExtraIcon TreeGrid.getExtraIcon()} is not supported. Additionally only
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType}:"simple" and "single" are supported.
     * You can also toggle the display of a disabled checkbox on a treegrid, displayed when the node can't be selected, via
     * {@link com.smartgwt.client.widgets.tree.TreeGrid#getShowDisabledSelectionCheckbox showDisabledSelectionCheckbox}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Changes selectionAppearance on the fly.
     *
     * @param selectionAppearance new selection appearance. Default value is "rowStyle"
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public void setSelectionAppearance(SelectionAppearance selectionAppearance) {
        setAttribute("selectionAppearance", selectionAppearance == null ? null : selectionAppearance.getValue(), true);
    }

    /**
     * How selection of rows should be presented to the user. <P> For <code>selectionAppearance:"checkbox"</code> with multiple
     * selection allowed, you would typically use {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType
     * selectionType}:"simple" (the default).  Because <code>selectionType</code> and <code>selectionAppearance</code> are
     * unrelated, the combination of <code>selectionAppearance:"checkbox"</code> and <code>selectionType:"multiple"</code>
     * results in a grid where multiple selection can only be achieved via shift-click or ctrl-click. <P> If using
     * <code>"checkbox"</code> for a {@link com.smartgwt.client.widgets.grid.ListGrid}, see also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCheckboxField checkboxField} for customization APIs. <P> If using
     * <code>"checkbox"</code> for a {@link com.smartgwt.client.widgets.tree.TreeGrid}, an extra icon, {@link
     * com.smartgwt.client.widgets.tree.TreeGrid#getExtraIcon TreeGrid.getExtraIcon()} is not supported. Additionally only
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType}:"simple" and "single" are supported.
     * You can also toggle the display of a disabled checkbox on a treegrid, displayed when the node can't be selected, via
     * {@link com.smartgwt.client.widgets.tree.TreeGrid#getShowDisabledSelectionCheckbox showDisabledSelectionCheckbox}.
     *
     * @return SelectionAppearance
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public SelectionAppearance getSelectionAppearance()  {
        return EnumUtil.getEnum(SelectionAppearance.values(), getAttribute("selectionAppearance"));
    }
    
    

    /**
     * If specified, the selection object for this list will use this property to mark records as selected.  In other words, if
     * this attribute were set to <code>"isSelected"</code> any records in the listGrid data where <code>"isSelected"</code> is
     * <code>true</code> will show up as selected in the grid. Similarly if records are selected within the grid after the grid
     * has been created, this property will be set to true on the selected records.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param selectionProperty  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setSelectionProperty(String selectionProperty)  throws IllegalStateException {
        setAttribute("selectionProperty", selectionProperty, false);
    }

    /**
     * If specified, the selection object for this list will use this property to mark records as selected.  In other words, if
     * this attribute were set to <code>"isSelected"</code> any records in the listGrid data where <code>"isSelected"</code> is
     * <code>true</code> will show up as selected in the grid. Similarly if records are selected within the grid after the grid
     * has been created, this property will be set to true on the selected records.
     *
     * @return String
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getSelectionProperty()  {
        return getAttributeAsString("selectionProperty");
    }
    

    /**
     * Defines a listGrid's clickable-selection behavior. <P> The default selection appearance is governed by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance}: if selectionAppearance is
     * "checkbox", this will be "simple", otherwise, this will be "multiple".
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Changes selectionType on the fly.
     *
     * @param selectionType New selection style.. Default value is null
     * @see com.smartgwt.client.types.SelectionStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_multiselect" target="examples">Multiple select Example</a>
     */
    public void setSelectionType(SelectionStyle selectionType) {
        setAttribute("selectionType", selectionType == null ? null : selectionType.getValue(), true);
    }

    /**
     * Defines a listGrid's clickable-selection behavior. <P> The default selection appearance is governed by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionAppearance selectionAppearance}: if selectionAppearance is
     * "checkbox", this will be "simple", otherwise, this will be "multiple".
     *
     * @return SelectionStyle
     * @see com.smartgwt.client.types.SelectionStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_interaction_multiselect" target="examples">Multiple select Example</a>
     */
    public SelectionStyle getSelectionType()  {
        return EnumUtil.getEnum(SelectionStyle.values(), getAttribute("selectionType"));
    }
    
    

    /**
     * When the user starts editing a row, should the row also be selected?  <P>  Note that  when this attribute is set to
     * <code>true</code>, other all other rows in the grid  will be deselected when a record is selected due to editing.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param selectOnEdit  Default value is true
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setSelectOnEdit(Boolean selectOnEdit) {
        setAttribute("selectOnEdit", selectOnEdit, true);
    }

    /**
     * When the user starts editing a row, should the row also be selected?  <P>  Note that  when this attribute is set to
     * <code>true</code>, other all other rows in the grid  will be deselected when a record is selected due to editing.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getSelectOnEdit()  {
        Boolean result = getAttributeAsBoolean("selectOnEdit");
        return result == null ? true : result;
    }
    

    /**
     * Whether all columns should be drawn all at once, or only columns visible in the viewport. <P> Drawing all columns causes
     * longer initial rendering time, but allows smoother horizontal scrolling.  With a very large number of columns,
     * showAllColumns will become too slow.
     *
     * @param showAllColumns  Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setShowAllColumns(Boolean showAllColumns)  throws IllegalStateException {
        setAttribute("showAllColumns", showAllColumns, false);
    }

    /**
     * Whether all columns should be drawn all at once, or only columns visible in the viewport. <P> Drawing all columns causes
     * longer initial rendering time, but allows smoother horizontal scrolling.  With a very large number of columns,
     * showAllColumns will become too slow.
     *
     * @return Boolean
     */
    public Boolean getShowAllColumns()  {
        Boolean result = getAttributeAsBoolean("showAllColumns");
        return result == null ? false : result;
    }
    

    /**
     * Whether all rows should be drawn all at once, or only rows visible in the viewport. <P> Drawing all rows causes longer
     * initial rendering time, but allows smoother vertical scrolling. With a very large number of rows, showAllRows will
     * become too slow. <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAllMaxCells drawAllMaxCells}.
     *
     * @param showAllRecords  Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public void setShowAllRecords(Boolean showAllRecords) {
        setAttribute("showAllRecords", showAllRecords, true);
    }

    /**
     * Whether all rows should be drawn all at once, or only rows visible in the viewport. <P> Drawing all rows causes longer
     * initial rendering time, but allows smoother vertical scrolling. With a very large number of rows, showAllRows will
     * become too slow. <P> See also {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAheadRatio drawAheadRatio} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawAllMaxCells drawAllMaxCells}.
     *
     * @return Boolean
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_rows" target="examples">Rows Example</a>
     */
    public Boolean getShowAllRecords()  {
        Boolean result = getAttributeAsBoolean("showAllRecords");
        return result == null ? false : result;
    }
    

    /**
     * If set to false, do not show the {@link com.smartgwt.client.widgets.grid.ListGrid#getAsynchGroupingPrompt
     * asynchGroupingPrompt} dialog during {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold
     * asynchronous grouping}.
     *
     * @param showAsynchGroupingPrompt  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setShowAsynchGroupingPrompt(Boolean showAsynchGroupingPrompt)  throws IllegalStateException {
        setAttribute("showAsynchGroupingPrompt", showAsynchGroupingPrompt, false);
    }

    /**
     * If set to false, do not show the {@link com.smartgwt.client.widgets.grid.ListGrid#getAsynchGroupingPrompt
     * asynchGroupingPrompt} dialog during {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByAsyncThreshold
     * asynchronous grouping}.
     *
     * @return Boolean
     */
    public Boolean getShowAsynchGroupingPrompt()  {
        return getAttributeAsBoolean("showAsynchGroupingPrompt");
    }
    

    /**
     * If <code>true</code> this grid will create and show per-row backgroundComponents as detailed {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBackgroundComponent here}.
     *
     * @param showBackgroundComponents  Default value is false
     */
    public void setShowBackgroundComponents(Boolean showBackgroundComponents) {
        setAttribute("showBackgroundComponents", showBackgroundComponents, true);
    }

    /**
     * If <code>true</code> this grid will create and show per-row backgroundComponents as detailed {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBackgroundComponent here}.
     *
     * @return Boolean
     */
    public Boolean getShowBackgroundComponents()  {
        Boolean result = getAttributeAsBoolean("showBackgroundComponents");
        return result == null ? false : result;
    }
    

    /**
     * Whether to show a context menu with standard items for all context clicks on rows in the body.
     *
     * @param showCellContextMenus  Default value is false
     */
    public void setShowCellContextMenus(Boolean showCellContextMenus) {
        setAttribute("showCellContextMenus", showCellContextMenus, true);
    }

    /**
     * Whether to show a context menu with standard items for all context clicks on rows in the body.
     *
     * @return Boolean
     */
    public Boolean getShowCellContextMenus()  {
        Boolean result = getAttributeAsBoolean("showCellContextMenus");
        return result == null ? false : result;
    }
    

    /**
     * If true and a header button's title is clipped, then a hover containing the full field title is enabled.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showClippedHeaderTitlesOnHover  Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#headerTitleClipped
     * @see com.smartgwt.client.widgets.grid.ListGrid#headerHoverHTML
     */
    public void setShowClippedHeaderTitlesOnHover(boolean showClippedHeaderTitlesOnHover)  throws IllegalStateException {
        setAttribute("showClippedHeaderTitlesOnHover", showClippedHeaderTitlesOnHover, false);
    }

    /**
     * If true and a header button's title is clipped, then a hover containing the full field title is enabled.
     *
     * @return boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#headerTitleClipped
     * @see com.smartgwt.client.widgets.grid.ListGrid#headerHoverHTML
     */
    public boolean getShowClippedHeaderTitlesOnHover()  {
        Boolean result = getAttributeAsBoolean("showClippedHeaderTitlesOnHover");
        return result == null ? true : result;
    }
    

    /**
     * If true and a cell's value is clipped, then a hover containing the full cell value is enabled. <p> Note that standard
     * cell hovers override clipped value hovers. Thus, to enable clipped value hovers, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanHover canHover} must be unset or null and the corresponding field must
     * have {@link com.smartgwt.client.widgets.grid.ListGridField#getShowHover showHover} unset or null as well.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showClippedValuesOnHover  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCanHover
     * @see com.smartgwt.client.widgets.grid.ListGrid#cellValueHoverHTML
     */
    public void setShowClippedValuesOnHover(Boolean showClippedValuesOnHover)  throws IllegalStateException {
        setAttribute("showClippedValuesOnHover", showClippedValuesOnHover, false);
    }

    /**
     * If true and a cell's value is clipped, then a hover containing the full cell value is enabled. <p> Note that standard
     * cell hovers override clipped value hovers. Thus, to enable clipped value hovers, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanHover canHover} must be unset or null and the corresponding field must
     * have {@link com.smartgwt.client.widgets.grid.ListGridField#getShowHover showHover} unset or null as well.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCanHover
     * @see com.smartgwt.client.widgets.grid.ListGrid#cellValueHoverHTML
     */
    public Boolean getShowClippedValuesOnHover()  {
        return getAttributeAsBoolean("showClippedValuesOnHover");
    }
    

    /**
     * Should group summaries be visible when the group is collapsed? <P> This property only applies to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} grids showing {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summary rows}. When set to true, the group summary
     * row(s) for each group will show up under the group header nodes when the group is collapsed, or at then end of the
     * grouped set of data if the group is expanded. <P> This property has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getShowCollapsedGroupSummary showCollapsedGroupSummary}
     *
     * @param showCollapsedGroupSummary new showCollapsedGroupSummary value. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setShowCollapsedGroupSummary(Boolean showCollapsedGroupSummary) {
        setAttribute("showCollapsedGroupSummary", showCollapsedGroupSummary, true);
    }

    /**
     * Should group summaries be visible when the group is collapsed? <P> This property only applies to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} grids showing {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summary rows}. When set to true, the group summary
     * row(s) for each group will show up under the group header nodes when the group is collapsed, or at then end of the
     * grouped set of data if the group is expanded. <P> This property has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public Boolean getShowCollapsedGroupSummary()  {
        Boolean result = getAttributeAsBoolean("showCollapsedGroupSummary");
        return result == null ? false : result;
    }
    

    /**
     * Whether to include fields marked <code>detail:true</code> from this component's <code>DataSource</code>. <P> Fields may
     * also be included directly in this component's <code>fields</code> array in which case they will be present regardless of
     * the <code>detail</code> attribute. <p> When this property is <code>true</code>, <code>ListGrid</code>s will include all
     * detail fields, but they will be initially hidden.  The user may show these fields via the default header context menu
     * ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu showHeaderContextMenu}). Setting this
     * property to false will completely exclude all detail fields from the list grid's fields array, such that they cannot be
     * shown by the user or programmatically. <P> To override the visibility of individual fields, use the standard {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showField ListGrid.showField()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#hideField ListGrid.hideField()} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#showIf ListGridField.showIf()} APIs, for example, set showIf:"true" to
     * show a detail field initially.
     *
     * @param showDetailFields  Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public void setShowDetailFields(Boolean showDetailFields)  throws IllegalStateException {
        setAttribute("showDetailFields", showDetailFields, false);
    }

    /**
     * Whether to include fields marked <code>detail:true</code> from this component's <code>DataSource</code>. <P> Fields may
     * also be included directly in this component's <code>fields</code> array in which case they will be present regardless of
     * the <code>detail</code> attribute. <p> When this property is <code>true</code>, <code>ListGrid</code>s will include all
     * detail fields, but they will be initially hidden.  The user may show these fields via the default header context menu
     * ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu showHeaderContextMenu}). Setting this
     * property to false will completely exclude all detail fields from the list grid's fields array, such that they cannot be
     * shown by the user or programmatically. <P> To override the visibility of individual fields, use the standard {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showField ListGrid.showField()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#hideField ListGrid.hideField()} and {@link
     * com.smartgwt.client.widgets.grid.ListGridField#showIf ListGridField.showIf()} APIs, for example, set showIf:"true" to
     * show a detail field initially.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public Boolean getShowDetailFields()  {
        Boolean result = getAttributeAsBoolean("showDetailFields");
        return result == null ? true : result;
    }
    

    /**
     * Indicates whether the text of the emptyMessage property should be displayed if no data is available.
     *
     * @param showEmptyMessage  Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#setEmptyMessage
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_grid" target="examples">Empty grid Example</a>
     */
    public void setShowEmptyMessage(Boolean showEmptyMessage) {
        setAttribute("showEmptyMessage", showEmptyMessage, true);
    }

    /**
     * Indicates whether the text of the emptyMessage property should be displayed if no data is available.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEmptyMessage
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_empty_grid" target="examples">Empty grid Example</a>
     */
    public Boolean getShowEmptyMessage()  {
        Boolean result = getAttributeAsBoolean("showEmptyMessage");
        return result == null ? true : result;
    }
    

    /**
     * If this grid is editable, and an edit has caused validation failure for some cell,  should we show an icon to indicate
     * validation failure?
     *
     * @param showErrorIcons  Default value is true
     */
    public void setShowErrorIcons(boolean showErrorIcons) {
        setAttribute("showErrorIcons", showErrorIcons, true);
    }

    /**
     * If this grid is editable, and an edit has caused validation failure for some cell,  should we show an icon to indicate
     * validation failure?
     *
     * @return boolean
     */
    public boolean getShowErrorIcons()  {
        Boolean result = getAttributeAsBoolean("showErrorIcons");
        return result == null ? true : result;
    }
    

    /**
     * When {@link com.smartgwt.client.types.ExpansionMode} is <i>editor</i>, should a Save button be shown below the the
     * expanded editor? <P> Note that if an expanded-row containing an editor is collapsed while changes are oustanding,
     * changes will be either be automatically updated to the grid, or will first show a confirmation dialog, according to the
     * value of {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionEditorShowSaveDialog
     * expansionEditorShowSaveDialog}.
     * <p>
     * <b>Note :</b> This method should be called only after the widget has been rendered.
     *
     * @return Boolean
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public Boolean getShowExpansionEditorSaveButton() throws IllegalStateException {
        errorIfNotCreated("showExpansionEditorSaveButton");
        Boolean result = getAttributeAsBoolean("showExpansionEditorSaveButton");
        return result == null ? true : result;
    }
    

    /**
     * Should this listGrid display a filter row.  If true, this ListGrid
     *  will be drawn with a single editable row, (separate from the body) with a filter button.
     *  <P>
     *  Values entered into this row are used as filter criteria to filter this List's data on
     * enter-keypress or filter button click. {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle
     * autoFetchTextMatchStyle} determines
     * the textMatchStyle for the request passed to {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData
     * ListGrid.fetchData()}.
     *  <P>
     * The default {@link com.smartgwt.client.widgets.form.fields.FormItem#getOperator search operator} for an item in the
     * filterEditor can
     * be set via a field's {@link com.smartgwt.client.widgets.grid.ListGridField#getFilterEditorProperties
     * filterEditorProperties}.  When this happens, calls to retrieve the criteria from the
     *  grid return {@link com.smartgwt.client.data.AdvancedCriteria}.
     *  <P>
     * Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#filterData ListGrid.filterData()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()} is called
     *  directly while the filter editor is showing, the filter editor values will be updated to
     *  reflect the new set of criteria. If you wish to retain the user entered filter criteria
     *  and modify a subset of field values programmatically, this can be achieved by
     *  copying the existing set of criteria and adding other changes - something
     *  like this:
     *  
     *  
     *  <pre><code>
     *    Criteria newCriteria = myListGrid.getFilterEditorCriteria();
     *    newCriteria = DataSource.combineCriteria(newCriteria,
     *       new Criteria("field1", "new value1")
     *    );
     *    myListGrid.setCriteria(newCriteria);
     *  </code></pre>
     *  
     * In this example code we're using {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorCriteria
     * ListGrid.getFilterEditorCriteria()} rather than
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCriteria ListGrid.getCriteria()} - this ensures that if the user has
     * typed a new value into
     *  the filter editor, but not yet clicked the filter button, we pick up the value the user
     * entered.  This sample code uses {@link com.smartgwt.client.data.DataSource#combineCriteria DataSource.combineCriteria()}
     * to combine the
     *  existing filterEditorCriteria with some new custom criteria.  This technique is
     *  applicable to both simple and advanced criteria.
     *  <P>
     *  If you call <code>filterData()</code> and pass in criteria for dataSource
     *  fields that are not present in the ListGrid, these criteria will continue to be applied
     *  along with the user-visible criteria.
     *  <P>
     *  <b>filterEditor and advanced criteria</b>: If a developer calls <code>filterData()</code>
     *  on a ListGrid and passes in {@link com.smartgwt.client.data.AdvancedCriteria}, expected behavior of the filter
     *  editor becomes ambiguous, since AdvancedCriteria has far more complex filter
     *  expression support than the ordinary filterEditor can represent.
     *  <P>
     *  Default behavior for AdvancedCriteria will combine the AdvancedCriteria with the values
     *  in the filter editor as follows:
     *  <ul>
     *  <li>If the top level criteria has operator of type "and":<br>
     *   Each field in the top level
     *   criteria array for which a 'canFilter' true field is shown in the listGrid will show up
     *   if the specified operator matches the default filter behavior
     * (based on the {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle autoFetchTextMatchStyle}).<br>
     *   If the user enters values in the filter editor, these will be combined with the
     *   existing AdvancedCriteria by either replacing or adding field level criteria at the top
     *   level.</li>
     *  <li>If the top level criteria is a single field-criteria:<br>
     *   If the field shows up in the listGrid and is canFilter:true, it will be displayed to
     *   the user (if the operator matches the default filter behavior for the field).<br>
     *   If the user enters new filter criteria in the filterEditor, they will be combined with
     *   this existing criterion via a top level "and" operator, or if the user modifies the
     *   field for which the criterion already existed, it will be replaced.</li>
     *  <li>Otherwise, if there are multiple top level criteria combined with an "or" operator,
     *   these will not be shown in the filter editor. Any filter parameters the user enters will
     *   be added to the existing criteria via an additional top level "and" operator, meaning
     *   the user will essentially filter a subset of the existing criteria</li>
     *  </ul>
     *  <P>
     *  See {@link com.smartgwt.client.widgets.grid.ListGrid#getDropCriteriaOnHideField dropCriteriaOnHideField}
     *  for behavior when hiding fields while the filter-editor is showing.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} property. Allows the filter editor to be shown or hidden at runtime.
     *
     * @param showFilterEditor true if the filter editor should be shown, false if it should be hidden. Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sortFilter_filter" target="examples">Filter Example</a>
     */
    public void setShowFilterEditor(boolean showFilterEditor) {
        setAttribute("showFilterEditor", showFilterEditor, true);
    }

    /**
     * Should this listGrid display a filter row.  If true, this ListGrid
     *  will be drawn with a single editable row, (separate from the body) with a filter button.
     *  <P>
     *  Values entered into this row are used as filter criteria to filter this List's data on
     * enter-keypress or filter button click. {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle
     * autoFetchTextMatchStyle} determines
     * the textMatchStyle for the request passed to {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData
     * ListGrid.fetchData()}.
     *  <P>
     * The default {@link com.smartgwt.client.widgets.form.fields.FormItem#getOperator search operator} for an item in the
     * filterEditor can
     * be set via a field's {@link com.smartgwt.client.widgets.grid.ListGridField#getFilterEditorProperties
     * filterEditorProperties}.  When this happens, calls to retrieve the criteria from the
     *  grid return {@link com.smartgwt.client.data.AdvancedCriteria}.
     *  <P>
     * Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#filterData ListGrid.filterData()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()} is called
     *  directly while the filter editor is showing, the filter editor values will be updated to
     *  reflect the new set of criteria. If you wish to retain the user entered filter criteria
     *  and modify a subset of field values programmatically, this can be achieved by
     *  copying the existing set of criteria and adding other changes - something
     *  like this:
     *  
     *  
     *  <pre><code>
     *    Criteria newCriteria = myListGrid.getFilterEditorCriteria();
     *    newCriteria = DataSource.combineCriteria(newCriteria,
     *       new Criteria("field1", "new value1")
     *    );
     *    myListGrid.setCriteria(newCriteria);
     *  </code></pre>
     *  
     * In this example code we're using {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorCriteria
     * ListGrid.getFilterEditorCriteria()} rather than
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCriteria ListGrid.getCriteria()} - this ensures that if the user has
     * typed a new value into
     *  the filter editor, but not yet clicked the filter button, we pick up the value the user
     * entered.  This sample code uses {@link com.smartgwt.client.data.DataSource#combineCriteria DataSource.combineCriteria()}
     * to combine the
     *  existing filterEditorCriteria with some new custom criteria.  This technique is
     *  applicable to both simple and advanced criteria.
     *  <P>
     *  If you call <code>filterData()</code> and pass in criteria for dataSource
     *  fields that are not present in the ListGrid, these criteria will continue to be applied
     *  along with the user-visible criteria.
     *  <P>
     *  <b>filterEditor and advanced criteria</b>: If a developer calls <code>filterData()</code>
     *  on a ListGrid and passes in {@link com.smartgwt.client.data.AdvancedCriteria}, expected behavior of the filter
     *  editor becomes ambiguous, since AdvancedCriteria has far more complex filter
     *  expression support than the ordinary filterEditor can represent.
     *  <P>
     *  Default behavior for AdvancedCriteria will combine the AdvancedCriteria with the values
     *  in the filter editor as follows:
     *  <ul>
     *  <li>If the top level criteria has operator of type "and":<br>
     *   Each field in the top level
     *   criteria array for which a 'canFilter' true field is shown in the listGrid will show up
     *   if the specified operator matches the default filter behavior
     * (based on the {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle autoFetchTextMatchStyle}).<br>
     *   If the user enters values in the filter editor, these will be combined with the
     *   existing AdvancedCriteria by either replacing or adding field level criteria at the top
     *   level.</li>
     *  <li>If the top level criteria is a single field-criteria:<br>
     *   If the field shows up in the listGrid and is canFilter:true, it will be displayed to
     *   the user (if the operator matches the default filter behavior for the field).<br>
     *   If the user enters new filter criteria in the filterEditor, they will be combined with
     *   this existing criterion via a top level "and" operator, or if the user modifies the
     *   field for which the criterion already existed, it will be replaced.</li>
     *  <li>Otherwise, if there are multiple top level criteria combined with an "or" operator,
     *   these will not be shown in the filter editor. Any filter parameters the user enters will
     *   be added to the existing criteria via an additional top level "and" operator, meaning
     *   the user will essentially filter a subset of the existing criteria</li>
     *  </ul>
     *  <P>
     *  See {@link com.smartgwt.client.widgets.grid.ListGrid#getDropCriteriaOnHideField dropCriteriaOnHideField}
     *  for behavior when hiding fields while the filter-editor is showing.
     *
     * @return boolean
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sortFilter_filter" target="examples">Filter Example</a>
     */
    public boolean getShowFilterEditor()  {
        Boolean result = getAttributeAsBoolean("showFilterEditor");
        return result == null ? false : result;
    }
    

    /**
     * Should this ListGrid show a summary row beneath the last record of the grid. This summary row will contain per-field
     * summary information. See {@link com.smartgwt.client.widgets.grid.ListGridField#getShowGridSummary showGridSummary} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getGridSummaryFunction ListGrid.getGridSummaryFunction()} for details
     * on how the summary value to be displayed for each column will be calculated. <P> Note that the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summaryRow autoChild} will be created to actually display the
     * summary row.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} attribute
     *
     * @param showGridSummary new value for this.showGridSummary. Default value is false
     */
    public void setShowGridSummary(Boolean showGridSummary) {
        setAttribute("showGridSummary", showGridSummary, true);
    }

    /**
     * Should this ListGrid show a summary row beneath the last record of the grid. This summary row will contain per-field
     * summary information. See {@link com.smartgwt.client.widgets.grid.ListGridField#getShowGridSummary showGridSummary} and
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getGridSummaryFunction ListGrid.getGridSummaryFunction()} for details
     * on how the summary value to be displayed for each column will be calculated. <P> Note that the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summaryRow autoChild} will be created to actually display the
     * summary row.
     *
     * @return Boolean
     */
    public Boolean getShowGridSummary()  {
        Boolean result = getAttributeAsBoolean("showGridSummary");
        return result == null ? false : result;
    }
    

    /**
     * If this listGrid supports {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping}, setting this
     * property will cause the grid to render an extra row at the end of each group when grouped, containing summary
     * information for the fields. Summary information will be calculated by the {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getGroupSummary ListGridField.getGroupSummary()} method if specified,
     * otherwise via the specified {@link com.smartgwt.client.widgets.grid.ListGridField#getSummaryFunction summaryFunction}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} attribute
     *
     * @param showGroupSummary new value for this.showGroupSummary. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#setGroupByFieldSummaries
     */
    public void setShowGroupSummary(Boolean showGroupSummary) {
        setAttribute("showGroupSummary", showGroupSummary, true);
    }

    /**
     * If this listGrid supports {@link com.smartgwt.client.widgets.grid.ListGrid#getCanGroupBy grouping}, setting this
     * property will cause the grid to render an extra row at the end of each group when grouped, containing summary
     * information for the fields. Summary information will be calculated by the {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getGroupSummary ListGridField.getGroupSummary()} method if specified,
     * otherwise via the specified {@link com.smartgwt.client.widgets.grid.ListGridField#getSummaryFunction summaryFunction}.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getGroupByFieldSummaries
     */
    public Boolean getShowGroupSummary()  {
        Boolean result = getAttributeAsBoolean("showGroupSummary");
        return result == null ? false : result;
    }
    

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, setting this property causes
     * field summary values for each group to be displayed directly in the group header node, rather than showing up at the
     * bottom of each expanded group. <P> Note that this means the group header node will be showing multiple field values
     * rather than the default display of a single cell spanning all columns containing the group title. Developers may specify
     * an explicit {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField}, or rely on the
     * automatically generated {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn groupTitleColumn} to
     * have group titles be visible in as well as the summary values. <P> Also note that multi-line group summaries are not
     * supported when showing the group summary in the group header. If multiple {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSummaryFunction field summary functions} are defined for some field
     * only the first will be displayed when this property is set to true.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader}
     *
     * @param showGroupSummaryInHeader new showGroupSummaryInHeader state. Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public void setShowGroupSummaryInHeader(Boolean showGroupSummaryInHeader) {
        setAttribute("showGroupSummaryInHeader", showGroupSummaryInHeader, true);
    }

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, setting this property causes
     * field summary values for each group to be displayed directly in the group header node, rather than showing up at the
     * bottom of each expanded group. <P> Note that this means the group header node will be showing multiple field values
     * rather than the default display of a single cell spanning all columns containing the group title. Developers may specify
     * an explicit {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField}, or rely on the
     * automatically generated {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupTitleColumn groupTitleColumn} to
     * have group titles be visible in as well as the summary values. <P> Also note that multi-line group summaries are not
     * supported when showing the group summary in the group header. If multiple {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getSummaryFunction field summary functions} are defined for some field
     * only the first will be displayed when this property is set to true.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#groupBy
     */
    public Boolean getShowGroupSummaryInHeader()  {
        Boolean result = getAttributeAsBoolean("showGroupSummaryInHeader");
        return result == null ? false : result;
    }
    

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, instead of
     * group header nodes showing up with a single cell value spanning the full set of columns, summaries for each field will
     * show up in the appropriate columns of the header node. <P> In this case there are 2 options for where the group title
     * will show up. Developers may specify an existing field to put the title values into via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField}. If no groupTitleField is specified, this
     * property may be set to <code>true</code> which causes a <code>groupTitleColumn</code> to be automatically generated.
     * Each group header will show the group title in this column (records within the group will not show a value for this
     * column). The column appears in the leftmost position within the grid (unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true, in which case this column shows up
     * in the second-leftmost position), and by default will auto-fit to its data. <P> To customize this field, developers may
     * modify {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleColumnProperties groupTitleColumnProperties}
     *
     * @param showGroupTitleColumn  Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setShowGroupTitleColumn(Boolean showGroupTitleColumn)  throws IllegalStateException {
        setAttribute("showGroupTitleColumn", showGroupTitleColumn, false);
    }

    /**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummaryInHeader showGroupSummaryInHeader} is true, instead of
     * group header nodes showing up with a single cell value spanning the full set of columns, summaries for each field will
     * show up in the appropriate columns of the header node. <P> In this case there are 2 options for where the group title
     * will show up. Developers may specify an existing field to put the title values into via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleField groupTitleField}. If no groupTitleField is specified, this
     * property may be set to <code>true</code> which causes a <code>groupTitleColumn</code> to be automatically generated.
     * Each group header will show the group title in this column (records within the group will not show a value for this
     * column). The column appears in the leftmost position within the grid (unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true, in which case this column shows up
     * in the second-leftmost position), and by default will auto-fit to its data. <P> To customize this field, developers may
     * modify {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTitleColumnProperties groupTitleColumnProperties}
     *
     * @return Boolean
     */
    public Boolean getShowGroupTitleColumn()  {
        Boolean result = getAttributeAsBoolean("showGroupTitleColumn");
        return result == null ? true : result;
    }
    

    /**
     * Should we show the header for this ListGrid?
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Show or hide the ListGrid header.
     *
     * @param showHeader true to show the header, false to hide it.. Default value is true
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public void setShowHeader(Boolean showHeader) {
        setAttribute("showHeader", showHeader, true);
    }

    /**
     * Should we show the header for this ListGrid?
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public Boolean getShowHeader()  {
        Boolean result = getAttributeAsBoolean("showHeader");
        return result == null ? true : result;
    }
    

    /**
     * Whether to show a context menu on the header with standard items for showing and hiding fields.  Not supported for
     * {@link com.smartgwt.client.widgets.cube.CubeGrid}.
     *
     * @param showHeaderContextMenu  Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#displayHeaderContextMenu
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenuItems
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public void setShowHeaderContextMenu(Boolean showHeaderContextMenu)  throws IllegalStateException {
        setAttribute("showHeaderContextMenu", showHeaderContextMenu, false);
    }

    /**
     * Whether to show a context menu on the header with standard items for showing and hiding fields.  Not supported for
     * {@link com.smartgwt.client.widgets.cube.CubeGrid}.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#displayHeaderContextMenu
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHeaderContextMenuItems
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public Boolean getShowHeaderContextMenu()  {
        Boolean result = getAttributeAsBoolean("showHeaderContextMenu");
        return result == null ? true : result;
    }
    

    /**
     * If set to true and {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu showHeaderContextMenu} is
     * true, the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderMenuButton headerMenuButton} will be displayed when
     * the user rolls over the header buttons in this grid.  Not supported for {@link
     * com.smartgwt.client.widgets.cube.CubeGrid}.
     *
     * @param showHeaderMenuButton  Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setShowHeaderMenuButton(Boolean showHeaderMenuButton)  throws IllegalStateException {
        setAttribute("showHeaderMenuButton", showHeaderMenuButton, false);
    }

    /**
     * If set to true and {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu showHeaderContextMenu} is
     * true, the {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderMenuButton headerMenuButton} will be displayed when
     * the user rolls over the header buttons in this grid.  Not supported for {@link
     * com.smartgwt.client.widgets.cube.CubeGrid}.
     *
     * @return Boolean
     */
    public Boolean getShowHeaderMenuButton()  {
        Boolean result = getAttributeAsBoolean("showHeaderMenuButton");
        return result == null ? true : result;
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the FormulaBuilder or
     * SummaryBuilder.
     *
     * @param showHeaderSpanTitlesInFormulaBuilder  Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFormulaBuilderSpanTitleSeparator
     */
    public void setShowHeaderSpanTitlesInFormulaBuilder(Boolean showHeaderSpanTitlesInFormulaBuilder) {
        setAttribute("showHeaderSpanTitlesInFormulaBuilder", showHeaderSpanTitlesInFormulaBuilder, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the FormulaBuilder or
     * SummaryBuilder.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getFormulaBuilderSpanTitleSeparator
     */
    public Boolean getShowHeaderSpanTitlesInFormulaBuilder()  {
        Boolean result = getAttributeAsBoolean("showHeaderSpanTitlesInFormulaBuilder");
        return result == null ? true : result;
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the {@link
     * com.smartgwt.client.widgets.DataBoundComponent#editHilites hilite editor}.
     *
     * @param showHeaderSpanTitlesInHiliteEditor  Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#setHiliteEditorSpanTitleSeparator
     */
    public void setShowHeaderSpanTitlesInHiliteEditor(Boolean showHeaderSpanTitlesInHiliteEditor) {
        setAttribute("showHeaderSpanTitlesInHiliteEditor", showHeaderSpanTitlesInHiliteEditor, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the {@link
     * com.smartgwt.client.widgets.DataBoundComponent#editHilites hilite editor}.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getHiliteEditorSpanTitleSeparator
     */
    public Boolean getShowHeaderSpanTitlesInHiliteEditor()  {
        Boolean result = getAttributeAsBoolean("showHeaderSpanTitlesInHiliteEditor");
        return result == null ? true : result;
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the  multi-sort editor.
     *
     * @param showHeaderSpanTitlesInSortEditor  Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#setSortEditorSpanTitleSeparator
     */
    public void setShowHeaderSpanTitlesInSortEditor(Boolean showHeaderSpanTitlesInSortEditor) {
        setAttribute("showHeaderSpanTitlesInSortEditor", showHeaderSpanTitlesInSortEditor, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, should field
     * titles be prefixed with the titles of the headerSpans in which they are contained when using the  multi-sort editor.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getSortEditorSpanTitleSeparator
     */
    public Boolean getShowHeaderSpanTitlesInSortEditor()  {
        Boolean result = getAttributeAsBoolean("showHeaderSpanTitlesInSortEditor");
        return result == null ? true : result;
    }
    

    /**
     * Determines whether hiliting for any field in this grid is shown in a group summary. This setting affects all fields of
     * the grid. <P> To suppress hilites for a specific field see {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowHilitesInGroupSummary showHilitesInGroupSummary}. <P> Hiliting in
     * summary fields (columns) can be enabled by setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getIncludeHilitesInSummaryFields includeHiliteInSummaryField} to true.
     *
     * @param showHilitesInGroupSummary  Default value is true
     */
    public void setShowHilitesInGroupSummary(boolean showHilitesInGroupSummary) {
        setAttribute("showHilitesInGroupSummary", showHilitesInGroupSummary, true);
    }

    /**
     * Determines whether hiliting for any field in this grid is shown in a group summary. This setting affects all fields of
     * the grid. <P> To suppress hilites for a specific field see {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowHilitesInGroupSummary showHilitesInGroupSummary}. <P> Hiliting in
     * summary fields (columns) can be enabled by setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getIncludeHilitesInSummaryFields includeHiliteInSummaryField} to true.
     *
     * @return boolean
     */
    public boolean getShowHilitesInGroupSummary()  {
        Boolean result = getAttributeAsBoolean("showHilitesInGroupSummary");
        return result == null ? true : result;
    }
    

    /**
     * If true, and canHover is also true, when the user hovers over a cell, hover text will pop up next to the mouse.  The
     * contents of the hover is determined by {@link com.smartgwt.client.widgets.grid.ListGrid#cellHoverHTML
     * ListGrid.cellHoverHTML()}.
     *
     * @param showHover  Default value is true
     * @see com.smartgwt.client.widgets.grid.ListGrid#setCanHover
     * @see com.smartgwt.client.widgets.grid.ListGrid#cellHoverHTML
     */
    public void setShowHover(Boolean showHover) {
        setAttribute("showHover", showHover, true);
    }

    /**
     * If true, and canHover is also true, when the user hovers over a cell, hover text will pop up next to the mouse.  The
     * contents of the hover is determined by {@link com.smartgwt.client.widgets.grid.ListGrid#cellHoverHTML
     * ListGrid.cellHoverHTML()}.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCanHover
     * @see com.smartgwt.client.widgets.grid.ListGrid#cellHoverHTML
     */
    public Boolean getShowHover()  {
        Boolean result = getAttributeAsBoolean("showHover");
        return result == null ? true : result;
    }
    

    /**
     * When set to true and canHover is also true, shows a widget hovering at the mouse point. <P> A number of builtin modes
     * are provided - see {@link com.smartgwt.client.types.HoverMode}.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showHoverComponents  Default value is false
     */
    public void setShowHoverComponents(Boolean showHoverComponents) {
        setAttribute("showHoverComponents", showHoverComponents, true);
    }

    /**
     * When set to true and canHover is also true, shows a widget hovering at the mouse point. <P> A number of builtin modes
     * are provided - see {@link com.smartgwt.client.types.HoverMode}.
     *
     * @return Boolean
     */
    public Boolean getShowHoverComponents()  {
        Boolean result = getAttributeAsBoolean("showHoverComponents");
        return result == null ? false : result;
    }
    

    /**
     * Should partially selected parents (in a Tree data set) be shown with special icon? This has an impact in grouped grids
     * where {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectGroups canSelectGroups} is true. The partial icon
     * will show up for the group header node when a group is partially selected.
     *
     * @param showPartialSelection  Default value is false
     */
    public void setShowPartialSelection(Boolean showPartialSelection) {
        setAttribute("showPartialSelection", showPartialSelection, true);
    }

    /**
     * Should partially selected parents (in a Tree data set) be shown with special icon? This has an impact in grouped grids
     * where {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectGroups canSelectGroups} is true. The partial icon
     * will show up for the group header node when a group is partially selected.
     *
     * @return Boolean
     */
    public Boolean getShowPartialSelection()  {
        Boolean result = getAttributeAsBoolean("showPartialSelection");
        return result == null ? false : result;
    }
    

    /**
     * When enabled, {@link com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent ListGrid.createRecordComponent()}
     * will be called when saved rows are being rendered, and any returned component will be displayed embedded within the row
     * or cell. <P> recordComponents are not created for newly added rows which have not yet been saved.   See the {@link
     * com.smartgwt.client.docs.UnsavedRecords Handling Unsaved Records overview} for more information. <p> Depending on the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell showRecordComponentsByCell} setting,
     * <code>createRecordComponent()</code> will be called either once per row, or once for every cell. <P> Depending on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPosition recordComponentPosition}, components can either be
     * placed underneath normal record or cell content ("expand" setting) or placed so that they overlap normal cell content
     * ("within" setting).  For the "within" setting, the default is to fill the row or cell, but the component can specify
     * percent size or even use {@link com.smartgwt.client.widgets.Canvas#getSnapTo snapTo-positioning} to place itself within
     * the row or cell. <p> The "expand" setting is incompatible with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields frozen columns} <i>unless</i> all
     * <code>recordComponents</code> are the same height and they are present in every row, in which case the fixed height of
     * all <code>recordComponents</code> can be set via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentHeight recordComponentHeight} to re-enable frozen fields.
     * <p> Using <code>recordComponents</code> potentially means creating one component for every visible grid row or cell and
     * so can impact performance.  Before using this subsystem: <ul> <li> consider using {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIcons valueIcons} (possibly with a specified       {@link
     * com.smartgwt.client.widgets.grid.ListGridField#addValueIconClickHandler ListGridField.valueIconClick()} handler) for
     * icons based on field values      which may be displayed alone in the cell or alongside standard content      (see {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowValueIconOnly showValueIconOnly}); <li> for clickable icons
     * representing actions that can be taken on a record, also       consider using {@link
     * com.smartgwt.client.types.ListGridFieldType a field of type "icon"}, or       multiple such fields <li> for controls
     * that only need to appear on rollover, consider      {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOverCanvas rollOver controls} <li> if you are trying to customize
     * the editor for a field, you can provide a custom      control via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getEditorType editorType}, and {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getIcons icons} are a common      way to add clickable buttons.  You
     * can also      {@link com.smartgwt.client.widgets.grid.ListGrid#getEditorType provide different controls per record}. 
     * These options are      usually better that using <code>recordComponents</code> as custom editors, since      you won't
     * have to manage issues like making the <code>recordComponent</code> appear      only when editing, having changes affect
     * {@link com.smartgwt.client.docs.Editing editValues},      triggering saves and handling validation errors, etc. </ul>
     * <P> See {@link com.smartgwt.client.types.RecordComponentPoolingMode} for an overview of how best to optimize use of
     * <code>recordComponents</code> for different data sets. <p> Regardless of the pooling mode, you can explicitly refresh
     * record components via {@link com.smartgwt.client.widgets.grid.ListGrid#invalidateRecordComponents
     * ListGrid.invalidateRecordComponents()} and {@link com.smartgwt.client.widgets.grid.ListGrid#refreshRecordComponent
     * ListGrid.refreshRecordComponent()}.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Setter for the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} attribute
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showRecordComponents new value for <code>this.showRecordComponents</code>. Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setRecordComponentPosition
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowRecordComponentsByCell
     * @see com.smartgwt.client.types.RecordComponentPoolingMode
     * @see com.smartgwt.client.widgets.grid.ListGrid#showRecordComponent
     * @see com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent
     * @see com.smartgwt.client.widgets.grid.ListGrid#updateRecordComponent
     */
    public void setShowRecordComponents(Boolean showRecordComponents) {
        setAttribute("showRecordComponents", showRecordComponents, true);
    }

    /**
     * When enabled, {@link com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent ListGrid.createRecordComponent()}
     * will be called when saved rows are being rendered, and any returned component will be displayed embedded within the row
     * or cell. <P> recordComponents are not created for newly added rows which have not yet been saved.   See the {@link
     * com.smartgwt.client.docs.UnsavedRecords Handling Unsaved Records overview} for more information. <p> Depending on the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell showRecordComponentsByCell} setting,
     * <code>createRecordComponent()</code> will be called either once per row, or once for every cell. <P> Depending on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPosition recordComponentPosition}, components can either be
     * placed underneath normal record or cell content ("expand" setting) or placed so that they overlap normal cell content
     * ("within" setting).  For the "within" setting, the default is to fill the row or cell, but the component can specify
     * percent size or even use {@link com.smartgwt.client.widgets.Canvas#getSnapTo snapTo-positioning} to place itself within
     * the row or cell. <p> The "expand" setting is incompatible with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields frozen columns} <i>unless</i> all
     * <code>recordComponents</code> are the same height and they are present in every row, in which case the fixed height of
     * all <code>recordComponents</code> can be set via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentHeight recordComponentHeight} to re-enable frozen fields.
     * <p> Using <code>recordComponents</code> potentially means creating one component for every visible grid row or cell and
     * so can impact performance.  Before using this subsystem: <ul> <li> consider using {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIcons valueIcons} (possibly with a specified       {@link
     * com.smartgwt.client.widgets.grid.ListGridField#addValueIconClickHandler ListGridField.valueIconClick()} handler) for
     * icons based on field values      which may be displayed alone in the cell or alongside standard content      (see {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowValueIconOnly showValueIconOnly}); <li> for clickable icons
     * representing actions that can be taken on a record, also       consider using {@link
     * com.smartgwt.client.types.ListGridFieldType a field of type "icon"}, or       multiple such fields <li> for controls
     * that only need to appear on rollover, consider      {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOverCanvas rollOver controls} <li> if you are trying to customize
     * the editor for a field, you can provide a custom      control via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getEditorType editorType}, and {@link
     * com.smartgwt.client.widgets.form.fields.FormItem#getIcons icons} are a common      way to add clickable buttons.  You
     * can also      {@link com.smartgwt.client.widgets.grid.ListGrid#getEditorType provide different controls per record}. 
     * These options are      usually better that using <code>recordComponents</code> as custom editors, since      you won't
     * have to manage issues like making the <code>recordComponent</code> appear      only when editing, having changes affect
     * {@link com.smartgwt.client.docs.Editing editValues},      triggering saves and handling validation errors, etc. </ul>
     * <P> See {@link com.smartgwt.client.types.RecordComponentPoolingMode} for an overview of how best to optimize use of
     * <code>recordComponents</code> for different data sets. <p> Regardless of the pooling mode, you can explicitly refresh
     * record components via {@link com.smartgwt.client.widgets.grid.ListGrid#invalidateRecordComponents
     * ListGrid.invalidateRecordComponents()} and {@link com.smartgwt.client.widgets.grid.ListGrid#refreshRecordComponent
     * ListGrid.refreshRecordComponent()}.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPosition
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell
     * @see com.smartgwt.client.types.RecordComponentPoolingMode
     * @see com.smartgwt.client.widgets.grid.ListGrid#showRecordComponent
     * @see com.smartgwt.client.widgets.grid.ListGrid#createRecordComponent
     * @see com.smartgwt.client.widgets.grid.ListGrid#updateRecordComponent
     */
    public Boolean getShowRecordComponents()  {
        return getAttributeAsBoolean("showRecordComponents");
    }
    

    /**
     * If true, shows {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents} in cells,
     * rather than just in records.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showRecordComponentsByCell  Default value is null
     */
    public void setShowRecordComponentsByCell(Boolean showRecordComponentsByCell) {
        if(showRecordComponentsByCell) setRecordComponentPosition(EmbeddedPosition.WITHIN);
        setAttribute("showRecordComponentsByCell", showRecordComponentsByCell, true);
    }

    /**
     * If true, shows {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents} in cells,
     * rather than just in records.
     *
     * @return Boolean
     */
    public Boolean getShowRecordComponentsByCell()  {
        return getAttributeAsBoolean("showRecordComponentsByCell");
    }
    

    /**
     * Should a different styling be shown for the cell that the mouse is over? By default, this is <code>true</code>, except
     * on touch devices ({@link com.smartgwt.client.util.Browser#isTouch isTouch} is <code>true</code>) for which the default
     * <code>showRollOver</code> setting is <code>false</code>. <p> If <code>true</code>, the cell style will have an "Over"
     * suffix.
     *
     * @param showRollOver  Default value is see below
     * @see com.smartgwt.client.widgets.grid.ListGrid#setBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setShowRollOver(Boolean showRollOver) {
        setAttribute("showRollOver", showRollOver, true);
    }

    /**
     * Should a different styling be shown for the cell that the mouse is over? By default, this is <code>true</code>, except
     * on touch devices ({@link com.smartgwt.client.util.Browser#isTouch isTouch} is <code>true</code>) for which the default
     * <code>showRollOver</code> setting is <code>false</code>. <p> If <code>true</code>, the cell style will have an "Over"
     * suffix.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public Boolean getShowRollOver()  {
        return getAttributeAsBoolean("showRollOver");
    }
    

    /**
     * When enabled, when the mouse moves over a row or cell (depending on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers useCellRollOvers}), an arbitrary Canvas can be shown
     * layered on top of the row or cell (the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas
     * rollOverCanvas}), layered underneath the row or cell (the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas rollUnderCanvas}), or both.  <P> This can be used to
     * dynamically show controls or informational displays only on rollover.  For example, controls to delete a row might
     * appear only on rollover so they do not clutter the static display, or a "rollunder" Canvas could be used to display
     * additional information that can appear behind normal cell values (like displaying percent complete via as a bar of color
     * that appears behind text values). <p> {@link com.smartgwt.client.widgets.Canvas#getSnapTo snapTo positioning} can be
     * used to place the rollOver/rollUnderCanvas.  With <code>useCellRollOvers</code>, positioning is relative to the cell,
     * for row-level rollOver, position is relative to the portion of the row that is scrolled into view (this implies a
     * row-level rollOver/UnderCanvas can never be placed horizontally scrolled out of view, but this is possible for a
     * cell-level rollOver).   <p> <code>snapTo</code> positioning makes it easy to do something like place a button at the
     * right edge of the grid, next to the scrollbar: just set snapTo:"R" on the <code>rollOverCanvas</code>. <p> The
     * rollOver/rollUnder Canvas can be a single static component (the same for all cells/rows) configured via the {@link
     * com.smartgwt.client.types.AutoChild} system, or can instead be provided dynamically by implementing {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas ListGrid.getRollOverCanvas()} and/or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas ListGrid.getRollUnderCanvas()}. <p> With row-level
     * rollOvers with {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, the 
     * <code>rollOverCanvas</code> and <code>rollUnderCanvas</code> appear only for non-frozen fields.  This is usually not an
     * issue for something like rollOver controls for row deletion, but will prevent certain scenarios of using
     * rollOverCanvas/rollUnderCanvas for visual styling. <p> <code>showRollOverCanvas</code> has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} is <code>false</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showRollOverCanvas  Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowRollUnderCanvas
     * 
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_rollover_controls" target="examples">RollOver Controls Example</a>
     */
    public void setShowRollOverCanvas(Boolean showRollOverCanvas) {
        setAttribute("showRollOverCanvas", showRollOverCanvas, true);
    }

    /**
     * When enabled, when the mouse moves over a row or cell (depending on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers useCellRollOvers}), an arbitrary Canvas can be shown
     * layered on top of the row or cell (the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas
     * rollOverCanvas}), layered underneath the row or cell (the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas rollUnderCanvas}), or both.  <P> This can be used to
     * dynamically show controls or informational displays only on rollover.  For example, controls to delete a row might
     * appear only on rollover so they do not clutter the static display, or a "rollunder" Canvas could be used to display
     * additional information that can appear behind normal cell values (like displaying percent complete via as a bar of color
     * that appears behind text values). <p> {@link com.smartgwt.client.widgets.Canvas#getSnapTo snapTo positioning} can be
     * used to place the rollOver/rollUnderCanvas.  With <code>useCellRollOvers</code>, positioning is relative to the cell,
     * for row-level rollOver, position is relative to the portion of the row that is scrolled into view (this implies a
     * row-level rollOver/UnderCanvas can never be placed horizontally scrolled out of view, but this is possible for a
     * cell-level rollOver).   <p> <code>snapTo</code> positioning makes it easy to do something like place a button at the
     * right edge of the grid, next to the scrollbar: just set snapTo:"R" on the <code>rollOverCanvas</code>. <p> The
     * rollOver/rollUnder Canvas can be a single static component (the same for all cells/rows) configured via the {@link
     * com.smartgwt.client.types.AutoChild} system, or can instead be provided dynamically by implementing {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas ListGrid.getRollOverCanvas()} and/or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas ListGrid.getRollUnderCanvas()}. <p> With row-level
     * rollOvers with {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, the 
     * <code>rollOverCanvas</code> and <code>rollUnderCanvas</code> appear only for non-frozen fields.  This is usually not an
     * issue for something like rollOver controls for row deletion, but will prevent certain scenarios of using
     * rollOverCanvas/rollUnderCanvas for visual styling. <p> <code>showRollOverCanvas</code> has no effect if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} is <code>false</code>.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowRollUnderCanvas
     * 
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_rollover_controls" target="examples">RollOver Controls Example</a>
     */
    public Boolean getShowRollOverCanvas()  {
        return getAttributeAsBoolean("showRollOverCanvas");
    }
    

    /**
     * If roll overs are enabled, should the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas
     * rollUnderCanvas} be displayed? <p> Use of the <code>showRollUnderCanvas</code> is enabled if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} is <code>true</code>, and either {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOverCanvas showRollOverCanvas} is <code>true</code> and
     * <code>showRollUnderCanvas</code> is unset, or <code>showRollUnderCanvas</code> is explicitly set to <code>true</code>.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showRollUnderCanvas  Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowRollOverCanvas
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public void setShowRollUnderCanvas(Boolean showRollUnderCanvas) {
        setAttribute("showRollUnderCanvas", showRollUnderCanvas, true);
    }

    /**
     * If roll overs are enabled, should the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas
     * rollUnderCanvas} be displayed? <p> Use of the <code>showRollUnderCanvas</code> is enabled if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOver showRollOver} is <code>true</code>, and either {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRollOverCanvas showRollOverCanvas} is <code>true</code> and
     * <code>showRollUnderCanvas</code> is unset, or <code>showRollUnderCanvas</code> is explicitly set to <code>true</code>.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowRollOverCanvas
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_animated_selection" target="examples">Animated Selection Example</a>
     */
    public Boolean getShowRollUnderCanvas()  {
        return getAttributeAsBoolean("showRollUnderCanvas");
    }
    

    /**
     * When set to true, shows an additional field at the beginning of the field-list (respecting RTL) that displays the
     * current rowNum for each record.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showRowNumbers  Default value is null
     */
    public void setShowRowNumbers(Boolean showRowNumbers) {
        setAttribute("showRowNumbers", showRowNumbers, true);
    }

    /**
     * When set to true, shows an additional field at the beginning of the field-list (respecting RTL) that displays the
     * current rowNum for each record.
     *
     * @return Boolean
     */
    public Boolean getShowRowNumbers()  {
        return getAttributeAsBoolean("showRowNumbers");
    }
    

    /**
     * Should the "Selected" style be applied to selected records?
     *
     * @param showSelectedStyle  Default value is true
     */
    public void setShowSelectedStyle(Boolean showSelectedStyle) {
        setAttribute("showSelectedStyle", showSelectedStyle, true);
    }

    /**
     * Should the "Selected" style be applied to selected records?
     *
     * @return Boolean
     */
    public Boolean getShowSelectedStyle()  {
        Boolean result = getAttributeAsBoolean("showSelectedStyle");
        return result == null ? true : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType} is set to  {@link
     * com.smartgwt.client.types.SelectionStyle#SINGLE}, setting this property to <code>true</code> means selection will be
     * displayed to the user with the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionCanvas selectionCanvas}
     * and/or {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionUnderCanvas selectionUnderCanvas} rather than with
     * CSS styling. <p> If <code>showSelectionCanvas</code> is set to <code>true</code>, then the
     * <code>selectionUnderCanvas</code> will automatically be enabled unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSelectionUnderCanvas showSelectionUnderCanvas} is set to
     * <code>false</code>. <p> NOTE: It is recommended to use the <code>selectionUnderCanvas</code> rather than the
     * <code>selectionCanvas</code> if possible because the <code>selectionCanvas</code> is stacked on top of the selected
     * record and this may interfere with event handling in rare cases. If no interactive components are shown in the
     * <code>selectionCanvas</code> and it simply provides custom styling, then the <code>selectionUnderCanvas</code> should be
     * used instead. <p> With {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields frozen fields}, the
     * <code>selectionCanvas</code> is displayed only over the non-frozen fields of the selected row.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showSelectionCanvas  Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowSelectionUnderCanvas
     */
    public void setShowSelectionCanvas(Boolean showSelectionCanvas) {
        setAttribute("showSelectionCanvas", showSelectionCanvas, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType} is set to  {@link
     * com.smartgwt.client.types.SelectionStyle#SINGLE}, setting this property to <code>true</code> means selection will be
     * displayed to the user with the {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionCanvas selectionCanvas}
     * and/or {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionUnderCanvas selectionUnderCanvas} rather than with
     * CSS styling. <p> If <code>showSelectionCanvas</code> is set to <code>true</code>, then the
     * <code>selectionUnderCanvas</code> will automatically be enabled unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSelectionUnderCanvas showSelectionUnderCanvas} is set to
     * <code>false</code>. <p> NOTE: It is recommended to use the <code>selectionUnderCanvas</code> rather than the
     * <code>selectionCanvas</code> if possible because the <code>selectionCanvas</code> is stacked on top of the selected
     * record and this may interfere with event handling in rare cases. If no interactive components are shown in the
     * <code>selectionCanvas</code> and it simply provides custom styling, then the <code>selectionUnderCanvas</code> should be
     * used instead. <p> With {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields frozen fields}, the
     * <code>selectionCanvas</code> is displayed only over the non-frozen fields of the selected row.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowSelectionUnderCanvas
     */
    public Boolean getShowSelectionCanvas()  {
        return getAttributeAsBoolean("showSelectionCanvas");
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType} is set to  {@link
     * com.smartgwt.client.types.SelectionStyle#SINGLE}, and either {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSelectionCanvas showSelectionCanvas} is <code>true</code> and
     * <code>showSelectionUnderCanvas</code> is unset, or <code>showSelectionUnderCanvas</code> is explicitly set to
     * <code>true</code>, then selection will be displayed to the user with the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionCanvas selectionCanvas} and/or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionUnderCanvas selectionUnderCanvas} rather than with CSS styling.
     * Setting <code>showSelectionUnderCanvas</code> to <code>false</code> will disable the use of the
     * <code>selectionUnderCanvas</code>. <p> With {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields frozen
     * fields}, the <code>selectionUnderCanvas</code> is displayed only behind the non-frozen fields of the selected row.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showSelectionUnderCanvas  Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGrid#setShowSelectionCanvas
     * 
     */
    public void setShowSelectionUnderCanvas(Boolean showSelectionUnderCanvas) {
        setAttribute("showSelectionUnderCanvas", showSelectionUnderCanvas, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType} is set to  {@link
     * com.smartgwt.client.types.SelectionStyle#SINGLE}, and either {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowSelectionCanvas showSelectionCanvas} is <code>true</code> and
     * <code>showSelectionUnderCanvas</code> is unset, or <code>showSelectionUnderCanvas</code> is explicitly set to
     * <code>true</code>, then selection will be displayed to the user with the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionCanvas selectionCanvas} and/or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionUnderCanvas selectionUnderCanvas} rather than with CSS styling.
     * Setting <code>showSelectionUnderCanvas</code> to <code>false</code> will disable the use of the
     * <code>selectionUnderCanvas</code>. <p> With {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields frozen
     * fields}, the <code>selectionUnderCanvas</code> is displayed only behind the non-frozen fields of the selected row.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowSelectionCanvas
     * 
     */
    public Boolean getShowSelectionUnderCanvas()  {
        return getAttributeAsBoolean("showSelectionUnderCanvas");
    }
    

    /**
     * Indicates whether a sorting arrow should appear for the listGrid, and its location. See {@link
     * com.smartgwt.client.types.SortArrow} for details. <P> Clicking the sort arrow reverses the direction of sorting for the
     * current sort column (if any), or sorts the listGrid by its first sortable column. The arrow image on the button
     * indicates the current direction of sorting. If undefined, the sort arrow will show up in the sorted field, and the
     * corner sort button will be displayed if a vertical scrollbar is being displayed
     *
     * @param showSortArrow  Default value is null
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setShowSortArrow(SortArrow showSortArrow) {
        setAttribute("showSortArrow", showSortArrow == null ? null : showSortArrow.getValue(), true);
    }

    /**
     * Indicates whether a sorting arrow should appear for the listGrid, and its location. See {@link
     * com.smartgwt.client.types.SortArrow} for details. <P> Clicking the sort arrow reverses the direction of sorting for the
     * current sort column (if any), or sorts the listGrid by its first sortable column. The arrow image on the button
     * indicates the current direction of sorting. If undefined, the sort arrow will show up in the sorted field, and the
     * corner sort button will be displayed if a vertical scrollbar is being displayed
     *
     * @return SortArrow
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public SortArrow getShowSortArrow()  {
        return EnumUtil.getEnum(SortArrow.values(), getAttribute("showSortArrow"));
    }
    

    /**
     * When multiple fields are sorted, set this to false to hide the sort-numeral displayed by default after the sort-arrows
     * in the header-buttons of sorted fields.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param showSortNumerals  Default value is null
     */
    public void setShowSortNumerals(Boolean showSortNumerals) {
        setAttribute("showSortNumerals", showSortNumerals, true);
    }

    /**
     * When multiple fields are sorted, set this to false to hide the sort-numeral displayed by default after the sort-arrows
     * in the header-buttons of sorted fields.
     *
     * @return Boolean
     */
    public Boolean getShowSortNumerals()  {
        return getAttributeAsBoolean("showSortNumerals");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans} are in use, whether to show a
     * hierarchical column picker that includes both headerSpans and normal headers, with normal headers indented under
     * headerSpans similarly to how a {@link com.smartgwt.client.widgets.tree.TreeGrid} displays a Tree. <P> If
     * <code>showTreeColumnPicker</code> is false, no column picker will be shown on the headerSpan itself, and the column
     * picker for a clicked on a normal field header will include only normal fields.
     *
     * @param showTreeColumnPicker  Default value is true
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setShowTreeColumnPicker(Boolean showTreeColumnPicker)  throws IllegalStateException {
        setAttribute("showTreeColumnPicker", showTreeColumnPicker, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans} are in use, whether to show a
     * hierarchical column picker that includes both headerSpans and normal headers, with normal headers indented under
     * headerSpans similarly to how a {@link com.smartgwt.client.widgets.tree.TreeGrid} displays a Tree. <P> If
     * <code>showTreeColumnPicker</code> is false, no column picker will be shown on the headerSpan itself, and the column
     * picker for a clicked on a normal field header will include only normal fields.
     *
     * @return Boolean
     */
    public Boolean getShowTreeColumnPicker()  {
        Boolean result = getAttributeAsBoolean("showTreeColumnPicker");
        return result == null ? true : result;
    }
    

    /**
     * If this list grid is showing any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen} fields, and a
     * horizontal scrollbar is visible at the bottom of the liquid columns, should an equivalent scrollbar gap be left visible
     * below the frozen columns?<br> Note that if set to <code>true</code> any backgroundColor or border applied to the
     * ListGrid will show up below the bottom row of the frozen column(s).
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param shrinkForFreeze  Default value is false
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public void setShrinkForFreeze(Boolean shrinkForFreeze) {
        setAttribute("shrinkForFreeze", shrinkForFreeze, true);
    }

    /**
     * If this list grid is showing any {@link com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen} fields, and a
     * horizontal scrollbar is visible at the bottom of the liquid columns, should an equivalent scrollbar gap be left visible
     * below the frozen columns?<br> Note that if set to <code>true</code> any backgroundColor or border applied to the
     * ListGrid will show up below the bottom row of the frozen column(s).
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public Boolean getShrinkForFreeze()  {
        Boolean result = getAttributeAsBoolean("shrinkForFreeze");
        return result == null ? false : result;
    }
    

    /**
     * If <code>record[this.singleCellValueProperty]</code> is set for some record, the record will be displayed as a single
     * cell spanning every column in the grid, with contents set to the value of
     * <code>record[this.singleCellValueProperty]</code>.
     *
     * @param singleCellValueProperty  Default value is "singleCellValue"
     */
    public void setSingleCellValueProperty(String singleCellValueProperty) {
        setAttribute("singleCellValueProperty", singleCellValueProperty, true);
    }

    /**
     * If <code>record[this.singleCellValueProperty]</code> is set for some record, the record will be displayed as a single
     * cell spanning every column in the grid, with contents set to the value of
     * <code>record[this.singleCellValueProperty]</code>.
     *
     * @return String
     */
    public String getSingleCellValueProperty()  {
        return getAttributeAsString("singleCellValueProperty");
    }
    

    /**
     * Where do 'skin' images (those provided with the class) live?
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param skinImgDir  Default value is "images/ListGrid/"
     * @see com.smartgwt.client.docs.Images Images overview and related methods
     */
    public void setSkinImgDir(String skinImgDir) {
        setAttribute("skinImgDir", skinImgDir, true);
    }

    /**
     * Where do 'skin' images (those provided with the class) live?
     *
     * @return String
     * @see com.smartgwt.client.docs.Images Images overview and related methods
     */
    public String getSkinImgDir()  {
        return getAttributeAsString("skinImgDir");
    }
    

    /**
     * Image to show when sorting ascending. See {@link com.smartgwt.client.widgets.ImgProperties} for format.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param sortAscendingImage  Default value is {...}
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setSortAscendingImage(ImgProperties sortAscendingImage) {
        setAttribute("sortAscendingImage", sortAscendingImage.getJsObj(), true);
    }

    /**
     * Image to show when sorting ascending. See {@link com.smartgwt.client.widgets.ImgProperties} for format.
     *
     * @return ImgProperties
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ImgProperties getSortAscendingImage()  {
        return new ImgProperties(getAttributeAsJavaScriptObject("sortAscendingImage"));
    }
    

    /**
     * If set, whenever grouping is performed by an end user or by a programmatic call to  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy ListGrid.groupBy()}, data is implicitly sorted by all of the grouped
     * columns, in the order  they were passed to groupBy. Any user-configured sorting is applied after sorting by  grouped
     * columns. <p> Sorting by grouped fields will be in ascending or descending order according to whether  the grid is
     * currently sorted (by any field) in ascending or descending order, defaulting  to ascending if the grid is not sorted.
     * Implicit sorting by group can be forced to be  always ascending or always descending by setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupSortDirection groupSortDirection}. <p> The sorting is "implicit" in
     * the sense that the sorting is not shown in the ListGrid  headers, and not shown in the MultiSortDialog if enabled.  An
     * end user cannot  currently remove the implicit sorting themselves (except by removing the grouping),  though it is
     * possible to override it by providing an expliit sort on the group's column. Clicking on the grouped field's header
     * reveals the usual sort indicators with all the same semantics. <p> The correct way to remove implicit sorting
     * programmatically is to call  {@link com.smartgwt.client.widgets.grid.ListGrid#setSortByGroupFirst
     * setSortByGroupFirst(false)}. <p> Programmatic calls to {@link com.smartgwt.client.widgets.grid.ListGrid#getSort
     * ListGrid.getSort()} will not include the implicit sort in  the list of return sort specifiers, and calls to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSort ListGrid.setSort()} will implicitly add  the sorting by grouped
     * columns before the specified sort. <p> Note that directly calling ResultSet.getSort() will include the implicit sort 
     * information.
     *
     * @param sortByGroupFirst  Default value is null
     */
    public void setSortByGroupFirst(Boolean sortByGroupFirst) {
        setAttribute("sortByGroupFirst", sortByGroupFirst, true);
    }

    /**
     * If set, whenever grouping is performed by an end user or by a programmatic call to  {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy ListGrid.groupBy()}, data is implicitly sorted by all of the grouped
     * columns, in the order  they were passed to groupBy. Any user-configured sorting is applied after sorting by  grouped
     * columns. <p> Sorting by grouped fields will be in ascending or descending order according to whether  the grid is
     * currently sorted (by any field) in ascending or descending order, defaulting  to ascending if the grid is not sorted.
     * Implicit sorting by group can be forced to be  always ascending or always descending by setting {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupSortDirection groupSortDirection}. <p> The sorting is "implicit" in
     * the sense that the sorting is not shown in the ListGrid  headers, and not shown in the MultiSortDialog if enabled.  An
     * end user cannot  currently remove the implicit sorting themselves (except by removing the grouping),  though it is
     * possible to override it by providing an expliit sort on the group's column. Clicking on the grouped field's header
     * reveals the usual sort indicators with all the same semantics. <p> The correct way to remove implicit sorting
     * programmatically is to call  {@link com.smartgwt.client.widgets.grid.ListGrid#setSortByGroupFirst
     * setSortByGroupFirst(false)}. <p> Programmatic calls to {@link com.smartgwt.client.widgets.grid.ListGrid#getSort
     * ListGrid.getSort()} will not include the implicit sort in  the list of return sort specifiers, and calls to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSort ListGrid.setSort()} will implicitly add  the sorting by grouped
     * columns before the specified sort. <p> Note that directly calling ResultSet.getSort() will include the implicit sort 
     * information.
     *
     * @return Boolean
     */
    public Boolean getSortByGroupFirst()  {
        return getAttributeAsBoolean("sortByGroupFirst");
    }
    

    /**
     * Image to show when sorting descending. See {@link com.smartgwt.client.widgets.ImgProperties} for format.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param sortDescendingImage  Default value is {...}
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setSortDescendingImage(ImgProperties sortDescendingImage) {
        setAttribute("sortDescendingImage", sortDescendingImage.getJsObj(), true);
    }

    /**
     * Image to show when sorting descending. See {@link com.smartgwt.client.widgets.ImgProperties} for format.
     *
     * @return ImgProperties
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public ImgProperties getSortDescendingImage()  {
        return new ImgProperties(getAttributeAsJavaScriptObject("sortDescendingImage"));
    }
    

    /**
     * Sorting direction of this ListGrid. If specified when the ListGrid is initialized, this property will be the default
     * sorting direction for the {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField sortField}. May be overridden by
     * specifying {@link com.smartgwt.client.widgets.grid.ListGridField#getSortDirection sortDirection}. <P> After
     * initialization, this property will be updated on {@link com.smartgwt.client.widgets.grid.ListGrid#sort ListGrid.sort()}
     * or {@link com.smartgwt.client.widgets.grid.ListGrid#setSort ListGrid.setSort()} to reflect the current sort direction of
     * the grid. When this grid is sorted by multiple fields, the grid's sortDirection reflects the sort direction of the
     * primary sort field.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Sort this grid's data, with the option to explicitly specify a single field to sort by and sort direction. <P> If sortField is not provided and listGrid.sortField is undefined, the data will be sorted by the first sortable column according to {@link com.smartgwt.client.widgets.grid.ListGridField#getSortDirection sortDirection} if specified, or {@link com.smartgwt.client.widgets.grid.ListGrid#getSortDirection sortDirection}. <P> ListGrids also support multiple-field sorting. See {@link com.smartgwt.client.widgets.grid.ListGrid#setSort ListGrid.setSort()} for details.
     *
     * @param sortDirection the field name or column number to sort by. Default value is "ascending"
     * @see com.smartgwt.client.types.SortDirection
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sort_sort" target="examples">Sort Example</a>
     */
    public void setSortDirection(SortDirection sortDirection) {
        setAttribute("sortDirection", sortDirection == null ? null : sortDirection.getValue(), true);
    }

    /**
     * Sorting direction of this ListGrid. If specified when the ListGrid is initialized, this property will be the default
     * sorting direction for the {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField sortField}. May be overridden by
     * specifying {@link com.smartgwt.client.widgets.grid.ListGridField#getSortDirection sortDirection}. <P> After
     * initialization, this property will be updated on {@link com.smartgwt.client.widgets.grid.ListGrid#sort ListGrid.sort()}
     * or {@link com.smartgwt.client.widgets.grid.ListGrid#setSort ListGrid.setSort()} to reflect the current sort direction of
     * the grid. When this grid is sorted by multiple fields, the grid's sortDirection reflects the sort direction of the
     * primary sort field.
     *
     * @return SortDirection
     * @see com.smartgwt.client.types.SortDirection
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sort_sort" target="examples">Sort Example</a>
     */
    public SortDirection getSortDirection()  {
        return EnumUtil.getEnum(SortDirection.values(), getAttribute("sortDirection"));
    }
    

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInSortEditor showHeaderSpanTitlesInSortEditor} is true,
     * this string will be inserted between the headerSpan title(s) and the field title in the field chooser grid on the 
     * multi-sort editor
     *
     * @param sortEditorSpanTitleSeparator  Default value is " - "
     */
    public void setSortEditorSpanTitleSeparator(String sortEditorSpanTitleSeparator) {
        setAttribute("sortEditorSpanTitleSeparator", sortEditorSpanTitleSeparator, true);
    }

    /**
     * If this grid has specified {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderSpanTitlesInSortEditor showHeaderSpanTitlesInSortEditor} is true,
     * this string will be inserted between the headerSpan title(s) and the field title in the field chooser grid on the 
     * multi-sort editor
     *
     * @return String
     */
    public String getSortEditorSpanTitleSeparator()  {
        return getAttributeAsString("sortEditorSpanTitleSeparator");
    }
    

    /**
     * The title for the corner sort button.  The title will only  ListGrid.changeDefaults() rather than replacing with an
     * entirely new object.
     *
     * @param sorterButtonTitle  Default value is "corner menu"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public void setSorterButtonTitle(String sorterButtonTitle)  throws IllegalStateException {
        setAttribute("sorterButtonTitle", sorterButtonTitle, false);
    }

    /**
     * The title for the corner sort button.  The title will only  ListGrid.changeDefaults() rather than replacing with an
     * entirely new object.
     *
     * @return String
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public String getSorterButtonTitle()  {
        return getAttributeAsString("sorterButtonTitle");
    }
    
    
    
    

    /**
     * Specifies the field by which this grid should be initially sorted. Can be set to either a {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getName field name} or the index of the field in the fields Array. <P>
     * ListGrids also support being initialized with multiple-field sort via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getInitialSort initialSort}. If initialSort is specified, it will be used in
     * preference to this property. <P> To sort the grid after it has been initialized, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#sort ListGrid.sort()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSort ListGrid.setSort()}. Details about the current sort of a live grid can
     * be retrieved by calling {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField ListGrid.getSortField()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSort ListGrid.getSort()}
     *
     * @param sortField  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sort_sort" target="examples">Sort Example</a>
     */
    public void setSortField(String sortField)  throws IllegalStateException {
        setAttribute("sortField", sortField, false);
    }

    /**
     * Specifies the field by which this grid should be initially sorted. Can be set to either a {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getName field name} or the index of the field in the fields Array. <P>
     * ListGrids also support being initialized with multiple-field sort via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getInitialSort initialSort}. If initialSort is specified, it will be used in
     * preference to this property. <P> To sort the grid after it has been initialized, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#sort ListGrid.sort()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSort ListGrid.setSort()}. Details about the current sort of a live grid can
     * be retrieved by calling {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField ListGrid.getSortField()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSort ListGrid.getSort()}
     *
     * @return Returns the current sort field for this grid. Note that if {@link com.smartgwt.client.widgets.grid.ListGrid#setSort
     * ListGrid.setSort()} has been used to sort by multiple fields, you can call {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSort ListGrid.getSort()} to retrieve details about the complete sort
     * applied to the grid.
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sort_sort" target="examples">Sort Example</a>
     */
    public String getSortField()  {
        return getAttributeAsString("sortField");
    }

    /**
     * Specifies the field by which this grid should be initially sorted. Can be set to either a {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getName field name} or the index of the field in the fields Array. <P>
     * ListGrids also support being initialized with multiple-field sort via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getInitialSort initialSort}. If initialSort is specified, it will be used in
     * preference to this property. <P> To sort the grid after it has been initialized, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#sort ListGrid.sort()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSort ListGrid.setSort()}. Details about the current sort of a live grid can
     * be retrieved by calling {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField ListGrid.getSortField()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSort ListGrid.getSort()}
     *
     * @param sortField  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_sort_sort" target="examples">Sort Example</a>
     */
    public void setSortField(Integer sortField)  throws IllegalStateException {
        setAttribute("sortField", sortField, false);
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to sort a field in ascending order.
     *
     * @param sortFieldAscendingText  Default value is "Sort Ascending"
     */
    public void setSortFieldAscendingText(String sortFieldAscendingText) {
        setAttribute("sortFieldAscendingText", sortFieldAscendingText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to sort a field in ascending order.
     *
     * @return String
     */
    public String getSortFieldAscendingText()  {
        return getAttributeAsString("sortFieldAscendingText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to sort a field in descending order.
     *
     * @param sortFieldDescendingText  Default value is "Sort Descending"
     */
    public void setSortFieldDescendingText(String sortFieldDescendingText) {
        setAttribute("sortFieldDescendingText", sortFieldDescendingText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, this attribute will be shown as the menu item title to sort a field in descending order.
     *
     * @return String
     */
    public String getSortFieldDescendingText()  {
        return getAttributeAsString("sortFieldDescendingText");
    }
    
    

    /**
     * When multiple fields are sorted, the Style to apply to the numeral that appears after the sort-arrows in the
     * header-buttons of sorted fields.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param sortNumeralStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is "sortNumeral"
     */
    public void setSortNumeralStyle(String sortNumeralStyle) {
        setAttribute("sortNumeralStyle", sortNumeralStyle, true);
    }

    /**
     * When multiple fields are sorted, the Style to apply to the numeral that appears after the sort-arrows in the
     * header-buttons of sorted fields.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     */
    public String getSortNumeralStyle()  {
        return getAttributeAsString("sortNumeralStyle");
    }
    

    /**
     * Initial sort state for the grid. <P> {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState viewState} can be
     * used to initialize all view properties of the grid. When doing so, <code>sortState</code> is not needed because
     * <code>viewState</code> includes it as well. If both are provided, <code>sortState</code> has priority for sort state.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Reset this grid's sort state (sort field and direction or list of {@link com.smartgwt.client.data.SortSpecifier}s) to match the {@link com.smartgwt.client.docs.ListGridSortState} object passed in.<br> Used to restore previous state retrieved from the grid by a call to {@link com.smartgwt.client.widgets.grid.ListGrid#getSortState ListGrid.getSortState()}.
     *
     * @param sortState Object describing the desired sort state for the grid. See {@link com.smartgwt.client.docs.ListGridSortState ListGridSortState} . Default value is null
     */
    public void setSortState(String sortState) {
        setAttribute("sortState", sortState, true);
    }

    /**
     * Initial sort state for the grid. <P> {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState viewState} can be
     * used to initialize all view properties of the grid. When doing so, <code>sortState</code> is not needed because
     * <code>viewState</code> includes it as well. If both are provided, <code>sortState</code> has priority for sort state.
     *
     * @return Returns a snapshot of the current sort state within this listGrid as a {@link
     * com.smartgwt.client.docs.ListGridSortState} object.<br> This object can be passed to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSortState ListGrid.setSortState()} to reset this grid's sort to the current
     * state (assuming the same fields are present in the grid).<br> See {@link com.smartgwt.client.docs.ListGridSortState ListGridSortState} 
     */
    public String getSortState()  {
        return getAttributeAsString("sortState");
    }
    

    /**
     * The menu displayed when a cell is right clicked on.
     * <p>
     * For an overview of how to use and configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Layout
     * @throws IllegalStateException if this widget has not yet been rendered.
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public Layout getSpanContextMenu() throws IllegalStateException {
        errorIfNotCreated("spanContextMenu");
        return (Layout)Layout.getByJSObject(getAttributeAsJavaScriptObject("spanContextMenu"));
    }
    

    /**
     * If this is an editable listGrid, this property determines how failure to save due to validation errors should be
     * displayed to the user. <P> If this property is true, when validation errors occur the errors will be displayed to the
     * user in an alert, and focus will be returned to the first cell to fail validation. <P> If false, the cells that failed
     * validation will be silently styled with the editFailedBaseStyle. <p> <b>Note:</b> stopOnErrors being set to true implies
     * that 'waitForSave' is also true. We will not dismiss the editor until save has completed if stopOnErrors is true.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param stopOnErrors  Default value is false
     * @see com.smartgwt.client.widgets.grid.ListGrid#setWaitForSave
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setStopOnErrors(Boolean stopOnErrors) {
        setAttribute("stopOnErrors", stopOnErrors, true);
    }

    /**
     * If this is an editable listGrid, this property determines how failure to save due to validation errors should be
     * displayed to the user. <P> If this property is true, when validation errors occur the errors will be displayed to the
     * user in an alert, and focus will be returned to the first cell to fail validation. <P> If false, the cells that failed
     * validation will be silently styled with the editFailedBaseStyle. <p> <b>Note:</b> stopOnErrors being set to true implies
     * that 'waitForSave' is also true. We will not dismiss the editor until save has completed if stopOnErrors is true.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getWaitForSave
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getStopOnErrors()  {
        Boolean result = getAttributeAsBoolean("stopOnErrors");
        return result == null ? false : result;
    }
    

    /**
     * Default CSS class for the ListGrid as a whole.
     *
     * @param styleName  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is "listGrid"
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public void setStyleName(String styleName) {
        setAttribute("styleName", styleName, true);
    }

    /**
     * Default CSS class for the ListGrid as a whole.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public String getStyleName()  {
        return getAttributeAsString("styleName");
    }
    

    /**
     * Automatically generated ListGrid for displaying grid summary information (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary}). <P> This component is an {@link
     * com.smartgwt.client.types.AutoChild} and as such may be customized via <code>listGrid.summaryRowProperties</code> and
     * <code>listGrid.summaryRowDefaults</code>
     * <p>
     * For an overview of how to use and configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return ListGrid
     * @throws IllegalStateException if this widget has not yet been rendered.
     */
    public ListGrid getSummaryRow() throws IllegalStateException {
        errorIfNotCreated("summaryRow");
        return (ListGrid)ListGrid.getByJSObject(getAttributeAsJavaScriptObject("summaryRow"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, and a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowDataSource summaryRowDataSource} is specified this property may
     * be used to specify fetch criteria to apply when retrieving summary data to show in the summary row. If unset, and any
     * filter criteria have been specified for the grid, they will be used.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param summaryRowCriteria  Default value is null
     */
    public void setSummaryRowCriteria(Criteria summaryRowCriteria) {
        setAttribute("summaryRowCriteria", summaryRowCriteria.getJsObj(), true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, and a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowDataSource summaryRowDataSource} is specified this property may
     * be used to specify fetch criteria to apply when retrieving summary data to show in the summary row. If unset, and any
     * filter criteria have been specified for the grid, they will be used.
     *
     * @return Criteria
     */
    public Criteria getSummaryRowCriteria()  {
        return new Criteria(getAttributeAsJavaScriptObject("summaryRowCriteria"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, by default summary
     * values are calculated on the client based on the current data-set for the grid (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGridSummary ListGrid.getGridSummary()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGridSummaryFunction ListGrid.getGridSummaryFunction()}). <P> In some cases
     * however it may make sense to calculate summary values on the server and retrieve them via a dataSource fetch. If set,
     * this property specifies a dataSource to fetch against for the summary row. The dataSource should return a single record
     * with summary data for each field for which summary data should be shown. Note that specifying this property completely
     * bypasses the standard client-side grid summary calculation logic. <P> The fetch may be further customized via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowCriteria summaryRowCriteria} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowFetchRequestProperties summaryRowFetchRequestProperties}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param summaryRowDataSource  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setSummaryRowDataSource(DataSource summaryRowDataSource)  throws IllegalStateException {
        setAttribute("summaryRowDataSource", summaryRowDataSource == null ? null : summaryRowDataSource.getOrCreateJsObj(), false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, by default summary
     * values are calculated on the client based on the current data-set for the grid (see {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGridSummary ListGrid.getGridSummary()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGridSummaryFunction ListGrid.getGridSummaryFunction()}). <P> In some cases
     * however it may make sense to calculate summary values on the server and retrieve them via a dataSource fetch. If set,
     * this property specifies a dataSource to fetch against for the summary row. The dataSource should return a single record
     * with summary data for each field for which summary data should be shown. Note that specifying this property completely
     * bypasses the standard client-side grid summary calculation logic. <P> The fetch may be further customized via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowCriteria summaryRowCriteria} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowFetchRequestProperties summaryRowFetchRequestProperties}
     *
     * @return DataSource
     */
    public DataSource getSummaryRowDataSource()  {
        return DataSource.getOrCreateRef(getAttributeAsJavaScriptObject("summaryRowDataSource"));
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, and a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowDataSource summaryRowDataSource} is specified this property may
     * be used to customize the fetch request used when retrieving summary data to show in the summary row. An example use case
     * might be specifying a {@link com.smartgwt.client.data.DSRequest#getOperationId operationId} to perform a custom fetch
     * operation which retrieved only summary values based on criteria.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param summaryRowFetchRequestProperties  Default value is null
     */
    public void setSummaryRowFetchRequestProperties(DSRequest summaryRowFetchRequestProperties) {
        setAttribute("summaryRowFetchRequestProperties", summaryRowFetchRequestProperties.getJsObj(), true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true, and a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowDataSource summaryRowDataSource} is specified this property may
     * be used to customize the fetch request used when retrieving summary data to show in the summary row. An example use case
     * might be specifying a {@link com.smartgwt.client.data.DSRequest#getOperationId operationId} to perform a custom fetch
     * operation which retrieved only summary values based on criteria.
     *
     * @return DSRequest
     */
    public DSRequest getSummaryRowFetchRequestProperties()  {
        return new DSRequest(getAttributeAsJavaScriptObject("summaryRowFetchRequestProperties"));
    }
    

    /**
     * Default height for the {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summary row autoChild}. Note that
     * this height is a minumum - the summary row has {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData
     * autoFitData} set to "vertical" so if multiple rows are visible in the grid summary, the summaryRow component will expand
     * to accommodate them.
     *
     * @param summaryRowHeight  Default value is 20
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setSummaryRowHeight(int summaryRowHeight)  throws IllegalStateException {
        setAttribute("summaryRowHeight", summaryRowHeight, false);
    }

    /**
     * Default height for the {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summary row autoChild}. Note that
     * this height is a minumum - the summary row has {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitData
     * autoFitData} set to "vertical" so if multiple rows are visible in the grid summary, the summaryRow component will expand
     * to accommodate them.
     *
     * @return int
     */
    public int getSummaryRowHeight()  {
        return getAttributeAsInt("summaryRowHeight");
    }
    

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} for the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summaryRow}
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param summaryRowStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is "gridSummaryCell"
     */
    public void setSummaryRowStyle(String summaryRowStyle) {
        setAttribute("summaryRowStyle", summaryRowStyle, true);
    }

    /**
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} for the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow summaryRow}
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     */
    public String getSummaryRowStyle()  {
        return getAttributeAsString("summaryRowStyle");
    }
    

    /**
     * "Tall" baseStyle for this listGrid. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} is set to null. <P> If <code>baseStyle</code> is unset, this property will be used as a base cell style
     * unless the grid is showing fixed height rows with a specified cellHeight that matches {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNormalCellHeight normalCellHeight}, in which case {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle} will be used. Note that in Internet
     * Explorer if {@link com.smartgwt.client.widgets.grid.ListGrid#getFastCellUpdates fastCellUpdates} is true,
     * <code>tallBaseStyle</code> will also be used even if the cellHeight matches the specified <code>normalCellHeight</code>
     * for the grid. <P> See {@link com.smartgwt.client.widgets.grid.ListGrid#getCellStyleSuffixes cellStyleSuffixes} for
     * details on how stateful suffixes are combined with the base style to generate stateful cell styles.
     *
     * @param tallBaseStyle  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} . Default value is "cell"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     */
    public void setTallBaseStyle(String tallBaseStyle)  throws IllegalStateException {
        setAttribute("tallBaseStyle", tallBaseStyle, false);
    }

    /**
     * "Tall" baseStyle for this listGrid. Only applies if {@link com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * baseStyle} is set to null. <P> If <code>baseStyle</code> is unset, this property will be used as a base cell style
     * unless the grid is showing fixed height rows with a specified cellHeight that matches {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNormalCellHeight normalCellHeight}, in which case {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle} will be used. Note that in Internet
     * Explorer if {@link com.smartgwt.client.widgets.grid.ListGrid#getFastCellUpdates fastCellUpdates} is true,
     * <code>tallBaseStyle</code> will also be used even if the cellHeight matches the specified <code>normalCellHeight</code>
     * for the grid. <P> See {@link com.smartgwt.client.widgets.grid.ListGrid#getCellStyleSuffixes cellStyleSuffixes} for
     * details on how stateful suffixes are combined with the base style to generate stateful cell styles.
     *
     * @return  See {@link com.smartgwt.client.docs.CSSStyleName CSSStyleName} 
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     */
    public String getTallBaseStyle()  {
        return getAttributeAsString("tallBaseStyle");
    }
    
    
    

    /**
     * Default image to use for the dragTracker when things are dragged within or out of this list. See {@link
     * com.smartgwt.client.widgets.ImgProperties} for format.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param trackerImage  Default value is {...}
     * @see com.smartgwt.client.widgets.grid.ListGrid#setDragTrackerMode
     * @see com.smartgwt.client.widgets.grid.ListGrid#getDragTrackerIcon
     */
    public void setTrackerImage(ImgProperties trackerImage) {
        setAttribute("trackerImage", trackerImage.getJsObj(), true);
    }

    /**
     * Default image to use for the dragTracker when things are dragged within or out of this list. See {@link
     * com.smartgwt.client.widgets.ImgProperties} for format.
     *
     * @return ImgProperties
     * @see com.smartgwt.client.widgets.grid.ListGrid#getDragTrackerMode
     * @see com.smartgwt.client.widgets.grid.ListGrid#getDragTrackerIcon
     */
    public ImgProperties getTrackerImage()  {
        return new ImgProperties(getAttributeAsJavaScriptObject("trackerImage"));
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to unfreeze a currently frozen field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Unfreeze " + the field's summary title.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param unfreezeFieldText  See {@link com.smartgwt.client.docs.HTMLString HTMLString} . Default value is "Unfreeze ${title}"
     */
    public void setUnfreezeFieldText(String unfreezeFieldText) {
        setAttribute("unfreezeFieldText", unfreezeFieldText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to unfreeze a currently frozen field. <P> This is a dynamic string - text
     * within <code>&#36;{...}</code> will be evaluated as JS code when the message is displayed, with <code>title</code>
     * available as a variable containing the field title. <P> Default value returns "Unfreeze " + the field's summary title.
     *
     * @return  See {@link com.smartgwt.client.docs.HTMLString HTMLString} 
     */
    public String getUnfreezeFieldText()  {
        return getAttributeAsString("unfreezeFieldText");
    }
    

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getIsGrouped this.isGrouped} is true, this attribute will be
     * shown as the title for the menu item to ungroup the grid.
     *
     * @param ungroupText  Default value is "Ungroup"
     */
    public void setUngroupText(String ungroupText) {
        setAttribute("ungroupText", ungroupText, true);
    }

    /**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid, and {@link com.smartgwt.client.widgets.grid.ListGrid#getIsGrouped this.isGrouped} is true, this attribute will be
     * shown as the title for the menu item to ungroup the grid.
     *
     * @return String
     */
    public String getUngroupText()  {
        return getAttributeAsString("ungroupText");
    }
    

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, this icon will
     * be shown in the auto generated field fro removing records if the record has been marked as removed via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved ListGrid.markRecordRemoved()}. At this point, clicking on
     * the icon will unmark the record as removed.
     *
     * @param unremoveIcon  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} . Default value is "[SKIN]/actions/undo.png"
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setUnremoveIcon(String unremoveIcon)  throws IllegalStateException {
        setAttribute("unremoveIcon", unremoveIcon, false);
    }

    /**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is enabled, this icon will
     * be shown in the auto generated field fro removing records if the record has been marked as removed via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved ListGrid.markRecordRemoved()}. At this point, clicking on
     * the icon will unmark the record as removed.
     *
     * @return  See {@link com.smartgwt.client.docs.SCImgURL SCImgURL} 
     */
    public String getUnremoveIcon()  {
        return getAttributeAsString("unremoveIcon");
    }
    
    

    /**
     * If set to true, an advanced field picker based on the {@link com.smartgwt.client.widgets.FieldPicker} will be shown
     * instead of the column picker submenu if there are more fields in the grid than {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAdvancedFieldPickerThreshold advancedFieldPickerThreshold}. <P> When there
     * are large numbers of available fields, the FieldPicker-based interface is more usable for both defining visible fields
     * and defining field order.
     *
     * @param useAdvancedFieldPicker  Default value is false
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setUseAdvancedFieldPicker(Boolean useAdvancedFieldPicker)  throws IllegalStateException {
        setAttribute("useAdvancedFieldPicker", useAdvancedFieldPicker, false);
    }

    /**
     * If set to true, an advanced field picker based on the {@link com.smartgwt.client.widgets.FieldPicker} will be shown
     * instead of the column picker submenu if there are more fields in the grid than {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAdvancedFieldPickerThreshold advancedFieldPickerThreshold}. <P> When there
     * are large numbers of available fields, the FieldPicker-based interface is more usable for both defining visible fields
     * and defining field order.
     *
     * @return Boolean
     */
    public Boolean getUseAdvancedFieldPicker()  {
        Boolean result = getAttributeAsBoolean("useAdvancedFieldPicker");
        return result == null ? false : result;
    }
    
    

    /**
     * Are rollovers cell-level or row-level?
     *
     * @param useCellRollOvers  Default value is null
     */
    public void setUseCellRollOvers(Boolean useCellRollOvers) {
        setAttribute("useCellRollOvers", useCellRollOvers, true);
    }

    /**
     * Are rollovers cell-level or row-level?
     *
     * @return Boolean
     */
    public Boolean getUseCellRollOvers()  {
        return getAttributeAsBoolean("useCellRollOvers");
    }
    

    /**
     * Enables copy/paste shortcuts, provided {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells
     * canSelectCells} is true <p> The default setting of true means that the value of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} determines whether copy/paste shortcuts are
     * enabled.  Setting this property to false disables said shortcuts unconditionally. <p> Copying is done via copying to a
     * Smart GWT-wide "clipboard" - <b>not</b> the OS-level clipboard, which is innaccessible on some browsers - via the
     * methods {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectedCellData ListGrid.getSelectedCellData()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#applyCellData ListGrid.applyCellData()}.  To copy data to and from
     * applications outside of the browser, use the technique shown in the @see <a
     * href="http://www.smartclient.com/smartgwtee/showcase/#gridToExcel" target="examples">Grid to Excel</a> and @see <a
     * href="http://www.smartclient.com/smartgwtee/showcase/#excelToGrid" target="examples">Excel to Grid</a> samples. <p> The
     * following shortcuts are available: <p> CTRL + D: copy cell values from top row of selected cells down to all rows <p>
     * CTRL + R: copy cell values from left column of selected cells right to all columns <p> CTRL + C: copy selected cell
     * values into shared clipboard <p> CTRL + V: paste from shared clipboard into current selection
     *
     * @param useCopyPasteShortcuts  Default value is true
     */
    public void setUseCopyPasteShortcuts(Boolean useCopyPasteShortcuts) {
        setAttribute("useCopyPasteShortcuts", useCopyPasteShortcuts, true);
    }

    /**
     * Enables copy/paste shortcuts, provided {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells
     * canSelectCells} is true <p> The default setting of true means that the value of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} determines whether copy/paste shortcuts are
     * enabled.  Setting this property to false disables said shortcuts unconditionally. <p> Copying is done via copying to a
     * Smart GWT-wide "clipboard" - <b>not</b> the OS-level clipboard, which is innaccessible on some browsers - via the
     * methods {@link com.smartgwt.client.widgets.grid.ListGrid#getSelectedCellData ListGrid.getSelectedCellData()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#applyCellData ListGrid.applyCellData()}.  To copy data to and from
     * applications outside of the browser, use the technique shown in the @see <a
     * href="http://www.smartclient.com/smartgwtee/showcase/#gridToExcel" target="examples">Grid to Excel</a> and @see <a
     * href="http://www.smartclient.com/smartgwtee/showcase/#excelToGrid" target="examples">Excel to Grid</a> samples. <p> The
     * following shortcuts are available: <p> CTRL + D: copy cell values from top row of selected cells down to all rows <p>
     * CTRL + R: copy cell values from left column of selected cells right to all columns <p> CTRL + C: copy selected cell
     * values into shared clipboard <p> CTRL + V: paste from shared clipboard into current selection
     *
     * @return Boolean
     */
    public Boolean getUseCopyPasteShortcuts()  {
        Boolean result = getAttributeAsBoolean("useCopyPasteShortcuts");
        return result == null ? true : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} is specified, but this grid is bound to
     * a DataSource which includes remote field validators, by default edits will be saved synchronously and these validators
     * will not be executed.<br> Set this property to <code>true</code> to ensure these remote validators are called when
     * saving edits in saveLocally mode. Note that since these remote validators need to run on the server, saving with this
     * property set is asynchronous, even though the data that ultimately gets updated is already present on the client.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param useRemoteValidators  Default value is null
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public void setUseRemoteValidators(Boolean useRemoteValidators) {
        setAttribute("useRemoteValidators", useRemoteValidators, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally} is specified, but this grid is bound to
     * a DataSource which includes remote field validators, by default edits will be saved synchronously and these validators
     * will not be executed.<br> Set this property to <code>true</code> to ensure these remote validators are called when
     * saving edits in saveLocally mode. Note that since these remote validators need to run on the server, saving with this
     * property set is asynchronous, even though the data that ultimately gets updated is already present on the client.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Databinding Databinding overview and related methods
     */
    public Boolean getUseRemoteValidators()  {
        return getAttributeAsBoolean("useRemoteValidators");
    }
    

    /**
     * Enables various styling behaviors that potentially make sense when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan ListGrid.getRowSpan()} has been overriden to introduce spanning
     * cells, and spanning is largest on the left and smaller as cells go to the right.  Specifically: <ul> <li> computes
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles banded styling} based on the span of the     
     * cell in the left-most column <li> enables {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells cell-level
     * selection}, including      {@link com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers cell-level rollover}
     * styling <li> enables row-span-sensitive cell selection.  See also {@link com.smartgwt.client.types.RowSpanSelectionMode}
     * for available behaviors </ul> <P> Because this setting enables {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells}, it is incompatible with any APIs that
     * expect a record-oriented data model. <P> Because this setting only makes sense when row spanning decreases from the
     * first column to the last, it has unspecified behavior with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanReorderFields canReorderFields}.
     *
     * @param useRowSpanStyling  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setUseRowSpanStyling(Boolean useRowSpanStyling)  throws IllegalStateException {
        setAttribute("useRowSpanStyling", useRowSpanStyling, false);
    }

    /**
     * Enables various styling behaviors that potentially make sense when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan ListGrid.getRowSpan()} has been overriden to introduce spanning
     * cells, and spanning is largest on the left and smaller as cells go to the right.  Specifically: <ul> <li> computes
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getAlternateRecordStyles banded styling} based on the span of the     
     * cell in the left-most column <li> enables {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells cell-level
     * selection}, including      {@link com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers cell-level rollover}
     * styling <li> enables row-span-sensitive cell selection.  See also {@link com.smartgwt.client.types.RowSpanSelectionMode}
     * for available behaviors </ul> <P> Because this setting enables {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells}, it is incompatible with any APIs that
     * expect a record-oriented data model. <P> Because this setting only makes sense when row spanning decreases from the
     * first column to the last, it has unspecified behavior with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanReorderFields canReorderFields}.
     *
     * @return Boolean
     */
    public Boolean getUseRowSpanStyling()  {
        return getAttributeAsBoolean("useRowSpanStyling");
    }
    

    /**
     * Whether client-side validation checks should be performed when the user moves between cells in the current edit row.  If
     * unset, defaults to {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell editByCell}. <P> Note that validation
     * always occurs when a row is to be saved, so setting {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell
     * saveByCell}:true forces validation on cell transitions.  To completely disable automatic validation, set {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNeverValidate neverValidate}:true.
     *
     * @param validateByCell  Default value is null
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public void setValidateByCell(Boolean validateByCell) {
        setAttribute("validateByCell", validateByCell, true);
    }

    /**
     * Whether client-side validation checks should be performed when the user moves between cells in the current edit row.  If
     * unset, defaults to {@link com.smartgwt.client.widgets.grid.ListGrid#getEditByCell editByCell}. <P> Note that validation
     * always occurs when a row is to be saved, so setting {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveByCell
     * saveByCell}:true forces validation on cell transitions.  To completely disable automatic validation, set {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getNeverValidate neverValidate}:true.
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public Boolean getValidateByCell()  {
        return getAttributeAsBoolean("validateByCell");
    }
    

    /**
     * If true, validation will be performed on each edited cell when each editor's "change" handler is fired.
     *
     * @param validateOnChange  Default value is null
     * @see com.smartgwt.client.widgets.grid.ListGridField#setValidateOnChange
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public void setValidateOnChange(Boolean validateOnChange) {
        setAttribute("validateOnChange", validateOnChange, true);
    }

    /**
     * If true, validation will be performed on each edited cell when each editor's "change" handler is fired.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGridField#getValidateOnChange
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public Boolean getValidateOnChange()  {
        return getAttributeAsBoolean("validateOnChange");
    }
    

    /**
     * Height for value icons for this listGrid. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getValueIconSize
     * valueIconSize}. Can be overridden at the field level
     *
     * @param valueIconHeight  Default value is null
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setValueIconHeight(Integer valueIconHeight) {
        setAttribute("valueIconHeight", valueIconHeight, true);
    }

    /**
     * Height for value icons for this listGrid. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getValueIconSize
     * valueIconSize}. Can be overridden at the field level
     *
     * @return Integer
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public Integer getValueIconHeight()  {
        return getAttributeAsInt("valueIconHeight");
    }
    

    /**
     * How much padding should there be on the left of valueIcons by default Can be overridden at the field level
     *
     * @param valueIconLeftPadding  Default value is 2
     * @see com.smartgwt.client.widgets.grid.ListGridField#setValueIcons
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setValueIconLeftPadding(int valueIconLeftPadding) {
        setAttribute("valueIconLeftPadding", valueIconLeftPadding, true);
    }

    /**
     * How much padding should there be on the left of valueIcons by default Can be overridden at the field level
     *
     * @return int
     * @see com.smartgwt.client.widgets.grid.ListGridField#getValueIcons
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public int getValueIconLeftPadding()  {
        return getAttributeAsInt("valueIconLeftPadding");
    }
    

    /**
     * How much padding should there be on the right of valueIcons by default
     *
     * @param valueIconRightPadding  Default value is 2
     * @see com.smartgwt.client.widgets.grid.ListGridField#setValueIcons
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setValueIconRightPadding(int valueIconRightPadding) {
        setAttribute("valueIconRightPadding", valueIconRightPadding, true);
    }

    /**
     * How much padding should there be on the right of valueIcons by default
     *
     * @return int
     * @see com.smartgwt.client.widgets.grid.ListGridField#getValueIcons
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public int getValueIconRightPadding()  {
        return getAttributeAsInt("valueIconRightPadding");
    }
    

    /**
     * Default width and height of value icons for this ListGrid. Can be overridden at the listGrid level via explicit {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getValueIconWidth valueIconWidth} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getValueIconHeight valueIconHeight}, or at the field level via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIconSize valueIconSize}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIconWidth valueIconWidth} and {ListGridField.valueIconHeight}
     *
     * @param valueIconSize  Default value is 16
     * @see com.smartgwt.client.widgets.grid.ListGrid#setValueIconWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#setValueIconHeight
     * @see com.smartgwt.client.widgets.grid.ListGridField#setValueIconSize
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setValueIconSize(int valueIconSize) {
        setAttribute("valueIconSize", valueIconSize, true);
    }

    /**
     * Default width and height of value icons for this ListGrid. Can be overridden at the listGrid level via explicit {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getValueIconWidth valueIconWidth} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getValueIconHeight valueIconHeight}, or at the field level via {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIconSize valueIconSize}, {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIconWidth valueIconWidth} and {ListGridField.valueIconHeight}
     *
     * @return int
     * @see com.smartgwt.client.widgets.grid.ListGrid#getValueIconWidth
     * @see com.smartgwt.client.widgets.grid.ListGrid#getValueIconHeight
     * @see com.smartgwt.client.widgets.grid.ListGridField#getValueIconSize
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public int getValueIconSize()  {
        return getAttributeAsInt("valueIconSize");
    }
    

    /**
     * Width for value icons for this listGrid. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getValueIconSize
     * valueIconSize}. Can be overridden at the field level
     *
     * @param valueIconWidth  Default value is null
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public void setValueIconWidth(Integer valueIconWidth) {
        setAttribute("valueIconWidth", valueIconWidth, true);
    }

    /**
     * Width for value icons for this listGrid. Overrides {@link com.smartgwt.client.widgets.grid.ListGrid#getValueIconSize
     * valueIconSize}. Can be overridden at the field level
     *
     * @return Integer
     * @see com.smartgwt.client.docs.ImageColumns ImageColumns overview and related methods
     */
    public Integer getValueIconWidth()  {
        return getAttributeAsInt("valueIconWidth");
    }
    

    /**
     * Initial {@link com.smartgwt.client.docs.ListGridViewState view state} for the grid. <P> Since view state contains field
     * state it is not necessary to set {@link com.smartgwt.client.widgets.grid.ListGrid#getFieldState fieldState} when also
     * setting <code>viewState</code>. If both are provided, <code>fieldState</code> has priority for field state.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Reset this grid's view state to match the {@link com.smartgwt.client.docs.ListGridViewState} object passed in.<br> Used to restore previous state retrieved from the grid by a call to {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState ListGrid.getViewState()}.
     *
     * @param viewState Object describing the desired view state for the grid. Default value is null
     */
    public void setViewState(String viewState) {
        setAttribute("viewState", viewState, true);
    }

    /**
     * Initial {@link com.smartgwt.client.docs.ListGridViewState view state} for the grid. <P> Since view state contains field
     * state it is not necessary to set {@link com.smartgwt.client.widgets.grid.ListGrid#getFieldState fieldState} when also
     * setting <code>viewState</code>. If both are provided, <code>fieldState</code> has priority for field state.
     *
     * @return Returns a snapshot of the current view state of this ListGrid.<br> This includes the field, sort, hilite, group, and
     * selected state of the grid, returned  as a string representation of a {@link com.smartgwt.client.docs.ListGridViewState}
     * object.<br> This string can be passed to {@link com.smartgwt.client.widgets.grid.ListGrid#setViewState
     * ListGrid.setViewState()} to reset this grid's view state to the current state (assuming the same data / fields are
     * present in the grid).<br>
     */
    public String getViewState()  {
        return getAttributeAsString("viewState");
    }
    

    /**
     * When incremental rendering is switched on and there are variable record heights, the virtual scrolling mechanism manages
     * the differences in scroll height calculations due to the unknown sizes of un-rendered rows to make the scrollbar and
     * viewport appear correctly. <P> When the <code>virtualScrolling</code> system is active, the last scroll position scrolls
     * the last record to the top of the viewport, leaving blank space underneath. This is a necessary and unavoidable
     * consequence of mapping the position of the scrollbar thumb to an unknown amount of remaining space without being able to
     * know the total scrollable area in advance (since record heights vary). <P> virtualScrolling is switched on automatically
     * when {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights} is false and also when
     * using the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents subsystem}, as
     * recordComponents expand the rows that contain them. This flag should be manually enabled when calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addEmbeddedComponent ListGrid.addEmbeddedComponent()} if embedded components
     * can cause record sizes to expand beyond specified cellHeight. <P> virtualScrolling is also automatically enabled when
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true to handle the fact that
     * expanded rows may render at variable heights.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param virtualScrolling  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     * @see com.smartgwt.client.widgets.grid.ListGrid#setRecordComponentHeight
     */
    public void setVirtualScrolling(Boolean virtualScrolling)  throws IllegalStateException {
        setAttribute("virtualScrolling", virtualScrolling, false);
    }

    /**
     * When incremental rendering is switched on and there are variable record heights, the virtual scrolling mechanism manages
     * the differences in scroll height calculations due to the unknown sizes of un-rendered rows to make the scrollbar and
     * viewport appear correctly. <P> When the <code>virtualScrolling</code> system is active, the last scroll position scrolls
     * the last record to the top of the viewport, leaving blank space underneath. This is a necessary and unavoidable
     * consequence of mapping the position of the scrollbar thumb to an unknown amount of remaining space without being able to
     * know the total scrollable area in advance (since record heights vary). <P> virtualScrolling is switched on automatically
     * when {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights} is false and also when
     * using the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponents subsystem}, as
     * recordComponents expand the rows that contain them. This flag should be manually enabled when calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addEmbeddedComponent ListGrid.addEmbeddedComponent()} if embedded components
     * can cause record sizes to expand beyond specified cellHeight. <P> virtualScrolling is also automatically enabled when
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true to handle the fact that
     * expanded rows may render at variable heights.
     *
     * @return Boolean
     * @see com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentHeight
     */
    public Boolean getVirtualScrolling()  {
        return getAttributeAsBoolean("virtualScrolling");
    }
    

    /**
     * If this is an editable listGrid, this property determines whether the user will be able to dismiss the edit form, or
     * navigate to another cell while the save is in process (before the asynchronous server response returns).
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param waitForSave  Default value is false
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public void setWaitForSave(Boolean waitForSave) {
        setAttribute("waitForSave", waitForSave, true);
    }

    /**
     * If this is an editable listGrid, this property determines whether the user will be able to dismiss the edit form, or
     * navigate to another cell while the save is in process (before the asynchronous server response returns).
     *
     * @return Boolean
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public Boolean getWaitForSave()  {
        Boolean result = getAttributeAsBoolean("waitForSave");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is true, when the user clicks
     * the remove icon for some record, should we show a warning message (defined as {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemovalMessage warnOnRemovalMessage}) and allow the user to cancel
     * removal?
     *
     * @param warnOnRemoval  Default value is false
     */
    public void setWarnOnRemoval(Boolean warnOnRemoval) {
        setAttribute("warnOnRemoval", warnOnRemoval, true);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is true, when the user clicks
     * the remove icon for some record, should we show a warning message (defined as {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemovalMessage warnOnRemovalMessage}) and allow the user to cancel
     * removal?
     *
     * @return Boolean
     */
    public Boolean getWarnOnRemoval()  {
        Boolean result = getAttributeAsBoolean("warnOnRemoval");
        return result == null ? false : result;
    }
    

    /**
     * Warning message to show the user on a click on the 'remove' icon if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemoval warnOnRemoval} is true.
     *
     * @param warnOnRemovalMessage  Default value is "Are you sure you want to delete this record?"
     */
    public void setWarnOnRemovalMessage(String warnOnRemovalMessage) {
        setAttribute("warnOnRemovalMessage", warnOnRemovalMessage, true);
    }

    /**
     * Warning message to show the user on a click on the 'remove' icon if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemoval warnOnRemoval} is true.
     *
     * @return String
     */
    public String getWarnOnRemovalMessage()  {
        return getAttributeAsString("warnOnRemovalMessage");
    }
    

    /**
     * If a field has {@link com.smartgwt.client.widgets.grid.ListGridField#getDisplayField displayField} specified and has no
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource optionDataSource}, this field will display the
     * value from the <code>displayField</code> of each record by default (for more on this behavior see {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource optionDataSource}). <P> If such a field is editable,
     * changing the edit value for the field on some record, without updating the edit value for the associated display field
     * on the same record would mean the user would continue to see the unchanged display field value. Developers can resolve
     * this situation by programmatically setting an edit value for the display field as well as the data field, or avoid it by
     * specifying an optionDataSource and ensuring {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchDisplayMap
     * autoFetchDisplayMap} is true, or setting an explicit valueMap for the field. <P> By default, when the edit value on a
     * field with a specified displayField and no optionDataSource is set, we log a warning to notify the developer. This
     * warning may be disabled by setting <code>warnOnUnmappedValueFieldChange</code> to <code>false</code>. <P> Note: There
     * are actually a couple of cases in which the system will automatically derive a new display-field value and apply it to
     * the record: <ol><li>If the edit value was changed by a user actually editing the record (rather than a programmatic call
     * to setEditValue()), and the edit-item had a valueMap or optionDataSource set, we automatically pick up the display value
     * from that item and store it as an edit-value for the displayField of the record</li>     <li>If the listGrid has a
     * loaded record in its data set whose valueField value matches the edit value for the valueField, we automatically apply
     * the displayField value from that record as an edit value for the displayField on the newly edited record.</li></ol> In
     * either case, the display value for the record is updated automatically (and the warning would not be logged).
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param warnOnUnmappedValueFieldChange  Default value is true
     */
    public void setWarnOnUnmappedValueFieldChange(Boolean warnOnUnmappedValueFieldChange) {
        setAttribute("warnOnUnmappedValueFieldChange", warnOnUnmappedValueFieldChange, true);
    }

    /**
     * If a field has {@link com.smartgwt.client.widgets.grid.ListGridField#getDisplayField displayField} specified and has no
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource optionDataSource}, this field will display the
     * value from the <code>displayField</code> of each record by default (for more on this behavior see {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getOptionDataSource optionDataSource}). <P> If such a field is editable,
     * changing the edit value for the field on some record, without updating the edit value for the associated display field
     * on the same record would mean the user would continue to see the unchanged display field value. Developers can resolve
     * this situation by programmatically setting an edit value for the display field as well as the data field, or avoid it by
     * specifying an optionDataSource and ensuring {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchDisplayMap
     * autoFetchDisplayMap} is true, or setting an explicit valueMap for the field. <P> By default, when the edit value on a
     * field with a specified displayField and no optionDataSource is set, we log a warning to notify the developer. This
     * warning may be disabled by setting <code>warnOnUnmappedValueFieldChange</code> to <code>false</code>. <P> Note: There
     * are actually a couple of cases in which the system will automatically derive a new display-field value and apply it to
     * the record: <ol><li>If the edit value was changed by a user actually editing the record (rather than a programmatic call
     * to setEditValue()), and the edit-item had a valueMap or optionDataSource set, we automatically pick up the display value
     * from that item and store it as an edit-value for the displayField of the record</li>     <li>If the listGrid has a
     * loaded record in its data set whose valueField value matches the edit value for the valueField, we automatically apply
     * the displayField value from that record as an edit value for the displayField on the newly edited record.</li></ol> In
     * either case, the display value for the record is updated automatically (and the warning would not be logged).
     *
     * @return Boolean
     */
    public Boolean getWarnOnUnmappedValueFieldChange()  {
        Boolean result = getAttributeAsBoolean("warnOnUnmappedValueFieldChange");
        return result == null ? true : result;
    }
    

    /**
     * Should content within cells be allowed to wrap? <P> Even if content is allowed to wrap, if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights} is set, the content will be clipped
     * off at the cell boundary.  Either set a larger, fixed {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight
     * cellHeight} to reveal more content, or set {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights
     * fixedRecordHeights} to false to allow auto-sizing.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param wrapCells  Default value is false
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_values" target="examples">Cell Values Example</a>
     */
    public void setWrapCells(Boolean wrapCells) {
        setAttribute("wrapCells", wrapCells, true);
    }

    /**
     * Should content within cells be allowed to wrap? <P> Even if content is allowed to wrap, if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights} is set, the content will be clipped
     * off at the cell boundary.  Either set a larger, fixed {@link com.smartgwt.client.widgets.grid.ListGrid#getCellHeight
     * cellHeight} to reveal more content, or set {@link com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights
     * fixedRecordHeights} to false to allow auto-sizing.
     *
     * @return Boolean
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_autofit_values" target="examples">Cell Values Example</a>
     */
    public Boolean getWrapCells()  {
        Boolean result = getAttributeAsBoolean("wrapCells");
        return result == null ? false : result;
    }
    

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGridField#getWrap wrap} is not explicitly set, should fields wrap?
     *
     * @param wrapHeaderTitles  Default value is null
     * @throws IllegalStateException this property cannot be changed after the component has been created
     */
    public void setWrapHeaderTitles(Boolean wrapHeaderTitles)  throws IllegalStateException {
        setAttribute("wrapHeaderTitles", wrapHeaderTitles, false);
    }

    /**
     * If {@link com.smartgwt.client.widgets.grid.ListGridField#getWrap wrap} is not explicitly set, should fields wrap?
     *
     * @return Boolean
     */
    public Boolean getWrapHeaderTitles()  {
        return getAttributeAsBoolean("wrapHeaderTitles");
    }
    

    // ********************* Methods ***********************


	/**
     * Perform a DataSource "add" operation to add new records to this component's DataSource.
     * @param newRecord new record
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBoundComponentMethods overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_dataoperations_add" target="examples">Databound add Example</a>
     */
    public native void addData(Record newRecord) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.addData(newRecord.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;


    /**
     * @see ListGrid#addData
     */
    public void addData(Record newRecord, DSCallback callback){
        addData(newRecord, callback, null);
    }

	/**
     * Perform a DataSource "add" operation to add new records to this component's DataSource.
     * @param newRecord new record
     * @param callback method to call on operation completion
     * @param requestProperties additional properties to set on the DSRequest                                          that will be issued
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBoundComponentMethods overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_dataoperations_add" target="examples">Databound add Example</a>
     */
    public native void addData(Record newRecord, DSCallback callback, DSRequest requestProperties) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.addData(newRecord.@com.smartgwt.client.core.DataClass::getJsObj()(), 
			$entry( function(dsResponse, data, dsRequest) { 
				if(callback!=null) callback.@com.smartgwt.client.data.DSCallback::execute(Lcom/smartgwt/client/data/DSResponse;Ljava/lang/Object;Lcom/smartgwt/client/data/DSRequest;)(
					@com.smartgwt.client.data.DSResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsResponse), 
					data, 
					@com.smartgwt.client.data.DSRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsRequest)
				);
			}), requestProperties == null ? null : requestProperties.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;
	


	/**
     * Attaches the component to the provided record. If <code>position</code> is specified as <code>"within"</code> {@link
     * com.smartgwt.client.widgets.Canvas#getSnapTo snapTo} and {@link com.smartgwt.client.widgets.Canvas#getSnapOffsetLeft
     * snapOffsetLeft}, {@link com.smartgwt.client.widgets.Canvas#getSnapOffsetTop snapOffsetTop} may be set to specify where
     * the component will render within the cell or record. If unset, for components embedded within a record we will default
     * to embedding at the top/left coordinate, and for components embedded within a cell, we will respect the align / valign
     * properties for the cell in question. Any percentage sizing will be interpreted as percentage of row size. <P> Otherwise
     * it will appear to be embedded within the record, underneath the field values. <P> Embedded components become children of
     * the grid and will stay attached to a record through scrolling, sorting and other operations that cause records to shift
     * position. <P> If <code>position</code> is set to <code>"expand"</code>, embedded components may offer a resize
     * interface, eg, by setting {@link com.smartgwt.client.widgets.grid.ListGridField#getCanDragResize canDragResize}:true,
     * and the grid will react accordingly, growing or shrinking the record to match the embedded component's new extents. <P>
     * Embedded components can be explicitly removed with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeEmbeddedComponent ListGrid.removeEmbeddedComponent()}. <P> If a record
     * is removed from the dataset or is replaced in the dataset, for example, it is eliminated through filtering (removes
     * record) or is successfully edited in a databound grid (replaces record), the component is cleared but not logically
     * removed from the grid. It is the responsibility of code that sets up the embedded component to remove it if the record
     * is removed from the dataSet. <P> When embedding components will result in variable height records, you should switch on
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}.
     * @param component component to embed
     * @param record record to attach the component to
     */
    public native void addEmbeddedComponent(Canvas component, ListGridRecord record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.addEmbeddedComponent(component == null ? null : component.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()(), record.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;


    /**
     * @see ListGrid#addEmbeddedComponent
     */
    public void addEmbeddedComponent(Canvas component, ListGridRecord record, Integer rowNum){
        addEmbeddedComponent(component, record, rowNum, (Integer) null, null);
    }

    /**
     * @see ListGrid#addEmbeddedComponent
     */
    public void addEmbeddedComponent(Canvas component, ListGridRecord record, Integer rowNum, Integer colNum){
        addEmbeddedComponent(component, record, rowNum, colNum, null);
    }

	/**
     * Attaches the component to the provided record. If <code>position</code> is specified as <code>"within"</code> {@link
     * com.smartgwt.client.widgets.Canvas#getSnapTo snapTo} and {@link com.smartgwt.client.widgets.Canvas#getSnapOffsetLeft
     * snapOffsetLeft}, {@link com.smartgwt.client.widgets.Canvas#getSnapOffsetTop snapOffsetTop} may be set to specify where
     * the component will render within the cell or record. If unset, for components embedded within a record we will default
     * to embedding at the top/left coordinate, and for components embedded within a cell, we will respect the align / valign
     * properties for the cell in question. Any percentage sizing will be interpreted as percentage of row size. <P> Otherwise
     * it will appear to be embedded within the record, underneath the field values. <P> Embedded components become children of
     * the grid and will stay attached to a record through scrolling, sorting and other operations that cause records to shift
     * position. <P> If <code>position</code> is set to <code>"expand"</code>, embedded components may offer a resize
     * interface, eg, by setting {@link com.smartgwt.client.widgets.grid.ListGridField#getCanDragResize canDragResize}:true,
     * and the grid will react accordingly, growing or shrinking the record to match the embedded component's new extents. <P>
     * Embedded components can be explicitly removed with {@link
     * com.smartgwt.client.widgets.grid.ListGrid#removeEmbeddedComponent ListGrid.removeEmbeddedComponent()}. <P> If a record
     * is removed from the dataset or is replaced in the dataset, for example, it is eliminated through filtering (removes
     * record) or is successfully edited in a databound grid (replaces record), the component is cleared but not logically
     * removed from the grid. It is the responsibility of code that sets up the embedded component to remove it if the record
     * is removed from the dataSet. <P> When embedding components will result in variable height records, you should switch on
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}.
     * @param component component to embed
     * @param record record to attach the component to
     * @param rowNum rowNum of the record to attach the component to
     * @param colNum colNum in which to embed the component
     * @param position positioning with respect to the record or cell (Defaults to "expand").
     */
    public native void addEmbeddedComponent(Canvas component, ListGridRecord record, Integer rowNum, Integer colNum, EmbeddedPosition position) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.addEmbeddedComponent(component == null ? null : component.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()(), record.@com.smartgwt.client.core.DataClass::getJsObj()(), rowNum == null ? null : rowNum.@java.lang.Integer::intValue()(), colNum == null ? null : colNum.@java.lang.Integer::intValue()(), position == null ? null : position.@com.smartgwt.client.types.EmbeddedPosition::getValue()());
    }-*/;
	


	/**
     * Adds another {@link com.smartgwt.client.data.SortSpecifier} to this grid's sort configuration and resorts.
     * @param sortSpecifier A SortSpecifier object indicating an additional field    and direction to sort by
     */
    public native void addSort(SortSpecifier sortSpecifier) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.addSort(sortSpecifier.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;




	/**
     * Applies a set of Records containing coordinate-based data as returned by {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectedCellData ListGrid.getSelectedCellData()} and applies the data at
     * the current selection. <P> For consistency with Excel, given a record in the cellData, after the data value with the
     * most negative column index is found, the rest of the values in the record are applied contiguously to the right of it,
     * using the positional data for ordering only. <P> Will only modify cells in the grid which are editable, and changes will
     * be applied as editValues, exactly as though the user had typed the values in (see {@link
     * com.smartgwt.client.docs.Editing Grid Editing Overview}). <P> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#applyRecordData ListGrid.applyRecordData()}.
     * @param cellData list of Records as described above
     */
    public native void applyCellData(RecordList cellData) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.applyCellData(cellData == null ? null : cellData.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()());
    }-*/;




	/**
     * Applies a list of Records as changes to the current selection. <P> Values found in each of the passed records will be
     * applied to the same-named fields in the Records starting from the top-left of the current selection, in order. <P> Will
     * only modify cells in the grid which are editable, and changes will be applied as editValues, exactly as though the user
     * had typed the values in (see {@link com.smartgwt.client.docs.Editing Grid Editing Overview}). <P> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#applyCellData ListGrid.applyCellData()}.
     * @param recordData list of Records as described above
     */
    public native void applyRecordData(RecordList recordData) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.applyRecordData(recordData == null ? null : recordData.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()());
    }-*/;




	/**
     * Programmatically cause a field to auto-fit horizontally to it's contents or title. <P> Does not establish permanent
     * auto-fitting - use {@link com.smartgwt.client.widgets.grid.ListGrid#setAutoFitWidth ListGrid.setAutoFitWidth()} to do
     * so.
     * @param fieldName 
     *
     * @return new width in pixels
     */
    public native int autoFitField(String fieldName) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.autoFitField(fieldName);
        return ret;
    }-*/;


	/**
     * Perform a one-time horizontal auto-fit of the fields passed. Fields will be sized to match their contents or title (as
     * specified in {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach autoFitWidthApproach}) Does not
     * establish permanent auto-fitting - use {@link com.smartgwt.client.widgets.grid.ListGrid#setAutoFitWidth
     * ListGrid.setAutoFitWidth()} to do so.
     */
    public native void autoFitFields() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.autoFitFields();
    }-*/;

	/**
     * Perform a one-time horizontal auto-fit of the fields passed. Fields will be sized to match their contents or title (as
     * specified in {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitWidthApproach autoFitWidthApproach}) Does not
     * establish permanent auto-fitting - use {@link com.smartgwt.client.widgets.grid.ListGrid#setAutoFitWidth
     * ListGrid.setAutoFitWidth()} to do so.
     * @param fields Array of fields to auto fit. If this parameter  is not passed, autoFitting will occur on all visible fields.
     */
    public native void autoFitFields(ListGridField... fields) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.autoFitFields(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(fields));
    }-*/;
	
	/**
     * Cancel the current edit without saving.
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void cancelEditing() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.cancelEditing();
    }-*/;



	/**
     * Can this cell be edited?
     *  <P>
     *  The default implementation of <code>canEditCell()</code> respects the various property
     *  settings affecting editability:
     *  <ul><li>{@link com.smartgwt.client.widgets.grid.ListGridField#getCanEdit field.canEdit} can be set to disable editing
     *           for a field</li>
     * <li>If the grid is bound to a dataSource, the {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEditFieldAttribute
     * canEditFieldAttribute} value on the
     *          dataSource field may enable / disable editing</li>
     *  <li>a record with the {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordEditProperty recordEditProperty} set to
     *          false is not editable</li>
     *      <li>disabled records are not editable</li>
     *  </ul>
     *  You can override this method to control editability on a cell-by-cell basis.  For example,
     *  if you had a grid that allows editing of "orders", and you had a field "shipDate" that is
     *  normally editable, but should not be editable if the order is already "complete", you might
     *  implement <code>canEditCell()</code> as follows:
     *  <P>
     *  <pre>
     *    isc.ListGrid.create({
     *        ...
     *        canEditCell : function (rowNum, colNum) {
     *            var record = this.getRecord(rowNum),
     *                fieldName = this.getFieldName(colNum);
     *            if (fieldName == "shipDate" &&
     *                record.orderStatus == "complete")
     *            {
     *                return false;
     *            }
     *            // use default rules for all other fields
     *            return this.Super("canEditCell", arguments);
     *        }
     *    });
     *  </pre>
     *  <P>
     *  Notes on providing custom implementations:
     *  <ul>
     *  <li> In order to allow complete control over editing, <code>canEditCell()</code> is called
     *  very frequently.  If you see delays on row to row navigation, check that your implementation
     *  is efficient
     *  <li> If you change the editability of a cell on the fly, for example, during
     * {@link com.smartgwt.client.widgets.grid.ListGrid#addEditorExitHandler ListGrid.editorExit()} on another cell, call
     * refreshCell() to show or hide the editor
     *  <li> If this ListGrid allows new records to be created, <code>canEditCell()</code> may be
     *  called when there is no record available, in which case getRecord() will return null.  The
     * values input so far by the user are available via {@link com.smartgwt.client.widgets.grid.ListGrid#getEditValues
     * ListGrid.getEditValues()}.
     *  </ul>
     * 
     * 
     * @param rowNum row number for the cell
     * @param colNum column number of the cell
     *
     * @return Whether to allow editing this cell
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native boolean canEditCell(int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__canEditCell(rowNum, colNum);
        return ret;
    }-*/;




	/**
     * Indicates whether a given record or rowNum can be expanded.  The default implementation checks the value of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} and <code>record[{@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecordProperty canExpandRecordProperty}]</code>. <P> Override this
     * method for more specific control over individual record expansion. <P> <b>Note:</b> Rows with no underlying record in
     * the data array - for example newly added edit rows that have not yet been saved - cannot be expanded.
     * @param record record to work with
     * @param rowNum rowNum of the record to work with
     *
     * @return true if the record can be expanded
     */
    public native boolean canExpandRecord(ListGridRecord record, int rowNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__canExpandRecord(record.@com.smartgwt.client.core.DataClass::getJsObj()(), rowNum);
        if(ret == null || ret === undefined) { return false; }
        return ret;
    }-*/;




	/**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is set to <code>true</code> then,
     * whenever an end-user or programmatic cell-selection is attempted, this method is called for  each cell in the selection.
     * If it returns false, the cell will not be selected.
     * @param rowNum rowNum being selected
     * @param colNum colNum being selected
     *
     * @return return false to disallow selection
     */
    public native boolean canSelectCell(int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__canSelectCell(rowNum, colNum);
        return ret;
    }-*/;


    /**
     * Add a cellSaved handler.
     * <p>
     * Fires after user edits have been successfully saved to the server, only for cells where the value was actually modified.
     * <p> If you want immediate notification of a changes <b>before</b> changes has been saved to the server, implement {@link
     * com.smartgwt.client.widgets.grid.ListGridField#addChangeHandler field.change()} or {@link
     * com.smartgwt.client.widgets.grid.ListGridField#addChangedHandler field.changed()} instead. <P> You can alternatively use
     * {@link com.smartgwt.client.widgets.grid.ListGridField#cellChanged ListGridField.cellChanged()} to get notification only
     * of saved changes for a specific field.  If both a listGridField and the containing listGrid have a handler for this
     * event, only the handler defined on the field is called.
     *
     * @param handler the cellSaved handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellSavedHandler(com.smartgwt.client.widgets.grid.events.CellSavedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellSavedEvent.getType()) == 0) setupCellSavedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellSavedEvent.getType());
    }

    private native void setupCellSavedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellChanged = $entry(function(){
            var param = {"record" : arguments[0], "newValue" : arguments[1], "oldValue" : arguments[2], "rowNum" : arguments[3], "colNum" : arguments[4], "grid" : arguments[5]};
            var event = @com.smartgwt.client.widgets.grid.events.CellSavedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            if (hasDefaultHandler) this.Super("cellChanged", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellChanged"));
            obj.addProperties({cellChanged:  cellChanged              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellChanged"));
            obj.cellChanged =  cellChanged             ;
        }
   }-*/;
    /**
     * Add a cellClick handler.
     * <p>
     * Called when a cell receives a click event. <P> Note that returning false from this method will not prevent any specified
     * {@link com.smartgwt.client.widgets.grid.ListGrid#rowClick ListGrid.rowClick()} handler from firing.
     *
     * @param handler the cellClick handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellClickHandler(com.smartgwt.client.widgets.grid.events.CellClickHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellClickEvent.getType()) == 0) setupCellClickEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellClickEvent.getType());
    }

    private native void setupCellClickEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellClick = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellClickEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellClick"));
            obj.addProperties({cellClick: 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellClick", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellClick"));
            obj.cellClick = 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellClick", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
    /**
     * Add a cellContextClick handler.
     * <p>
     * Called when a cell receives a contextclick event.
     *
     * @param handler the cellContextClick handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellContextClickHandler(com.smartgwt.client.widgets.grid.events.CellContextClickHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellContextClickEvent.getType()) == 0) setupCellContextClickEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellContextClickEvent.getType());
    }

    private native void setupCellContextClickEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellContextClick = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellContextClickEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellContextClick"));
            obj.addProperties({cellContextClick: 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellContextClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellContextClick", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellContextClick"));
            obj.cellContextClick = 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellContextClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellContextClick", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
    /**
     * Add a cellDoubleClick handler.
     * <p>
     * Called when a cell receives a double click event.
     *
     * @param handler the cellDoubleClick handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellDoubleClickHandler(com.smartgwt.client.widgets.grid.events.CellDoubleClickHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellDoubleClickEvent.getType()) == 0) setupCellDoubleClickEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellDoubleClickEvent.getType());
    }

    private native void setupCellDoubleClickEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellDoubleClick = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellDoubleClickEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellDoubleClick"));
            obj.addProperties({cellDoubleClick: 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellDoubleClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellDoubleClick", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellDoubleClick"));
            obj.cellDoubleClick = 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellDoubleClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellDoubleClick", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;


	/**
     * If this listGrid can be edited, this method will return true if the cell passed in has been edited, but the edits have
     * not yet been saved to the ListGrid's data object.
     * @param rowNum index of row to check for changes
     * @param colNum index of the col to check for changes
     *
     * @return returns true if the cell has unsaved edits
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native Boolean cellHasChanges(int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.cellHasChanges(rowNum, colNum);
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;




	/**
     * Given a rowNum and a colNum or fieldName, determine whether we currently have stored validation errors for the
     * record/field in question.
     * @param rowNum index of row to check for validation errors
     * @param fieldID name of field, or index of column to check for validation                                      errors
     *
     * @return true if we have validation errors for the row/col in question
     * @see com.smartgwt.client.widgets.grid.ListGrid#hasErrors
     * @see com.smartgwt.client.widgets.grid.ListGrid#rowHasErrors
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public native Boolean cellHasErrors(int rowNum, String fieldID) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.cellHasErrors(rowNum, fieldID);
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;


    /**
     * Add a cellHover handler.
     * <p>
     * Called when the mouse hovers over a cell if this.canHover is true.   Returning false will suppress the hover text from
     * being shown if this.showHover is true.
     *
     * @param handler the cellHover handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellHoverHandler(com.smartgwt.client.widgets.grid.events.CellHoverHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellHoverEvent.getType()) == 0) setupCellHoverEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellHoverEvent.getType());
    }

    private native void setupCellHoverEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellHover = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellHoverEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellHover"));
            obj.addProperties({cellHover: 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellHover(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellHover", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellHover"));
            obj.cellHover = 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellHover(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellHover", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
    /**
     * Add a cellMouseDown handler.
     * <p>
     * Called when a cell receives a mousedown event.
     *
     * @param handler the cellMouseDown handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellMouseDownHandler(com.smartgwt.client.widgets.grid.events.CellMouseDownHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellMouseDownEvent.getType()) == 0) setupCellMouseDownEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellMouseDownEvent.getType());
    }

    private native void setupCellMouseDownEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellMouseDown = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellMouseDownEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellMouseDown"));
            obj.addProperties({cellMouseDown: 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellMouseDown(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellMouseDown", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellMouseDown"));
            obj.cellMouseDown = 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellMouseDown(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellMouseDown", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
    /**
     * Add a cellMouseUp handler.
     * <p>
     * Called when a cell receives a mouseup event.
     *
     * @param handler the cellMouseUp handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellMouseUpHandler(com.smartgwt.client.widgets.grid.events.CellMouseUpHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellMouseUpEvent.getType()) == 0) setupCellMouseUpEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellMouseUpEvent.getType());
    }

    private native void setupCellMouseUpEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellMouseUp = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellMouseUpEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellMouseUp"));
            obj.addProperties({cellMouseUp: 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellMouseUp(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellMouseUp", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellMouseUp"));
            obj.cellMouseUp = 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellMouseUp(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellMouseUp", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
    /**
     * Add a cellOut handler.
     * <p>
     * Called when the mouse pointer leaves a cell
     *
     * @param handler the cellOut handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellOutHandler(com.smartgwt.client.widgets.grid.events.CellOutHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellOutEvent.getType()) == 0) setupCellOutEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellOutEvent.getType());
    }

    private native void setupCellOutEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellOut = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellOutEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellOut"));
            obj.addProperties({cellOut: 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellOut(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellOut", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellOut"));
            obj.cellOut = 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellOut(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellOut", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
    /**
     * Add a cellOver handler.
     * <p>
     * Called when the mouse pointer enters a cell
     *
     * @param handler the cellOver handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellOverHandler(com.smartgwt.client.widgets.grid.events.CellOverHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellOverEvent.getType()) == 0) setupCellOverEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellOverEvent.getType());
    }

    private native void setupCellOverEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellOver = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellOverEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellOver"));
            obj.addProperties({cellOver: 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellOver(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellOver", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellOver"));
            obj.cellOver = 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellOver(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellOver", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
    /**
     * Add a cellSelectionChanged handler.
     * <p>
     * Called when (cell-based) selection changes within this grid.
     *
     * @param handler the cellSelectionChanged handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellSelectionChangedHandler(com.smartgwt.client.widgets.grid.events.CellSelectionChangedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellSelectionChangedEvent.getType()) == 0) setupCellSelectionChangedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellSelectionChangedEvent.getType());
    }

    private native void setupCellSelectionChangedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellSelectionChanged = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellSelectionChangedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellSelectionChanged"));
            obj.addProperties({cellSelectionChanged: 
                function () {
                    var param = {"cellList" : arguments[0]};
                    var ret = cellSelectionChanged(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellSelectionChanged", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellSelectionChanged"));
            obj.cellSelectionChanged = 
                function () {
                    var param = {"cellList" : arguments[0]};
                    var ret = cellSelectionChanged(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellSelectionChanged", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
    /**
     * Add a cellValueHover handler.
     * <p>
     * Optional stringMethod to fire when the user hovers over a cell and the value is clipped. If
     * this.showClippedValuesOnHover is true, the default behavior is to show a hover canvas containing the HTML returned by
     * cellValueHoverHTML(). Call {@link com.smartgwt.client.widgets.grid.events.CellValueHoverEvent#cancel()} from within
     * {@link com.smartgwt.client.widgets.grid.events.CellValueHoverHandler#onCellValueHover} to suppress this default
     * behavior.
     *
     * @param handler the cellValueHover handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addCellValueHoverHandler(com.smartgwt.client.widgets.grid.events.CellValueHoverHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.CellValueHoverEvent.getType()) == 0) setupCellValueHoverEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.CellValueHoverEvent.getType());
    }

    private native void setupCellValueHoverEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var cellValueHover = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.CellValueHoverEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("cellValueHover"));
            obj.addProperties({cellValueHover: 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellValueHover(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellValueHover", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("cellValueHover"));
            obj.cellValueHover = 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = cellValueHover(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("cellValueHover", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;


	/**
     * Returns the HTML that is displayed by the default cellValueHover handler. Return null or an empty string to cancel the
     * hover. <p>Use <code>setCellValueHoverFormatter()</code> to provide a custom implementation.
     * @param record cell record as returned by getCellRecord()
     * @param rowNum row number for the cell
     * @param colNum column number of the cell
     * @param defaultHTML the HTML that would have been displayed by default. See {@link com.smartgwt.client.docs.HTMLString HTMLString}
     *
     * @return HTML to be displayed in the hover. If null or an empty string, then the hover is canceled.
     * @see com.smartgwt.client.widgets.grid.events.CellValueHoverEvent
     */
    public native String cellValueHoverHTML(ListGridRecord record, int rowNum, int colNum, String defaultHTML) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.cellValueHoverHTML(record.@com.smartgwt.client.core.DataClass::getJsObj()(), rowNum, colNum, defaultHTML);
        return ret;
    }-*/;




	/**
     * Is the value in a given cell clipped?
     * @param rowNum row number of the cell
     * @param colNum column number of the cell
     *
     * @return null if there is no cell at the given row, column; otherwise, whether the value in the specified cell is clipped.
     * @see com.smartgwt.client.widgets.grid.events.CellValueHoverEvent
     */
    public native Boolean cellValueIsClipped(int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.cellValueIsClipped(rowNum, colNum);
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;




	/**
     * Chart the data in this listGrid as a multi-series chart. <P> Each row provides a series of data.  Each series of data is
     * labeled by a value from one column, called the <code>labelField</code>. <P> For example, cell values are sales figures,
     * and fields are "Product", "August", "September", "October".  In this case each row gives a series: sales figures for
     * each of 3 months.  The <code>labelField</code> in this case is the "Product" field, meaning each row represents sales
     * figures for each of 3 months for a particular product.  This dataset can be charted via any multi-series chart: stacked
     * or clustered bar or column chart, line chart with multiple lines, or area chart (stacked lines). <P> By default, all
     * visible fields other than the label field are assumed to be labels for series values, but an explicit list of fields can
     * be provided as <code>dataFields</code>. <P> By default, all data is charted if all data is loaded, otherwise, data
     * visible in the viewport is charted.  An explicit set of rows can be provided via <code>dataRows</code>.
     * @param labelField name of the field
     *
     * @return created Chart instance
     * @see <a href="http://www.smartclient.com/smartgwtee/showcase/#gridCharting" target="examples">Grid Charting Example</a>
     */
    public native FacetChart chartData(String labelField) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.chartData(labelField);
        return @com.smartgwt.client.widgets.chart.FacetChart::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;


    /**
     * @see ListGrid#chartData
     */
    public FacetChart chartData(String labelField, String[] dataFields){
        return chartData(labelField, dataFields, null, null, false);
    }

    /**
     * @see ListGrid#chartData
     */
    public FacetChart chartData(String labelField, String[] dataFields, ListGridRecord... dataRows){
        return chartData(labelField, dataFields, dataRows, null, false);
    }

    /**
     * @see ListGrid#chartData
     */
    public FacetChart chartData(String labelField, String[] dataFields, ListGridRecord[] dataRows, FacetChart chartProperties){
        return chartData(labelField, dataFields, dataRows, chartProperties, false);
    }

	/**
     * Chart the data in this listGrid as a multi-series chart. <P> Each row provides a series of data.  Each series of data is
     * labeled by a value from one column, called the <code>labelField</code>. <P> For example, cell values are sales figures,
     * and fields are "Product", "August", "September", "October".  In this case each row gives a series: sales figures for
     * each of 3 months.  The <code>labelField</code> in this case is the "Product" field, meaning each row represents sales
     * figures for each of 3 months for a particular product.  This dataset can be charted via any multi-series chart: stacked
     * or clustered bar or column chart, line chart with multiple lines, or area chart (stacked lines). <P> By default, all
     * visible fields other than the label field are assumed to be labels for series values, but an explicit list of fields can
     * be provided as <code>dataFields</code>. <P> By default, all data is charted if all data is loaded, otherwise, data
     * visible in the viewport is charted.  An explicit set of rows can be provided via <code>dataRows</code>.
     * @param labelField name of the field
     * @param dataFields optional list of fields to use as labels.  By      default, all fields are used.
     * @param dataRows set of records to chart.  Can be obtained by eg      {@link com.smartgwt.client.data.ResultSet#getRange
     * grid.data.getRange()}.
     * @param chartProperties properties to pass to the created chart
     * @param labelFieldFirst if true, use the labelField as the "first" set of labels,      for example, as the bar labels in a stacked bar chart,
     * whereas the second set of labels      would appear as the legend.
     *
     * @return created Chart instance
     * @see <a href="http://www.smartclient.com/smartgwtee/showcase/#gridCharting" target="examples">Grid Charting Example</a>
     */
    public native FacetChart chartData(String labelField, String[] dataFields, ListGridRecord[] dataRows, FacetChart chartProperties, boolean labelFieldFirst) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.chartData(labelField, @com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(dataFields), @com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(dataRows), chartProperties == null ? null : chartProperties.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), labelFieldFirst == null ? false : labelFieldFirst);
        return @com.smartgwt.client.widgets.chart.FacetChart::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;
	
	/**
     * Clear the current criteria used to filter data.
     * @see com.smartgwt.client.widgets.grid.ListGrid#fetchData
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBoundComponentMethods overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_dataoperations_filter" target="examples">Databound filter Example</a>
     */
    public native void clearCriteria() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.clearCriteria();
    }-*/;

    /**
     * @see ListGrid#clearCriteria
     */
    public void clearCriteria(DSCallback callback){
        clearCriteria(callback, null);
    }

	/**
     * Clear the current criteria used to filter data.
     * @param callback callback to invoke on completion
     * @param requestProperties additional properties to set on the DSRequest                                            that will be issued
     * @see com.smartgwt.client.widgets.grid.ListGrid#fetchData
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBoundComponentMethods overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_dataoperations_filter" target="examples">Databound filter Example</a>
     */
    public native void clearCriteria(DSCallback callback, DSRequest requestProperties) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.clearCriteria(
			$entry( function(dsResponse, data, dsRequest) { 
				if(callback!=null) callback.@com.smartgwt.client.data.DSCallback::execute(Lcom/smartgwt/client/data/DSResponse;Ljava/lang/Object;Lcom/smartgwt/client/data/DSRequest;)(
					@com.smartgwt.client.data.DSResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsResponse), 
					data, 
					@com.smartgwt.client.data.DSRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsRequest)
				);
			}), requestProperties == null ? null : requestProperties.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;
	


	/**
     * Clears any validation errors for some cell.
     * @param rowNum row index of cell to add validation error for
     * @param fieldName col index or field name of cell to add validation error for
     * @see com.smartgwt.client.widgets.grid.ListGrid#setFieldError
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public native void clearFieldError(int rowNum, int fieldName) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.clearFieldError(rowNum, fieldName);
    }-*/;




	/**
     * Clear any stored validation errors for some row
     * @param rowNum index of row to clear validation error for
     * @see com.smartgwt.client.widgets.grid.ListGrid#setRowErrors
     * @see com.smartgwt.client.docs.Validation Validation overview and related methods
     */
    public native void clearRowErrors(int rowNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.clearRowErrors(rowNum);
    }-*/;


	/**
     * This method clears any existing sort on this grid by calling {@link com.smartgwt.client.widgets.grid.ListGrid#setSort
     * ListGrid.setSort()} with a null parameter.  The internal list of {@link com.smartgwt.client.data.SortSpecifier}s is
     * removed and the grid is unsorted.
     */
    public native void clearSort() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.clearSort();
    }-*/;



	/**
     * Collapses a given {@link com.smartgwt.client.widgets.grid.ListGridRecord record} which has been previously expanded
     * using {@link com.smartgwt.client.widgets.grid.ListGrid#expandRecord ListGrid.expandRecord()}. <P> Depending on the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionComponentPoolingMode pooling mode}, this method may
     * automatically destroy expansionComponents.  By default, components created automatically by the ListGrid will be
     * auto-destroyed.  This behavior can be changed by setting a different pooling mode. <P> Note that components created via
     * an override to {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionComponent ListGrid.getExpansionComponent()}
     * will *not* be auto-destroyed - developers should override collapseRecord to take care of clean-up for such components.
     * @param record record to collapse
     */
    public native void collapseRecord(ListGridRecord record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.collapseRecord(record.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;




	/**
     * Collapses the passed list of expanded {@link com.smartgwt.client.widgets.grid.ListGridRecord records}.  Calls {@link
     * com.smartgwt.client.widgets.grid.ListGrid#collapseRecord collapseRecord} for each passed record, but only marks the grid
     * for redraw once, after all records have been collapsed.
     * @param records records to collapse
     */
    public native void collapseRecords(ListGridRecord... records) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.collapseRecords(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(records));
    }-*/;


	/**
     * Open a MultiGroupDialog to configure the fields used for grouping.
     */
    public native void configureGrouping() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.configureGrouping();
    }-*/;



	/**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} is true, this method
     * is called to create per-row or per-cell embedded components to display in the grid. <p> The colNum parameter is
     * applicable only when {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell
     * showRecordComponentsByCell} is true. <p> If this row should not have a <code>recordComponent</code>, return null. <p>
     * This method should create and return a new component for the record passed in every time it is called and never return
     * the same Canvas instance twice.  To re-use components with different rows, set {@link
     * com.smartgwt.client.types.RecordComponentPoolingMode} to "recycle".  In this mode, in addition to implementing this
     * method, developers should also implement {@link com.smartgwt.client.widgets.grid.ListGrid#updateRecordComponent
     * ListGrid.updateRecordComponent()} which allows already created components to be altered for re-use in new records. See
     * the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents showRecordComponents} overview for more
     * information.
     * @param record record to create a component for
     * @param colNum cell to which the component applies
     *
     * @return return the component to embed in the passed record
     */
    protected native Canvas createRecordComponent(ListGridRecord record, Integer colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__createRecordComponent(record.@com.smartgwt.client.core.DataClass::getJsObj()(), colNum == null ? null : colNum.@java.lang.Integer::intValue()());
        return @com.smartgwt.client.widgets.Canvas::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;


    /**
     * Add a dataArrived handler.
     * <p>
     * Notification method fired when new data arrives from the server to be displayed in this ListGrid, (for example in
     * response to the user scrolling a new set of rows into view). Only applies to databound listGrids where the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getData data} attribute is a {@link com.smartgwt.client.data.ResultSet}. This
     * ResultSet may have been created manually and applied to the grid via a call to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setData ListGrid.setData()} or may have been created and automatically
     * assigned if {@link com.smartgwt.client.widgets.grid.ListGrid#fetchData ListGrid.fetchData()} was used to populate the
     * grid.  This method is fired directly in response to {@link com.smartgwt.client.data.ResultSet#addDataArrivedHandler
     * dataArrived()} firing on the data object.
     *
     * @param handler the dataArrived handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addDataArrivedHandler(com.smartgwt.client.widgets.grid.events.DataArrivedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.DataArrivedEvent.getType()) == 0) setupDataArrivedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.DataArrivedEvent.getType());
    }

    private native void setupDataArrivedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var dataArrived = $entry(function(){
            var param = {"startRow" : arguments[0], "endRow" : arguments[1]};
            var event = @com.smartgwt.client.widgets.grid.events.DataArrivedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            if (hasDefaultHandler) this.Super("dataArrived", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("dataArrived"));
            obj.addProperties({dataArrived:  dataArrived              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("dataArrived"));
            obj.dataArrived =  dataArrived             ;
        }
   }-*/;


	/**
     * Deselect a contiguous range of records by index. <P> This is a synonym for <code>selectRange(startRow, endRow,
     * false);</code>
     * @param startRow start of selection range
     * @param endRow end of selection range (non-inclusive)
     */
    public native void deselectRange(int startRow, int endRow) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.deselectRange(startRow, endRow);
    }-*/;


	/**
     * Cancel outstanding edits, discarding edit values, and hiding editors for the record[s] passed in if appropriate. <P> If
     * no rows are passed in, all outstanding edit values will be dropped.  This will <b>not</b> automatically end editing;
     * call {@link com.smartgwt.client.widgets.grid.ListGrid#endEditing ListGrid.endEditing()} <b>before</b> calling
     * discardAllEdits() if you also want to end editing. <P> Note that this also clears the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved removed} state of any records that have been marked as
     * removed.
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void discardAllEdits() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.discardAllEdits();
    }-*/;

    /**
     * @see ListGrid#discardAllEdits
     */
    public void discardAllEdits(int[] rows){
        discardAllEdits(rows, false);
    }

	/**
     * Cancel outstanding edits, discarding edit values, and hiding editors for the record[s] passed in if appropriate. <P> If
     * no rows are passed in, all outstanding edit values will be dropped.  This will <b>not</b> automatically end editing;
     * call {@link com.smartgwt.client.widgets.grid.ListGrid#endEditing ListGrid.endEditing()} <b>before</b> calling
     * discardAllEdits() if you also want to end editing. <P> Note that this also clears the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved removed} state of any records that have been marked as
     * removed.
     * @param rows allows you to specify which row(s) to drop edits for
     * @param dontHideEditor By default this method will hide the editor if                              it is currently showing for any row in the
     * grid. Passing in                              this parameter will leave the editor visible (and just reset              
     *                the edit values underneath the editor).
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void discardAllEdits(int[] rows, boolean dontHideEditor) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.discardAllEdits(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([I)(rows), dontHideEditor == null ? false : dontHideEditor);
    }-*/;
	


	/**
     * Cancel outstanding edits for the specified rows, discarding edit values, and hiding editors if appropriate. <P> Note
     * that if this method is called on a new edit row (created via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#startEditingNew ListGrid.startEditingNew()} for example), which has not yet
     * been saved, this method will remove the row entirely. <P> Also note that this method will clear the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved removed} state of records that have been marked as removed.
     * @param rowNum Row to cancel
     * @param colNum Column to cancel. Note that this parameter is ignored in ListGrids but                        may be required in
     * subclasses of ListGrid where each cell represents                        one record in the data set (EG CubeGrid)
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void discardEdits(int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.discardEdits(rowNum, colNum);
    }-*/;


	/**
     * Cancel outstanding edits for the specified rows, discarding edit values, and hiding editors if appropriate. <P> Note
     * that if this method is called on a new edit row (created via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#startEditingNew ListGrid.startEditingNew()} for example), which has not yet
     * been saved, this method will remove the row entirely. <P> Also note that this method will clear the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved removed} state of records that have been marked as removed.
     * @param rowNum Row to cancel
     * @param colNum Column to cancel. Note that this parameter is ignored in ListGrids but                        may be required in
     * subclasses of ListGrid where each cell represents                        one record in the data set (EG CubeGrid)
     * @param dontHideEditor By default this method will hide the editor if                              it is currently showing for the row in
     * question. Passing in                              this parameter will leave the editor visible (and just reset          
     *                    the edit values underneath the editor).
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void discardEdits(int rowNum, int colNum, Boolean dontHideEditor) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.discardEdits(rowNum, colNum, dontHideEditor == null ? null : dontHideEditor.@java.lang.Boolean::booleanValue()());
    }-*/;
	
    /**
     * Add a drawAreaChanged handler.
     * <p>
     * Notification method that fires when the drawArea changes due to scrolling.  Receives the previous drawArea co-ordinates
     * as parameters.  Call {@link com.smartgwt.client.widgets.grid.ListGrid#getDrawArea ListGrid.getDrawArea()} to get the new
     * drawArea co-ordinates. <P> Note that if this grid is showing any {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, they will not be included in the
     * <code>oldStartCol</code>, <code>oldEndCol</code> range reported by this method. Frozen fields are assumed never to be
     * scrolled out of view.
     *
     * @param handler the drawAreaChanged handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addDrawAreaChangedHandler(com.smartgwt.client.widgets.grid.events.DrawAreaChangedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.DrawAreaChangedEvent.getType()) == 0) setupDrawAreaChangedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.DrawAreaChangedEvent.getType());
    }

    private native void setupDrawAreaChangedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var drawAreaChanged = $entry(function(){
            var param = {"oldStartRow" : arguments[0], "oldEndRow" : arguments[1], "oldStartCol" : arguments[2], "oldEndCol" : arguments[3]};
            var event = @com.smartgwt.client.widgets.grid.events.DrawAreaChangedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            if (hasDefaultHandler) this.Super("drawAreaChanged", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("drawAreaChanged"));
            obj.addProperties({drawAreaChanged:  drawAreaChanged              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("drawAreaChanged"));
            obj.drawAreaChanged =  drawAreaChanged             ;
        }
   }-*/;
    /**
     * Add a editComplete handler.
     * <p>
     * Callback fired when inline edits have been successfully saved. <P> No default implementation.
     *
     * @param handler the editComplete handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addEditCompleteHandler(com.smartgwt.client.widgets.grid.events.EditCompleteHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.EditCompleteEvent.getType()) == 0) setupEditCompleteEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.EditCompleteEvent.getType());
    }

    private native void setupEditCompleteEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var editComplete = $entry(function(){
            var param = {"rowNum" : arguments[0], "colNum" : arguments[1], "newValues" : arguments[2], "oldValues" : arguments[3], "editCompletionEvent" : arguments[4], "dsResponse" : arguments[5]};
            var event = @com.smartgwt.client.widgets.grid.events.EditCompleteEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            if (hasDefaultHandler) this.Super("editComplete", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("editComplete"));
            obj.addProperties({editComplete:  editComplete              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("editComplete"));
            obj.editComplete =  editComplete             ;
        }
   }-*/;
    /**
     * Add a editFailed handler.
     * <p>
     * Called when an attempt to save inline edits fails, due to a validation error or other server error. <P> The default
     * implementation of editFailed does nothing for normal validation errors, which are displayed before editFailed() is
     * called.  For any other errors, the default implementation will call {@link
     * com.smartgwt.client.rpc.RPCManager#handleError RPCManager.handleError()}, which by default will result in a warning
     * dialog.
     *
     * @param handler the editFailed handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addEditFailedHandler(com.smartgwt.client.widgets.grid.events.EditFailedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.EditFailedEvent.getType()) == 0) setupEditFailedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.EditFailedEvent.getType());
    }

    private native void setupEditFailedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var editFailed = $entry(function(){
            var param = {"rowNum" : arguments[0], "colNum" : arguments[1], "newValues" : arguments[2], "oldValues" : arguments[3], "editCompletionEvent" : arguments[4], "dsResponse" : arguments[5]};
            var event = @com.smartgwt.client.widgets.grid.events.EditFailedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            if (hasDefaultHandler) this.Super("editFailed", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("editFailed"));
            obj.addProperties({editFailed:  editFailed              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("editFailed"));
            obj.editFailed =  editFailed             ;
        }
   }-*/;
    /**
     * Add a editorEnter handler.
     * <p>
     * Callback fired when the user starts editing a new cell. <P> This callback is typically used to establish dynamic default
     * values via {@link com.smartgwt.client.widgets.grid.ListGrid#setEditValue ListGrid.setEditValue()} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setEditValues ListGrid.setEditValues()}. <P> Can also be overridden on a
     * per-field basis via {@link com.smartgwt.client.widgets.grid.ListGridField#addEditorEnterHandler field.editorEnter}.
     *
     * @param handler the editorEnter handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addEditorEnterHandler(com.smartgwt.client.widgets.grid.events.EditorEnterHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.EditorEnterEvent.getType()) == 0) setupEditorEnterEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.EditorEnterEvent.getType());
    }

    private native void setupEditorEnterEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var editorEnter = $entry(function(){
            var param = {"record" : arguments[0], "value" : arguments[1], "rowNum" : arguments[2], "colNum" : arguments[3]};
            var event = @com.smartgwt.client.widgets.grid.events.EditorEnterEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            if (hasDefaultHandler) this.Super("editorEnter", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("editorEnter"));
            obj.addProperties({editorEnter:  editorEnter              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("editorEnter"));
            obj.editorEnter =  editorEnter             ;
        }
   }-*/;
    /**
     * Add a editorExit handler.
     * <p>
     * Callback fired when the user attempts to navigate away from the current edit cell, or complete the current edit. <P>
     * Call {@link com.smartgwt.client.widgets.grid.events.EditorExitEvent#cancel()} from within {@link
     * com.smartgwt.client.widgets.grid.events.EditorExitHandler#onEditorExit} from this method to cancel the default behavior
     * (Saving / cancelling the current edit / moving to the next edit cell). <P> This callback is typically used to
     * dynamically update values or value maps for related fields (via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setEditValue ListGrid.setEditValue()} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setEditorValueMap ListGrid.setEditorValueMap()} respectively, or to implement
     * custom navigation (via {@link com.smartgwt.client.widgets.grid.ListGrid#startEditing startEditing(rowNum,colNum)}. <P>
     * Can be overridden at the field level as field.editorExit.
     *
     * @param handler the editorExit handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addEditorExitHandler(com.smartgwt.client.widgets.grid.events.EditorExitHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.EditorExitEvent.getType()) == 0) setupEditorExitEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.EditorExitEvent.getType());
    }

    private native void setupEditorExitEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var editorExit = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.EditorExitEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("editorExit"));
            obj.addProperties({editorExit: 
                function () {
                    var param = {"editCompletionEvent" : arguments[0], "record" : arguments[1], "newValue" : arguments[2], "rowNum" : arguments[3], "colNum" : arguments[4]};
                    var ret = editorExit(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("editorExit", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("editorExit"));
            obj.editorExit = 
                function () {
                    var param = {"editCompletionEvent" : arguments[0], "record" : arguments[1], "newValue" : arguments[2], "rowNum" : arguments[3], "colNum" : arguments[4]};
                    var ret = editorExit(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("editorExit", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
	/**
     * Complete the current edit by storing the value and hiding the inline editor. Note that if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits} is true, the value will be saved to the
     * server.
     * @see com.smartgwt.client.widgets.grid.ListGrid#startEditing
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void endEditing() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.endEditing();
    }-*/;



	/**
     * Expands a given {@link com.smartgwt.client.widgets.grid.ListGridRecord record} by creating a subcomponent and inserting
     * it in to the record's grid-row.  A number of built-in {@link com.smartgwt.client.types.ExpansionMode expansionModes} are
     * supported by the default implementation of {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionComponent
     * getExpansionComponent()} and you can override that method to provide your own expansion behavior. <P> Once a record has
     * been expanded, the currently visible expansion component may be retrieved via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCurrentExpansionComponent ListGrid.getCurrentExpansionComponent()}.
     * @param record record to expand
     */
    public native void expandRecord(ListGridRecord record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.expandRecord(record.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;




	/**
     * Expands the passed list of {@link com.smartgwt.client.widgets.grid.ListGridRecord records} by creating a subcomponent
     * for each record and inserting them it in to the record's grid-row.  Calls {@link
     * com.smartgwt.client.widgets.grid.ListGrid#expandRecord expandRecord} for each passed record, but only marks the grid for
     * redraw once, after all expansions are complete.
     * @param records records to expand
     */
    public native void expandRecords(ListGridRecord... records) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.expandRecords(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(records));
    }-*/;


	/**
     * Exports this component's data with client-side formatters applied, so is suitable for direct display to users.  This
     * feature requires the Smart GWT server. <P> Ordinarily, calls to this method go through the static classMethod  {@link
     * com.smartgwt.client.data.DataSource#exportClientData DataSource.exportClientData()}.  In this case, no server-side
     * DataSources are required.  However, if this component is  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#setDataSource databound} and you specify a valid  {@link
     * com.smartgwt.client.data.DSRequest#getOperationId operationId} in the properties passed to this method, the call will go
     * through the instance method {@link com.smartgwt.client.data.DataSource#exportClientData DataSource.exportClientData()}
     * instead.  As the  documentation for that method explains, this allows you more control on the server side.   This
     * approach requires both the Smart GWT server and server-side DataSource definitions. <P> To export data from this
     * component's dataSource,  see {@link com.smartgwt.client.widgets.DataBoundComponent#exportData exportData}, which does
     * not include client-side  formatters, but <b>does</b> include formatters declared in the <code>.ds.xml</code> file.
     * <code>exportData()</code> relies on both the Smart GWT server and server-side DataSources.
     * @see com.smartgwt.client.data.DataSource#exportClientData
     */
    public native void exportClientData() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.exportClientData();
    }-*/;

    /**
     * @see ListGrid#exportClientData
     */
    public void exportClientData(DSRequest requestProperties){
        exportClientData(requestProperties, null);
    }

	/**
     * Exports this component's data with client-side formatters applied, so is suitable for direct display to users.  This
     * feature requires the Smart GWT server. <P> Ordinarily, calls to this method go through the static classMethod  {@link
     * com.smartgwt.client.data.DataSource#exportClientData DataSource.exportClientData()}.  In this case, no server-side
     * DataSources are required.  However, if this component is  {@link
     * com.smartgwt.client.widgets.DataBoundComponent#setDataSource databound} and you specify a valid  {@link
     * com.smartgwt.client.data.DSRequest#getOperationId operationId} in the properties passed to this method, the call will go
     * through the instance method {@link com.smartgwt.client.data.DataSource#exportClientData DataSource.exportClientData()}
     * instead.  As the  documentation for that method explains, this allows you more control on the server side.   This
     * approach requires both the Smart GWT server and server-side DataSource definitions. <P> To export data from this
     * component's dataSource,  see {@link com.smartgwt.client.widgets.DataBoundComponent#exportData exportData}, which does
     * not include client-side  formatters, but <b>does</b> include formatters declared in the <code>.ds.xml</code> file.
     * <code>exportData()</code> relies on both the Smart GWT server and server-side DataSources.
     * @param requestProperties Request properties for the export.  Note that specifying {@link com.smartgwt.client.data.DSRequest#getExportData
     * exportData} on the request properties  allows the developer to pass in an explicit data set to export.
     * @param callback Optional callback.  If  you specify {@link com.smartgwt.client.data.DSRequest#getExportToClient exportToClient}: false
     * in the request  properties, this callback will fire after export completes.  Otherwise the callback will  fire right
     * before the download request is made to the server.
     * @see com.smartgwt.client.data.DataSource#exportClientData
     */
    public native void exportClientData(DSRequest requestProperties, RPCCallback callback) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.exportClientData(requestProperties == null ? null : requestProperties.@com.smartgwt.client.core.DataClass::getJsObj()(), 
			$entry( function(response, rawData, request) { 
				if(callback!=null) callback.@com.smartgwt.client.rpc.RPCCallback::execute(Lcom/smartgwt/client/rpc/RPCResponse;Ljava/lang/Object;Lcom/smartgwt/client/rpc/RPCRequest;)(
					@com.smartgwt.client.rpc.RPCResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(response), 
					rawData, 
					@com.smartgwt.client.rpc.RPCRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(request)
				);
			}));
    }-*/;
	


	/**
     * Based on the relationship between the DataSource this component is bound to and the DataSource specified as the "schema"
     * argument, call fetchData() to retrieve records in this grid that are related to the passed-in record. <P> Relationships
     * between DataSources are declared via {@link com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey}. <P> For
     * example, given two related DataSources "orders" and "orderItems", where we want to fetch the "orderItems" that belong to
     * a given "order".  "orderItems" should declare a field that is a {@link
     * com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey} to the "orders" table (for example, it might be named
     * "orderId" with foreignKey="orders.id").  Then, to load the records related to a given "order", call fetchRelatedData()
     * on the component bound to "orderItems", pass the "orders" DataSource as the "schema" and pass a record from the "orders"
     * DataSource as the "record" argument.
     * @param record DataSource record
     * @param schema schema of the DataSource record, or                            DataBoundComponent already bound to that schema
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBoundComponentMethods overview and related methods
     */
    public native void fetchRelatedData(ListGridRecord record, Canvas schema) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.fetchRelatedData(record.@com.smartgwt.client.core.DataClass::getJsObj()(), schema == null ? null : schema.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()());
    }-*/;


    /**
     * @see ListGrid#fetchRelatedData
     */
    public void fetchRelatedData(ListGridRecord record, Canvas schema, DSCallback callback){
        fetchRelatedData(record, schema, callback, null);
    }

	/**
     * Based on the relationship between the DataSource this component is bound to and the DataSource specified as the "schema"
     * argument, call fetchData() to retrieve records in this grid that are related to the passed-in record. <P> Relationships
     * between DataSources are declared via {@link com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey}. <P> For
     * example, given two related DataSources "orders" and "orderItems", where we want to fetch the "orderItems" that belong to
     * a given "order".  "orderItems" should declare a field that is a {@link
     * com.smartgwt.client.data.DataSourceField#getForeignKey foreignKey} to the "orders" table (for example, it might be named
     * "orderId" with foreignKey="orders.id").  Then, to load the records related to a given "order", call fetchRelatedData()
     * on the component bound to "orderItems", pass the "orders" DataSource as the "schema" and pass a record from the "orders"
     * DataSource as the "record" argument.
     * @param record DataSource record
     * @param schema schema of the DataSource record, or                            DataBoundComponent already bound to that schema
     * @param callback callback to invoke on completion
     * @param requestProperties additional properties to set on the DSRequest                                            that will be issued
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBoundComponentMethods overview and related methods
     */
    public native void fetchRelatedData(ListGridRecord record, Canvas schema, DSCallback callback, DSRequest requestProperties) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.fetchRelatedData(record.@com.smartgwt.client.core.DataClass::getJsObj()(), schema == null ? null : schema.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()(), 
			$entry( function(dsResponse, data, dsRequest) { 
				if(callback!=null) callback.@com.smartgwt.client.data.DSCallback::execute(Lcom/smartgwt/client/data/DSResponse;Ljava/lang/Object;Lcom/smartgwt/client/data/DSRequest;)(
					@com.smartgwt.client.data.DSResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsResponse), 
					data, 
					@com.smartgwt.client.data.DSRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsRequest)
				);
			}), requestProperties == null ? null : requestProperties.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;
	
	/**
     * Check whether a field is currently visible
     * @param field field to be checked
     *
     * @return true if the field is currently visible, false otherwise.
     */
    public native boolean fieldIsVisible(String field) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.fieldIsVisible(field);
        return ret;
    }-*/;

    /**
     * Add a fieldStateChanged handler.
     * <p>
     * Notification method executed when columns are resized or reordered, or fields are shown or hidden. Has no default
     * implementation.
     *
     * @param handler the fieldStateChanged handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addFieldStateChangedHandler(com.smartgwt.client.widgets.grid.events.FieldStateChangedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.FieldStateChangedEvent.getType()) == 0) setupFieldStateChangedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.FieldStateChangedEvent.getType());
    }

    private native void setupFieldStateChangedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var fieldStateChanged = $entry(function(){
            var param = {};
            var event = @com.smartgwt.client.widgets.grid.events.FieldStateChangedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            if (hasDefaultHandler) this.Super("fieldStateChanged", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("fieldStateChanged"));
            obj.addProperties({fieldStateChanged:  fieldStateChanged              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("fieldStateChanged"));
            obj.fieldStateChanged =  fieldStateChanged             ;
        }
   }-*/;
	/**
     * If the filter editor ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor}) is visible
     * for this grid, this method will perform a filter based on the current values in the editor.
     */
    public native void filterByEditor() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.filterByEditor();
    }-*/;

    /**
     * Add a filterEditorSubmit handler.
     * <p>
     * Optional notification fired when the user performs a filter using the
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor Filter Editor}.  May fire as criteria values are
     * being edited if 
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterOnKeypress filterOnKeypress} is true, otherwise will fire when
     * the user clicks the filter
     *  button or presses the Enter key while focus is in the Filter Editor.
     *  <p>
     *  Use event.cancel()
     *  
     *  to cancel the default behavior - you <b>must</b> cancel the default behavior if your
     * code is going to call {@link com.smartgwt.client.widgets.grid.ListGrid#filterData ListGrid.filterData()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setCriteria ListGrid.setCriteria()} or any other API that
     *  affects the criteria applied to the grid.
     *  <P>
     *  The <code>criteria</code> parameter contains the current criteria applied to the
     *  grid including edits the user has just made using the Filter Editor.  This matches
     * what is returned if you call {@link com.smartgwt.client.widgets.grid.ListGrid#getFilterEditorCriteria
     * ListGrid.getFilterEditorCriteria()}.
     *  <P>
     *  If you wish to access the <code>criteria</code> applied to the grid without picking
     * up any edits to the Filter Editor, use {@link com.smartgwt.client.widgets.grid.ListGrid#getCriteria
     * ListGrid.getCriteria()} instead.
     *  <P>
     *  Developers may wish to perform a filter using the Filter Editor values from code
     *  running outside the standard filterEditorSubmit flow.  For example, if you wanted a
     *  confirmation dialog to be shown before filtering was performed, you would cancel the
     *  default behavior as described above, but then need to replicate the default behavior
     *  once the user confirms that they want to proceed.  To replicate the default behavior, 
     *  just call:
     *  <pre>
     *   grid.filterData(grid.getFilterEditorCriteria());
     *  </pre>
     * or, to ensure the specified {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchTextMatchStyle
     * autoFetchTextMatchStyle} is picked up
     *  
     *  
     *  <pre>
     *   DSRequest request = new DSRequest();
     *   request.setTextMatchStyle(grid.getAutoFetchTextMatchStyle());
     *   grid.filterData(grid.getFilterEditorCriteria(), null,
     *        request);
     *  </pre>
     *  
     * 
     * 
     *
     * @param handler the filterEditorSubmit handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addFilterEditorSubmitHandler(com.smartgwt.client.widgets.grid.events.FilterEditorSubmitHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.FilterEditorSubmitEvent.getType()) == 0) setupFilterEditorSubmitEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.FilterEditorSubmitEvent.getType());
    }

    private native void setupFilterEditorSubmitEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var filterEditorSubmit = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.FilterEditorSubmitEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("filterEditorSubmit"));
            obj.addProperties({filterEditorSubmit: 
                function () {
                    var param = {"criteria" : arguments[0]};
                    var ret = filterEditorSubmit(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("filterEditorSubmit", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("filterEditorSubmit"));
            obj.filterEditorSubmit = 
                function () {
                    var param = {"criteria" : arguments[0]};
                    var ret = filterEditorSubmit(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("filterEditorSubmit", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;


	/**
     * Puts keyboard focus into the specified cell, showing a highlighted (roll-over style) appearance, and ensuring that
     * arrow-key navigation will start from the specified cell. <P> Only applies where {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is true.
     * @param row Index of target row
     * @param col Index of target col
     * @see com.smartgwt.client.widgets.grid.ListGrid#focusInRow
     */
    public native void focusInCell(Integer row, Integer col) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.focusInCell(row == null ? null : row.@java.lang.Integer::intValue()(), col == null ? null : col.@java.lang.Integer::intValue()());
    }-*/;


	/**
     * If the filter editor ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor}) is visible
     * for this grid, this method will explicitly put focus into the specified field in the filter editor.
     */
    public native void focusInFilterEditor() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.focusInFilterEditor();
    }-*/;

	/**
     * If the filter editor ({@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor}) is visible
     * for this grid, this method will explicitly put focus into the specified field in the filter editor.
     * @param fieldName Name of the field to put focus into. If unspecified focus will go                             to the first field in the
     * editor
     */
    public native void focusInFilterEditor(String fieldName) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.focusInFilterEditor(fieldName);
    }-*/;
	


	/**
     * Puts keyboard focus into the specified row, showing a highlighted (roll-over style) appearance, and ensuring that
     * arrow-key navigation will start from the specified row. <P> Only applies where {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is false.
     * @param row Index of target row
     * @see com.smartgwt.client.widgets.grid.ListGrid#focusInCell
     */
    public native void focusInRow(Integer row) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.focusInRow(row == null ? null : row.@java.lang.Integer::intValue()());
    }-*/;


    /**
     * Add a formulaUpdated handler.
     * <p>
     * Notification fired when a user either creates a new formula field or edits an existing formula field.
     *
     * @param handler the formulaUpdated handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addFormulaUpdatedHandler(com.smartgwt.client.widgets.events.FormulaUpdatedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.events.FormulaUpdated.getType()) == 0) setupFormulaUpdatedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.events.FormulaUpdated.getType());
    }

    private native void setupFormulaUpdatedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var formulaUpdated = $entry(function(){
            var param = {"field" : arguments[0], "formula" : arguments[1]};
            var event = @com.smartgwt.client.widgets.events.FormulaUpdated::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            if (hasDefaultHandler) this.Super("formulaUpdated", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("formulaUpdated"));
            obj.addProperties({formulaUpdated:  formulaUpdated              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("formulaUpdated"));
            obj.formulaUpdated =  formulaUpdated             ;
        }
   }-*/;


	/**
     * Freeze the indicated field, so that it remains in place and visible when horizontal scrolling occurs.
     * @param field field or fields to freeze.  fields may be specified as ListGridField objects, field names or colNum.
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public native void freezeField(ListGridField field) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.freezeField(field.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;

	/**
     * Freeze the indicated field, so that it remains in place and visible when horizontal scrolling occurs.
     * @param field field or fields to freeze.  fields may be specified as ListGridField objects, field names or colNum.
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public native void freezeField(Integer field) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.freezeField(field == null ? null : field.@java.lang.Integer::intValue()());
    }-*/;

	/**
     * Freeze the indicated field, so that it remains in place and visible when horizontal scrolling occurs.
     * @param field field or fields to freeze.  fields may be specified as ListGridField objects, field names or colNum.
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public native void freezeField(String field) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.freezeField(field);
    }-*/;

	/**
     * Freeze the indicated field, so that it remains in place and visible when horizontal scrolling occurs.
     * @param field field or fields to freeze.  fields may be specified as ListGridField objects, field names or colNum.
     * @see com.smartgwt.client.docs.FrozenFields FrozenFields overview and related methods
     */
    public native void freezeField(String[] field) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.freezeField(field);
    }-*/;


	/**
     * Returns an array of every rowNum for which we have pending (unsubmitted) edits. This will return records that have been
     * marked as removed (see {@link com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved ListGrid.markRecordRemoved()}
     * as well as records with unsaved changes to field values.
     *
     * @return Array of rowNums for rows with edit values pending submission.
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native int[] getAllEditRows() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getAllEditRows();
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfint(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Get the complete array of fields for this ListGrid, including fields that are not currently visible or were specified
     * implicitly via {@link com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}. <P> This list of fields is
     * only valid once the ListGrid has been {@link com.smartgwt.client.widgets.Canvas#draw drawn} or once {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setFields ListGrid.setFields()} has been called explicitly.  If called
     * earlier, only the list of directly specified fields will be returned (the Array passed to create()). <P> This Array
     * should be treated as <b>read-only</b>.  To modify the set of visible fields, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#showField ListGrid.showField()}, {@link
     * com.smartgwt.client.widgets.grid.ListGrid#hideField ListGrid.hideField()} and related APIs.  To update properties of
     * individual fields, use {@link com.smartgwt.client.widgets.grid.ListGrid#setFieldProperties
     * ListGrid.setFieldProperties()} or more specific APIs such as {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setFieldTitle ListGrid.setFieldTitle()}.
     *
     * @return Array of all fields in the ListGrid
     */
    public native ListGridField[] getAllFields() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getAllFields();
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfListGridField(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;



	/**
     * Return the base stylename for this cell.  Has the following implementation by default: <ul> <li>If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditFailedBaseStyle this.editFailedBaseStyle} is defined, and the     cell
     * is displaying a validation error return this value.</li> <li>If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getEditPendingBaseStyle this.editFailedPendingStyle} is defined, and     the
     * cell is displaying an edit value that has not yet been saved (see     {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAutoSaveEdits autoSaveEdits}) return this value.</li> <li>Otherwise return
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordBaseStyleProperty record[listGrid.recordBaseStyleProperty]},  
     * if defined, otherwise {@link com.smartgwt.client.widgets.grid.ListGridField#getBaseStyle field.baseStyle}.</li> </ul> If
     * no custom style is found for the cell as described above, the default baseStyle will be returned. If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle baseStyle} is specified this will be used. Otherwise for grids
     * showing fixed height rows which match {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalCellHeight
     * normalCellHeight} {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle} will be used. For
     * grids with variable, or modified cell heights, {@link com.smartgwt.client.widgets.grid.ListGrid#getTallBaseStyle
     * tallBaseStyle} will be used. <P> Note also that enabling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFastCellUpdates fastCellUpdates} will cause the <code>tallBaseStyle</code>
     * to be used rather than {@link com.smartgwt.client.widgets.grid.ListGrid#getNormalBaseStyle normalBaseStyle}. <p>
     * <b>Note: This is an override point.</b>
     * @param record Record associated with this cell. May be <code>null</code>                                  for a new edit row at the
     * end of this grid's data set.
     * @param rowNum row number for the cell
     * @param colNum column number of the cell
     *
     * @return CSS class for this cell
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCellStyle
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_hilite_replace" target="examples">Hilite cells (replace style) Example</a>
     */
    protected native String getBaseStyle(ListGridRecord record, int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__getBaseStyle(record == null ? null : record.@com.smartgwt.client.core.DataClass::getJsObj()(), rowNum, colNum);
        return ret;
    }-*/;




	/**
     * Return CSS text for styling this cell, which will be applied in addition to the CSS class for the cell, as overrides.
     * <p> "CSS text" means semicolon-separated style settings, suitable for inclusion in a CSS stylesheet or in a STYLE
     * attribute of an HTML element.
     * @param record cell record as returned by getCellRecord
     * @param rowNum row number for the cell
     * @param colNum column number of the cell
     *
     * @return CSS text for this cell
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCellStyle
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_hilite_add" target="examples">Hilite cells (add style) Example</a>
     */
    protected native String getCellCSSText(ListGridRecord record, int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        if(record==null) { return null;}
        var ret = self.__getCellCSSText(record.@com.smartgwt.client.core.DataClass::getJsObj()(), rowNum, colNum);
        return ret;
    }-*/;




	/**
     * Returns the current set of errors for this cell.
     * @param rowNum index of row to check for validation errors.
     * @param fieldName field to check for validation errors - can be fieldName                                          or index of the column.
     *
     * @return array of error messages (strings) for the specified cell. If no validation                  errors are present, returns
     * null.
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public native String[] getCellErrors(int rowNum, String fieldName) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getCellErrors(rowNum, fieldName);
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfString(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;




	/**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHoverComponents showHoverComponents} is set, this method is
     * called to get the component to show as a hover for the current cell. <P> By default, this method returns one of a set of
     * builtin components, according to the value of {@link com.smartgwt.client.types.HoverMode listGrid.hoverMode}.  You can
     * override this method to return any component you wish to provide as a hoverComponent, or invoke the superclass method to
     * have the default hover component generated, then further customize it. <P> By default, components returned by
     * <code>getCellHoverComponent()</code> will be automatically destroyed when the hover is hidden.  To prevent this, set
     * {@link com.smartgwt.client.widgets.Canvas#getHoverAutoDestroy hoverAutoDestroy} to false on the returned component.
     * @param record record to get the hoverComponent for
     * @param rowNum row number for the cell
     * @param colNum column number of the cell
     *
     * @return the component to show as a hover
     */
    protected native Canvas getCellHoverComponent(Record record, Integer rowNum, Integer colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__getCellHoverComponent(record.@com.smartgwt.client.core.DataClass::getJsObj()(), rowNum == null ? null : rowNum.@java.lang.Integer::intValue()(), colNum == null ? null : colNum.@java.lang.Integer::intValue()());
        return @com.smartgwt.client.widgets.Canvas::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;




	/**
     * Returns the page offsets and size of the cell at the passed row and column.  If auto-sizing is enabled, sizes are not
     * definitive until the grid has finished drawing, so calling this method before drawing completes will return the
     * configured column sizes.
     * @param rowNum row index of the cell
     * @param colNum column index of the cell
     *
     * @return the page rect of the passed cell, or null if undrawn
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public native Integer[] getCellPageRect(int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getCellPageRect(rowNum, colNum);
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfInteger(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;




	/**
     * When using {@link com.smartgwt.client.widgets.grid.ListGrid#getRowSpan row spanning}, returns the number of cells
     * spanned by the cell at the given coordinates. <P> If the passed coordinates are in the middle of a series of spanned
     * cells, the row span of the spanning cell is returned.  For example, if row 2 col 0 spans 3 cells, calls to
     * <code>getCellRowSpan()</code> for row 2 col 0, row 3 col 0, row 4 col 0 will all return 3. <P> This method returns row
     * span information for the current rendered cells.  In contrast, if the grid is about to be redrawn, a call to
     * <code>getRowSpan()</code> may return row span values for how the grid is about to be drawn.  Also, user-provided
     * getRowSpan() functions are not required to operate properly when called outside of the grid rendering loop. <P>
     * <b>Note:</b> This method is a utility method for developers - it is not called directly by the grid rendering path and
     * therefore is not intended for override. To set up custom row-spanning behavior, override {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowSpan ListGrid.getRowSpan()} instead.
     * @param rowNum row number of cell to return the row span for
     * @param colNum column number of cell to return the row span for
     *
     * @return number of cells spanned by the cell that spans through these coordinates
     */
    public native int getCellRowSpan(int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getCellRowSpan(rowNum, colNum);
        return ret;
    }-*/;


	/**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is active, returns the {@link
     * com.smartgwt.client.widgets.grid.CellSelection} object that tracks and manages the current selection.  Returns null if
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getCanSelectCells canSelectCells} is false.
     *
     * @return current cellSelection
     */
    public native CellSelection getCellSelection() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getCellSelection();
        if(ret == null) return null;
        return @com.smartgwt.client.widgets.grid.CellSelection::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;



	/**
     * When using {@link com.smartgwt.client.widgets.grid.ListGrid#getRowSpan row spanning}, returns the row number where a
     * row-spanning cell starts. <P> For example, if row 2 col 0 spans 3 cells, <code>getCellStartRow()</code> for row 2 col 0,
     * row 3 col 0, row 4 col 0 will all return 2, because that's the row when spanning starts.
     * @param rowNum row number of cell for which the start row should be returned
     * @param colNum column number of cell for which the start row should be returned
     *
     * @return row number where spanning starts
     */
    public native int getCellStartRow(int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getCellStartRow(rowNum, colNum);
        return ret;
    }-*/;




	/**
     * Return the CSS class for a cell. By default this method has the following implementation:<br> - return any custom style
     * for the record (e {@link com.smartgwt.client.widgets.grid.GridRenderer#getRecordCustomStyleProperty
     * recordCustomStyleProperty})    if defined.<br> - create a style name based on the result of {@link
     * com.smartgwt.client.widgets.grid.GridRenderer#getBaseStyle GridRenderer.getBaseStyle()} and the    state of the record
     * using the rules described in {@link com.smartgwt.client.widgets.grid.ListGrid#getCellStyleSuffixes cellStyleSuffixes}.
     * <p> Cell Styles are customizable by: <ul> <li>attaching a custom style to a record by setting    
     * <code>record[this.recordCustomStyleProperty]</code> to some valid CSS style name.   <li>modifying the base style
     * returned by getBaseStyle() [see that method for further      documentation on this] <li>overriding this function </ul>
     * <p> In addition to this {@link com.smartgwt.client.widgets.grid.ListGrid#getCellCSSText ListGrid.getCellCSSText()} may
     * be overriden to provide custom cssText to apply on top of the styling attributes derived from the named style.
     * @param record record object for this row and column
     * @param rowNum number of the row
     * @param colNum number of the column
     *
     * @return CSS style for this cell
     * @see com.smartgwt.client.widgets.grid.ListGrid#getBaseStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    protected native String getCellStyle(ListGridRecord record, int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        if(record==null) { return null;}
        var ret = self.__getCellStyle(record.@com.smartgwt.client.core.DataClass::getJsObj()(), rowNum, colNum);
        return ret;
    }-*/;




	/**
     * Return the left offset (in local coordinate space) of a particular column.
     * @param colNum number of the column
     *
     * @return left offset of the passed colNum, or null if not yet drawn or no such column
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public native Integer getColumnLeft(Integer colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getColumnLeft(colNum == null ? null : colNum.@java.lang.Integer::intValue()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toInteger(I)(ret);
    }-*/;




	/**
     * Return the left coordinate for a given column number as a GLOBAL coordinate
     * @param colNum number of the column
     *
     * @return page left offset of the passed colNum, or null if undrawn or no such column
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public native Integer getColumnPageLeft(Integer colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getColumnPageLeft(colNum == null ? null : colNum.@java.lang.Integer::intValue()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toInteger(I)(ret);
    }-*/;




	/**
     * Return the width of a particular column.
     * @param colNum number of the column
     *
     * @return width of the column, or <code>null</code> if undrawn or no such column.
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public native Integer getColumnWidth(int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getColumnWidth(colNum);
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toInteger(I)(ret);
    }-*/;




	/**
     * Returns the expansion component derived from {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionComponent
     * ListGrid.getExpansionComponent()} currently visible in some record, or null if the specified record is not showing an
     * expansion component.
     * @param record rowNum or record to get the expansionComponent for
     *
     * @return the currently visible expansion component for the expanded row.
     */
    public native Canvas getCurrentExpansionComponent(Integer record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getCurrentExpansionComponent(record == null ? null : record.@java.lang.Integer::intValue()());
        return @com.smartgwt.client.widgets.Canvas::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Returns the expansion component derived from {@link com.smartgwt.client.widgets.grid.ListGrid#getExpansionComponent
     * ListGrid.getExpansionComponent()} currently visible in some record, or null if the specified record is not showing an
     * expansion component.
     * @param record rowNum or record to get the expansionComponent for
     *
     * @return the currently visible expansion component for the expanded row.
     */
    public native Canvas getCurrentExpansionComponent(ListGridRecord record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getCurrentExpansionComponent(record.@com.smartgwt.client.core.DataClass::getJsObj()());
        return @com.smartgwt.client.widgets.Canvas::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;




	/**
     * Method to calculate and return the default width of a field. This method is called to calculate the size of each field's
     * content as part of the {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFitFieldWidths field auto fit} behavior.
     * Note that this method returns a size for <i>content</i>, so will not be consulted if {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidthApproach autoFitWidthApproach} is set  to
     * <code>"title"</code>. <P> The default implementation varies by {@link com.smartgwt.client.types.ListGridFieldType field
     * type}. For fields of type <code>"icon"</code>, or fields which show only a {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getValueIcons valueIcon} as a value, and for boolean fields which show a
     * checkbox value, the width will be calculated based on the icon size and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getIconPadding iconPadding}. For other fields the width will be calculated
     * based on the rendered width of content. Note that for <code>"image"</code> type fields, this method will rely on the
     * {@link com.smartgwt.client.widgets.grid.ListGridField#getImageWidth imageWidth} being specified. <P> Note that this
     * width is the default width of "content" - it does not take into account the rendered size of the field title.
     * @param field Field for which the size should be determined
     *
     * @return default size required for the field's content.
     */
    public native int getDefaultFieldWidth(ListGridField field) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getDefaultFieldWidth(field.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret;
    }-*/;




	/**
     * Get a field value for some record with default field formatters applied. <P> This method differs from {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultFormattedValue ListGrid.getDefaultFormattedValue()} in a couple of
     * ways. Firstly, this method does not rely on the rowNum and colNum parameters to find the record and field in the
     * grid.<br> Secondly, unlike {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFormattedValue
     * ListGrid.getDefaultFormattedValue()} this method <i>will</i> call any explicit cell formatter specified on the field
     * passed in (though it will not call a {@link com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter component level
     * formatter} if one exists). <P> This is useful for cases where a developer wishes to display a formatted value for some
     * record and field combination which does not necessarily map to a cell displayed in the ListGrid. <P> If
     * <code>rowNum</code> and <code>colNum</code> parameters are passed through to the field level cell formatter if one
     * exists. If not explicitly provided these are defaulted to -1.
     * @param record the record object
     * @param field the field object
     *
     * @return Default formatted value
     * @see com.smartgwt.client.widgets.grid.ListGridField#setCellFormatter
     */
    public native String getDefaultFormattedFieldValue(Record record, ListGridField field) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getDefaultFormattedFieldValue(record.@com.smartgwt.client.core.DataClass::getJsObj()(), field.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret;
    }-*/;


    /**
     * @see ListGrid#getDefaultFormattedFieldValue
     */
    public String getDefaultFormattedFieldValue(Record record, ListGridField field, int rowNum){
        return getDefaultFormattedFieldValue(record, field, rowNum, (Integer) null);
    }

	/**
     * Get a field value for some record with default field formatters applied. <P> This method differs from {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDefaultFormattedValue ListGrid.getDefaultFormattedValue()} in a couple of
     * ways. Firstly, this method does not rely on the rowNum and colNum parameters to find the record and field in the
     * grid.<br> Secondly, unlike {@link com.smartgwt.client.widgets.grid.ListGrid#getDefaultFormattedValue
     * ListGrid.getDefaultFormattedValue()} this method <i>will</i> call any explicit cell formatter specified on the field
     * passed in (though it will not call a {@link com.smartgwt.client.widgets.grid.ListGrid#setCellFormatter component level
     * formatter} if one exists). <P> This is useful for cases where a developer wishes to display a formatted value for some
     * record and field combination which does not necessarily map to a cell displayed in the ListGrid. <P> If
     * <code>rowNum</code> and <code>colNum</code> parameters are passed through to the field level cell formatter if one
     * exists. If not explicitly provided these are defaulted to -1.
     * @param record the record object
     * @param field the field object
     * @param rowNum rowNum (passed to any field level cell formatter)
     * @param colNum colNum (passed to any field level cell formatter)
     *
     * @return Default formatted value
     * @see com.smartgwt.client.widgets.grid.ListGridField#setCellFormatter
     */
    public native String getDefaultFormattedFieldValue(Record record, ListGridField field, int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getDefaultFormattedFieldValue(record.@com.smartgwt.client.core.DataClass::getJsObj()(), field.@com.smartgwt.client.core.DataClass::getJsObj()(), rowNum, colNum);
        return ret;
    }-*/;
	


	/**
     * Get the value for some cell with default formatters applied. <P> This method is useful for cases where a developer
     * wishes to conditionally customize a cell's formatting, but needs to see what the default formatted value would be. <P>
     * For example - a developer might wish to apply a custom {@link
     * com.smartgwt.client.widgets.grid.ListGridField#setCellFormatter formatter} to some <code>link</code> type field, and be
     * able to return the default active link HTML in some cases. In this case a formatter could check for the conditions in
     * which custom formatting should be applied and run appropriate custom logic to generate a value for display - otherwise
     * return the result of this method to leave the standard formatted-value intact.
     * @param record the cell's record object
     * @param rowNum rowNum for the cell
     * @param colNum colNum for the cell
     *
     * @return Cell value with default formatters applied
     * @see com.smartgwt.client.widgets.grid.ListGridField#setCellFormatter
     */
    public native String getDefaultFormattedValue(Record record, int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getDefaultFormattedValue(record.@com.smartgwt.client.core.DataClass::getJsObj()(), rowNum, colNum);
        return ret;
    }-*/;


	/**
     * Returns the extents of the rows and columns currently visible in this grid's viewport. <P> Note: if there are any {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getFrozen frozen fields}, they are not included in the draw area range
     * returned by this method. Frozen fields are assumed to never be scrolled out of view.  The column coordinates returned by
     * this method will only include unfrozen columns.
     *
     * @return The row/col co-ordinates currently visible in the viewport as    [startRow, endRow, startCol, endCol].
     */
    public native Integer[] getDrawArea() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getDrawArea();
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfInteger(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;



	/**
     * Get the drawn height of a row.
     * @param rowNum 
     *
     * @return height
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public native int getDrawnRowHeight(int rowNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getDrawnRowHeight(rowNum);
        return ret;
    }-*/;


	/**
     * Returns the index of the column being edited or  -1 if there is no current edit column.
     *
     * @return index of the current edit column
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native int getEditCol() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getEditCol();
        if(ret == null){ret = -1;}
        return ret;
    }-*/;



	/**
     * Returns the current value of a cell. If the cell has an outstanding edit value, this will be returned, otherwise the
     * underlying value of the record will be returned.
     * @param record rowNum of the record being edited, or an Object                                      containing values for all the
     * record's primary keys
     * @param field colNum or fieldName of the cell
     *
     * @return Current edit value, or underlying value for the cell
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native Object getEditedCell(int record, int field) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getEditedCell(record, field);
        return $wnd.SmartGWT.convertToJavaType(ret);
    }-*/;


	/**
     * Returns the index of the row being edited or  -1 if there is no current edit row.
     *
     * @return index of the current edit row
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native int getEditRow() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getEditRow();
        if(ret == null){ret = -1;}
        return ret;
    }-*/;



	/**
     * Returns the current temporary locally stored edit value for some field within a record being edited.
     * @param rowNum index of the row for which the editValue should be returned
     * @param colNum index of the field, or fieldName, for which value should be                              returned
     *
     * @return edit value for the field in question
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native Object getEditValue(int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getEditValue(rowNum, colNum);
        return $wnd.SmartGWT.convertToJavaType(ret);
    }-*/;


	/**
     * Returns the column number of the most recent mouse event.
     *
     * @return column number, or -2 if beyond last drawn column
     */
    public native int getEventColumn() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getEventColumn();
        return ret;
    }-*/;

	/**
     * Returns the column number of the most recent mouse event.
     * @param x optional x-coordinate to obtain column number for, in lieu of the x                        coordinate of the last mouse
     * event
     *
     * @return column number, or -2 if beyond last drawn column
     */
    public native int getEventColumn(Integer x) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getEventColumn(x == null ? null : x.@java.lang.Integer::intValue()());
        return ret;
    }-*/;
	
	/**
     * Returns the row number of the most recent mouse event.
     *
     * @return row number, or -2 if beyond last drawn row
     */
    public native int getEventRow() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getEventRow();
        return ret;
    }-*/;

	/**
     * Returns the row number of the most recent mouse event.
     * @param y optional y-coordinate to obtain row number, in lieu of the y                        coordinate of the last mouse event
     *
     * @return row number, or -2 if beyond last drawn row
     */
    public native int getEventRow(Integer y) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getEventRow(y == null ? null : y.@java.lang.Integer::intValue()());
        return ret;
    }-*/;
	


	/**
     * Gets the embedded-component to show as a given record's expansionComponent.  This component is then housed in {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionLayout a VLayout} and embedded into a record's row. <P> By
     * default, this method returns one of a set of built-in components, according to the value of {@link
     * com.smartgwt.client.types.ExpansionMode listGrid.expansionMode}.  You can override this method to return any component
     * you wish to provide as an expansionComponent. <P> As long as the record is expanded, this component may be retrieved via
     * a call to {@link com.smartgwt.client.widgets.grid.ListGrid#getCurrentExpansionComponent
     * ListGrid.getCurrentExpansionComponent()}. <P> When an expanded record is collapsed, the component is disassociated from
     * the record and may or may not be automatically destroyed.  By default, built-in components will be destroyed on unembed.
     * Custom expansion components, created via an override of getExpansionComponents(), may not be auto-destroyed, according
     * to the {@link com.smartgwt.client.types.ExpansionComponentPoolingMode pooling mode} being used.
     * @param record record to get the expansionComponent for
     *
     * @return the component to embed
     */
    protected native Canvas getExpansionComponent(ListGridRecord record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__getExpansionComponent(record.@com.smartgwt.client.core.DataClass::getJsObj()());
        return @com.smartgwt.client.widgets.Canvas::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;




	/**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, background color
     * to use  for the cell at the given rowNum and colNum. <p> See {@link com.smartgwt.client.docs.ExportBGColor} for an
     * overview.
     * @param rowNum row number of cell
     * @param colNum column number of cell
     * @param record the record object behind the row being exported
     *
     * @return background color to use for the cell, or null to use the default                    background color
     */
    public native String getExportBGColor(int rowNum, int colNum, Record record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__getExportBGColor(rowNum, colNum, record.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret;
    }-*/;




	/**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, background color
     * to use  for the given colNum. <p> See {@link com.smartgwt.client.docs.ExportBGColor} for an overview.
     * @param colNum column number
     *
     * @return background color to use for the column, or null to use the default                    background color
     */
    public native String getExportColumnBGColor(int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__getExportColumnBGColor(colNum);
        return ret;
    }-*/;




	/**
     * When exporting data to Excel/OpenOffice format using {@link com.smartgwt.client.widgets.grid.ListGrid#exportData
     * exportData()} or {@link com.smartgwt.client.widgets.grid.ListGrid#exportClientData exportClientData()}, background color
     * to use  for the given rowNum. <p> See {@link com.smartgwt.client.docs.ExportBGColor} for an overview.
     * @param rowNum row number
     * @param record the record object behind the row being exported
     *
     * @return background color to use for the row, or null to use the default                    background color
     */
    public native String getExportRowBGColor(int rowNum, Record record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__getExportRowBGColor(rowNum, record.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret;
    }-*/;


	/**
     * Given a column number or field name, return the field definition. <P> When using {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getFields DataBinding}, the field definition may be a mix of information
     * derived from {@link com.smartgwt.client.widgets.grid.ListGrid#getFields fields} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDataSource dataSource}.
     * @param colNum number or id of the field.
     *
     * @return field definition
     */
    public native ListGridField getField(int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getField(colNum);
        if(ret == null) return null;
        return @com.smartgwt.client.widgets.grid.ListGridField::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Given a column number or field id, return the field name of a field.
     * @param colNum number or id of the field.
     *
     * @return Name of the field.
     */
    public native String getFieldName(int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getFieldName(colNum);
        return ret;
    }-*/;



	/**
     * Given a field or field id, return it's index in the fields array
     * @param fieldID field number or field.name
     *
     * @return index of the field within this.fields
     */
    public native int getFieldNum(String fieldID) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getFieldNum(fieldID);
        return ret;
    }-*/;

	/**
     * Given a field or field id, return it's index in the fields array
     * @param fieldID field number or field.name
     *
     * @return index of the field within this.fields
     */
    public native int getFieldNum(int fieldID) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getFieldNum(fieldID);
        return ret;
    }-*/;




	/**
     * Return the title of a field, specified by name or index.
     * @param fieldId name or index of the field
     *
     * @return Field title.
     */
    public native String getFieldTitle(String fieldId) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getFieldTitle(fieldId);
        return ret;
    }-*/;

	/**
     * Return the title of a field, specified by name or index.
     * @param fieldId name or index of the field
     *
     * @return Field title.
     */
    public native String getFieldTitle(int fieldId) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getFieldTitle(fieldId);
        return ret;
    }-*/;


	/**
     * Returns a numeric value for the width of some field within this <code>ListGrid</code>.
     * @param fieldNum Index or name of the field for which the width is to be determined.
     *
     * @return width of the field in px, or <code>null</code> if the width can't be determined.
     */
    public native Integer getFieldWidth(int fieldNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getFieldWidth(fieldNum);
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toInteger(I)(ret);
    }-*/;



	/**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is true, this method will
     * return the criteria currently displayed in the <code>filterEditor</code>. Note that these values may differ from the
     * criteria returned by {@link com.smartgwt.client.widgets.grid.ListGrid#getCriteria ListGrid.getCriteria()} if the filter
     * editor values have been modified without performing an actual filter.
     *
     * @return criteria currently displayed in the filterEditor
     */
    public native Criteria getFilterEditorCriteria() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getFilterEditorCriteria();
        if(ret == null) return null;
        return @com.smartgwt.client.data.Criteria::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is true, this method will
     * return the criteria currently displayed in the <code>filterEditor</code>. Note that these values may differ from the
     * criteria returned by {@link com.smartgwt.client.widgets.grid.ListGrid#getCriteria ListGrid.getCriteria()} if the filter
     * editor values have been modified without performing an actual filter.
     *
     * @return criteria currently displayed in the filterEditor
     */
    public native AdvancedCriteria getFilterEditorCriteriaAsAdvancedCriteria() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getFilterEditorCriteriaAsAdvancedCriteria();
        if(ret == null) return null;
        return @com.smartgwt.client.data.AdvancedCriteria::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;


	/**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowFilterEditor showFilterEditor} is true, this method will
     * return the criteria currently displayed in the <code>filterEditor</code>. Note that these values may differ from the
     * criteria returned by {@link com.smartgwt.client.widgets.grid.ListGrid#getCriteria ListGrid.getCriteria()} if the filter
     * editor values have been modified without performing an actual filter.
     * @param omitHiddenFields By default this method will include criteria applied to   fields, including criteria that are not actually
     * visible/editable in the filterEditor for the   grid. Pass in this parameter to get only values for visible fields
     * returned.
     *
     * @return criteria currently displayed in the filterEditor
     */
    public native Criteria getFilterEditorCriteria(Boolean omitHiddenFields) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getFilterEditorCriteria(omitHiddenFields == null ? null : omitHiddenFields.@java.lang.Boolean::booleanValue()());
        if(ret == null) return null;
        return @com.smartgwt.client.data.Criteria::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;
	
	/**
     * Get the row that currently has keyboard focus.  Arrow key navigation moves relative to this row.
     *
     * @return rowNum of the current focus row
     */
    public native Integer getFocusRow() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getFocusRow();
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toInteger(I)(ret);
    }-*/;



	/**
     * When {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is <code>true</code> this
     * method is called for each field which will show a grid summary value (as described in {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getShowGridSummary showGridSummary}) to get the summary value to display
     * below the relevant column. <P> The default implementation is as follows: <ul><li>If this is a databound grid and not all
     * data is loaded, returns null for every field</li>     <li>Otherwise if {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getGridSummary ListGridField.getGridSummary()} is defined, calls that
     * method passing         in the current data set for the grid</li>     <li>If {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getGridSummary ListGridField.getGridSummary()} is undefined, makes use of
     * the          {@link com.smartgwt.client.widgets.grid.ListGrid#getGridSummaryFunction standard summary function} for the
     * field to          calculate the summary based on the current data set</li> </ul> This method may return an array of
     * values. This implies that the grid summary should show multiple rows. Note that if a field has more than one
     * summaryFunction specified, this method will pick up values from each summary function and return them in an array,
     * meaning these summaries will show up on multiple rows in the grid. <P> This method may be overridden to completely
     * customize the summary value displayed for columns in this grid. An example use case would be when summary information is
     * available on the client and does not need to be calculated directly from the data. <P> <b>Note:</b> this method will not
     * be called if {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowDataSource summaryRowDataSource} is
     * specified.
     * @param field field for which the summary value should be returned
     *
     * @return summary value to display for the specified field.
     */
    public native Object getGridSummary(ListGridField field) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__getGridSummary(field.@com.smartgwt.client.core.DataClass::getJsObj()());
        return $wnd.SmartGWT.convertToJavaType(ret);
    }-*/;


	/**
     * This method returns the data  displayed in the  {@link com.smartgwt.client.widgets.grid.ListGrid#getSummaryRow
     * summaryRow} when {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary showGridSummary} is true. <P> By
     * default this will call {@link com.smartgwt.client.widgets.grid.ListGrid#getGridSummary ListGrid.getGridSummary()} for
     * each field and generate an array of records containing the resulting values. <P> This method   may return multiple
     * records if more than one summary row is desired.
     *
     * @return summary record(s)
     */
    public native ListGridRecord[] getGridSummaryData() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getGridSummaryData();
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfListGridRecord(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;



	/**
     * If this grid is {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByField grouped}, and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary} is true, this method will  return the 
     * group summary data displayed  at the end of the group. <P> This method may  return multiple records if more than one
     * summary row per group is desired.
     * @param records the records in the group, for which the summary values                                  are being calculated
     * @param groupNode object with specified groupValue and groupName for this group
     *
     * @return summary record(s)
     */
    public native ListGridRecord[] getGroupSummaryData(Record[] records, Record groupNode) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getGroupSummaryData(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(records), groupNode.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfListGridRecord(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;


	/**
     * If this grid {@link com.smartgwt.client.widgets.grid.ListGrid#getIsGrouped is grouped}, this method will return the
     * current selection. Unlike the standard {@link com.smartgwt.client.widgets.grid.ListGrid#getSelection getSelection
     * method}, this method will return {@link com.smartgwt.client.widgets.grid.ListGrid#isGroupNode group nodes} in addition
     * to standard {@link com.smartgwt.client.widgets.grid.ListGridRecord}s within the grid's data.
     *
     * @return Selected group header nodes and record data objects.   If this grid is not grouped, standard {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelection listGrid selection}   will be returned.
     */
    public native ListGridRecord[] getGroupTreeSelection() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getGroupTreeSelection();
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfListGridRecord(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

    /**
     * @see ListGrid#getGroupTreeSelection
     */
    public ListGridRecord[] getGroupTreeSelection(boolean excludePartialSelection){
        return getGroupTreeSelection(excludePartialSelection, false);
    }

	/**
     * If this grid {@link com.smartgwt.client.widgets.grid.ListGrid#getIsGrouped is grouped}, this method will return the
     * current selection. Unlike the standard {@link com.smartgwt.client.widgets.grid.ListGrid#getSelection getSelection
     * method}, this method will return {@link com.smartgwt.client.widgets.grid.ListGrid#isGroupNode group nodes} in addition
     * to standard {@link com.smartgwt.client.widgets.grid.ListGridRecord}s within the grid's data.
     * @param excludePartialSelection By default a group header node is considered   selected if any members of the group are selected. If this flag is passed
     * in, only   header nodes where <b>all</b> members of the group are selected will be included   in the returned results.
     * @param groupNodesOnly If this parameter is passed as <code>true</code>,    this method will return just the group header nodes from the group
     * tree. If omitted   or false, both header nodes and data records will be returned.
     *
     * @return Selected group header nodes and record data objects.   If this grid is not grouped, standard {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelection listGrid selection}   will be returned.
     */
    public native ListGridRecord[] getGroupTreeSelection(boolean excludePartialSelection, boolean groupNodesOnly) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getGroupTreeSelection(excludePartialSelection == null ? false : excludePartialSelection, groupNodesOnly == null ? false : groupNodesOnly);
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfListGridRecord(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;
	
	/**
     * If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu showHeaderContextMenu} is <code>true</code>
     * this method returns the menu items to be displayed in the default header context menu. <P> This method is called at
     * various times, including during redraws, as the mouse moves over a ListGrid header button and each time the menu is
     * actually displayed - this allows for  dynamic content depending on the current state of the grid and its fields. <P>
     * Consequently, this method should not instantiate any classes, because they'll be re-created on each call, resulting in a
     * leak - your implementation should return an array of menuItem  config-blocks only, so you shouldn't instantiate actual
     * Menu instances to apply as the  +link{menuItem.subMenu, submenu) of items - instead, set submenu to a simple array of
     * menuItems.  If your use-case necessitates that class instances are created, because specific submenus have a different
     * Menu class, for example, you should keep a reference to them and  either, if their content is dynamic, destroy and
     * recreate them with the new items, or just return the existing instances otherwise.  <P> The default set of menu items
     * includes items for built-in ListGrid features like showing  and hiding fields, freezing fields or grouping by them, and
     * other functions.
     * @param fieldNum Index of the field the user clicked in the    {@link com.smartgwt.client.widgets.grid.ListGrid#getFields fields} array.
     * <b>Note:</b> if the user right-clicked the sorter button    this parameter will be <code>null</code>.
     *
     * @return 
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    protected native MenuItem[] getHeaderContextMenuItems(Integer fieldNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__getHeaderContextMenuItems(fieldNum == null ? null : fieldNum.@java.lang.Integer::intValue()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfMenuItem(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;
	


	/**
     * Return the menus items that should be shown in a menu triggered from a {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpan}.
     * @param headerSpan the component representing the headerSpan.  This component will                            have all the properties
     * specified via {@link com.smartgwt.client.widgets.grid.ListGrid#getHeaderSpans headerSpans}.
     *
     * @return return false instead to avoid showing a menu
     */
    protected native MenuItem[] getHeaderSpanContextMenuItems(HeaderSpan headerSpan) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__getHeaderSpanContextMenuItems(headerSpan.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfMenuItem(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;




	/**
     * Return the pointer to a particular record by record number. Synonym for {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCellRecord ListGrid.getCellRecord()}.
     * @param recordNum row index of record to return.
     *
     * @return Record object for the row.
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCellRecord
     * @see com.smartgwt.client.widgets.grid.ListGrid#getEditedRecord
     */
    public native ListGridRecord getRecord(int recordNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getRecord(recordNum);
        if(ret == null) return null;
        return @com.smartgwt.client.widgets.grid.ListGridRecord::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;




	/**
     * Retrieve the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponent} currently being
     * shown at the given coordinates. <p> <code>recordComponents</code> are dynamically assigned to row/cell coordinates and,
     * depending on the {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPoolingMode
     * recordComponentPoolingMode}, any kind of redraw of the containing ListGrid (due to sort change, scrolling, editing etc)
     * may cause a <code>recordComponent</code> to be assigned to another row, {@link com.smartgwt.client.widgets.Canvas#clear
     * clear()ed} or permanently {@link com.smartgwt.client.widgets.Canvas#destroy destroy()ed}. <p> Hence you should always
     * call <code>getRecordComponent()</code> right before taking action on the <code>recordComponent</code> - don't cache the
     * component associated with row/cell coordinate.  Similarly, it's invalid to call <code>getRecordComponent()</code> during
     * a redraw (for example, from {@link com.smartgwt.client.widgets.grid.ListGridField#setCellFormatter formatting} code).
     * <p> It's always invalid to try to use a <code>recordComponent</code> outside of a ListGrid (by eg adding it to some
     * other layout). <p> If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell
     * showRecordComponentsByCell} is true and the colNum parameter is not passed, the call will return the first component in
     * the passed rowNum. <p> Returns null if there is no component at the specified coordinates.
     * @param rowNum row number to get record component for
     *
     * @return record component, or null if none is shown at these coordintes
     */
    public native Canvas getRecordComponent(int rowNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getRecordComponent(rowNum);
        return @com.smartgwt.client.widgets.Canvas::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;


	/**
     * Retrieve the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponent} currently being
     * shown at the given coordinates. <p> <code>recordComponents</code> are dynamically assigned to row/cell coordinates and,
     * depending on the {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPoolingMode
     * recordComponentPoolingMode}, any kind of redraw of the containing ListGrid (due to sort change, scrolling, editing etc)
     * may cause a <code>recordComponent</code> to be assigned to another row, {@link com.smartgwt.client.widgets.Canvas#clear
     * clear()ed} or permanently {@link com.smartgwt.client.widgets.Canvas#destroy destroy()ed}. <p> Hence you should always
     * call <code>getRecordComponent()</code> right before taking action on the <code>recordComponent</code> - don't cache the
     * component associated with row/cell coordinate.  Similarly, it's invalid to call <code>getRecordComponent()</code> during
     * a redraw (for example, from {@link com.smartgwt.client.widgets.grid.ListGridField#setCellFormatter formatting} code).
     * <p> It's always invalid to try to use a <code>recordComponent</code> outside of a ListGrid (by eg adding it to some
     * other layout). <p> If {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell
     * showRecordComponentsByCell} is true and the colNum parameter is not passed, the call will return the first component in
     * the passed rowNum. <p> Returns null if there is no component at the specified coordinates.
     * @param rowNum row number to get record component for
     * @param colNum optional column number to get the record component for
     *
     * @return record component, or null if none is shown at these coordintes
     */
    public native Canvas getRecordComponent(int rowNum, Integer colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getRecordComponent(rowNum, colNum == null ? null : colNum.@java.lang.Integer::intValue()());
        return @com.smartgwt.client.widgets.Canvas::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;
	
	/**
     * Returns the {@link com.smartgwt.client.types.RecordDropPosition} for some record drop operation. This value is passed to
     * the {@link com.smartgwt.client.widgets.grid.ListGrid#recordDrop ListGrid.recordDrop()} event notification method. <P>
     * Default implementation determines the position to return based on the specified {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordDropAppearance recordDropAppearance} for the grid and the {@link
     * com.smartgwt.client.util.EventHandler#getY y-coordinate of the drop event}.
     *
     * @return record drop position.
     */
    public native RecordDropPosition getRecordDropPosition() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getRecordDropPosition();
        if(ret == null) return null;
        var enumValues = @com.smartgwt.client.types.RecordDropPosition::values()();
        return @com.smartgwt.client.util.EnumUtil::getEnum([Lcom/smartgwt/client/types/ValueEnum;Ljava/lang/String;)(enumValues, ret);
    }-*/;



	/**
     * Get the index of the provided record. <P> This is essentially the same as calling listGrid.data.indexOf(record), except
     * that the currently visible range of records is checked first.  This is important for responsiveness in functions that
     * respond to user actions when the user is working near the end of a very large dataset (eg 500k records).
     * @param record the record whose index is to be retrieved
     *
     * @return index of the record, or -1 if not found
     */
    public native int getRecordIndex(ListGridRecord record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getRecordIndex(record.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret;
    }-*/;




	/**
     * Returns the {@link com.smartgwt.client.data.DataSource} containing data related to the passed record.  Used when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true and {@link
     * com.smartgwt.client.types.ExpansionMode} is "related". The default implementation returns the DataSource specified in
     * {@link com.smartgwt.client.widgets.grid.ListGridRecord#getDetailDS detailDS} if set, otherwise {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDetailDS detailDS}.
     * @param record The record to get the Related dataSource for.
     *
     * @return The related DataSource for the "record" param
     */
    public native DataSource getRelatedDataSource(ListGridRecord record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__getRelatedDataSource(record.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.data.DataSource::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;




	/**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollOverCanvas rollOverCanvas} is enabled, this method will
     * be called to create the canvas to display over the current row or cell when a user moves their mouse over the row. <p>
     * Note that for efficiency this should not typically create a new Canvas every time that it is called. Instead typically a
     * single rollOver canvas should be created and updated to reflect the current rollOver row if necessary. <p> Return null
     * to avoid showing a <code>rollOverCanvas</code> for this row. <p> <b>Note: This is an override point.</b>
     * @param rowNum index of the current rollOver row.
     * @param colNum index of the current rollOver column. This parameter will be null unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers useCellRollOvers} is true for the grid.
     *
     * @return the embedded component
     */
    protected native Canvas getRollOverCanvas(Integer rowNum, Integer colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__getRollOverCanvas(rowNum == null ? null : rowNum.@java.lang.Integer::intValue()(), colNum == null ? null : colNum.@java.lang.Integer::intValue()());
        return @com.smartgwt.client.widgets.Canvas::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;




	/**
     * If the {@link com.smartgwt.client.widgets.grid.ListGrid#getRollUnderCanvas rollUnderCanvas} is enabled, this method will
     * be called to create the canvas to display under the current row or cell when a user moves their mouse over the row. <p>
     * Note that for efficiency this should not typically create a new Canvas every time that it is called. Instead typically a
     * single rollUnder canvas should be created and updated to reflect the current rollOver row if necessary. <p> Return null
     * to avoid showing a <code>rollUnderCanvas</code> for this row. <p> <b>Note: This is an override point.</b>
     * @param rowNum index of the current rollOver row.
     * @param colNum index of the current rollOver column. This parameter will be null unless {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUseCellRollOvers useCellRollOvers} is true for the grid.
     *
     * @return the embedded component
     */
    protected native Canvas getRollUnderCanvas(Integer rowNum, Integer colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__getRollUnderCanvas(rowNum == null ? null : rowNum.@java.lang.Integer::intValue()(), colNum == null ? null : colNum.@java.lang.Integer::intValue()());
        return @com.smartgwt.client.widgets.Canvas::getByJSObject(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;




	/**
     * Returns any currently stored validation errors for this row in the following format:<br> 
     * &nbsp;&nbsp;<code>{fieldName:[array of error messages], ...}</code>
     * @param rowNum index of row to check for validation errors.
     *
     * @return object showing validation error arrays by field for the row passed in                      - if no validation errors
     * stored for the row, null is returned.
     * @see com.smartgwt.client.widgets.grid.ListGrid#getCellErrors
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public native Map getRowErrors(int rowNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getRowErrors(rowNum);
        return @com.smartgwt.client.util.JSOHelper::convertToMap(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;




	/**
     * Return the height this row should be.  Default is this.cellHeight. If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getFixedRecordHeights fixedRecordHeights} is false, the row may be rendered
     * taller than this specified size. <P> If records will be variable height, you should switch on {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getVirtualScrolling virtualScrolling}. <P> Note if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getAllowRowSpanning row spanning} is enabled, this method should return the
     * height of a single row (with rowSpan set to 1).
     * @param record cell record as returned by getCellRecord
     * @param rowNum row number
     *
     * @return height in pixels
     */
    public native int getRowHeight(ListGridRecord record, int rowNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.__getRowHeight(record != null ? record.@com.smartgwt.client.core.DataClass::getJsObj()() : null, rowNum);
        return ret;
    }-*/;




	/**
     * Synonym of {@link com.smartgwt.client.widgets.grid.ListGrid#getRecordIndex getRecordIndex()}.
     * @param record the record whose index is to be retrieved
     *
     * @return index of the record, or -1 if not found
     */
    public native int getRowNum(ListGridRecord record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getRowNum(record.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret;
    }-*/;




	/**
     * Returns the Y-coordinate for a given row number as a page-relative coordinate.  See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowTop ListGrid.getRowTop()}.
     * @param rowNum 
     *
     * @return Y-coordinate
     * @see com.smartgwt.client.docs.Positioning Positioning overview and related methods
     */
    public native int getRowPageTop(int rowNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getRowPageTop(rowNum);
        return ret;
    }-*/;




	/**
     * Returns the top coordinate for a given row number, relative to the top of body content.  Use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowPageTop ListGrid.getRowPageTop()} for a page-relative coordinate. <P>
     * This method is reliable only for rows that are currently drawn, which is generally only rows that are visible in the
     * viewport.  If row heights vary (see <code>fixedRowHeights</code>), coordinates for rows that are not currently shown are
     * rough approximations.
     * @param rowNum 
     *
     * @return Y-coordinate
     * @see com.smartgwt.client.docs.Positioning Positioning overview and related methods
     */
    public native int getRowTop(int rowNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getRowTop(rowNum);
        return ret;
    }-*/;


	/**
     * Returns the first selected record in this grid. <p> This method is appropriate if the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelectionType selectionType} is  {@link
     * com.smartgwt.client.types.SelectionStyle#SINGLE}, or if you only care about the first selected record in a
     * multiple-record selection. To access all selected records, use {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSelection ListGrid.getSelection()} instead. <p> <strong>NOTE:</strong> If a
     * record is returned, it should be treated as read-only and not modified.
     *
     * @return the first selected record, or null if no record is selected.
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_dataoperations_remove" target="examples">Databound remove Example</a>
     */
    public native ListGridRecord getSelectedRecord() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getSelectedRecord();
        if(ret == null) return null;
        return @com.smartgwt.client.widgets.grid.ListGridRecord::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Returns all selected records in this grid. <p> <strong>NOTE:</strong> Records in the returned array should be treated as
     * read-only and not modified.
     *
     * @return array of selected records, which will be empty if no record is selected.
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public native ListGridRecord[] getSelectedRecords() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getSelectedRecords();
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfListGridRecord(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Returns all selected records in this grid. <p> <strong>NOTE:</strong> Records in the returned array should be treated as
     * read-only and not modified.
     * @param excludePartialSelections When true, partially selected records will not be returned.                                   Otherwise, both fully and
     * partially selected records are                                   returned.
     *
     * @return array of selected records, which will be empty if no record is selected.
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public native ListGridRecord[] getSelectedRecords(boolean excludePartialSelections) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getSelectedRecords(excludePartialSelections == null ? false : excludePartialSelections);
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfListGridRecord(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;
	
	/**
     * Returns the current {@link com.smartgwt.client.data.SortSpecifier SortSpecifiers} for this ListGrid. Will return null if
     * this grid has never been sorted (and has no specified {@link com.smartgwt.client.widgets.grid.ListGrid#getInitialSort
     * initialSort} or {@link com.smartgwt.client.widgets.grid.ListGrid#getSortField sortField}). <P> Note that if sorting was
     * applied via {@link com.smartgwt.client.widgets.grid.ListGrid#sort ListGrid.sort()} [rather than {@link
     * com.smartgwt.client.widgets.grid.ListGrid#setSort ListGrid.setSort()}] the sortSpecifiers returned will have been
     * created based on the specified sort field / direction passed into {@link com.smartgwt.client.widgets.grid.ListGrid#sort
     * ListGrid.sort()}.
     *
     * @return current sort specifiers for this grid (may be null if  this grid is unsorted).
     */
    public native SortSpecifier[] getSort() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getSort();
        if(ret == null) return null;
        return @com.smartgwt.client.util.ConvertTo::arrayOfSortSpecifier(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Returns the number of fields involved in this grid's current sort configuration.
     *
     * @return the number of fields this grid is currently sorted on.
     */
    public native int getSortFieldCount() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getSortFieldCount();
        return ret;
    }-*/;



	/**
     * When multiple fields are sorted, this method returns the HTML for the sort-numeral that appears after the sort-arrows in
     * the header-buttons of sorted fields.  If you don't want sort-numerals in the header-buttons, you can override this
     * method to return null or an empty string, or set {@link com.smartgwt.client.widgets.grid.ListGrid#getShowSortNumerals
     * showSortNumerals} to false. <P> Note that the sortIndex passed in is zero based. The default implementation of this
     * method returns an HTML element with the {@link com.smartgwt.client.widgets.grid.ListGrid#getSortNumeralStyle
     * sortNumeralStyle} applied to it, containing the specified sortIndex incremented by 1 (therefore showing the more
     * user-friendly 1-based numbering system).
     * @param fieldName The name of a sort-field to get the  {@link com.smartgwt.client.widgets.grid.ListGrid#getSortNumeralStyle sortNumeral}
     * HTML for.
     * @param sortIndex The sort index for the field.
     *
     * @return The HTML for this field's sortNumeral
     */
    public native String getSortNumeralHTML(String fieldName, int sortIndex) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getSortNumeralHTML(fieldName, sortIndex);
        return ret;
    }-*/;




	/**
     * Returns the {@link com.smartgwt.client.data.SortSpecifier} for the passed fieldName, or null if the field is not sorted.
     * @param fieldName The name of a field, visible, hidden or existing only in the dataSource
     *
     * @return for the passed fieldName, or null if the field is not sorted.
     */
    public native SortSpecifier getSortSpecifier(String fieldName) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getSortSpecifier(fieldName);
        if(ret == null) return null;
        return @com.smartgwt.client.data.SortSpecifier::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;




	/**
     * Get the computed value of a {@link com.smartgwt.client.widgets.grid.ListGrid#getCanAddSummaryFields summary field}.
     * @param field field that has a summary format
     * @param record record to use to compute formula value
     *
     * @return formula result
     */
    public native String getSummaryFieldValue(ListGridField field, Record record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getSummaryFieldValue(field.@com.smartgwt.client.core.DataClass::getJsObj()(), record.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret;
    }-*/;




	/**
     * If we're showing a {@link com.smartgwt.client.widgets.grid.ListGrid#getShowHeaderContextMenu headerContextMenu} for this
     * grid and {@link com.smartgwt.client.widgets.grid.ListGrid#getCanFreezeFields this.canFreezeFields} is true, this string
     * will be shown as the title for the menu item to toggle whether a field is frozen or unfrozen. <P> Default implementation
     * evaluates and returns {@link com.smartgwt.client.widgets.grid.ListGrid#getFreezeFieldText freezeFieldText} or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getUnfreezeFieldText unfreezeFieldText} depending on whether the field is
     * currently frozen.
     * @param field field to get the menu item title for
     *
     * @return Title to show in the menu item
     */
    public native String getToggleFreezeText(ListGridField field) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.getToggleFreezeText(field.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret;
    }-*/;


    /**
     * Add a groupByComplete handler.
     * <p>
     * Callback fired when the listGrid is grouped or ungrouped. <P> Unlike {@link
     * com.smartgwt.client.widgets.grid.ListGrid#addGroupByHandler ListGrid.groupBy()}, this notification will fire when
     * grouping is complete, and the {@link com.smartgwt.client.widgets.grid.ListGrid#getData data} object has been updated. On
     * successful grouping the <code>fields</code> argument will list the new  grouping and the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupTree groupTree} will have been updated to reflect the grouped data.
     * <P> Note that the <code>fields</code> argument may be an empty array if the data is not grouped. This implies that a
     * user or developer explicitly ungrouped the grid, or that a groupBy attempt failed due to the data length exceeding 
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupByMaxRecords groupByMaxRecords}.
     *
     * @param handler the groupByComplete handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addGroupByCompleteHandler(com.smartgwt.client.widgets.grid.events.GroupByCompleteHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.GroupByCompleteEvent.getType()) == 0) setupGroupByCompleteEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.GroupByCompleteEvent.getType());
    }

    private native void setupGroupByCompleteEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var groupByComplete = $entry(function(){
            var param = {"fields" : arguments[0]};
            var event = @com.smartgwt.client.widgets.grid.events.GroupByCompleteEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            if (hasDefaultHandler) this.Super("groupByComplete", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("groupByComplete"));
            obj.addProperties({groupByComplete:  groupByComplete              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("groupByComplete"));
            obj.groupByComplete =  groupByComplete             ;
        }
   }-*/;
    /**
     * Add a groupStateChanged handler.
     * <p>
     * Notification method executed whenever the groupState of this grid changes. Group state is accessible via {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getGroupState ListGrid.getGroupState()}, and contains group state information.
     *
     * @param handler the groupStateChanged handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addGroupStateChangedHandler(com.smartgwt.client.widgets.grid.events.GroupStateChangedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.GroupStateChangedEvent.getType()) == 0) setupGroupStateChangedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.GroupStateChangedEvent.getType());
    }

    private native void setupGroupStateChangedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var groupStateChanged = $entry(function(){
            var param = {};
            var event = @com.smartgwt.client.widgets.grid.events.GroupStateChangedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            if (hasDefaultHandler) this.Super("groupStateChanged", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("groupStateChanged"));
            obj.addProperties({groupStateChanged:  groupStateChanged              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("groupStateChanged"));
            obj.groupStateChanged =  groupStateChanged             ;
        }
   }-*/;
    /**
     * Add a groupBy handler.
     * <p>
     * Callback fired when the user attempts to group or ungroup the listGrid, or when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#groupBy ListGrid.groupBy()} is called programmatically.  This event may be
     * cancelled. <P> This notification is fired before the {@link com.smartgwt.client.widgets.grid.ListGrid#getGroupTree data}
     * is updated to reflect the grouping. See also {@link com.smartgwt.client.widgets.grid.ListGrid#addGroupByCompleteHandler
     * ListGrid.groupByComplete()}.
     *
     * @param handler the groupBy handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addGroupByHandler(com.smartgwt.client.widgets.grid.events.GroupByHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.GroupByEvent.getType()) == 0) setupGroupByEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.GroupByEvent.getType());
    }

    private native void setupGroupByEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var handleGroupBy = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.GroupByEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("handleGroupBy"));
            obj.addProperties({handleGroupBy: 
                function () {
                    var param = {"fields" : arguments[0]};
                    var ret = handleGroupBy(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("handleGroupBy", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("handleGroupBy"));
            obj.handleGroupBy = 
                function () {
                    var param = {"fields" : arguments[0]};
                    var ret = handleGroupBy(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("handleGroupBy", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
	/**
     * Whether the grid as a whole has any unsaved edits, in any row. Note that this method will return true if any rows are
     * {@link com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved marked as removed} in addition to any rows that have
     * pending unsaved edits.
     *
     * @return returns true of any unsaved edits are present
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native Boolean hasChanges() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.hasChanges();
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;

	/**
     * Does this grid currently have errors associated with editValues for any row in the grid.
     *
     * @return true if there are unresolved errors, false otherwise
     * @see com.smartgwt.client.widgets.grid.ListGrid#rowHasErrors
     * @see com.smartgwt.client.widgets.grid.ListGrid#cellHasErrors
     * @see com.smartgwt.client.docs.GridValidation GridValidation overview and related methods
     */
    public native Boolean hasErrors() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.hasErrors();
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;

    /**
     * Add a headerDoubleClick handler.
     * <p>
     * Handle a double click in the list header. <P> By default, calls {@link
     * com.smartgwt.client.widgets.grid.ListGrid#autoFitField ListGrid.autoFitField()} if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanAutoFitFields canAutoFitFields} is true and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getHeaderAutoFitEvent headerAutoFitEvent} is <code>"doubleClick"</code>.
     *
     * @param handler the headerDoubleClick handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addHeaderDoubleClickHandler(com.smartgwt.client.widgets.grid.events.HeaderDoubleClickHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.HeaderDoubleClickEvent.getType()) == 0) setupHeaderDoubleClickEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.HeaderDoubleClickEvent.getType());
    }

    private native void setupHeaderDoubleClickEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var headerDoubleClick = $entry(function(){
            var param = {"fieldNum" : arguments[0]};
            var event = @com.smartgwt.client.widgets.grid.events.HeaderDoubleClickEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            if (hasDefaultHandler) this.Super("headerDoubleClick", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("headerDoubleClick"));
            obj.addProperties({headerDoubleClick:  headerDoubleClick              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("headerDoubleClick"));
            obj.headerDoubleClick =  headerDoubleClick             ;
        }
   }-*/;
    /**
     * Add a headerHover handler.
     * <p>
     * Handle a hover over a button in the header.
     *
     * @param handler the headerHover handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addHeaderHoverHandler(com.smartgwt.client.widgets.grid.events.HeaderHoverHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.HeaderHoverEvent.getType()) == 0) setupHeaderHoverEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.HeaderHoverEvent.getType());
    }

    private native void setupHeaderHoverEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var headerHover = $entry(function(){
            var param = {"fieldNum" : arguments[0]};
            var event = @com.smartgwt.client.widgets.grid.events.HeaderHoverEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            if (hasDefaultHandler) this.Super("headerHover", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("headerHover"));
            obj.addProperties({headerHover:  headerHover              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("headerHover"));
            obj.headerHover =  headerHover             ;
        }
   }-*/;


	/**
     * Returns the HTML that is displayed by the default {@link com.smartgwt.client.widgets.grid.ListGrid#addHeaderHoverHandler
     * headerHover} handler. Return null or an empty string to cancel the hover. <p>Use <code>setHeaderHoverFormatter()</code>
     * to provide a custom implementation.
     * @param fieldNum field number for the header that was hovered
     * @param defaultHTML the HTML that would have been displayed by default. See {@link com.smartgwt.client.docs.HTMLString HTMLString}
     *
     * @return HTML to be displayed in the hover. If null or an empty string, then the hover is canceled.
     * @see com.smartgwt.client.widgets.grid.ListGrid#getShowClippedHeaderTitlesOnHover
     * @see com.smartgwt.client.widgets.grid.ListGrid#getClipHeaderTitles
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public native String headerHoverHTML(int fieldNum, String defaultHTML) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.headerHoverHTML(fieldNum, defaultHTML);
        return ret;
    }-*/;




	/**
     * Is the field title for the specified field clipped?
     * @param fieldNum field number for the header button title to test
     *
     * @return whether the field title for the specified field is clipped
     * @see com.smartgwt.client.widgets.grid.ListGrid#getClipHeaderTitles
     * @see com.smartgwt.client.docs.GridHeader GridHeader overview and related methods
     */
    public native boolean headerTitleClipped(int fieldNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.headerTitleClipped(fieldNum);
        return ret;
    }-*/;


	/**
     * Force a field to be hidden.<br><br> NOTE: If a field.showIf expression exists, it will be destroyed. <P> Note also that
     * if multiple fields are to be hidden it is more efficient to call {@link
     * com.smartgwt.client.widgets.grid.ListGrid#hideFields ListGrid.hideFields()} passing in the array of fields to hide
     * rather than to call this method repeatedly. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDiscardEditsOnHideField discardEditsOnHideField} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDropCriteriaOnHideField dropCriteriaOnHideField} for behavior when hiding
     * fields while {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit editing}.
     * @param field field to hide
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_columnorder" target="examples">Column order Example</a>
     */
    public native void hideField(String field) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.hideField(field);
    }-*/;

	/**
     * Force a field to be hidden.<br><br> NOTE: If a field.showIf expression exists, it will be destroyed. <P> Note also that
     * if multiple fields are to be hidden it is more efficient to call {@link
     * com.smartgwt.client.widgets.grid.ListGrid#hideFields ListGrid.hideFields()} passing in the array of fields to hide
     * rather than to call this method repeatedly. <P> See {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDiscardEditsOnHideField discardEditsOnHideField} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getDropCriteriaOnHideField dropCriteriaOnHideField} for behavior when hiding
     * fields while {@link com.smartgwt.client.widgets.grid.ListGrid#getCanEdit editing}.
     * @param field field to hide
     * @param suppressRelayout if passed, don't relayout non-explicit sized fields                                      to fit the available space
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_appearance_columnorder" target="examples">Column order Example</a>
     */
    public native void hideField(String field, boolean suppressRelayout) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.hideField(field, suppressRelayout == null ? false : suppressRelayout);
    }-*/;
	


	/**
     * Force an array of fields to be hidden. <P> NOTE: If a field.showIf expression exists, it will be destroyed. <P> When
     * hiding multiple fields, this method should be called rather than calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#hideField ListGrid.hideField()} repeatedly for each field to hide.
     * @param fields fields to hide
     */
    public native void hideFields(String... fields) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.hideFields(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(fields));
    }-*/;

	/**
     * Force an array of fields to be hidden. <P> NOTE: If a field.showIf expression exists, it will be destroyed. <P> When
     * hiding multiple fields, this method should be called rather than calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#hideField ListGrid.hideField()} repeatedly for each field to hide.
     * @param fields fields to hide
     */
    public native void hideFields(ListGridField... fields) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.hideFields(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(fields));
    }-*/;


	/**
     * Force an array of fields to be hidden. <P> NOTE: If a field.showIf expression exists, it will be destroyed. <P> When
     * hiding multiple fields, this method should be called rather than calling {@link
     * com.smartgwt.client.widgets.grid.ListGrid#hideField ListGrid.hideField()} repeatedly for each field to hide.
     * @param fields fields to hide
     * @param suppressRelayout if passed, don't relayout non-explicit sized fields                                      to fit the available space
     */
    public native void hideFields(String[] fields, boolean suppressRelayout) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.hideFields(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(fields), suppressRelayout == null ? false : suppressRelayout);
    }-*/;
	
    /**
     * Add a hilitesChanged handler.
     * <p>
     * Notification method executed whenever the end user uses the HiliteEditor to change the set of hilites applied to this
     * grid.  This method will not be called after a purely programmatic change to the hilites made with a call to {@link
     * com.smartgwt.client.widgets.DataBoundComponent#setHilites setHilites()}.  The array of currently applied hilite objects
     * is accessible via {@link com.smartgwt.client.widgets.DataBoundComponent#getHilites getHilites()}.
     *
     * @param handler the hilitesChanged handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addHilitesChangedHandler(com.smartgwt.client.widgets.grid.events.HilitesChangedHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.HilitesChangedEvent.getType()) == 0) setupHilitesChangedEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.HilitesChangedEvent.getType());
    }

    private native void setupHilitesChangedEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var hilitesChanged = $entry(function(){
            var param = {};
            var event = @com.smartgwt.client.widgets.grid.events.HilitesChangedEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            if (hasDefaultHandler) this.Super("hilitesChanged", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("hilitesChanged"));
            obj.addProperties({hilitesChanged:  hilitesChanged              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("hilitesChanged"));
            obj.hilitesChanged =  hilitesChanged             ;
        }
   }-*/;
	/**
     * Invalidates the currently visible set of {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents
     * recordComponents} and gets fresh ones for the visible rows in the grid according to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPoolingMode recordComponentPoolingMode} <P> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#refreshRecordComponent ListGrid.refreshRecordComponent()} which allows you to
     * refresh a specific recordComponent
     */
    public native void invalidateRecordComponents() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.invalidateRecordComponents();
    }-*/;



	/**
     * Identifies whether the passed-in field is the specially generated {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCheckboxField checkboxField} used when {@link
     * com.smartgwt.client.types.SelectionAppearance} is "checkbox".  Use this method in your custom event handlers to avoid
     * inappropriately performing actions when the checkboxField is clicked on.
     * @param field field to test
     *
     * @return whether the provided field is the checkbox field
     */
    public native Boolean isCheckboxField(ListGridField field) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.isCheckboxField(field.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;




	/**
     * Whether a given {@link com.smartgwt.client.widgets.grid.ListGridRecord record} is expanded or collapsed.
     * @param record record in question
     *
     * @return true if the node is expanded
     */
    public native Boolean isExpanded(ListGridRecord record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.isExpanded(record.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;




	/**
     * Identifies whether the passed-in field is the specially generated {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getExpansionField expansionField} used when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanExpandRecords canExpandRecords} is true.  Use this method in your custom
     * event handlers to avoid inappropriately performing actions when the expansionField is clicked on.
     * @param field field to test
     *
     * @return whether the provided field is the expansion field
     */
    public native Boolean isExpansionField(ListGridField field) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.isExpansionField(field.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;




	/**
     * If this listGrid is {@link com.smartgwt.client.widgets.grid.ListGrid#groupBy grouped}, is the record passed in a group
     * header node.
     * @param record record to test
     *
     * @return returns true if the record passed in is a group header node
     */
    public native boolean isGroupNode(ListGridRecord record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        if(record==null){return false};
        var ret = self.isGroupNode(record.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret;
    }-*/;




	/**
     * When using tree-oriented selection modes like {@link com.smartgwt.client.widgets.tree.TreeGrid#getCascadeSelection
     * cascadeSelection}, returns true if the record is considered partially selected because only some of it's children are
     * selected.
     * @param record record to check
     *
     * @return true if record is partially selected; false otherwise
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public native Boolean isPartiallySelected(ListGridRecord record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.isPartiallySelected(record.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;




	/**
     * Identifies whether the passed-in field is the specially generated {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRowNumberField rowNumberField} used when {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRowNumbers showRowNumbers} is true.  Use this method in your custom
     * event handlers to avoid inappropriately performing actions when the rowNumberField is clicked on.
     * @param field field to test
     *
     * @return whether the provided field is the rowNumberField
     */
    public native Boolean isRowNumberField(ListGridField field) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.isRowNumberField(field.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;




	/**
     * Returns true if the record is selected.
     * @param record record to check
     *
     * @return true if record is selected; false otherwise
     * @see com.smartgwt.client.docs.Selection Selection overview and related methods
     */
    public native Boolean isSelected(ListGridRecord record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.isSelected(record.@com.smartgwt.client.core.DataClass::getJsObj()());
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;




	/**
     * Returns true if the passed fieldName is in the current sort-specification.
     * @param fieldName The name of a field, visible, hidden or existing only in the dataSource
     *
     * @return True if the passed field is sorted, false otherwise
     */
    public native Boolean isSortField(String fieldName) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.isSortField(fieldName);
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;


	/**
     * Marks the widget as "dirty" so that it will be added to a queue for redraw. Redraw of dirty components is handled by a
     * looping timer and will after a very short delay (typically less than 100ms). In most cases it is recommended that
     * developers use <code>markForRedraw()</code> instead of calling {@link com.smartgwt.client.widgets.Canvas#redraw
     * Canvas.redraw()} directly. Since this method queues the redraw, multiple calls to markForRedraw() within a single thread
     * of execution will only lead to a single DOM manipulation which greatly improves application performance.
     * @see com.smartgwt.client.docs.Drawing Drawing overview and related methods
     */
    public native void markForRedraw() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.markForRedraw();
    }-*/;

	/**
     * Marks the widget as "dirty" so that it will be added to a queue for redraw. Redraw of dirty components is handled by a
     * looping timer and will after a very short delay (typically less than 100ms). In most cases it is recommended that
     * developers use <code>markForRedraw()</code> instead of calling {@link com.smartgwt.client.widgets.Canvas#redraw
     * Canvas.redraw()} directly. Since this method queues the redraw, multiple calls to markForRedraw() within a single thread
     * of execution will only lead to a single DOM manipulation which greatly improves application performance.
     * @param reason reason for performing the redraw
     * @see com.smartgwt.client.docs.Drawing Drawing overview and related methods
     */
    public native void markForRedraw(String reason) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.markForRedraw(reason);
    }-*/;
	


	/**
     * Marks a record deleted such that a later call to {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits
     * ListGrid.saveEdits()} or {@link com.smartgwt.client.widgets.grid.ListGrid#saveAllEdits ListGrid.saveAllEdits()} will
     * cause a "remove" {@link com.smartgwt.client.data.DSRequest} to be submitted. <P> A removed record is disabled and
     * non-editable, and uses {@link com.smartgwt.client.widgets.grid.ListGrid#getRemovedCSSText removedCSSText} for its CSS
     * style, which by default will show strikethrough text. <P> Contrast this method with removeSelectedData(), which
     * immediately submits a DSRequest to remove the selected records from the dataset. <P> Records that have been marked for
     * removal using this method may be 'unmarked' via a call to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#unmarkRecordRemoved ListGrid.unmarkRecordRemoved()}, or by discarding edit
     * values ({@link com.smartgwt.client.widgets.grid.ListGrid#discardEdits ListGrid.discardEdits()}).
     * @param rowNum row number for the record to mark
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void markRecordRemoved(int rowNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.markRecordRemoved(rowNum);
    }-*/;




	/**
     * Marks an array of records deleted such that a later call to {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits
     * ListGrid.saveEdits()} or  {@link com.smartgwt.client.widgets.grid.ListGrid#saveAllEdits ListGrid.saveAllEdits()} will
     * cause a "remove" {@link com.smartgwt.client.data.DSRequest} to be submitted. <P> This method is similar to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved ListGrid.markRecordRemoved()} but should be more efficient
     * in avoiding unneeded duplicate refreshes due to the multiple records getting marked.
     * @param records records or indices to mark removed
     * @see com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void markRecordsRemoved(ListGridRecord... records) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.markRecordsRemoved(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(records));
    }-*/;

	/**
     * Marks an array of records deleted such that a later call to {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits
     * ListGrid.saveEdits()} or  {@link com.smartgwt.client.widgets.grid.ListGrid#saveAllEdits ListGrid.saveAllEdits()} will
     * cause a "remove" {@link com.smartgwt.client.data.DSRequest} to be submitted. <P> This method is similar to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved ListGrid.markRecordRemoved()} but should be more efficient
     * in avoiding unneeded duplicate refreshes due to the multiple records getting marked.
     * @param records records or indices to mark removed
     * @see com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void markRecordsRemoved(int records) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.markRecordsRemoved(records);
    }-*/;

	/**
     * Marks an array of records deleted such that a later call to {@link com.smartgwt.client.widgets.grid.ListGrid#saveEdits
     * ListGrid.saveEdits()} or  {@link com.smartgwt.client.widgets.grid.ListGrid#saveAllEdits ListGrid.saveAllEdits()} will
     * cause a "remove" {@link com.smartgwt.client.data.DSRequest} to be submitted. <P> This method is similar to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved ListGrid.markRecordRemoved()} but should be more efficient
     * in avoiding unneeded duplicate refreshes due to the multiple records getting marked.
     * @param records records or indices to mark removed
     * @see com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void markRecordsRemoved(RecordList records) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.markRecordsRemoved(records == null ? null : records.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()());
    }-*/;


	/**
     * Marks the currently selected records as removed, as though {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved ListGrid.markRecordRemoved()} had been called.
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native void markSelectionRemoved() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.markSelectionRemoved();
    }-*/;

    /**
     * Add a bodyKeyPress handler.
     * <p>
     * Handle a keyPress event on the body. <P> Default implementation handles navigating between records with arrow keys, and
     * activating records with space and enter.
     *
     * @param handler the bodyKeyPress handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addBodyKeyPressHandler(com.smartgwt.client.widgets.grid.events.BodyKeyPressHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.BodyKeyPressEvent.getType()) == 0) setupBodyKeyPressEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.BodyKeyPressEvent.getType());
    }

    private native void setupBodyKeyPressEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var onBodyKeyPress = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.BodyKeyPressEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("onBodyKeyPress"));
            obj.addProperties({onBodyKeyPress: 
                function () {
                    var param = {};
                    var ret = onBodyKeyPress(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("onBodyKeyPress", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("onBodyKeyPress"));
            obj.onBodyKeyPress = 
                function () {
                    var param = {};
                    var ret = onBodyKeyPress(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("onBodyKeyPress", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
    /**
     * Add a recordCollapse handler.
     * <p>
     * Handler fired when a record is collapsed in a grid with <code>canExpandRecords</code> set to true. Allows the collapse
     * to be cancelled.
     *
     * @param handler the recordCollapse handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addRecordCollapseHandler(com.smartgwt.client.widgets.grid.events.RecordCollapseHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.RecordCollapseEvent.getType()) == 0) setupRecordCollapseEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.RecordCollapseEvent.getType());
    }

    private native void setupRecordCollapseEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var onCollapseRecord = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.RecordCollapseEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("onCollapseRecord"));
            obj.addProperties({onCollapseRecord: 
                function () {
                    var param = {"record" : arguments[0]};
                    var ret = onCollapseRecord(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("onCollapseRecord", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("onCollapseRecord"));
            obj.onCollapseRecord = 
                function () {
                    var param = {"record" : arguments[0]};
                    var ret = onCollapseRecord(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("onCollapseRecord", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
    /**
     * Add a recordExpand handler.
     * <p>
     * Handler fired when a record is expanded in a grid with <code>canExpandRecords</code> set to true. Allows the expansion
     * to be cancelled.
     *
     * @param handler the recordExpand handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addRecordExpandHandler(com.smartgwt.client.widgets.grid.events.RecordExpandHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.RecordExpandEvent.getType()) == 0) setupRecordExpandEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.RecordExpandEvent.getType());
    }

    private native void setupRecordExpandEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var onExpandRecord = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.RecordExpandEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("onExpandRecord"));
            obj.addProperties({onExpandRecord: 
                function () {
                    var param = {"record" : arguments[0]};
                    var ret = onExpandRecord(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("onExpandRecord", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("onExpandRecord"));
            obj.onExpandRecord = 
                function () {
                    var param = {"record" : arguments[0]};
                    var ret = onExpandRecord(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("onExpandRecord", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
    /**
     * Add a headerClick handler.
     * <p>
     * Handler fired when the user clicks a header in this listGrid before any other processing occurs. Call {@link
     * com.smartgwt.client.widgets.grid.events.HeaderClickEvent#cancel()} from within {@link
     * com.smartgwt.client.widgets.grid.events.HeaderClickHandler#onHeaderClick} to suppress the default header click handling
     *
     * @param handler the headerClick handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addHeaderClickHandler(com.smartgwt.client.widgets.grid.events.HeaderClickHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.HeaderClickEvent.getType()) == 0) setupHeaderClickEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.HeaderClickEvent.getType());
    }

    private native void setupHeaderClickEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var onHeaderClick = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.HeaderClickEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("onHeaderClick"));
            obj.addProperties({onHeaderClick: 
                function () {
                    var param = {"fieldNum" : arguments[0]};
                    var ret = onHeaderClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("onHeaderClick", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("onHeaderClick"));
            obj.onHeaderClick = 
                function () {
                    var param = {"fieldNum" : arguments[0]};
                    var ret = onHeaderClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("onHeaderClick", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
    /**
     * Add a recordClick handler.
     * <p>
     * Executed when the listGrid receives a 'click' event on an enabled, non-separator record. The default implementation does
     * nothing -- override to perform some action when any record or field is clicked.<br> A record event handler can be
     * specified either as a function to execute, or as a string of script to evaluate. If the handler is defined as a string
     * of script, all the parameters below will be available as variables for use in the script.<br> To do something specific
     * if a particular field is clicked, add a recordClick method or string of script to that field (same parameters) when
     * you're setting up the list.<br> <b>Notes:</b><ul> <li>This will not be called if the click is below the last item of the
     * list.</li> <li>This method is called from the default implementation of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#rowClick ListGrid.rowClick()}, so if that method is overridden this method may
     * not be fired.</li></ul>
     *
     * @param handler the recordClick handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addRecordClickHandler(com.smartgwt.client.widgets.grid.events.RecordClickHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.RecordClickEvent.getType()) == 0) setupRecordClickEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.RecordClickEvent.getType());
    }

    private native void setupRecordClickEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var onRecordClick = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.RecordClickEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("onRecordClick"));
            obj.addProperties({onRecordClick: 
                function () {
                    var param = {"viewer" : arguments[0], "record" : arguments[1], "recordNum" : arguments[2], "field" : arguments[3], "fieldNum" : arguments[4], "value" : arguments[5], "rawValue" : arguments[6]};
                    var ret = onRecordClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("onRecordClick", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("onRecordClick"));
            obj.onRecordClick = 
                function () {
                    var param = {"viewer" : arguments[0], "record" : arguments[1], "recordNum" : arguments[2], "field" : arguments[3], "fieldNum" : arguments[4], "value" : arguments[5], "rawValue" : arguments[6]};
                    var ret = onRecordClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("onRecordClick", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
    /**
     * Add a recordDrop handler.
     * <p>
     * Process a drop of one or more records on a ListGrid record. <P> This method can be overridden to provide custom drop
     * behaviors, and is a more appropriate override point than the lower level {@link com.smartgwt.client.widgets.Canvas#drop
     * Canvas.drop()} handler. <P> If this is a self-drop, records are simply reordered. <P> For a drop from another widget,
     * {@link com.smartgwt.client.widgets.grid.ListGrid#transferDragData ListGrid.transferDragData()} is called, which
     * depending on the {@link com.smartgwt.client.widgets.grid.ListGrid#getDragDataAction dragDataAction} specified on the
     * source widget, may either remove the source records from the original list (<code>dragDataAction:"move"</code>) or just
     * provide a copy to this list (<code>dragDataAction:"copy"</code>). <P> If this grid is databound, the new records will be
     * added to the dataset by calling {@link com.smartgwt.client.data.DataSource#addData DataSource.addData()}.  Further, if
     * the new records were dragged from another databound component, and {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getAddDropValues addDropValues} is true, {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getDropValues getDropValues} will be called for every item being dropped.
     * <P> For multi-record drops, Queuing is automatically used to combine all DSRequests into a single HTTP Request (see
     * QuickStart Guide, Server Framework chapter).  This allows the server to persist all changes caused by the drop in a
     * single transaction (and this is automatically done when using the built-in server DataSources with Power Edition and
     * above). <P> Note that reordering records has no effect on a databound grid. <P> The newly dropped data is then selected
     * automatically. <P> If these default persistence behaviors are undesirable, Call {@link
     * com.smartgwt.client.widgets.grid.events.RecordDropEvent#cancel()} from within {@link
     * com.smartgwt.client.widgets.grid.events.RecordDropHandler#onRecordDrop} to cancel them, then and implement your own
     * behavior, typically by using grid.updateData() or addData() to add new records. <p><b>NOTE:</b> the records you receive
     * in this event are the actual Records from the source component.  Use {@link
     * com.smartgwt.client.data.DataSource#copyRecords DataSource.copyRecords()} to create a copy before modifying the records
     * or using them with updateData() or addData(). <P> NOTE: for a drop beyond the last visible record of a ListGrid,
     * <code>targetRecord</code> will be null and the <code>index</code> will be one higher than the last record.  This
     * includes a drop into an empty ListGrid, where <code>index</code> will be 0.
     *
     * @param handler the recordDrop handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addRecordDropHandler(com.smartgwt.client.widgets.grid.events.RecordDropHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.RecordDropEvent.getType()) == 0) setupRecordDropEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.RecordDropEvent.getType());
    }

    private native void setupRecordDropEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var onRecordDrop = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.RecordDropEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("onRecordDrop"));
            obj.addProperties({onRecordDrop: 
                function () {
                    var param = {"dropRecords" : arguments[0], "targetRecord" : arguments[1], "index" : arguments[2], "dropPosition" : arguments[3], "sourceWidget" : arguments[4]};
                    var ret = onRecordDrop(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("onRecordDrop", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("onRecordDrop"));
            obj.onRecordDrop = 
                function () {
                    var param = {"dropRecords" : arguments[0], "targetRecord" : arguments[1], "index" : arguments[2], "dropPosition" : arguments[3], "sourceWidget" : arguments[4]};
                    var ret = onRecordDrop(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("onRecordDrop", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
    /**
     * Add a removeRecordClick handler.
     * <p>
     * Handler fired when the user clicks the "remove" icon if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is true. Default behavior will remove
     * the record from the data set, or if we're {@link com.smartgwt.client.widgets.grid.ListGrid#getDeferRemoval deferring
     * removal} mark the record as removed [or for records already marked as removed, clear this removed marker]. <P> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemoval warnOnRemoval} is set, this method will also show a warning
     * dialog to users allowing them to cancel the removal. <P> This event may be cancelled to suppress the default behavior.
     *
     * @param handler the removeRecordClick handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addRemoveRecordClickHandler(com.smartgwt.client.widgets.grid.events.RemoveRecordClickHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.RemoveRecordClickEvent.getType()) == 0) setupRemoveRecordClickEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.RemoveRecordClickEvent.getType());
    }

    private native void setupRemoveRecordClickEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var onRemoveRecordClick = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.RemoveRecordClickEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("onRemoveRecordClick"));
            obj.addProperties({onRemoveRecordClick: 
                function () {
                    var param = {"rowNum" : arguments[0]};
                    var ret = onRemoveRecordClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("onRemoveRecordClick", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("onRemoveRecordClick"));
            obj.onRemoveRecordClick = 
                function () {
                    var param = {"rowNum" : arguments[0]};
                    var ret = onRemoveRecordClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("onRemoveRecordClick", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;
	/**
     * Refresh the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary}, by either re-calculating
     * from already-loaded data or doing a new fetch from the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getSummaryRowDataSource summaryRowDataSource}. <P> Note unlike {@link
     * com.smartgwt.client.widgets.grid.ListGrid#recalculateSummaries ListGrid.recalculateSummaries()}, this method will not
     * force a refresh of field-level summaries (see {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getRecordSummaryFunction recordSummaryFunction}) or group level summaries
     * (see {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary showGroupSummary}).
     */
    public native void recalculateGridSummary() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.recalculateGridSummary();
    }-*/;

	/**
     * Recalculates values for fields with {@link com.smartgwt.client.widgets.grid.ListGridField#getRecordSummaryFunction
     * summary-functions} or  {@link com.smartgwt.client.widgets.grid.ListGridField#getUserFormula user formulae} defined and
     * for values displayed in the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summary rows}.
     */
    public native void recalculateSummaries() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.recalculateSummaries();
    }-*/;

    /**
     * @see ListGrid#recalculateSummaries
     */
    public void recalculateSummaries(Record... records){
        recalculateSummaries(records, null);
    }

	/**
     * Recalculates values for fields with {@link com.smartgwt.client.widgets.grid.ListGridField#getRecordSummaryFunction
     * summary-functions} or  {@link com.smartgwt.client.widgets.grid.ListGridField#getUserFormula user formulae} defined and
     * for values displayed in the {@link com.smartgwt.client.widgets.grid.ListGrid#getShowGridSummary grid summary} and {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowGroupSummary group summary rows}.
     * @param records Optional array of records to recalculate summaries for,                  or null for all records
     * @param fields Optional array of fields to recalculate summaries                 for, or null for all fields <P> Note that the records
     * should be from {@link com.smartgwt.client.widgets.grid.ListGrid#getData data}; thus, if the grid is grouped,  the
     * records should be from the grouped data rather than {@link com.smartgwt.client.widgets.grid.ListGrid#getOriginalData
     * originalData}.
     */
    public native void recalculateSummaries(Record[] records, ListGridField... fields) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.recalculateSummaries(@com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(records), @com.smartgwt.client.util.JSOHelper::convertToJavaScriptArray([Ljava/lang/Object;)(fields));
    }-*/;
	


	/**
     * Executed when the listGrid receives a 'click' event on an enabled, non-separator record. The default implementation does
     * nothing -- override to perform some action when any record or field is clicked.<br> A record event handler can be
     * specified either as a function to execute, or as a string of script to evaluate. If the handler is defined as a string
     * of script, all the parameters below will be available as variables for use in the script.<br> To do something specific
     * if a particular field is clicked, add a recordClick method or string of script to that field (same parameters) when
     * you're setting up the list.<br> <b>Notes:</b><ul> <li>This will not be called if the click is below the last item of the
     * list.</li> <li>This method is called from the default implementation of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#rowClick ListGrid.rowClick()}, so if that method is overridden this method may
     * not be fired.</li></ul>
     * @param viewer the listGrid that contains the click event
     * @param record the record that was clicked on
     * @param recordNum number of the record clicked on in the current set of                                  displayed records (starts with 0)
     * @param field the field that was clicked on (field definition)
     * @param fieldNum number of the field clicked on in the listGrid.fields                                  array
     * @param value value of the cell (after valueMap, etc. applied)
     * @param rawValue raw value of the cell (before valueMap, etc applied)
     *
     * @return return false to cancel default behavior
     * @see com.smartgwt.client.widgets.grid.ListGrid#rowClick
     */
    public native boolean recordClick(ListGrid viewer, ListGridRecord record, int recordNum, ListGridField field, int fieldNum, Object value, Object rawValue) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.recordClick(viewer == null ? null : viewer.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()(), record.@com.smartgwt.client.core.DataClass::getJsObj()(), recordNum, field.@com.smartgwt.client.core.DataClass::getJsObj()(), fieldNum, value, rawValue);
        return ret;
    }-*/;


    /**
     * Add a recordDoubleClick handler.
     * <p>
     * Executed when the listGrid receives a 'doubleClick' event on an enabled, non-separator record. The default
     * implementation does nothing -- override to perform some action when any record or field is double clicked.<br> A record
     * event handler can be specified either as a function to execute, or as a string of script to evaluate. If the handler is
     * defined as a string of script, all the parameters below will be available as variables for use in the script.<br> To do
     * something specific if a particular field is double clicked, add a recordDoubleClick method or string of script to that
     * field (same parameters) when you're setting up the list.<br> <b>Notes:</b><ul> <li>This will not be called if the click
     * is below the last item of the list.</li> <li>This method is called from the default implementation of {@link
     * com.smartgwt.client.widgets.grid.ListGrid#rowDoubleClick ListGrid.rowDoubleClick()}, so if that method is overridden
     * this method may not be fired.</li></ul>
     *
     * @param handler the recordDoubleClick handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addRecordDoubleClickHandler(com.smartgwt.client.widgets.grid.events.RecordDoubleClickHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.RecordDoubleClickEvent.getType()) == 0) setupRecordDoubleClickEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.RecordDoubleClickEvent.getType());
    }

    private native void setupRecordDoubleClickEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var recordDoubleClick = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.RecordDoubleClickEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("recordDoubleClick"));
            obj.addProperties({recordDoubleClick: 
                function () {
                    var param = {"viewer" : arguments[0], "record" : arguments[1], "recordNum" : arguments[2], "field" : arguments[3], "fieldNum" : arguments[4], "value" : arguments[5], "rawValue" : arguments[6]};
                    var ret = recordDoubleClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("recordDoubleClick", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("recordDoubleClick"));
            obj.recordDoubleClick = 
                function () {
                    var param = {"viewer" : arguments[0], "record" : arguments[1], "recordNum" : arguments[2], "field" : arguments[3], "fieldNum" : arguments[4], "value" : arguments[5], "rawValue" : arguments[6]};
                    var ret = recordDoubleClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("recordDoubleClick", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;


	/**
     * Returns true if the specified record is marked as removed via a call to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#markRecordRemoved ListGrid.markRecordRemoved()}
     * @param rowNum index of row to verify
     *
     * @return true if the specified record has been marked for removal
     * @see com.smartgwt.client.docs.Editing Editing overview and related methods
     */
    public native Boolean recordMarkedAsRemoved(int rowNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        var ret = self.recordMarkedAsRemoved(rowNum);
        if(ret == null) return null;
        return @com.smartgwt.client.util.JSOHelper::toBoolean(Z)(ret);
    }-*/;




	/**
     * Refresh an individual cell without redrawing the grid. <P> The cell's value, CSS class, and CSS text will be refreshed,
     * to the current values returned by getCellValue(), getCellStyle() and getCellCSSText() respectively.
     * @param rowNum row number of cell to refresh
     * @param colNum column number of cell to refresh
     * @see com.smartgwt.client.widgets.grid.ListGrid#refreshCellStyle
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#grid_datatypes_calculated" target="examples">Calculated Example</a>
     */
    public native void refreshCell(int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.refreshCell(rowNum, colNum);
    }-*/;




	/**
     * Refresh the styling of an individual cell without redrawing the grid. <P> The cell's CSS class and CSS text will be
     * refreshed, to the current values returned by getCellStyle() and getCellCSSText() respectively. <P> The cell's contents
     * (as returned by getCellValue()) will <b>not</b> be refreshed.  To refresh both styling and contents, call refreshCell()
     * instead.
     * @param rowNum row number of cell to refresh
     * @param colNum column number of cell to refresh
     * @see com.smartgwt.client.widgets.grid.ListGrid#refreshCell
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public native void refreshCellStyle(int rowNum, int colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.refreshCellStyle(rowNum, colNum);
    }-*/;


	/**
     * Re-evaluates {@link com.smartgwt.client.widgets.grid.ListGridField#showIf ListGridField.showIf()} for each field,
     * dynamically showing and hiding the appropriate set of fields
     */
    public native void refreshFields() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.refreshFields();
    }-*/;



	/**
     * Discards any {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponent} currently
     * assigned to the specified record (or cell) and gets a fresh one, according to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPoolingMode recordComponentPoolingMode} <P> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#invalidateRecordComponents ListGrid.invalidateRecordComponents()} which allows
     * you to refresh all record components that are currently visible in the grid.
     * @param rowNum Row to refresh
     */
    public native void refreshRecordComponent(int rowNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.refreshRecordComponent(rowNum);
    }-*/;


	/**
     * Discards any {@link com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponents recordComponent} currently
     * assigned to the specified record (or cell) and gets a fresh one, according to the {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getRecordComponentPoolingMode recordComponentPoolingMode} <P> See also {@link
     * com.smartgwt.client.widgets.grid.ListGrid#invalidateRecordComponents ListGrid.invalidateRecordComponents()} which allows
     * you to refresh all record components that are currently visible in the grid.
     * @param rowNum Row to refresh
     * @param colNum Column to refresh. This parameter should be passed      if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getShowRecordComponentsByCell showRecordComponentsByCell} is true.
     */
    public native void refreshRecordComponent(int rowNum, Integer colNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.refreshRecordComponent(rowNum, colNum == null ? null : colNum.@java.lang.Integer::intValue()());
    }-*/;
	


	/**
     * Refresh an entire row of cells without redrawing the grid. <P> The cells' values, CSS classes, and CSS text will be
     * refreshed, to the current values returned by getCellValue(), getCellStyle() and getCellCSSText() respectively.
     * @param rowNum row number of cell to refresh
     * @see com.smartgwt.client.widgets.grid.ListGrid#refreshCellStyle
     * @see com.smartgwt.client.widgets.grid.ListGrid#refreshCell
     * @see com.smartgwt.client.docs.Appearance Appearance overview and related methods
     */
    public native void refreshRow(int rowNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.refreshRow(rowNum);
    }-*/;




	/**
     * Remove a record from this ListGrid. <P> If this grid is bound to a DataSource, it will perform a DataSource "remove"
     * operation to remove records from this component's DataSource. <P> Otherwise the data will be removed from the grid's
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getData data} object. <P> To make changes to the local data object even
     * when a DataSource is present, use {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally}.
     * @param data listGrid record, or primary key values of record to delete.
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBoundComponentMethods overview and related methods
     */
    public native void removeData(Record data) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.removeData(data.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;


    /**
     * @see ListGrid#removeData
     */
    public void removeData(Record data, DSCallback callback){
        removeData(data, callback, null);
    }

	/**
     * Remove a record from this ListGrid. <P> If this grid is bound to a DataSource, it will perform a DataSource "remove"
     * operation to remove records from this component's DataSource. <P> Otherwise the data will be removed from the grid's
     * {@link com.smartgwt.client.widgets.grid.ListGrid#getData data} object. <P> To make changes to the local data object even
     * when a DataSource is present, use {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveLocally saveLocally}.
     * @param data listGrid record, or primary key values of record to delete.
     * @param callback method to call on operation completion.   Note that if this is method does not trigger a dataSource remove operation,
     * the callback   will still be fired when the data has been removed, but the <code>dsResponse</code> parameter   will be
     * null.
     * @param requestProperties additional properties to set on any DSRequest                                          that will be issued
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBoundComponentMethods overview and related methods
     */
    public native void removeData(Record data, DSCallback callback, DSRequest requestProperties) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.removeData(data.@com.smartgwt.client.core.DataClass::getJsObj()(), 
			$entry( function(dsResponse, data, dsRequest) { 
				if(callback!=null) callback.@com.smartgwt.client.data.DSCallback::execute(Lcom/smartgwt/client/data/DSResponse;Ljava/lang/Object;Lcom/smartgwt/client/data/DSRequest;)(
					@com.smartgwt.client.data.DSResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsResponse), 
					data, 
					@com.smartgwt.client.data.DSRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsRequest)
				);
			}), requestProperties == null ? null : requestProperties.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;
	
	/**
     * Removes an embedded component previously associated with the provided record. If a Canvas is passed as the
     * <code>record</code> parameter, it is assumed to be a component and the record is detected automatically from it.  If
     * <code>destroyOnUnEmbed</code> is <code>true</code> for the component, it will also be destroyed.
     * @param record record that the component was previously attached     to or the component itself
     */
    public native void removeEmbeddedComponent(ListGridRecord record) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.removeEmbeddedComponent(record.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;

	/**
     * Removes an embedded component previously associated with the provided record. If a Canvas is passed as the
     * <code>record</code> parameter, it is assumed to be a component and the record is detected automatically from it.  If
     * <code>destroyOnUnEmbed</code> is <code>true</code> for the component, it will also be destroyed.
     * @param record record that the component was previously attached     to or the component itself
     * @param component component to unembed, or the colNum in which it appears
     */
    public native void removeEmbeddedComponent(ListGridRecord record, Integer component) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.removeEmbeddedComponent(record.@com.smartgwt.client.core.DataClass::getJsObj()(), component == null ? null : component.@java.lang.Integer::intValue()());
    }-*/;
	


	/**
     * Method fired when the user clicks the "remove" icon if {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getCanRemoveRecords canRemoveRecords} is true. Default behavior will remove
     * the record from the data set, or if we're {@link com.smartgwt.client.widgets.grid.ListGrid#getDeferRemoval deferring
     * removal} mark record as removed [or for records already marked as removed, clear this removed marker]. <P> If {@link
     * com.smartgwt.client.widgets.grid.ListGrid#getWarnOnRemoval warnOnRemoval} is set, this method will also show a warning
     * dialog to users allowing them to cancel the removal. <P> This method may be called directly to cause a record to be
     * removed or marked for removal as if the user had hit the "remove" icon. <P> To be notified when a "remove" click occurs,
     * developers should add a {@link com.smartgwt.client.widgets.grid.ListGrid#addRemoveRecordClickHandler *
     * RemoveRecordClickHandler}.
     * @param rowNum Row on which the icon was clicked
     */
    public native void removeRecordClick(int rowNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.removeRecordClick(rowNum);
    }-*/;


	/**
     * Remove the currently selected records from this component. If this is a databound grid, the records will be removed
     * directly from the DataSource. <P> If no records are selected, no action is taken. The grid will automatically be updated
     * if the record deletion succeeds.
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBoundComponentMethods overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#remove_grid_form_category" target="examples">Remove Example</a>
     */
    public native void removeSelectedData() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.removeSelectedData();
    }-*/;

    /**
     * @see ListGrid#removeSelectedData
     */
    public void removeSelectedData(DSCallback callback){
        removeSelectedData(callback, null);
    }

	/**
     * Remove the currently selected records from this component. If this is a databound grid, the records will be removed
     * directly from the DataSource. <P> If no records are selected, no action is taken. The grid will automatically be updated
     * if the record deletion succeeds.
     * @param callback callback to fire when the data has been removed
     * @param requestProperties additional properties to set on the DSRequest                                          that will be issued
     * @see com.smartgwt.client.docs.DataBoundComponentMethods DataBoundComponentMethods overview and related methods
     * @see <a href="http://www.smartclient.com/smartgwt/showcase/#remove_grid_form_category" target="examples">Remove Example</a>
     */
    public native void removeSelectedData(DSCallback callback, DSRequest requestProperties) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.removeSelectedData(
			$entry( function(dsResponse, data, dsRequest) { 
				if(callback!=null) callback.@com.smartgwt.client.data.DSCallback::execute(Lcom/smartgwt/client/data/DSResponse;Ljava/lang/Object;Lcom/smartgwt/client/data/DSRequest;)(
					@com.smartgwt.client.data.DSResponse::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsResponse), 
					data, 
					@com.smartgwt.client.data.DSRequest::new(Lcom/google/gwt/core/client/JavaScriptObject;)(dsRequest)
				);
			}), requestProperties == null ? null : requestProperties.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;
	


	/**
     * Reorder a particular field
     * @param fieldNum Number of the field to reorder
     * @param moveToPosition New position for that field
     */
    public native void reorderField(int fieldNum, int moveToPosition) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.reorderField(fieldNum, moveToPosition);
    }-*/;




	/**
     * Reorder a set of adjacent fields, from start to end exclusive at the end, by distance moveDelta.<br><br> NOTE: start and
     * end coordinates are in terms of the currently visible fields, not the full set of fields.
     * @param start Start of the range of fields to move, inclusive
     * @param end End of the range of fields to move, non-inclusive
     * @param moveDelta Distance to move by
     */
    public native void reorderFields(int start, int end, int moveDelta) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.reorderFields(start, end, moveDelta);
    }-*/;




	/**
     * Resize a particular field to a new width. Note that this method will also set {@link
     * com.smartgwt.client.widgets.grid.ListGridField#getAutoFitWidth autoFitWidth} to false if it was previously true.
     * @param fieldNum Number of the field to resize
     * @param newWidth New width of the field
     */
    public native void resizeField(int fieldNum, int newWidth) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.resizeField(fieldNum, newWidth);
    }-*/;


	/**
     * If a list has become unsorted due to data modification or a call to {@link
     * com.smartgwt.client.widgets.grid.ListGrid#unsort ListGrid.unsort()}, this method will resort the list by the previous
     * {@link com.smartgwt.client.widgets.grid.ListGrid#setSort sort-specifier} array, if there is one, or by the previous
     * sort-field and -direction.
     */
    public native void resort() /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.resort();
    }-*/;



	/**
     * Event handler for when rows in the body are clicked upon. The default implementation handles firing {@link
     * com.smartgwt.client.widgets.grid.ListGrid#startEditing ListGrid.startEditing()} if appropriate, and fires {@link
     * com.smartgwt.client.widgets.grid.ListGridField#addRecordClickHandler ListGridField.recordClick()} and/or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#recordClick ListGrid.recordClick()} if set. Developers should typically
     * implement recordClick rather than overriding this method. <P> Note that this method fires in addition to any specified
     * {@link com.smartgwt.client.widgets.grid.ListGrid#addCellClickHandler ListGrid.cellClick()} handler (even if that method
     * cancels the event as a whole by returning <code>false</code>).
     * @param record record object returned from getCellRecord()
     * @param recordNum index of the row where the click occurred
     * @param fieldNum index of the col where the click occurred
     * @see com.smartgwt.client.widgets.grid.ListGrid#recordClick
     */
    public native void rowClick(ListGridRecord record, int recordNum, int fieldNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.rowClick(record.@com.smartgwt.client.core.DataClass::getJsObj()(), recordNum, fieldNum);
    }-*/;


	/**
     * Event handler for when rows in the body are clicked upon. The default implementation handles firing {@link
     * com.smartgwt.client.widgets.grid.ListGrid#startEditing ListGrid.startEditing()} if appropriate, and fires {@link
     * com.smartgwt.client.widgets.grid.ListGridField#addRecordClickHandler ListGridField.recordClick()} and/or {@link
     * com.smartgwt.client.widgets.grid.ListGrid#recordClick ListGrid.recordClick()} if set. Developers should typically
     * implement recordClick rather than overriding this method. <P> Note that this method fires in addition to any specified
     * {@link com.smartgwt.client.widgets.grid.ListGrid#addCellClickHandler ListGrid.cellClick()} handler (even if that method
     * cancels the event as a whole by returning <code>false</code>).
     * @param record record object returned from getCellRecord()
     * @param recordNum index of the row where the click occurred
     * @param fieldNum index of the col where the click occurred
     * @param keyboardGenerated indicates whether this was a synthesized record                                              click in response to a
     * keyboard event
     * @see com.smartgwt.client.widgets.grid.ListGrid#recordClick
     */
    public native void rowClick(ListGridRecord record, int recordNum, int fieldNum, boolean keyboardGenerated) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.rowClick(record.@com.smartgwt.client.core.DataClass::getJsObj()(), recordNum, fieldNum, keyboardGenerated == null ? false : keyboardGenerated);
    }-*/;
	
    /**
     * Add a rowContextClick handler.
     * <p>
     * Called when a row receives a contextclick event.
     *
     * @param handler the rowContextClick handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addRowContextClickHandler(com.smartgwt.client.widgets.grid.events.RowContextClickHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.RowContextClickEvent.getType()) == 0) setupRowContextClickEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.RowContextClickEvent.getType());
    }

    private native void setupRowContextClickEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var rowContextClick = $debox($entry(function(param){
            var event = @com.smartgwt.client.widgets.grid.events.RowContextClickEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            var ret = event.@com.smartgwt.client.event.Cancellable::isCancelled()();
            return !ret;
        }));
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("rowContextClick"));
            obj.addProperties({rowContextClick: 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = rowContextClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("rowContextClick", arguments);
                    }
                    return ret;
                }
             });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("rowContextClick"));
            obj.rowContextClick = 
                function () {
                    var param = {"record" : arguments[0], "rowNum" : arguments[1], "colNum" : arguments[2]};
                    var ret = rowContextClick(param) == true;
                    if (ret && hasDefaultHandler) {
                        ret = this.Super("rowContextClick", arguments);
                    }
                    return ret;
                }
            ;
        }
   }-*/;


	/**
     * Event handler for when a body record is double-clicked. <P> Default implementation fires 'editCell' if appropriate, and
     * handles firing 'recordDoubleClick' stringMethod if defined at the field or LG level (That method has a different
     * signature from this one)
     * @param record record object returned from getCellRecord()
     * @param recordNum index of the row where the click occurred
     * @param fieldNum index of the col where the click occurred
     * @see com.smartgwt.client.widgets.grid.events.RecordDoubleClickEvent
     */
    public native void rowDoubleClick(ListGridRecord record, int recordNum, int fieldNum) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.rowDoubleClick(record.@com.smartgwt.client.core.DataClass::getJsObj()(), recordNum, fieldNum);
    }-*/;


	/**
     * Event handler for when a body record is double-clicked. <P> Default implementation fires 'editCell' if appropriate, and
     * handles firing 'recordDoubleClick' stringMethod if defined at the field or LG level (That method has a different
     * signature from this one)
     * @param record record object returned from getCellRecord()
     * @param recordNum index of the row where the click occurred
     * @param fieldNum index of the col where the click occurred
     * @param keyboardGenerated indicates whether this was a synthesized record                                              doubleclick in response to
     * a keyboard event
     * @see com.smartgwt.client.widgets.grid.events.RecordDoubleClickEvent
     */
    public native void rowDoubleClick(ListGridRecord record, int recordNum, int fieldNum, boolean keyboardGenerated) /*-{
        var self = this.@com.smartgwt.client.widgets.BaseWidget::getOrCreateJsObj()();
        self.rowDoubleClick(record.@com.smartgwt.client.core.DataClass::getJsObj()(), recordNum, fieldNum, keyboardGenerated == null ? false : keyboardGenerated);
    }-*/;
	
    /**
     * Add a rowEditorEnter handler.
     * <p>
     * Callback fired when the user starts editing a new row.
     *
     * @param handler the rowEditorEnter handler
     * @return {@link HandlerRegistration} used to remove this handler
     */
    public HandlerRegistration addRowEditorEnterHandler(com.smartgwt.client.widgets.grid.events.RowEditorEnterHandler handler) {
        if(getHandlerCount(com.smartgwt.client.widgets.grid.events.RowEditorEnterEvent.getType()) == 0) setupRowEditorEnterEvent();
        return doAddHandler(handler, com.smartgwt.client.widgets.grid.events.RowEditorEnterEvent.getType());
    }

    private native void setupRowEditorEnterEvent() /*-{
        var obj;
        var selfJ = this;
        var hasDefaultHandler;
        var rowEditorEnter = $entry(function(){
            var param = {"record" : arguments[0], "editValues" : arguments[1], "rowNum" : arguments[2]};
            var event = @com.smartgwt.client.widgets.grid.events.RowEditorEnterEvent::new(Lcom/google/gwt/core/client/JavaScriptObject;)(param);
            selfJ.@com.smartgwt.client.widgets.BaseWidget::fireEvent(Lcom/google/gwt/event/shared/GwtEvent;)(event);
            if (hasDefaultHandler) this.Super("rowEditorEnter", arguments);
        });
        if(this.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getJsObj()();
            hasDefaultHandler = $wnd.isc.isA.Function(obj.getProperty("rowEditorEnter"));
            obj.addProperties({rowEditorEnter:  rowEditorEnter              });
        } else {
            obj = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
            var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
            hasDefaultHandler = $wnd.isc.isA.Function($wnd.isc[scClassName].getInstanceProperty("rowEditorEnter"));
            obj.rowEditorEnter =  rowEditorEnter             ;
        }
   }-*/;
    /**
     * Add a 